#!/bin/sh
# wg-callhome.sh - Generate wagdmin crontab if not exist

_add_callhome_cronjob() {

    . /etc/default/wg_system

    minute=`/usr/bin/shuf -i 0-59 -n 1`
    today=`/bin/date +%u`
    day=$(($today - 1))

    /bin/echo "$minute 23 * * $day ${WG_BINDIR}/python ${WG_BINDIR}/wg_callhome.pyc" | /usr/bin/crontab -u ${WG_ADMIN_USER} -
}

if [ ! -f /var/spool/cron/crontabs/wgadmin ]; then
    _add_callhome_cronjob
fi
