#!/bin/sh
# wg-data-disk-resize.sh - Resize the data filesystem for WatchGuard Dimension Virtual Appliance
#

MOUNTPOINT=/var/opt/watchguard/dimension/data
DEVICE=$(/bin/mount | grep "${MOUNTPOINT}" | awk -F ' ' '{print $1}')
TYPE=$(/bin/mount | grep "${MOUNTPOINT}" | awk -F ' ' '{print $5}')

if [ ! -n "$DEVICE" ]; then
    exit 0
fi

if /sbin/blkid "${DEVICE:?}" | grep -q "TYPE=\"${TYPE:?}\""; then
    if /sbin/resize2fs "${DEVICE:?}" >/dev/null; then
        /bin/df -h "${MOUNTPOINT:?}" || true
    fi
fi

exit 0
