#!/bin/sh

set -eu

. /etc/default/wg_system

export WG_BINDIR WG_ETCDIR WG_LIBDIR WG_RUNDIR WG_SHAREDIR WG_VARDIR 
export WG_ADMIN_USER WG_ADMIN_GROUP WG_SUPPORT_USER

interpreter="${WG_BINDIR}/python"
program="${WG_BINDIR}/wg_azure_state.pyc"

if [ ! -e "$interpreter" -o ! -x "$interpreter" ]; then
    echo "Interpreter file \"$interpreter\" does not exist or is non-executable" >&2
    exit 1
fi

if [ ! -e "$program" -o ! -s "$program" ]; then
    echo "Program file \"$program\" does not exist or is empty" >&2
    exit 1
fi

case "$1" in
    (Ready)
        "$interpreter" "$program" -p 1 "$@" >/dev/null
        ;;
    (*)
        echo "Argument \"$1\" not implemented" >&2
        exit 1
        ;;
esac
