/*global XTMWEBUI_DEVICE_NAME,XTMWEBUI_PAGE_PATH*/
var CONTROL_XTMWEBUI = {
    urlSn: '',
    xtmUrl: '',
    pagePath: '',
    init: function () {
        $.getUrlVars();
        CONTROL_XTMWEBUI.urlSn = $.getUrlVar('sn');
        CONTROL_XTMWEBUI.baseXtmUrl = "/devices/" + CONTROL_XTMWEBUI.urlSn;
        CONTROL_XTMWEBUI.pagePath = XTMWEBUI_PAGE_PATH;

        CONTROL_XTMWEBUI.initUI();
        CONTROL_XTMWEBUI.initEvents();
        CONTROL_XTMWEBUI.login();
    },
    initUI: function () {
        CONTROL_XTMWEBUI.uiState('connecting');
        $("#webui_app_title_device_name").text(XTMWEBUI_DEVICE_NAME);
    },
    initEvents: function () {
        $("#btn_webui_logout").click(CONTROL_XTMWEBUI.logout);

        $("a").click(function () {
            // Custom to disable anchor if it's been set to 'disabled'
            return ($(this).attr('disabled')) ? false : true;
        });

        /* Override the help_link to load the Web UI specific help */
        $('.help_link_webui').on('click', CONTROL_XTMWEBUI.postHelp);

        $("#btn_xtmwebui_goback").click(CONTROL_XTMWEBUI.goback);
        $("#btn_xtmwebui_goback_reconnect").click(CONTROL_XTMWEBUI.reconnect);
        $("#btn_xtmwebui_closewindow").click(CONTROL_XTMWEBUI.closewindow);
        $("#btn_xtmwebui_closewindow_reconnect").click(CONTROL_XTMWEBUI.reconnect);
    },
    login: function () {
        var url = 'get_xtmwebui_login?sn=' + CONTROL_XTMWEBUI.urlSn;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: CONTROL_XTMWEBUI.displayError,
            success: function (data) {
                if (!data.status) {
                    CONTROL_XTMWEBUI.displayError(data);
                } else {
                    CONTROL_XTMWEBUI.baseXtmUrl = "/devices/" + data.device_id;
                    CONTROL_XTMWEBUI.postForm();
                }
            }
        });
    },
    logout: function (params) {
        CONTROL_XTMWEBUI.uiState('connecting');
        var url = 'get_xtmwebui_logout?sn=' + CONTROL_XTMWEBUI.urlSn;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            complete: function () {
                if (window.name.indexOf('xtmwebui_') === 0) {
                    $("#xtmwebui_iframe").attr('src', '/control/xtmconnect?sn=' + CONTROL_XTMWEBUI.urlSn);
                    setTimeout(function () {
                        CONTROL_XTMWEBUI.uiState('success');
                    }, 500);
                    return;
                }
                window.location = '/control/device?sn=' + CONTROL_XTMWEBUI.urlSn;
            }
        });
    },
    postForm: function (data, status, xhr) {
        var pageParamParts = [];
        var pagePathParts = CONTROL_XTMWEBUI.pagePath.split('?');
        var html = '<form id="xtmwebui_form" method="GET" action="' + CONTROL_XTMWEBUI.baseXtmUrl + pagePathParts[0] + '" target="xtmwebui_iframe">';
        if (pagePathParts.length > 1) {
            pageParamParts = pagePathParts[1].split('=');
            html += '<input name="' + pageParamParts[0] + '" value="' + pageParamParts[1] + '" style="display:none;">';
        }
        html += '</form>';
        CONTROL_XTMWEBUI.uiState('loading');
        $("#xtmwebui_form").remove();
        $("body").append(html);
        $("#xtmwebui_form").submit();

        setTimeout(function (eo) {
            CONTROL_XTMWEBUI.uiState('success');
        }, 2000);
    },
    postHelp: function () {
        /* Get a reference to the first .help_link from the iframe and click it */
        var help_link = $("#xtmwebui_iframe").contents().find('.help_link')[0];
        if (help_link) {
            help_link.click();
        }
    },
    displayError: function (data) {
        CONTROL_XTMWEBUI.uiState('error');
        $("#xtmwebui_error_msg").text(data.message || '');
    },
    goback: function () {
        window.top.location.href = "/control/device?sn=" + CONTROL_XTMWEBUI.urlSn;
    },
    closewindow: function () {
        window.top.close();
    },
    reconnect: function () {
        window.top.location.href = "/control/xtmwebui?sn=" + CONTROL_XTMWEBUI.urlSn;
    },
    uiState: function (step) {
        WGRD.showUIElements(true, ["#xtmconnect_main"]);
        WGRD.showUIElements(false, ["#detail_loading_spinner", ".xtmconnect_message", "#xtmconnect_progress", "#xtmconnect_progress2",
                "#xtmwebui_error_div", "#xtmconnect_closewindow", "#xtmconnect_goback", "#btn_webui_logout"]);
        switch (step) {
        case 'connecting':
            WGRD.showUIElements(true, ["#detail_loading_spinner", ".xtmconnect_message", "#xtmconnect_progress"]);
            break;
        case 'loading':
            WGRD.showUIElements(true, ["#detail_loading_spinner", ".xtmconnect_message", "#xtmconnect_progress2"]);
            break;
        case 'error':
            WGRD.showUIElements(false, ["#detail_loading_spinner", "#xtmconnect_progress"]);
            if (window.top.name.indexOf('xtmwebui_') === 0) {
                WGRD.showUIElements(true, ["#xtmwebui_error_div", ".xtmconnect_message", "#xtmconnect_closewindow"]);
            } else {
                WGRD.showUIElements(true, ["#xtmwebui_error_div", ".xtmconnect_message", "#xtmconnect_goback"]);
            }
            WGRD.enableUIElements(true, ["li > a"]);
            break;
        case 'success':
            WGRD.showUIElements(false, ["#xtmconnect_main"]);
            WGRD.showUIElements(true, ["#btn_webui_logout"]);
            break;
        }
    }
};
$(document).ready(CONTROL_XTMWEBUI.init);
