$(document).ready(function() {                      
    var urlSn = $.getUrlVar('sn');
    var date = $.getUrlVar('date');
    var id = $.getUrlVar('id');
    var period = $.getUrlVar('period');    
    var urlTz = $.getUrlVar('tz');     
    var repType = $.getUrlVar('reptype');    
    var htmlDate = $("#date").val();
    var htmlSn = $("#sn").val();      
    var htmlSearch = $("#search").val();
    var band_or_Hit = $("#band_or_Hit").val();  
    var startTime = '';
    var endTime = '';
    var reportName = '';
    var portal_link = "https://securityportal.watchguard.com/Threats/Detail?ruleId=";
    
    var app_usage_rep_list = ['top_cli_app_usage_users_detail', 'top_cli_app_usage_hosts_detail',
                              'top_cli_app_usage_category_detail', 'top_cli_app_usage_application_detail',
                              'top_cli_app_usage_devices_detail'];
 
    var app_block_rep_list = ['top_cli_app_block_users_detail', 'top_cli_app_block_hosts_detail',
                              'top_cli_app_block_category_detail', 'top_cli_app_block_application_detail',
                              'top_cli_app_block_devices_detail'];

    if(htmlSearch !== '') {
        var htmlSearchLabel = decodeURIComponent(htmlSearch).split('=')[1];
        var $label1 = $('#label1').removeClass('active');
        var uri = "detail?sn=" + urlSn + "&reptype=" + repType;
        $label1.html("<a href='" + uri + "'>" + $label1.text() + "</a>");
        var $label2 = $('#label2');
        $label2.find(':first').text('/');
        $label2.find(':last').text(htmlSearchLabel);
    }

    // Set the report type from the url              
    if(repType != null) {
        switch (repType) {
            case 'alarms':
                HELP_LINK_OVERRIDE = 7200;
                break;
            case 'denied_packets_detail':
                HELP_LINK_OVERRIDE = 7201;
                break;
            case 'denied_packets_client_detail':
                HELP_LINK_OVERRIDE = 7202;
                break;
            case 'pop3_proxy_detail':
                HELP_LINK_OVERRIDE = 7203;
                break;
             case 'smtp_proxy_detail':
                HELP_LINK_OVERRIDE = 7204;
                break;
            case 'web_audit_category':
                HELP_LINK_OVERRIDE = 7205;
                break;
            case 'web_audit_client':
                HELP_LINK_OVERRIDE = 7206;
                break;
             case 'web_blocker_client':
                HELP_LINK_OVERRIDE = 7207;
                break;
            case 'web_blocker_category':
                HELP_LINK_OVERRIDE = 7208;
                break;
            case 'dlp_detail':
                HELP_LINK_OVERRIDE = 7209;
                break;
            case 'ips_detail':
                HELP_LINK_OVERRIDE = 7210;
                break;
            case 'gav_detail':
                HELP_LINK_OVERRIDE = 7211;
                break;
            case 'apt_detail':
                HELP_LINK_OVERRIDE = 7212;
                break;
            case 'undetected_apt_detail':
                HELP_LINK_OVERRIDE = 7213;
                $('#page_label_id').attr("title", D_SUMMARY_EXECUTIVE_ZERO_DAY_APT);
                break;
            case 'botnet_detail':
                HELP_LINK_OVERRIDE = 7214;
                break;
            case 'mobile_detail':
                HELP_LINK_OVERRIDE = 7215;
                break;
            case 'imap_proxy_detail':
                HELP_LINK_OVERRIDE = 7216;
                break;
        }
        $('#chart_select').val(repType);
    }
    
    if(period != null && period == 'custom'){
        $('#chart_select').hide();
    }

    customDetailReport();
    
    // Add handler for change the type of chart
    $("#chart_select").change(function () { getData(); });
    $("#bw_hits_select").change(function () { getData(); });
    
    $("#custom_datepicker_trigger").bind('click', function() {
        // Listen fora click on this div, it means the date changed 
        // and a refresh is needed
        getData();
    });       

    $('#csv_link').click(function(){
        var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();
        var startTime = R_DATE_NAVBAR.convertDateStr2GMT(startEnd[0] + ":00");
        var endTime = R_DATE_NAVBAR.convertDateStr2GMT(startEnd[1] + ":00");

        var reportType = $('#chart_select option:selected').val();
        reportType = getRepType(reportType);

        WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

        $.ajax({
            url:"saveAsCsv?serial=" + htmlSn +  "&client_tz=" + WGRD.client_tz + "&start_time=" + startTime + "&end_time=" + endTime + "&report_type=" + reportType + "&search=" + htmlSearch,
            type: 'POST',
            contentType: 'application/json',
            success: function(data) {
                if(!data.status){
                    if(data.message){
                        alert(data.message);
                    }
                    return true;
                }
                var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                window.location = "get_csv_file?serial=" + htmlSn + file_args;
                return false;
            },
            complete: function (filename) {
                WGRD.progressModalClose();
            }   
        });
    });

    function getRepType (repType) {
        if ($.inArray(repType, app_usage_rep_list) !== -1) {
            repType = repType + $('#bw_hits_select option:selected').val();
        }
        return repType;
    }

    function customDetailReport(){
        if(htmlSearch == '') {
            return;
        }

        var description = '';
        var linkSearch = decodeURIComponent(htmlSearch);
        linkSearch = linkSearch.split('=');
        var link = linkSearch[0];

        if (repType == 'ips_detail') {
            if (link == 'threat') {
                description = ips_headers[link] + ': ' + threat_map[linkSearch[1]];
            }else{
                description = ips_headers[link] + ': ' + linkSearch[1];
            }
        }else if (repType == 'gav_detail') {
            description = gav_headers[link] + ': ' + linkSearch[1];
        }else if (repType == 'apt_detail' || repType == 'undetected_apt_detail') {
            description = apt_headers[link] + ': ' + linkSearch[1];
        }else if (repType === 'botnet_detail') {
            description = botnet_headers[link] + ': ' + linkSearch[1];
        }else if ($.inArray(repType, app_usage_rep_list) !== -1) {
            description = app_headers[link] + ': ' + linkSearch[1];
            // Since 'Application name' is given in 'Application Usage summary' report,
            // no need to show 'Category' and 'Application' in drop down of its detail report.
            var removeReport = app_usage_rep_list[2];
            $('#chart_select option[value='+removeReport+']').remove();
            removeReport = app_usage_rep_list[3];
            $('#chart_select option[value='+removeReport+']').remove();

            $('#chart_select option[value=' + repType + ']').prop('selected', true);
            $('#bw_hits_select option[value=' + band_or_Hit + ']').prop('selected', true);   
        }else if ($.inArray(repType, app_block_rep_list) !== -1) {
            description = app_headers[link] + ': ' + linkSearch[1];
            // Since 'Application name' is given in 'Blocked Application summary' report,
            // no need to show 'Category' and 'Application' in drop down of its detail report.
            var removeReport = app_block_rep_list[2];
            $('#chart_select option[value='+removeReport+']').remove();

            removeReport = app_block_rep_list[3];
            $('#chart_select option[value='+removeReport+']').remove();
            $('#chart_select option[value=' + repType + ']').prop('selected', true);
        }

        $('#link_search').text(description);
        $('#link_search').show();
    }

    // Get the report data and setup the grid with the response
    function getData(){
        var report_type = $('#chart_select option:selected').val();
        if (report_type == ''){
            return;
        }
        
        if(!id){
            id = '';
        }        
        
        var filter_view = '';
        if ($.inArray(report_type, app_usage_rep_list) === -1) {
            $('#bw_hits_select').hide();
            $('#chart_select').css('width','120px');
        } 
        else {
            $('#bw_hits_select').show();
            $('#chart_select').css('width','120px');
            filter_view = $('#bw_hits_select option:selected').val();
        }
        
        if (filter_view !== '') {
            report_type += filter_view;
        }

        $('#csv_link').show();
        showChartLoading('detail');
        
        var startEnd = R_DATE_NAVBAR.getStartEndSeconds();
        start_dt = startEnd[0];
        end_dt = startEnd[1];
        
        var jqxhr = $.ajax({
           url: 'get_detail_data?report_type=' + report_type + '&sn=' + htmlSn + '&start_time=' + start_dt + '&end_time=' + end_dt + '&div=detail&rep_id=' + id + "&period=" + period,
           method: 'GET',
           dataType: 'json',
           success: onSuccess,
           error: errorHandler
        });     
        return jqxhr;
    }     
    
    function onSuccess(series){
        // The column names and model are returned, once the grid is created it'll handle
        // the callbacks to retrieve the data
        preHandleDataGrid(series);
        
        // Store the column model so we can use it when modifying the date strings
        column_model = series.col_model;
        if (series.col_model.length === 0) {
            $('#csv_link').hide();
        }
        jQuery('#report_table').GridUnload('#report_table');
        createDataGrid(series.col_names, series.col_model);
        
        $("#report_table").jqGrid('setGridParam',{datatype:'json'}).trigger('reloadGrid');        
    }

    function preHandleDataGrid(series){
        var linkSearch = decodeURIComponent(htmlSearch);
        if (!linkSearch || linkSearch === '') {
            return;
        }

        var link = linkSearch.split('=')[0];
        var i = 0;
        if (repType === 'apt_detail' || repType === 'undetected_apt_detail') {
            switch(link) {
                case 'threat_id':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name === 'threat_id'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'protocol':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name === 'protocol'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'threat_level':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name === 'threat_level'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'activity':
                case 'mime_type':
                case 'recipient_destination':
                case 'sender_source':
                    break;
            }
        }else if (repType === 'botnet_detail') {
            switch(link) {
                case 'source':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name === 'src_ip'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'destination':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name === 'dst_ip'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'botnet':
                    break;
            }
        }else if (repType === 'mobile_detail') {
            switch(link) {
                case 'hostname':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name === 'hostname'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'user':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name === 'user'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'check':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name === 'check'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
            }
        }
    }
                 
    function createDataGrid(col_names, col_model){
        // IPS and GAV detail report.
        var search = false;
        var postData = {};
        if(htmlSearch !== ''){
            search = true;
            postData = {searchString: htmlSearch};
        }

        $("#report_table").jqGrid({
            url:'detail_report?sn=' + htmlSn,
            datatype: 'json',
            mtype: 'GET',
            colNames: col_names,
            colModel: col_model,
            autoencode: true,
            pager: '#pager',
            pagerpos: 'right',
            toppager: true,
            rowNum: 100,
            rowList:[25, 50, 75, 100],
            sortname: 'name',
            sortorder: 'desc',
            caption: '',
            height: 'auto',
            width: '750',
            loadui: 'block',
            autowidth: true,
            shrinkToFit: true,
            search: search,
            postData: postData,
        
            loadError: errorHandler,
            loadComplete: function (data) {
                if (data.records === undefined || data.records === 0) {
                    $('#csv_link').hide();
                }

                // Update the timezone information
                var startTime = $.getDateDisplay(data.time_range_begin, true, urlTz);
                var endTime = $.getDateDisplay(data.time_range_end, true, urlTz);
                reportName = $('#chart_select option:selected').text();
                
                // Notify the date navbar the report range changed
                $('#report_range').trigger('reportRange', {start_time: startTime, 
                                                           end_time: endTime, 
                                                           name: reportName });
                
            }
        }).navGrid("#pager",{refresh:false,search:false,edit:false,add:false,del:false},{},{width:350},{});

        var reportType = $('#chart_select option:selected').val();
        if(reportType === "ips_detail"){
            $("#report_table").setColProp('more_info', { formatter: ipsLinkFormatter });
        }else if(reportType == "mobile_detail") {
            $("#report_table").setColProp('hostname', { formatter: mobileLinkFormatter });
            $("#report_table").setColProp('user', { formatter: mobileLinkFormatter });
            $("#report_table").setColProp('checkname', { formatter: mobileLinkFormatter });
        }

    }

    function ipsLinkFormatter(elem, cellval, opts){
        if(cellval.colModel.name === 'more_info'){
            return "<a href='" + portal_link + opts[11] +"' target='ipsportal'>" + elem + "</a>";
        }
    }

    function mobileLinkFormatter(elem, cellval, opts){
        // Use encodeURIComponent() instead of escape() because jQuery internally uses decodeURIComponent()
        // and sometimes escape() doesn't work with decodeURIComponent(). Also since hostname may contain
        // a ' character, quote the value of href at the end with " instead of '. 
        var uri = "detail?sn=" + urlSn + "&reptype=mobile_detail&search=";
        var name = cellval.colModel.name;
        if(name === 'hostname'){
            uri = uri + encodeURIComponent('hostname=' + elem);
        }else if(name === 'user'){
            uri = uri + encodeURIComponent('user=' + elem);
        }else if(name === 'checkname'){
            if(opts[7] === 2) {
                // If compliance_status is 2, which means Unknown, no need to add a link to it.
                return elem;
            }
            // checkinfo is '<update_time>:<compliance_status>:<compliance_setting>:<device_type>'.
            var checkinfo = encodeURIComponent(opts[0] + ';' + opts[7] + ';' + opts[8] + ';' + opts[11]);
            return "<a href='' data-checkinfo='" + checkinfo + "' class='mobiledialog' >"+ elem + "</a>";
        }
        return '<a href="' + uri + '">' + elem + '</a>'
    }

    $(window).bind('resizeEnd', function() {
        var grid = "#report_table";
        var parent = "#grid_data";
        var grid_width = resizegrid();
        $("#webui_content").width(grid_width);
        $(grid).setGridWidth(100, true); 
        $(grid).setGridWidth($(parent).width(), true);
    });             
   
    $(document).on('click', '.mobiledialog', S_MOBILE_DETAIL.showDetailsDialog);
});
