/*global S_HEALTH_REP_CHART_VIEW, S_HEALTH_REP_GRID_VIEW, S_HEALTH_REP_NO_DATA, S_HEALTH_REP_LOADING_TEXT, S_HEALTH_REP_VIEW_SUMMARY, resizegrid, showChart, plotChart, getChartData, alert, mem_plot_trend, cpu_plot_trend, S_EXPORTING_FILE, S_PROCESSING*/
var S_HEALTH_REP = {
    resultData : '',
    period: '1d',
    urlSn : '',
    htmlDate: '',
    htmlSn: '',
    urlTz: '',
    startTime: '',
    endTime: '',
    rep_type: 'health_summary',
    seriesEarliestRecord : '',
    seriesLatestRecord : '',
    reportName : '',

    init: function () {
        S_HEALTH_REP.htmlDate = $("#date").val();
        S_HEALTH_REP.urlSn = $.getUrlVar('sn');
        S_HEALTH_REP.htmlSn = $("#sn").val();
        S_HEALTH_REP.urlTz = $.getUrlVar('tz');
        S_HEALTH_REP.rep_type = $.getUrlVar('reptype');
        S_HEALTH_REP.initUI();
        S_HEALTH_REP.initEvents();
    },

    initUI: function () {
        S_HEALTH_REP.getAllData();
    },

    toggleInterfaceView : function (event) {
        $('#interface_view i').toggleClass('icon-th-list, icon-picture');
        if ($('#grid_data').is(":hidden")) {
            $('#interface_view').attr('title', S_HEALTH_REP_CHART_VIEW);
            $('#grid_data').show();
            $('#bps_select').show();
            $('.interfaces_chart').hide();
            S_HEALTH_REP.resizeInterfaceGrid();
        } else {
            $('#interface_view').attr('title', S_HEALTH_REP_GRID_VIEW);
            $('#grid_data').hide();
            $('#bps_select').hide();
            $('.interfaces_chart').show();
            S_HEALTH_REP.resizeInterfaceCharts();
        }
    },
    initEvents: function () {
        $('#bps_select').change(function () {
            S_HEALTH_REP.showPivotsData();
        });

        $('#interface_view').on('click',  S_HEALTH_REP.toggleInterfaceView);
        $('#pdf_link').click(function () {
            var interface_type = '';
            var reportType = $('#chart_select option:selected').val();

            WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

            $.ajax({
                url: "saveAsPdf?serial=" + S_HEALTH_REP.htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + reportType + "&start_time=" + S_HEALTH_REP.seriesEarliestRecord + "&end_time=" + S_HEALTH_REP.seriesLatestRecord +
                     "&tz_offset_start=" + S_HEALTH_REP.tzOffsetStart +  "&tz_offset_end=" + S_HEALTH_REP.tzOffsetEnd +  "&interface_type=" + interface_type,
                type: 'POST',
                contentType: 'application/json',
                success: function (data) {
                    if (!data.status) {
                        if (data.message) {
                            alert(data.message);
                        }
                        return true;
                    }
                    var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                    window.location = "get_pdf_file?serial=" + S_HEALTH_REP.htmlSn + file_args;
                    return false;
                },
                complete: function (filename) {
                    WGRD.progressModalClose();
                }
            });
        });

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            S_HEALTH_REP.getAllData();
        });

        $(window).bind('resizeEnd', function () {
            S_HEALTH_REP.resizeInterfaceGrid();
            S_HEALTH_REP.resizeInterfaceCharts();
        });
    },

    resizeInterfaceGrid : function () {
        var grid = "#grid_area";
        var parent = "#grid_data";
        var grid_width = resizegrid();
        $("#webui_content").width(grid_width);
        $(grid).setGridWidth(100, true);
        $(grid).setGridWidth($(parent).width(), true);
        if (window.mem_plot_trend) {
            mem_plot_trend.replot();
        }
        if (window.cpu_plot_trend) {
            cpu_plot_trend.replot();
        }
    },

    resizeInterfaceCharts : function () {
        var series = S_HEALTH_REP.resultData;
        if (series.interface_trend_plots !== undefined) {
            var i;
            for (i = 0; i < series.interface_trend_plots.length; i++) {
                if (series.interface_trend_plots[i]) {
                    series.interface_trend_plots[i].replot();
                }
            }
        }
    },

    showPivotsData : function () {
        var pivot_type = $('#bps_select option:selected').val();
        var series = S_HEALTH_REP.resultData;
        if (series.count === 0) {
            return;
        }
        var grid = $("#grid_area");
        var parent = $("#grid_data");

        //Hide / show cols based on the pivot selected, always show 'Interface name' column
        if (pivot_type === 'by_sent') {
            //Hide Upload Rate, Download Rate, Sent Packets, Received packets and Dropped packets col
            S_HEALTH_REP.showGridCols(false, grid, [5, 6, 7]);
            //Show Sent bytes and Received bytes col
            S_HEALTH_REP.showGridCols(true, grid, [2, 3, 4]);
        } else {
            //Hide Upload Rate, Download Rate, Sent Packets, Received packets and Dropped packets col
            S_HEALTH_REP.showGridCols(false, grid, [2, 3, 4]);
            //Show Sent bytes and Received bytes col
            S_HEALTH_REP.showGridCols(true, grid, [5, 6, 7]);
        }
        var grid_width = resizegrid();
        $("#webui_content").width(grid_width);
        grid.setGridWidth(100, true);
        grid.setGridWidth(parent.width(), true);
    },

    showGridCols : function (showCols, grid, cols) {
        $.each(cols, function (index, value) {
            if (showCols) {
                grid.jqGrid('showCol', grid.getGridParam("colModel")[value].name);
            } else {
                grid.jqGrid('hideCol', grid.getGridParam("colModel")[value].name);
            }
        });
    },

    retrieveData: function (series) {
        S_HEALTH_REP.resultData = series;

        showHideLinkIcon(series, 'pdf');

        if (series.earliest_record !== '') {
            S_HEALTH_REP.seriesEarliestRecord = series.earliest_record;
        }
        if (series.latest_record !== '') {
            S_HEALTH_REP.seriesLatestRecord = series.latest_record;
        }
        S_HEALTH_REP.startTime = $.getDateDisplay(series.earliest_record, true, S_HEALTH_REP.urlTz);
        S_HEALTH_REP.endTime = $.getDateDisplay(series.latest_record, true, S_HEALTH_REP.urlTz);
        S_HEALTH_REP.reportName = $('#chart_select option:selected').text();

        // Notify the date navbar the report range changed
        $('#report_range').trigger('reportRange', { start_time: S_HEALTH_REP.startTime,
                                                    end_time: S_HEALTH_REP.endTime,
                                                    name: S_HEALTH_REP.reportName });

        // Unload the grid and then recreate it and populate the rows
        jQuery("#grid_area").GridUnload("#grid_area");


        // When series contains no data, series.grid_sord is undefined,
        // which causes createGrid() to raise an error.
        // Can't let this function return at the beginning when series has no data,
        // because it would make the empty report shown not like usual
        if (series.grid_sort) {
            S_HEALTH_REP.createGrid(series.col_names, series.col_model, series.grid_sort);
        }

        var i = 0;
        for (i = 0; i <= series.grid_data.length; i++) {
            $("#grid_area").jqGrid('addRowData', i + 1, series.grid_data[i]);
        }
        $("#grid_area").setGridParam({rowNum: i});

        $("#grid_area").jqGrid('footerData', 'set', series.footer, false);

        S_HEALTH_REP.showUsageData();
        S_HEALTH_REP.showPivotsData();
    },

    genInterfaceUI : function (interface_data) {
        $('#intf_chart').empty();
        var chart_div = '<div class="interfaces_chart row-fluid">' +
                          '<div class="frontpanelUnit">' +
                            '<div id="template_frontpanelUnitHeader" class="frontpanelUnitHeader"></div>' +
                            '<div id="chart_area" class="singleChart">' +
                              '<div class="chart" style="padding:15px;padding-right:20px;">' +
                                '<div id="template_chart_graph" style="height:175px;" class="shown"></div>' +
                                '<div id="template_chart_empty" class="empty">' + S_HEALTH_REP_NO_DATA + '</div>' +
                                '<div id="template_chart_loading" class="loading">' +
                                  '<p align="center"><img src="/images/loader.gif" />' + S_HEALTH_REP_LOADING_TEXT + '</p>' +
                                '</div>' +
                              '</div>' +
                            '</div>' +
                          '</div>' +
                        '</div>';
        var i;
        var name;
        var id;
        var display_name;
        var uri;
        var header_element;
        for (i = 0; i < interface_data.length; i++) {
            name = interface_data[i].intf_name;
            id = interface_data[i].intf_id;
            display_name = name + ' (' + id + ')';
            uri = 'health?sn=' + S_HEALTH_REP.urlSn + '&reptype=interface_summary' + '&id=' + id;
            header_element = '<span>' + display_name + '<span><span class="pull-right"><a href="' + uri + '">' + S_HEALTH_REP_VIEW_SUMMARY + '</a></span>';

            $('#intf_chart').append(chart_div);
            $('#template_frontpanelUnitHeader').attr('id', id + '_frontpanelUnitHeader');

            $('#' + id + '_frontpanelUnitHeader').append(header_element);
            $('#template_chart_graph').attr('id', id + '_chart_graph');
            $('#template_chart_empty').attr('id', id + '_chart_empty');
            $('#template_chart_loading').attr('id', id + '_chart_loading');
        }
    },

    plotInterfaceCharts : function (series) {

        var intf_data = series.data[4][0];

        if (intf_data.length !== 0) {
            S_HEALTH_REP.genInterfaceUI(intf_data);
            series.interface_trend_plots = [];
            var i;
            var id;
            for (i = 0; i < intf_data.length; i++) {
                id = intf_data[i].intf_id;
                showChart(id + '_chart');
                plotChart(series, id + '_chart', true);
            }
        }
    },

    showUsageData : function () {
        var series_data = S_HEALTH_REP.resultData;
        if (series_data.count === 0) {
            return;
        }
        var mem_data = series_data.data[2];
        var cpu_data = series_data.data[3];

        $('#mem_min').text(mem_data[0]);
        $('#mem_avg').text(mem_data[1]);
        $('#mem_max').text(mem_data[2]);

        $('#cpu_min').text(cpu_data[0]);
        $('#cpu_avg').text(cpu_data[1]);
        $('#cpu_max').text(cpu_data[2]);
    },

    // Report DataGrid
    createGrid : function (colNames, colModel, gridSort) {
        $("#grid_area").jqGrid({
            datatype: "local",
            colNames: colNames,
            colModel: colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            footerrow: true
        });

        $("#grid_area").setColProp('send_bps_min', { formatter: WGRD.bpsFormatterGrid });
        $("#grid_area").setColProp('send_bps_max', { formatter: WGRD.bpsFormatterGrid });
        $("#grid_area").setColProp('send_bps_avg', { formatter: WGRD.bpsFormatterGrid });

        $("#grid_area").setColProp('recv_bps_min', { formatter: WGRD.bpsFormatterGrid });
        $("#grid_area").setColProp('recv_bps_max', { formatter: WGRD.bpsFormatterGrid });
        $("#grid_area").setColProp('recv_bps_avg', { formatter: WGRD.bpsFormatterGrid });

        $("#grid_area").setColProp('interface_name', { formatter: S_HEALTH_REP.interfaceLinkFormatter });
        $("#grid_area").setColProp('interface_name', {
            sorttype: function (cellvalue, options) {
                // The interface_id string will be "ethX', 'X' is a number.
                return parseInt(options.interface_id.substring(3), 10);
            }
        });
    },

    interfaceLinkFormatter : function (elem, cellval, opts) {
        var intf = opts.interface_id;
        var uri = 'health?sn=' + S_HEALTH_REP.urlSn + '&reptype=interface_summary' + '&id=' + intf;
        return "<a href='" + uri + "'>" + elem + "</a>";
    },

    getAllData: function () {
        var divName = 'chart';
        var jqxhr = getChartData(divName, S_HEALTH_REP.htmlSn, true);
        jqxhr.success(S_HEALTH_REP.retrieveData);
    }
};
$(document).ready(S_HEALTH_REP.init);
