$(document).ready(function() {
	var resultData = new Object();
	var reportName = '';
	var reportCategory = '';
    var portal_link = "https://securityportal.watchguard.com/Threats/Detail?ruleId=";
    var htmlSn = $("#sn").val();    
    var reportType = $("#report_type").val();
    var urlTz = $.getUrlVar('tz');      
    var resultData = new Object();    
    var showDetailView = false;
    var startTime = '';
    var endTime = '';

	$('#pdf_link').click(function(){
		resultData.grid_data = updateTimezones(resultData.grid_data, resultData.col_model);
		resultData.user_data = updateUserTimezones(resultData.user_data, resultData.user_col_model);

		data = JSON.stringify(resultData);
		
		var tzOffsetStart = $.getDateUTCOffsetString(startTime, urlTz);
		var tzOffsetEnd = $.getDateUTCOffsetString(endTime, urlTz);

		$.ajax({
			url:"saveAsPdf?serial=" + htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + reportType + "&start_time=" + startTime + "&end_time=" + endTime
		          + "&tz_offset_start=" + tzOffsetStart +  "&tz_offset_end=" + tzOffsetEnd,
			type: 'POST',
			data: data,
			contentType: 'application/json',
			success: function(data) {
				if(!data.status){
					if(data.message){
						alert(data.message);
					}
					return true;
				}
				window.location = "get_pdf_file?serial=" + htmlSn;
				return false;
			}	
		});
	}); 

    getData();     

    function showChartLoading(){
        $('#chart_loading').show();        
        $('#chart_empty').hide();                        
        $('#chart').hide();
    }
     
    function getData(){
        //Once the date is set, refresh all the charts
        var jqxhr = getOnDemandChartData('chart', htmlSn, true, true, reportType);
    }
    
    function getOnDemandChartData(){
        var b_time = $('#start_time_picker').val();
        var e_time = $('#end_time_picker').val();
        var begin_time = $.getDateLocalToSecs(b_time);
        var end_time = $.getDateLocalToSecs(e_time); 
                    
        if(!begin_time || !end_time){ return; }

        showChartLoading('chart');
        var jqxhr = $.ajax({
           url: 'get_ondemand_data?report_type=' + reportType + '&sn=' + htmlSn + '&start_time=' + begin_time + '&end_time=' + end_time,
           method: 'GET',
           dataType: 'json',
           success: onDemandReceived,
           error: errorHandler
        });     
        return jqxhr;
    }     
     
    // Return data handler functions
    function onDemandReceived(series){
        resultData = series;
        showDetailView = series.detail_view;

        if(series.count > 0){
            showChart('chart');
            plotChart(series, 'chart', true);
        }else{
            showChartEmpty('chart');
            return;
        }        
    
        startTime = $.getDateDisplay(series.earliest_record, true, urlTz);
        endTime = $.getDateDisplay(series.latest_record, true, urlTz);
        $('#report_select').find('option:selected').each(function(){
        	reportCategory = $(this).parent().attr("label");
        });
        reportName = $('#report_select option:selected').text();  
        
        // Unload the grid and then recreate it and populate the rows
        jQuery("#app_grid_area").GridUnload("#app_grid_area");
        createAppGrid(series.col_names, series.col_model);
                
        var i = 0;
        for(i=0;i<=series.grid_data.length;i++) {
            $("#app_grid_area").jqGrid('addRowData',i+1,series.grid_data[i]);
        }
        $("#app_grid_area").setGridParam({rowNum:i});          
        $("#app_grid_area").jqGrid('footerData','set', series.footer, false);        
        setGridHeight();
        
		resultData = series;     
    }          
     
    function createAppGrid(colNames, colModel){
        $('#app_grid_area').jqGrid({ 
            datatype: "local", 
            colNames:colNames,
            colModel:colModel,
            autoencode: true,
            autowidth:true,
            shrinkToFit: true,
            subGrid: true,
            footerrow:true,
            subGridRowExpanded: function(subgrid_id, row_id){
                var subgrid_table_id, pager_id;
                subgrid_table_id = "subgrid" + row_id;
                $("#" + subgrid_id).html("<table id='" + subgrid_table_id + "'></table>");
                jQuery("#" + subgrid_table_id).jqGrid({
                    datatype: "local",
                    colNames: resultData.user_col_names,
                    colModel: resultData.user_col_model,
                    height: '100%',
                    width: '100%',
                    onCellSelect: function(id, iCol, cellcontent, e) {
                        if(showDetailView){
                            doDetailView(id, subgrid_table_id, e.pageX, e.pageY);
                        }
                    }
                });
                

                
                // Add click handlers to the subgrid to link to the per client reports
                $("#" + subgrid_table_id).setColProp('host', { formatter: linkFormatter });     
                $("#" + subgrid_table_id).setColProp('ip', { formatter: linkFormatter });     
                $("#" + subgrid_table_id).setColProp('user', { formatter: linkFormatter });                 
                                
                //Get the subgrid data and fill it in here
                var app = $("#app_grid_area").jqGrid('getCell',row_id,'application');
                var row_data = resultData.user_data[app];
                var i = 0;                             
                for(i=0;i<=row_data.length;i++) {
                    $("#" + subgrid_table_id).jqGrid('addRowData',i+1, row_data[i]);
                }
                $("#" + subgrid_table_id).setGridParam({rowNum:i});   
                setGridHeight();                       
                
            },           
            subGridRowColapsed: function(subgrid_id, row_id) {
                /* IE doesn't resize grids with sub grids properly, so set the height manually  */            
                /* subtract the height of the subgrid that's being collapsed from the grids height */                
                var sub_height = $('#' + subgrid_id).height();
                var height = $('#app_grid_area').height();
                $('#app_grid_area').setGridHeight(height - sub_height);            
            }          
        });              
    }    
    
    /* IE doesn't resize grids with sub grids properly, so set the height manually  */
    function setGridHeight(){
        var height = $('#app_grid_area').height();
        $('#app_grid_area').setGridHeight(height);    
    }    
    
    linkFormatter = function(elem, cellval, opts){
        return formatPerClientLink(elem, cellval);
    }

    function formatPerClientLink(elem, cellval){
        var index = startTime.indexOf(' ');
        var start_date = startTime.substring(0,index);
        var start_time = startTime.substring(index + 1, startTime.length);
        index = endTime.indexOf(' ');
        var end_date = endTime.substring(0,index);
        var end_time = endTime.substring(index + 1, endTime.length);            

        uri = 'perclient?sn=' + htmlSn + 
              '&start_date=' + start_date + 
              '&start_time=' + start_time + 
              '&end_date=' + end_date + 
              '&end_time=' + end_time;
        if(cellval.colModel.name == 'ip'){
            uri = uri + '&ip=' + elem;
        }else if(cellval.colModel.name == 'user'){
            uri = uri + '&user=' + elem;
        }else if(cellval.colModel.name == 'host'){
            uri = uri + '&host=' + escape(elem);
        }              

        return "<a href='" + uri + "'>" + escapeHtml(elem) + "</a>";
    }      
    
    /* -=-=-=- detail view -=-=-=- */
    $("#detailview").dialog(
        {
            width: 600,
            resizable: false,
            autoOpen: false
        }
    );
    
    function doDetailView(id, subgrid_table_id, pageX, pageY) {
        var time = $("#" + subgrid_table_id).jqGrid('getCell',id,'time');    
        var output = "<table width='100%' style='padding: 3px;'>";
        
        for (var i=0; i<resultData.user_col_model.length; i++){
            var val = $("#" + subgrid_table_id).jqGrid('getCell',id, resultData.user_col_model[i].index);
            var name = resultData.user_col_names[i];
            output += "<tr><td width='150'>" + name + "</td><td>" + val + "</td></tr>";
        }
        output += "<tr><td colspan='2'>&nbsp;</td></tr>";
        
        var sig_id = $("#" + subgrid_table_id).jqGrid('getCell',id,'sig_id');    
        if(sig_id != ""){
            output += "<tr><td colspan='2'><a href='" + portal_link + sig_id +"' target='ipsportal'>"+ portal_link + sig_id + "</a></td></tr>";
            output += "<tr><td colspan='2'>&nbsp;</td></tr>";
        }
                        
        output += "</table>";
        output += "<div>&nbsp;</div>";
        $("#detailview").html("<div>" + output + "</div>");

        /* 
        * If the detail view has scrolled out of view, reposition it centered
        * and below the row that was clicked
        */
        offset = $("#detailview").offset();
        if (offset != null) {
            var scrollTop = $(document).scrollTop();
            var h_win = $(window).height();
            if (offset.top < scrollTop
                || offset.top > scrollTop + h_win) {
                w_doc = $(document).width();
                w_dlg = $("#detailview").width();
                var x = (w_doc - w_dlg) / 2;
                var y = pageY - scrollTop + 10;

                $("#detailview").dialog({ position: [x, y] });
            }
        }

        /* Reset the height to 'auto' for IE */
        $("#detailview").dialog({ height: 'auto' });
        $("#detailview").dialog({ title: time });
        $("#detailview").dialog("open");
    }

    $(window).bind('resizeEnd', function() {
        if(window.plot_trend){        
            var grid = "#app_grid_area";
            var parent = "#grid_data";
            var grid_width = resizegrid();
            $("#webui_content").width(grid_width);
            $(grid).setGridWidth(100, true); 
            $(grid).setGridWidth($(parent).width(), true);
            plot_trend.replot();
        }
    });        
});
