/*global unescape, escape, alert, errorHandler, updateTimezones, time_plot_trend:true, audit_plot_trend:true, domain_plot_trend:true, usage_plot_trend:true, dlp_rule_plot_trend:true, updateChartTimes, WGRD_CHARTS, S_EXPORTING_FILE, S_PROCESSING */
var S_PERCLIENT_REP = {
    allVars : '',
    urlSn : '',
    urlIp : '',
    urlHost : '',
    urlUser : '',
    urlDevice : '',
    urlStartDate : '',
    urlStartTime : '',
    urlEndDate : '',
    urlEndTime : '',
    urlPolicy : '',
    urlRule : '',
    urlTz : '',
    htmlSn : '',
    htmlIp : '',
    htmlHost : '',
    htmlUser : '',
    htmlDevice : '',
    htmlPolicy : '',
    htmlRule : '',
    htmlStartTime : '',
    htmlEndTime : '',
    seriesEarliestRecord : '',
    seriesLatestRecord : '',
    timeRangeError : '',
    invalidIPError : '',
    date : '',
    domainSeries : '',
    timeSeries : '',
    auditSeries : '',
    usageSeries : '',
    dlpRuleSeries : '',
    curUser : '',
    curIp : '',
    curHost : '',
    curDevice : '',
    curPolicy : '',
    curRule : '',
    gGetDataOnLoad : false,
    from_init : 0,

    init: function () {

        S_PERCLIENT_REP.allVars = $.getUrlVars();
        S_PERCLIENT_REP.urlSn = $.getUrlVar('sn');
        S_PERCLIENT_REP.urlIp = $.getUrlVar('ip');
        S_PERCLIENT_REP.urlHost = $.getUrlVar('host');
        S_PERCLIENT_REP.urlUser = $.getUrlVar('user');
        S_PERCLIENT_REP.urlDevice = $.getUrlVar('device');
        S_PERCLIENT_REP.urlStartDate = $.getUrlVar('start_date');
        S_PERCLIENT_REP.urlStartTime = $.getUrlVar('start_time');
        S_PERCLIENT_REP.urlEndDate = $.getUrlVar('end_date');
        S_PERCLIENT_REP.urlEndTime = $.getUrlVar('end_time');
        S_PERCLIENT_REP.urlPolicy = $.getUrlVar('policy');
        S_PERCLIENT_REP.urlRule = $.getUrlVar('rule');
        S_PERCLIENT_REP.urlTz = $.getUrlVar('tz');

        S_PERCLIENT_REP.htmlSn = $("#sn").val();
        S_PERCLIENT_REP.htmlIp = $("#ip").val();
        S_PERCLIENT_REP.htmlHost = $("#host").val();
        S_PERCLIENT_REP.htmlUser = $("#user").val();
        S_PERCLIENT_REP.htmlDevice = $("#device").val();
        S_PERCLIENT_REP.htmlPolicy = $("#policy").val();
        S_PERCLIENT_REP.htmlRule = $("#rule").val();

        S_PERCLIENT_REP.htmlStartTime = $("#start_time").val();
        S_PERCLIENT_REP.htmlEndTime = $("#end_time").val();

        S_PERCLIENT_REP.timeRangeError = $("#time_range_error").val();
        S_PERCLIENT_REP.invalidIPError = $("#invalid_ip_error").val();

        S_PERCLIENT_REP.initUI();
        S_PERCLIENT_REP.initEvents();
    },

    initUI: function () {

        if ((S_PERCLIENT_REP.urlUser && S_PERCLIENT_REP.urlUser !== "") || (S_PERCLIENT_REP.htmlUser !== "")) {
            $('#user_name').val(S_PERCLIENT_REP.urlUser || S_PERCLIENT_REP.htmlUser);
            S_PERCLIENT_REP.gGetDataOnLoad = true;
        }

        if ((S_PERCLIENT_REP.urlIp && S_PERCLIENT_REP.urlIp !== "") || (S_PERCLIENT_REP.htmlIp !== "")) {
            $('#ip_addr').val(S_PERCLIENT_REP.urlIp || S_PERCLIENT_REP.htmlIp);
            S_PERCLIENT_REP.gGetDataOnLoad = true;
        }

        if ((S_PERCLIENT_REP.urlHost && S_PERCLIENT_REP.urlHost !== "") || (S_PERCLIENT_REP.htmlHost !== "")) {
            var urlHost = unescape(S_PERCLIENT_REP.urlHost);
            var htmlHost = unescape(S_PERCLIENT_REP.htmlHost);
            var hostVal = urlHost;
            if (htmlHost !== "null") {
                hostVal = htmlHost;
            }
            $('#host_name').val(hostVal);
            S_PERCLIENT_REP.gGetDataOnLoad = true;
        }

        if ((S_PERCLIENT_REP.urlDevice && S_PERCLIENT_REP.urlDevice !== "") || (S_PERCLIENT_REP.htmlDevice !== "")) {
            var urlDevice = unescape(S_PERCLIENT_REP.urlDevice);
            var htmlDevice = unescape(S_PERCLIENT_REP.htmlDevice);
            var deviceVal = (htmlDevice !== "null") ? htmlDevice : urlDevice;
            $('#device_name').val(deviceVal);
            S_PERCLIENT_REP.gGetDataOnLoad = true;
        }

        if ((S_PERCLIENT_REP.urlPolicy && S_PERCLIENT_REP.urlPolicy !== "") || (S_PERCLIENT_REP.htmlPolicy !== "")) {
            $('#policy_name').val(S_PERCLIENT_REP.urlPolicy || S_PERCLIENT_REP.htmlPolicy);
            S_PERCLIENT_REP.gGetDataOnLoad = true;
        }

        if ((S_PERCLIENT_REP.urlRule && S_PERCLIENT_REP.urlRule !== "") || (S_PERCLIENT_REP.htmlRule !== "")) {
            $('#rule_name').val(S_PERCLIENT_REP.urlRule || S_PERCLIENT_REP.htmlRule);
            S_PERCLIENT_REP.gGetDataOnLoad = true;
        }

        if ($('#show_detail').val() === '0') {
            $('#perclient_summary').show();
            $('#perclient_detail').hide();
        } else {
            $('#perclient_detail').show();
            $('#perclient_summary').hide();
            $('#per_client_table').css('width', '99%');
            S_PERCLIENT_REP.from_init = 1;
        }
        S_PERCLIENT_REP.enableUpdateButton();
        S_PERCLIENT_REP.hidePdfLinks();
        S_PERCLIENT_REP.hideCsvLinks();
        S_PERCLIENT_REP.showHideDeviceCriteria();
    },

    initEvents: function () {

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen fora click on this div, it means the date changed
            // and a refresh is needed
            var username = $('#user_name').val();
            var ipaddr = $('#ip_addr').val();
            var hostname = $('#host_name').val();
            var devicename = $('#device_name').val();
            var policyname = $('#policy_name').val();
            var rulename = $('#rule_name').val();
            var show_report =  $('#show_detail').val();
            if (username !== '' || ipaddr !== '' || hostname !== '' || devicename !== '' || policyname !== '' || rulename !== '') {
                if (show_report === '0') {
                    S_PERCLIENT_REP.getChartData();
                } else if (show_report === '1') {
                    S_PERCLIENT_REP.getDetailReportData();
                }
                S_PERCLIENT_REP.gGetDataOnLoad = false;
            }
        });
        $('#user_name,#policy_name,#ip_addr,#rule_name,#host_name,#device_name').bind('keypress', function (e) {
            if (e.keyCode === 13 && S_PERCLIENT_REP.criteriaExists()) {
                $("#btn_update").click();
            }
        });

        $("#btn_update").click(function () {
            var show_report = $('#show_detail').val();
            if (show_report === '0') {
                S_PERCLIENT_REP.getChartData();
            } else if (show_report === '1') {
                S_PERCLIENT_REP.getDetailReportData();
            }
        });

        $(window).bind('resizeEnd', function () {

            var show_report =  $('#show_detail').val();
            var marginleft = parseInt($("#report_td").css('padding-left'), 10);
            var marginright = parseInt($("#report_td").css('padding-right'), 10);
            var reports_section_width = $('#device_reports').width() - $("#date_navbar_td").width() - (marginleft + marginright);
            if (show_report === '1') {
                if (S_PERCLIENT_REP.from_init === 0) {
                    $('.resize_widget').css('width', reports_section_width);
                    $('.resize_widget table').setGridWidth($('.resize_widget').width(), true);
                } else {
                    S_PERCLIENT_REP.from_init = 0;
                }
            } else {
                if (reports_section_width > 850) { //If current width for reports section is more than 850, each div should have span6
                    $('.resize_widget').addClass('span6').css('width', '');
                    $('.resize_widget.alt').css('margin-left', '')
                                           .addClass('span6')
                                           .css('width', '');
                } else { // Otherwise, update the width of each div to the available viewport width
                    $('.resize_widget.alt').css('width', reports_section_width)
                                           .css('margin-left', 'auto');
                    $('.resize_widget').css('width', reports_section_width);

                }
                $('.resize_widget table').setGridWidth($('.resize_widget').width(), true);
            }

            if (window.time_plot_trend) {
                time_plot_trend.replot();
            }

            if (window.audit_plot_trend) {
                audit_plot_trend.replot();
            }

            if (window.domain_plot_trend) {
                domain_plot_trend.replot();
            }

            if (window.usage_plot_trend) {
                usage_plot_trend.replot();
            }

            if (window.dlp_rule_plot_trend) {
                dlp_rule_plot_trend.replot();
            }
        });

        $('#time_pdf_link').click(function () {
            S_PERCLIENT_REP.getPdf(S_PERCLIENT_REP.timeSeries, 'time');
        });

        $('#audit_pdf_link').click(function () {
            S_PERCLIENT_REP.getPdf(S_PERCLIENT_REP.auditSeries, 'audit');
        });

        $('#domain_pdf_link').click(function () {
            S_PERCLIENT_REP.getPdf(S_PERCLIENT_REP.domainSeries, 'domain');
        });

        $('#usage_pdf_link').click(function () {
            S_PERCLIENT_REP.getPdf(S_PERCLIENT_REP.usageSeries, 'usage');
        });

        $('#dlp_rule_pdf_link').click(function () {
            S_PERCLIENT_REP.getPdf(S_PERCLIENT_REP.dlpRuleSeries, 'dlp_rule');
        });

        $('#dlp_csv_link').click(function () {
            S_PERCLIENT_REP.getCsv('dlp_detail');
        });

        $('#audit_csv_link').click(function () {
            S_PERCLIENT_REP.getCsv('audit_detail');
        });

        $('#url_audit_csv_link').click(function () {
            S_PERCLIENT_REP.getCsv('url_audit_detail');
        });

        $('#app_usage_csv_link').click(function () {
            S_PERCLIENT_REP.getCsv('app_usage_detail');
        });

        $('#show_hide_criteria').on('click', S_PERCLIENT_REP.toggleCriteria);

        $('#user_name, #ip_addr, #host_name, #device_name').bind('input', S_PERCLIENT_REP.enableUpdateButton);
    },

    getDetailReportData: function () {
        $('#no_detail_reps').hide();
        S_PERCLIENT_REP.hideCsvLinks();
        S_PERCLIENT_REP.showDetailReportElements();
        S_PERCLIENT_REP.getURLAuditDetailData();
        S_PERCLIENT_REP.getAppUsageDetailData();
        S_PERCLIENT_REP.getWebAuditDetailData();
        S_PERCLIENT_REP.getDlpDetailData();
    },

    showDetailReportElements: function () {
        $('#url_audit_detail').show();
        $('#audit_detail').show();
        $('#app_usage_detail').show();
        $('#dlp_detail').show();
    },

    criteriaExists: function () {
        return ($('#user_name').val().trim() || $('#ip_addr').val().trim() || $('#host_name').val().trim() || $('#device_name').val().trim());
    },

    //Enable Update button only if either user name or ip address or host name is not empty
    enableUpdateButton: function () {
        var enableButton = S_PERCLIENT_REP.criteriaExists();
        WGRD.enableUIElements(enableButton, ['#btn_update']);
    },

    toggleCriteria: function (event) {
        event.preventDefault();
        $('.criteria').slideToggle("slow");
        if ($('#show_hide_criteria i').hasClass("icon-chevron-down")) {
            $('#show_hide_criteria i').removeClass("icon-chevron-down");
            $('#show_hide_criteria i').addClass("icon-chevron-up");
        } else {
            $('#show_hide_criteria i').removeClass("icon-chevron-up");
            $('#show_hide_criteria i').addClass("icon-chevron-down");
        }
    },

    showChartsLoading: function () {

        $('#time_loading').show();
        $('#time_graph').hide();
        $('#time_empty').hide();

        $('#domain_loading').show();
        $('#domain_graph').hide();
        $('#domain_empty').hide();

        $('#audit_loading').show();
        $('#audit_graph').hide();
        $('#audit_empty').hide();

        $('#usage_loading').show();
        $('#usage_graph').hide();
        $('#usage_empty').hide();

        $('#dlp_rule_loading').show();
        $('#dlp_rule_graph').hide();
        $('#dlp_rule_empty').hide();

        S_PERCLIENT_REP.hidePdfLinks();
    },

    hidePdfLinks: function () {
        $('#time_pdf_link').hide();
        $('#domain_pdf_link').hide();
        $('#audit_pdf_link').hide();
        $('#usage_pdf_link').hide();
        $('#dlp_rule_pdf_link').hide();
    },

    hideCsvLinks: function () {
        $('#url_audit_csv_link').hide();
        $('#audit_csv_link').hide();
        $('#dlp_csv_link').hide();
        $('#app_usage_csv_link').hide();
    },

    showHideDeviceCriteria: function () {
        if ($('#show_device').val() === '1' || $('#device_name').val() !== '') {
            $('#device_criteria').show();
        } else {
            $('#device_criteria').hide();
        }
    },

    getChartData: function () {
        // options: time, domain, audit, url, usage
        //sn=None, ip='', host='', user='', start_time='', end_time='', option=''):

        var args = S_PERCLIENT_REP.getRepArgs();

        // Unload the grids before getting data
        jQuery("#time_grid").GridUnload("#time_grid");
        jQuery("#domain_grid").GridUnload("#domain_grid");
        jQuery("#audit_grid").GridUnload("#audit_grid");
        jQuery("#usage_grid").GridUnload("#usage_grid");
        jQuery("#dlp_rule_grid").GridUnload("#dlp_rule_grid");

        S_PERCLIENT_REP.showChartsLoading();

        $.ajax({
            url: 'get_per_client?option=time',
            data: args,
            method: 'GET',
            dataType: 'json',
            success: S_PERCLIENT_REP.onTimeDataReceived
        });
        $.ajax({
            url: 'get_per_client?option=domain',
            data: args,
            method: 'GET',
            dataType: 'json',
            success: S_PERCLIENT_REP.onDomainDataReceived
        });
        $.ajax({
            url: 'get_per_client?option=audit',
            data: args,
            method: 'GET',
            dataType: 'json',
            success: S_PERCLIENT_REP.onAuditDataReceived
        });
        $.ajax({
            url: 'get_per_client?option=usage',
            data: args,
            method: 'GET',
            dataType: 'json',
            success: S_PERCLIENT_REP.onUsageDataReceived
        });
        $.ajax({
            url: 'get_per_client?option=dlp_rule',
            data: args,
            method: 'GET',
            dataType: 'json',
            success: S_PERCLIENT_REP.onDlpRuleDataReceived
        });
    },

    // Return data handler functions
    onTimeDataReceived: function (series) {

        S_PERCLIENT_REP.seriesEarliestRecord = series.earliest_record;
        S_PERCLIENT_REP.seriesLatestRecord = series.latest_record;

        if (series.count <= 0) {
            $('#time_graph').hide();
            $('#time_loading').hide();
            $('#time_empty').show();
            return;
        }

        $('#time_graph').show();
        $('#time_loading').hide();
        $('#time_pdf_link').show();

        updateChartTimes(series);

        var i,
            repDates,
            timespan;

        if (series.chart_type === 'date') {
            for (i = 0; i < series.legend.length; i++) {
                WGRD_CHARTS.date_options.series[i].label = series.legend[i];
                if (series.data[i].length === 1) {
                    /*
                    The Web Activity Trend report in Per-client reports:
                    When the selected user/ip/host name only has data of one point-in-time,
                    should print a distinct dot in chart in web UI, instead of print noting.
                    */
                    WGRD_CHARTS.date_options.series[i].showMarker = true;
                }
            }
            WGRD_CHARTS.date_options.axes.yaxis.ticks = series.ticks;
            if (Math.max.apply(Math, series.ticks) < 5) {
                WGRD_CHARTS.date_options.axes.yaxis.tickOptions.formatString = '%.2f';
            }

            repDates = S_PERCLIENT_REP.getStartEndDates();
            timespan = repDates.end_date - repDates.start_date;
            if (repDates.end_date !== '' && timespan > 86400) {
                /* If the time span is bigger than one day, use the MM-DD HH:MM format */
                WGRD_CHARTS.date_options.axes.xaxis.tickOptions.formatString = '%m-%d %H:%M';
            } else {
                /* If the period is one day, use the HH:MM format */
                WGRD_CHARTS.date_options.axes.xaxis.tickOptions.formatString = '%H:%M';
            }

            time_plot_trend = $.jqplot('time_graph', series.data, WGRD_CHARTS.date_options);

        } else {
            WGRD_CHARTS.bar_line_options.axes.yaxis.ticks = series.ticks;
            if (Math.max.apply(Math, series.ticks) < 5) {
                WGRD_CHARTS.bar_line_options.axes.yaxis.tickOptions.formatString = '%.2f';
            }
            WGRD_CHARTS.bar_line_options.series[0].label = series.legend[0];
            WGRD_CHARTS.bar_line_options.series[1].label = series.legend[1];

            WGRD_CHARTS.bar_line_options.axes.yaxis.label = series.label[0];
            WGRD_CHARTS.bar_line_options.axes.y2axis.label = series.label[1];

            time_plot_trend = $.jqplot('time_graph', series.data, WGRD_CHARTS.bar_line_options);
        }

        time_plot_trend.replot();

        // Unload the grid and then recreate it and populate the rows
        jQuery("#time_grid").GridUnload("#time_grid");
        S_PERCLIENT_REP.createTimeGrid(series.col_names, series.col_model, series.grid_sort);

        for (i = 0; i <= series.grid_data.length; i++) {
            $("#time_grid").jqGrid('addRowData', i + 1, series.grid_data[i]);
        }

        $("#time_grid").setGridParam({rowNum: i});
        $("#time_grid").jqGrid('footerData', 'set', series.footer, false);

        S_PERCLIENT_REP.timeSeries = series;
        $('#time_grid').setGridWidth($('#time').width(), true);
    },

    // Return data handler functions
    onDomainDataReceived: function (series) {

        if (series.count <= 0) {
            $('#domain_graph').hide();
            $('#domain_loading').hide();
            $('#domain_empty').show();
            return;
        }

        $('#domain_graph').show();
        $('#domain_loading').hide();
        $('#domain_pdf_link').show();

        S_PERCLIENT_REP.seriesEarliestRecord = series.earliest_record;
        S_PERCLIENT_REP.seriesLatestRecord = series.latest_record;

        WGRD_CHARTS.bar_bar_options.series[0].label = series.legend[0];
        WGRD_CHARTS.bar_bar_options.series[1].label = series.legend[1];
        WGRD_CHARTS.bar_bar_options.axes.xaxis.ticks = series.ticks;
        if (Math.max.apply(Math, series.ticks) < 5) {
            WGRD_CHARTS.bar_bar_options.axes.xaxis.tickOptions.formatString = '%.2f';
        }
        WGRD_CHARTS.bar_bar_options.axes.yaxis.ticks = series.cat_ticks;

        domain_plot_trend = $.jqplot('domain_graph', series.data, WGRD_CHARTS.bar_bar_options);
        domain_plot_trend.replot();

        // Unload the grid and then recreate it and populate the rows
        jQuery("#domain_grid").GridUnload("#domain_grid");
        S_PERCLIENT_REP.createDomainGrid(series.col_names, series.col_model, series.grid_sort);

        var i = 0;
        for (i = 0; i <= series.grid_data.length; i++) {
            $("#domain_grid").jqGrid('addRowData', i + 1, series.grid_data[i]);
        }

        $("#domain_grid").setGridParam({rowNum: i});
        $("#domain_grid").jqGrid('footerData', 'set', series.footer, false);

        S_PERCLIENT_REP.domainSeries = series;
        $('#domain_grid').setGridWidth($('#domain').width(), true);
    },

    // Return data handler functions
    onAuditDataReceived: function (series) {
        if (series.count <= 0) {
            $('#audit_graph').hide();
            $('#audit_loading').hide();
            $('#audit_empty').show();
            return;
        }
        $('#audit_graph').show();
        $('#audit_loading').hide();
        $('#audit_pdf_link').show();

        S_PERCLIENT_REP.seriesEarliestRecord = series.earliest_record;
        S_PERCLIENT_REP.seriesLatestRecord = series.latest_record;

        audit_plot_trend = $.jqplot('audit_graph', series.data, WGRD_CHARTS.pie_options);
        audit_plot_trend.replot();

        // Unload the grid and then recreate it and populate the rows
        jQuery("#audit_grid").GridUnload("#audit_grid");
        S_PERCLIENT_REP.createAuditGrid(series.col_names, series.col_model, series.grid_sort);

        var i = 0;
        for (i = 0; i <= series.grid_data.length; i++) {
            $("#audit_grid").jqGrid('addRowData', i + 1, series.grid_data[i]);
        }
        $("#audit_grid").setGridParam({rowNum: i});

        $("#audit_grid").jqGrid('footerData', 'set', series.footer, false);
        S_PERCLIENT_REP.auditSeries = series;
        $('#audit_grid').setGridWidth($('#audit').width(), true);
    },

    // Return data handler functions
    onUsageDataReceived: function (series) {

        if (series.count <= 0) {
            $('#usage_graph').hide();
            $('#usage_loading').hide();
            $('#usage_empty').show();
            return;
        }
        $('#usage_graph').show();
        $('#usage_loading').hide();
        $('#usage_pdf_link').show();

        S_PERCLIENT_REP.seriesEarliestRecord = series.earliest_record;
        S_PERCLIENT_REP.seriesLatestRecord = series.latest_record;

        WGRD_CHARTS.bar_bar_options.series[0].label = series.legend[0];
        WGRD_CHARTS.bar_bar_options.series[1].label = series.legend[1];
        WGRD_CHARTS.bar_bar_options.axes.xaxis.ticks = series.ticks;
        if (Math.max.apply(Math, series.ticks) < 5) {
            WGRD_CHARTS.bar_bar_options.axes.xaxis.tickOptions.formatString = '%.2f';
        }
        WGRD_CHARTS.bar_bar_options.axes.yaxis.ticks = series.cat_ticks;

        usage_plot_trend = $.jqplot('usage_graph', series.data, WGRD_CHARTS.bar_bar_options);
        usage_plot_trend.replot();

        // Unload the grid and then recreate it and populate the rows
        jQuery("#usage_grid").GridUnload("#usage_grid");
        S_PERCLIENT_REP.createUsageGrid(series.col_names, series.col_model, series.grid_sort);

        var i = 0;
        for (i = 0; i <= series.grid_data.length; i++) {
            $("#usage_grid").jqGrid('addRowData', i + 1, series.grid_data[i]);
        }
        $("#usage_grid").setGridParam({rowNum: i});
        $("#usage_grid").jqGrid('footerData', 'set', series.footer, false);

        S_PERCLIENT_REP.usageSeries = series;
        $('#usage_grid').setGridWidth($('#usage').width(), true);
    },

    //If policy_name or rule_name present then show dlp_criteria UI else hide it
    showHideDLPCriteria: function () {
        if ($('#policy_name').val() || $('#rule_name').val()) {
            $('#dlp_criteria').show();
        } else {
            $('#dlp_criteria').hide();
        }
    },

    // Return data handler functions
    onDlpRuleDataReceived: function (series) {

        if (series.count <= 0) {
            $('#dlp_rule_graph').hide();
            $('#dlp_rule_loading').hide();
            $('#dlp_rule_empty').show();
            S_PERCLIENT_REP.showHideDLPCriteria();
            return;
        }
        $('#dlp_rule_graph').show();
        $('#dlp_rule_loading').hide();
        $('#dlp_rule_pdf_link').show();
        $('#dlp_criteria').show();

        WGRD_CHARTS.bar_options.series[0].label = series.legend[0];
        WGRD_CHARTS.bar_options.axes.xaxis.ticks = series.ticks;
        if (Math.max.apply(Math, series.ticks) < 5) {
            WGRD_CHARTS.bar_options.axes.xaxis.formatString = '%.2f';
        }
        WGRD_CHARTS.bar_options.axes.yaxis.ticks = series.cat_ticks;

        dlp_rule_plot_trend = $.jqplot('dlp_rule_graph', series.data, WGRD_CHARTS.bar_options);
        dlp_rule_plot_trend.replot();

        // Unload the grid and then recreate it and populate the rows
        jQuery("#dlp_rule_grid").GridUnload("#dlp_rule_grid");
        S_PERCLIENT_REP.createDlpRuleGrid(series.col_names, series.col_model, series.grid_sort);

        var i = 0;
        for (i = 0; i <= series.grid_data.length; i++) {
            $("#dlp_rule_grid").jqGrid('addRowData', i + 1, series.grid_data[i]);
        }
        $("#dlp_rule_grid").setGridParam({ rowNum: i });
        $("#dlp_rule_grid").jqGrid('footerData', 'set', series.footer, false);

        S_PERCLIENT_REP.dlpRuleSeries = series;
        $('#dlp_rule_grid').setGridWidth($('#dlp_rule').width(), true);
    },

    // Report DataGrid
    createTimeGrid: function (colNames, colModel, gridSort) {
        $("#time_grid").jqGrid({
            datatype: "local",
            colNames: colNames,
            colModel: colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height: 'auto',
            footerrow: true
        });
    },

    createDomainGrid: function (colNames, colModel, gridSort) {
        $("#domain_grid").jqGrid({
            datatype: "local",
            colNames: colNames,
            colModel: colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height: 'auto',
            footerrow: true
        });
    },

    createAuditGrid: function (colNames, colModel, gridSort) {
        $("#audit_grid").jqGrid({
            datatype: "local",
            colNames: colNames,
            colModel: colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height: 'auto',
            footerrow: true
        });
    },

    createUsageGrid: function (colNames, colModel, gridSort) {
        $("#usage_grid").jqGrid({
            datatype: "local",
            colNames: colNames,
            colModel: colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height: 'auto',
            footerrow: true
        });
    },

    createDlpRuleGrid: function (colNames, colModel, gridSort) {
        $("#dlp_rule_grid").jqGrid({
            datatype: "local",
            colNames: colNames,
            colModel: colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height: 'auto',
            footerrow: true
        });
    },

    getCsv: function (option) {
        WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);
        $.ajax({
            url: "saveClientAsCsv?serial=" + S_PERCLIENT_REP.htmlSn +
                "&ip=" + S_PERCLIENT_REP.curIp +
                "&host=" + escape(S_PERCLIENT_REP.curHost) +
                "&user=" + S_PERCLIENT_REP.curUser +
                "&device=" + escape(S_PERCLIENT_REP.curDevice) +
                "&policy=" + S_PERCLIENT_REP.curPolicy +
                "&rule=" + S_PERCLIENT_REP.curRule +
                "&start_time=" + S_PERCLIENT_REP.seriesEarliestRecord +
                "&end_time=" + S_PERCLIENT_REP.seriesLatestRecord +
                "&option=" + option +
                "&client_tz=" + WGRD.client_tz,
            type: 'POST',
            contentType: 'application/json',
            success: function (data) {
                if (!data.status) {
                    if (data.message) {
                        alert(data.message);
                    }
                    return true;
                }
                var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                window.location = "get_csv_file?serial=" + S_PERCLIENT_REP.htmlSn + file_args;
                return false;
            },
            complete: function (filename) {
                WGRD.progressModalClose();
            }
        });
    },

    getPdf: function (seriesData, option) {
        seriesData.grid_data = updateTimezones(seriesData.grid_data, seriesData.col_model);

        var data = JSON.stringify(seriesData);

        var tzOffsetStart = $.getDateUTCOffsetString(S_PERCLIENT_REP.seriesEarliestRecord, S_PERCLIENT_REP.urlTz);
        var tzOffsetEnd = $.getDateUTCOffsetString(S_PERCLIENT_REP.seriesLatestRecord, S_PERCLIENT_REP.urlTz);

        WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

        $.ajax({
            url: "saveClientAsPdf?serial=" + S_PERCLIENT_REP.htmlSn +
                "&ip=" + S_PERCLIENT_REP.curIp +
                "&host=" + escape(S_PERCLIENT_REP.curHost) +
                "&user=" + S_PERCLIENT_REP.curUser +
                "&device=" + escape(S_PERCLIENT_REP.curDevice) +
                "&policy=" + S_PERCLIENT_REP.curPolicy +
                "&rule=" + S_PERCLIENT_REP.curRule +
                "&start_time=" + S_PERCLIENT_REP.seriesEarliestRecord +
                "&end_time=" + S_PERCLIENT_REP.seriesLatestRecord +
                "&tz_offset_start=" + tzOffsetStart +
                "&tz_offset_end=" + tzOffsetEnd +
                "&option=" + option +
                "&client_tz=" + WGRD.client_tz,
            type: 'POST',
            data: data,
            contentType: 'application/json',
            success: function (data) {
                if (!data.status) {
                    if (data.message) {
                        alert(data.message);
                    }
                    return true;
                }
                var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                window.location = "get_pdf_file?serial=" + S_PERCLIENT_REP.htmlSn + file_args;
                return false;
            },
            complete: function (filename) {
                WGRD.progressModalClose();
            }
        });
    },

    // Get Application usage detail report data and setup the grid with the response
    getAppUsageDetailData: function () {
        $('#app_usage_detail_empty').hide();
        $('#app_usage_detail_grid_data').show();

        var args = S_PERCLIENT_REP.getRepArgs();
        args.report_type = 'per_client_app_usage_detail';
        args.option = 'app_usage_detail';

        var jqxhr = $.ajax({
            url: 'get_per_client_detail',
            data: args,
            method: 'GET',
            dataType: 'json',
            success: S_PERCLIENT_REP.onAppUsageDetailSuccess,
            error: errorHandler
        });

        return jqxhr;
    },

    onAppUsageDetailSuccess: function (series) {
        // The column names and model are returned, once the grid is created it'll handle
        // the callbacks to retrieve the data
        jQuery('#app_usage_detail_report_table').GridUnload('#app_usage_detail_report_table');
        S_PERCLIENT_REP.createAppUsageDetailDataGrid(series.col_names, series.col_model);
        $("#app_usage_detail_report_table").jqGrid('setGridParam', {datatype: 'json'}).trigger('reloadGrid');
    },

    createAppUsageDetailDataGrid: function (col_names, col_model) {
        var args = S_PERCLIENT_REP.getRepArgs();
        args.report_type = 'per_client_app_usage_detail';
        args.option = 'app_usage_detail';
        var rep_url = 'get_per_client_detail_data?' + S_PERCLIENT_REP.getRepURL(args);

        $("#app_usage_detail_report_table").jqGrid({
            url: rep_url,
            datatype: 'json',
            mtype: 'GET',
            colNames: col_names,
            colModel: col_model,
            autoencode: true,
            pager: '#pager',
            pagerpos: 'right',
            toppager: true,
            rowNum: 25,
            rowList: [25, 50, 75, 100],
            sortname: 'name',
            sortorder: 'desc',
            caption: '',
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            forceFit: true,
            loadui: 'block',
            hidegrid: false,
            loadError: errorHandler,
            loadComplete: function (data) {
                if (data.records === 0  || data.records === undefined) {
                    $('#app_usage_detail').hide();
                    if ($('#dlp_detail').is(":hidden") && $('#url_audit_detail').is(":hidden") && $('#audit_detail').is(":hidden")) {
                        $('#no_detail_reps').show();
                    }
                    return;
                }

                $('#app_usage_csv_link').show();
                var startTime = $.getDateDisplay(data.time_range_begin, true, S_PERCLIENT_REP.urlTz);
                var endTime = $.getDateDisplay(data.time_range_end, true, S_PERCLIENT_REP.urlTz);
                S_PERCLIENT_REP.seriesEarliestRecord = data.time_range_begin;
                S_PERCLIENT_REP.seriesLatestRecord = data.time_range_end;
                jQuery("#app_usage_detail_report_table").jqGrid('setCaption', startTime + " - " + endTime);
                $('#app_usage_detail_report_table').setGridWidth($('#app_usage_detail').width(), true);

            }
        }).navGrid("#app_usage_detail_pager", {refresh: false, search: false, edit: false, add: false, del: false}, {}, {width: 350}, {});
    },

    // Get Web Audit detail report data and setup the grid with the response
    getWebAuditDetailData: function () {
        $('#audit_detail_empty').hide();
        $('#audit_detail_grid_data').show();

        var args = S_PERCLIENT_REP.getRepArgs();
        args.report_type = 'per_client_audit_detail';
        args.option = 'audit_detail';

        var jqxhr = $.ajax({
            url: 'get_per_client_detail',
            data: args,
            method: 'GET',
            dataType: 'json',
            success: S_PERCLIENT_REP.onWebAuditDetailSuccess,
            error: errorHandler
        });

        return jqxhr;
    },

    onWebAuditDetailSuccess: function (series) {
        // The column names and model are returned, once the grid is created it'll handle
        // the callbacks to retrieve the data
        jQuery('#audit_detail_report_table').GridUnload('#audit_detail_report_table');
        S_PERCLIENT_REP.createWebAuditDetailDataGrid(series.col_names, series.col_model);
        $("#audit_detail_report_table").jqGrid('setGridParam', {datatype: 'json'}).trigger('reloadGrid');
    },

    createWebAuditDetailDataGrid: function (col_names, col_model) {
        var args = S_PERCLIENT_REP.getRepArgs();
        args.report_type = 'per_client_audit_detail';
        args.option = 'audit_detail';
        var rep_url = 'get_per_client_detail_data?' + S_PERCLIENT_REP.getRepURL(args);

        $("#audit_detail_report_table").jqGrid({
            url: rep_url,
            datatype: 'json',
            mtype: 'GET',
            colNames: col_names,
            colModel: col_model,
            autoencode: true,
            pager: '#pager',
            pagerpos: 'right',
            toppager: true,
            rowNum: 25,
            rowList: [25, 50, 75, 100],
            sortname: 'name',
            sortorder: 'desc',
            caption: '',
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            forceFit: true,
            loadui: 'block',
            hidegrid: false,
            loadError: errorHandler,
            loadComplete: function (data) {
                if (data.records === 0  || data.records === undefined) {
                    $('#audit_detail').hide();
                    if ($('#dlp_detail').is(":hidden") && $('#url_audit_detail').is(":hidden") && $('#app_usage_detail').is(":hidden")) {
                        $('#no_detail_reps').show();
                    }
                    return;
                }

                $('#audit_csv_link').show();
                var startTime = $.getDateDisplay(data.time_range_begin, true, S_PERCLIENT_REP.urlTz);
                var endTime = $.getDateDisplay(data.time_range_end, true, S_PERCLIENT_REP.urlTz);
                S_PERCLIENT_REP.seriesEarliestRecord = data.time_range_begin;
                S_PERCLIENT_REP.seriesLatestRecord = data.time_range_end;
                jQuery("#audit_detail_report_table").jqGrid('setCaption', startTime + " - " + endTime);
                $('#audit_detail_report_table').setGridWidth($('#audit_detail').width(), true);

            }
        }).navGrid("#audit_detail_pager", {refresh: false, search: false, edit: false, add: false, del: false}, {}, {width: 350}, {});
    },

    // Get the DLP detail report data and setup the grid with the response
    getDlpDetailData: function () {
        $('#dlp_detail_empty').hide();
        $('#dlp_detail_grid_data').show();

        var args = S_PERCLIENT_REP.getRepArgs();
        args.report_type = 'per_client_dlp_detail';
        args.option = 'dlp_detail';

        var jqxhr = $.ajax({
            url: 'get_per_client_detail',
            data: args,
            method: 'GET',
            dataType: 'json',
            success: S_PERCLIENT_REP.onDlpDetailSuccess,
            error: errorHandler
        });

        return jqxhr;
    },

    onDlpDetailSuccess: function (series) {
        // The column names and model are returned, once the grid is created it'll handle
        // the callbacks to retrieve the data
        jQuery('#dlp_detail_report_table').GridUnload('#dlp_detail_report_table');
        S_PERCLIENT_REP.createDlpDetailDataGrid(series.col_names, series.col_model);
        $("#dlp_detail_report_table").jqGrid('setGridParam', {datatype: 'json'}).trigger('reloadGrid');
    },

    createDlpDetailDataGrid: function (col_names, col_model) {
        var args = S_PERCLIENT_REP.getRepArgs();
        args.report_type = 'per_client_dlp_detail';
        args.option = 'dlp_detail';
        var rep_url = 'get_per_client_detail_data?' + S_PERCLIENT_REP.getRepURL(args);

        $("#dlp_detail_report_table").jqGrid({
            url: rep_url,
            datatype: 'json',
            mtype: 'GET',
            colNames: col_names,
            colModel: col_model,
            autoencode: true,
            pager: '#pager',
            pagerpos: 'right',
            toppager: true,
            rowNum: 25,
            rowList: [25, 50, 75, 100],
            sortname: 'name',
            sortorder: 'desc',
            caption: '',
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            forceFit: true,
            loadui: 'block',
            hidegrid: false,
            loadError: errorHandler,
            loadComplete: function (data) {
                if (data.records === 0 || data.records === undefined) {
                    $('#dlp_detail').hide();
                    if ($('#audit_detail').is(":hidden") && $('#url_audit_detail').is(":hidden") && $('#app_usage_detail').is(":hidden")) {
                        $('#no_detail_reps').show();
                    }
                    S_PERCLIENT_REP.showHideDLPCriteria();
                    return;
                }

                $('#dlp_csv_link').show();
                $('#dlp_criteria').show();
                var startTime = $.getDateDisplay(data.time_range_begin, true, S_PERCLIENT_REP.urlTz);
                var endTime = $.getDateDisplay(data.time_range_end, true, S_PERCLIENT_REP.urlTz);
                S_PERCLIENT_REP.seriesEarliestRecord = data.time_range_begin;
                S_PERCLIENT_REP.seriesLatestRecord = data.time_range_end;
                jQuery("#dlp_detail_report_table").jqGrid('setCaption', startTime + " - " + endTime);
                $('#dlp_detail_report_table').setGridWidth($('#dlp_detail').width(), true);
            }
        }).navGrid("#dlp_detail_pager", {refresh: false, search: false, edit: false, add: false, del: false}, {}, {width: 350}, {});
    },

    // Get the URL audit detail report data and setup the grid with the response
    getURLAuditDetailData: function () {
        $('#url_audit_detail_empty').hide();
        $('#url_audit_detail_grid_data').show();
        $('#max_limit').hide();

        var args = S_PERCLIENT_REP.getRepArgs();
        args.report_type = 'per_client_url_audit_detail';
        args.option = 'url_audit_detail';

        var jqxhr = $.ajax({
            url: 'get_per_client_detail',
            data: args,
            method: 'GET',
            dataType: 'json',
            success: S_PERCLIENT_REP.onURLDetailSuccess,
            error: errorHandler
        });

        return jqxhr;
    },

    onURLDetailSuccess: function (series) {
        // The column names and model are returned, once the grid is created it'll handle
        // the callbacks to retrieve the data
        jQuery('#url_audit_detail_report_table').GridUnload('#url_audit_detail_report_table');
        S_PERCLIENT_REP.createURLDetailDataGrid(series.col_names, series.col_model);
        $("#url_audit_detail_report_table").jqGrid('setGridParam', {datatype: 'json'}).trigger('reloadGrid');
    },

    createURLDetailDataGrid: function (col_names, col_model) {
        var args = S_PERCLIENT_REP.getRepArgs();
        args.report_type = 'per_client_url_audit_detail';
        args.option = 'url_audit_detail';
        var rep_url = 'get_per_client_detail_data?' + S_PERCLIENT_REP.getRepURL(args);

        $("#url_audit_detail_report_table").jqGrid({
            url: rep_url,
            datatype: 'json',
            loadonce: true,
            mtype: 'GET',
            colNames: col_names,
            colModel: col_model,
            autoencode: true,
            pager: '#pager',
            pagerpos: 'right',
            toppager: true,
            rowNum: 25,
            rowList: [25, 50, 75, 100],
            sortname: 'name',
            sortorder: 'desc',
            caption: '',
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            forceFit: true,
            loadui: 'block',
            hidegrid: false,
            loadError: errorHandler,
            loadComplete: function (data) {
                if (data.records === 0 || data.records === undefined) {
                    $('#url_audit_detail').hide();
                    if ($('#audit_detail').is(":hidden") && $('#dlp_detail').is(":hidden") && $('#app_usage_detail').is(":hidden")) {
                        $('#no_detail_reps').show();
                    }
                    return;
                }
                if (parseInt(data.records, 10) === 1500) {
                    $('#max_limit').show();
                } else {
                    $('#max_limit').hide();
                }

                $('#url_audit_csv_link').show();
                if (data.time_range_begin !== undefined && data.time_range_end !== undefined) {
                    var startTime = $.getDateDisplay(data.time_range_begin, true, S_PERCLIENT_REP.urlTz);
                    var endTime = $.getDateDisplay(data.time_range_end, true, S_PERCLIENT_REP.urlTz);
                    S_PERCLIENT_REP.seriesEarliestRecord = data.time_range_begin;
                    S_PERCLIENT_REP.seriesLatestRecord = data.time_range_end;
                    jQuery("#url_audit_detail_report_table").jqGrid('setCaption', startTime + " - " + endTime);
                }
                $('#url_audit_detail_report_table').setGridWidth($('#url_audit_detail').width(), true);
            }
        });
    },

    getStartEndDates: function () {
        var start_dt = $("#reports_toolbar_start").text();
        var end_dt = $("#reports_toolbar_end").text();
        if (start_dt !== '') {
            start_dt = start_dt.substring(0, start_dt.length - 2).trim(); //Remove the '-' from date at the end'
            start_dt = $.getDateLocalToSecs(start_dt);
        }
        if (end_dt !== '') {
            end_dt = $.getDateLocalToSecs(end_dt);
        }
        var dates = {
            'start_date': start_dt,
            'end_date': end_dt
        };
        return dates;
    },

    getRepArgs: function () {
        var repDates = S_PERCLIENT_REP.getStartEndDates();

        S_PERCLIENT_REP.curUser = $.trim($('#user_name').val());
        S_PERCLIENT_REP.curIp = $.trim($('#ip_addr').val());
        S_PERCLIENT_REP.curHost = $.trim($('#host_name').val());
        S_PERCLIENT_REP.curDevice = $.trim($('#device_name').val());
        S_PERCLIENT_REP.curPolicy = $.trim($('#policy_name').val());
        S_PERCLIENT_REP.curRule = $.trim($('#rule_name').val());

        var repArgs = {'sn': S_PERCLIENT_REP.htmlSn,
                       'start_time': repDates.start_date,
                       'end_time': repDates.end_date,
                       'ip': S_PERCLIENT_REP.curIp,
                       'host': escape(S_PERCLIENT_REP.curHost),
                       'user': S_PERCLIENT_REP.curUser,
                       'device': escape(S_PERCLIENT_REP.curDevice),
                       'policy': S_PERCLIENT_REP.curPolicy,
                       'rule': S_PERCLIENT_REP.curRule
                      };

        return repArgs;
    },

    getRepURL: function (args) {
        var url = 'sn=' + args.sn +
                  '&ip=' + args.ip +
                  '&host=' + args.host +
                  '&user=' + args.user +
                  '&device=' + args.device +
                  '&policy=' + args.policy +
                  '&rule=' + args.rule +
                  '&start_time=' + args.start_time +
                  '&end_time=' + args.end_time +
                  '&report_type=' + args.report_type +
                  '&option=' + args.option;
        return url;
    }
};
$(document).ready(S_PERCLIENT_REP.init);
