/*global utcTimeStrToDate, dateToUTCTimeStr, createDateFromStr, writeErrorContainer, isChecked, LogServerConfigObj, S_USER_MODE, lock_page, is_page_locked, is_diarole_only, is_anonymized, selected_tab, HELP_LINK_OVERRIDE:true, IPHELPER, validateDomainNameStr, showHideErrorMsg, POLLER, backup_time_org, use_syslog, org_system_log, org_file_log_level:true, org_system_log_level:true, last_db_backup_time:true, next_db_backup_time:true, remote_backup_enabled, org_email_to_address:true, org_email_from_address:true, org_email_subject:true, confirm, curr_db_size:true, db_auto_size, org_max_db_size:true, org_email_address, org_log_file_dir, db_size_warning_limit, db_run_delete_time, db_days_retain_log, log_del_flag,
S_NONE, S_BACKUP_MESSAGE, S_BACKUP_TITLE, S_ERR_FQDN_ADDR, S_ERR_FQDN_ADDR_DUPLICATE, S_FQDN_LIMIT, S_CONFIRM_SAVE_BEFORE_TEST, S_GB, S_ERROR_RESTART_FAILED, S_ERROR_ENCRYPT_KEY_EMPTY, S_ERROR_ENCRYPT_KEY_MISMATCH, S_ERR_FQDN_EMPTY, S_PUBLIC_PORT_NAME, S_MAX_DB_SIZE_NAME, S_ERROR_DB_SIZE_SMALL, S_DELETE_LOG_AGE_NAME, S_DB_BACKUP_DAY_NAME, S_LS_CW_REP, S_MAX_REVS_NAME, S_MAX_STORAGE_NAME, S_ERROR_EMAIL_TO_EMPTY, S_ERROR_EMAIL_TO_INVALID, S_ERROR_EMAIL_FROM_EMPTY, S_ERROR_EMAIL_FROM_INVALID, S_RESTART_TITLE, S_RESTART_MSG, accept_diag_logs, devicesColNames, devicesColModel, visibility_clients, S_ADD_DEVICES_TITLE, S_DEVICE_INFO_TEXT, S_MG_REMOVE_DEVICE_MSG, escapeHtml, escapeHtml*/
var S_LS_C = {

    needs_restart: false,      // track if we need to restart the server after save
    poller: null,

    // setup the page
    init: function () {
        S_LS_C.initUI();
        S_LS_C.initEvents();
        S_LS_C.initHelp();
    },

    // initialize UI elements
    initUI : function () {
        $('#progress_test_email').hide();
        $('#test_email_results').hide();
        $('#progress_save').hide();
        $('#progress_restarting').hide();
        $('#error_container').hide();

        // public port/address
        S_LS_C.togglePublicInfo();

        // anonymization
        S_LS_C.toggleAnonymization();
        S_LS_C.togglePageVisits();

        // notifications
        S_LS_C.checkNotifEnable();

        // DB backup settings
        // configure the backup time picker
        $('#db_backup_time').datetimepicker({
            pickDate: false,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });

        // convert backup_time_org to local time as HH:mm
        $('#db_backup_time').data('datetimepicker').setLocalDate(utcTimeStrToDate(backup_time_org, false));
        $('#db_backup_time').data('datetimepicker').disable();  // disable by default; it will be enabled later if needed

        // convert the last/next backup run time to local time UTC time string
        S_LS_C.updateLastDbBackupTime();
        S_LS_C.updateNextDbBackupTime();

        S_LS_C.toggleDbBackupEnable(false);

        S_LS_C.toggleDeleteLogAge();

        S_LS_C.createDevicesGrid();

        // logging
        if (use_syslog === 1) {
            S_LS_C.showSyslog();
        } else {
            S_LS_C.showWindowsLog();
        }
        S_LS_C.toggleEncryptionKeyEnable();
        S_LS_C.toggleEventViewerEnable();
        S_LS_C.toggleSyslogEnable();
        S_LS_C.toggleFileEnable();

        $('#select_action').val(accept_diag_logs);
        $('#options_level_event_viewer').val('1');
        $('#options_level_syslog').val('1');
        $('#options_level_file').val('1');
        if ($('#event_viewer_enable').is(':checked')) {
            $('#options_level_event_viewer').val(org_system_log_level);
        }
        if ($('#syslog_enable').is(':checked')) {
            $('#options_level_syslog').val(org_system_log_level);
        }
        if ($('#file_enable').is(':checked')) {
            $('#options_level_file').val(org_file_log_level);
        }

        // detect if any fields are changed
        var flds = $("input, textarea", window.document);
        $(flds).on('change keyup', flds, function (eo) {
            $('#error_container').hide();
            $('#test_email_results').hide();
        });

        // Check if the lock_page is in sessionStorage, this will be true
        // if user acquired a lock and clicked on refresh on the same page
        // and is in the same browser tab.
        S_LS_C.pg_tracker = window.sessionStorage.getItem(lock_page);

        var viewMode = WGRD.userInViewMode(is_page_locked, S_LS_C.pg_tracker);
        //If user is in readonly mode, then grayout the entire UI
        //Only enable the report customization div and connectwise's company name div
        if (viewMode) {
            WGRD.enableUI(false, ".tab-content");
            WGRD.enableUI(true, "#report_cust_list_div");
            WGRD.enableUI(true, "#cw_cnames_div");
            WGRD.enableUI(true, "#ftp_servers_list_div");
            WGRD.enableUI(true, "#devices_table_div");
            WGRD.enableUIElements(false, ['#title_anonymize', '#desc_anonymize']);
            WGRD.enableUIElements(true, ["#cust_close", '#add_close',
                                         '#ftp_close', '.wgrd-modal-close-x',
                                         '.close']);
        } else {
            // if user session in anonymized mode, and user only has dimension administrator role
            if (is_anonymized && is_diarole_only) {
                WGRD.enableUIElements(false, ['#enable_anonymization', '#title_anonymize', '#desc_anonymize']);
            }
        }

        S_USER_MODE.initUI(['#submit_button', '#add_device', '#remove_device', '#accept_action', '#discard_action'], viewMode);
        S_USER_MODE.show_warning_msg = true;
        $('#tabs a[href=' + selected_tab + ']').tab('show');
        S_USER_MODE.selected_tab = selected_tab;

        // So that when switching to VIEW or EDIT mode
        // the device table and buttons will be displayed appropriately.
        S_LS_C._doResizeGrid();
        S_LS_C._toggleRowChangeBtns();
        // hide devices section if user only has dimension administrator role
        if (is_diarole_only) {
            $('#devices').hide();
        } else {
            $('#devices').show();
        }
    },

    // add event handlers
    initEvents : function () {
        WGRD.pgUnloadCallBack(S_LS_C.pg_tracker, lock_page);
        $('#change_encryption_key').click(S_LS_C.toggleEncryptionKeyEnable);
        $('#public_ip_port').click(S_LS_C.togglePublicInfo);
        $('#add_address').click(S_LS_C.addPublicAddress);
        $('#rem_address').click(S_LS_C.removePublicAddress);
        $('#avail_fqdn').click(S_LS_C.enableFqdnRemoveButton);
        $('#notif_event_failure').click(S_LS_C.checkNotifEnable);
        $('#notif_event_received').click(S_LS_C.checkNotifEnable);
        $('#submit_button').button().click(S_LS_C.savePage);
        $('#test_email').button().click(S_LS_C.testEmail);
        $('#db_delete_log_age_enable').click(S_LS_C.toggleDeleteLogAge);
        $('#db_auto_backup').click(function () {
            S_LS_C.toggleDbBackupEnable(true);
        });
        $('#event_viewer_enable').click(S_LS_C.toggleEventViewerEnable);
        $('#syslog_enable').click(S_LS_C.toggleSyslogEnable);
        $('#file_enable').click(S_LS_C.toggleFileEnable);

        $('#add_device').click(S_LS_C.addDevice);
        $('#specify_device_save').click(S_LS_C.deviceDialogSave);
        $('#specify_device_close').click(S_LS_C.deviceDialogClose);
        $('#device_server_name').on('keyup', S_LS_C.deviceDialogSearch);
        $('#copy_device').click(S_LS_C.deviceDialogCopy);
        $('#del_device').click(S_LS_C.deviceDialogDel);
        $('#remove_device').click(S_LS_C.removeDevice);
        $('#confirm_save_btn').click(S_LS_C.confirmRemoveDevice);
        $('#accept_action').click(S_LS_C.setAcceptAction);
        $('#discard_action').click(S_LS_C.setDiscardAction);

        $('#enable_anonymization').click(S_LS_C.toggleAnonymization);
        $('#enable_page_visit_audits').click(S_LS_C.togglePageVisits);

        $(window).resize(function () {
            S_LS_C._doResizeGrid();
        });
        $('a[data-toggle="tab"]').on('shown', function (e) {
            S_LS_C._doResizeGrid();
            S_LS_C._toggleRowChangeBtns();
        });

        // start a poller to refresh the DB data every minute
        S_LS_C.poller = new POLLER('db_data', '', 60000, S_LS_C.dbRefreshSuccessHandler, S_LS_C.dbRefreshErrorHandler);

        //User mode changes
        S_USER_MODE.initEvents();
    },

    initHelp : function () {
        // Update help link based on tab selected
        $('#tabs a[href="#general"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7320;
            S_USER_MODE.selected_tab = "#general";
        });
        $('#tabs a[href="#visibility"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7324;
            S_USER_MODE.selected_tab = "#visibility";
        });
        $('#tabs a[href="#command"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7325;
            S_USER_MODE.selected_tab = "#command";
        });
        $('#tabs a[href="#notifications"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7321;
            S_USER_MODE.selected_tab = "#notifications";
        });
        $('#tabs a[href="#reporting"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7322;
            S_USER_MODE.selected_tab = "#reporting";
        });
        $('#tabs a[href="#logging"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7323;
            S_USER_MODE.selected_tab = "#logging";
        });
    },

    createDevicesGrid : function () {
        var devices_grid = $("#devices_table").jqGrid({
            loadonce: true,
            datatype: S_LS_C.refreshGrid,
            colNames: devicesColNames,
            colModel: devicesColModel,
            pager: '#devices_pager',
            viewrecords: true,
            gridview: true,
            autoencode: true,
            shrinktofit: true,
            autowidth: true,
            shrinkToFit: true,
            height: "auto",
            sortname: 'name',
            sortorder: 'asc',
            sorttable: true,
            rowNum: 10,
            rowList: [10, 20, 50, 100],
            multiselect: true,
            onSelectRow: function (rowid, status, e) {
                S_LS_C._toggleRowChangeBtns();
            },
            onSelectAll: function (rowid, status) {
                S_LS_C._toggleRowChangeBtns();
            }
        });

        devices_grid.jqGrid('navGrid', '#devices_pager', {edit: false, add: false, del: false, search: false, refresh: false});
    },

    refreshGrid : function () {
        $('#devices_table').jqGrid('clearGridData');
        $('#devices_table').jqGrid('setGridParam', {datatype: 'local'});
        var i, j, id, name, sn, action;
        for (i = 0, j = 0; i < visibility_clients.length; i++) {
            id = visibility_clients[i].id;
            name = escapeHtml(visibility_clients[i].name);
            sn = escapeHtml(visibility_clients[i].sn);
            action = visibility_clients[i].action;
            if (action === -1) {
                // this device use the default action
                // should not be added to the exception device table
                continue;
            }
            action = $('#select_action option[value=' + action + ']').text();
            $('#devices_table').addRowData(j++, {'id': id, 'name': name, 'sn': sn, 'action': action}, 'last');
        }
    },

    _doResizeGrid : function () {
        var pad = parseInt($("#log_configure_tab_visibility").css('margin-left'), 10);
        var row_width = $("#log_configure_tab_visibility").width();
        pad *= 2;
        if (pad === 0) {
            pad += row_width / 110;  // add padding to keep the grid smaller than the parent
        }
        var grid_width = row_width - pad;
        $('#devices_table').setGridWidth(grid_width);
        $('#diag_action_div').css('width', grid_width);
    },

    _toggleRowChangeBtns : function () {
        if (is_page_locked === 0) {
            var enabled = true;
            var selRowIds = $('#devices_table').jqGrid('getGridParam', 'selarrrow');
            if (selRowIds === null || selRowIds.length === 0) {
                enabled = false;
            }
            WGRD.enableUIElements(enabled, ['#remove_device', '#accept_action', '#discard_action']);
        }
    },

    // ------------ DB/Server Info -----------------------------------------------------

    dbRefreshSuccessHandler : function (response) {
        S_LS_C.updateDBInfoUI(response);
        return true;
    },
    dbRefreshErrorHandler: function (response, num_failed) {
        return true;
    },

    // set the UI text based on the latest value of last_db_backup_time
    updateLastDbBackupTime: function () {
        if (last_db_backup_time.length === 0) {
            $('#last_backup_runtime').text(S_NONE);
        } else {
            var last_backup_d = createDateFromStr(last_db_backup_time);
            $('#last_backup_runtime').text(last_backup_d.toLocaleString());
        }
    },

    // set the UI text based on the latest value of next_db_backup_time
    updateNextDbBackupTime: function () {
        if (next_db_backup_time.length === 0) {
            $('#next_backup_runtime').text(S_NONE);
        } else {
            var next_backup_d = createDateFromStr(next_db_backup_time);
            $('#next_backup_runtime').text(next_backup_d.toLocaleString());
        }
    },

    toggleDeleteLogAge: function () {
        var enable = $('#db_delete_log_age_enable').is(':checked');
        WGRD.enableUIElements(enable, ['#db_delete_log_age']);
    },

    toggleDbBackupEnable: function (show_warning) {
        var enable = $('#db_auto_backup').is(':checked');
        WGRD.enableUIElements(enable, ['#db_backup_day']);
        if (enable) {
            $('#db_backup_time').data('datetimepicker').enable();
            if (show_warning && !remote_backup_enabled) {
                // show a notification dialog telling the admin that system backup configuration is required
                WGRD.okMessageModal(S_BACKUP_MESSAGE, S_BACKUP_TITLE);
            }
        } else {
            $('#db_backup_time').data('datetimepicker').disable();
        }
    },

    togglePublicInfo: function () {
        var enable = $('#public_ip_port').is(':checked');
        WGRD.enableUIElements(enable, ['#public_address', '#avail_fqdn', '#public_port']);
        $('#add_address').attr('disabled', !enable);
        $('#rem_address').attr('disabled', !enable);
    },

    toggleAnonymization: function () {
        var enable = $('#enable_anonymization').is(':checked');
        WGRD.enableUIElements(enable, ['#title_anonymize', '#desc_anonymize']);
    },

    togglePageVisits: function () {
        var enable = $('#enable_page_visit_audits').is(':checked');
        WGRD.enableUIElements(enable, ['#enable_page_visit_audits_deanon']);
    },

    validateFqdn: function (public_address) {
        var addr_valid_ip = IPHELPER.validIP4(public_address);

        // verify address is valid ip
        if (addr_valid_ip.length === 0 || (!addr_valid_ip && !validateDomainNameStr(public_address))) {
            $('#public_address').focus();
            $('#public_address').select();

            showHideErrorMsg('#public_address', S_ERR_FQDN_ADDR);
            return false;
        }

        if (addr_valid_ip) {
            public_address = IPHELPER.trimIP4(public_address);
        }

        // don't allow duplicates
        if ($('#avail_fqdn option[value="' + public_address + '"]').length > 0) {
            $('#public_address').focus();
            $('#public_address').select();

            showHideErrorMsg('#public_address', S_ERR_FQDN_ADDR_DUPLICATE);
            return false;
        }
        $('#public_address').val("");
        showHideErrorMsg('#public_address');
        return true;
    },

    addPublicAddress: function (event) {
        event.preventDefault();

        // ignore event if checkbox is not selected
        if (!$('#public_ip_port').is(':checked')) {
            return;
        }

        // Disable the add button if 5 addresses are already added
        if ($('#avail_fqdn option').length === 5) {
            return;
        }

        var public_address = $('#public_address').val().trim();
        if (S_LS_C.validateFqdn(public_address)) {
            $('#avail_fqdn').append('<option value="' + public_address + '">' + public_address + '</option>');
        }
        S_LS_C.enforceFqdnLimit();
    },

    removePublicAddress: function (event) {
        event.preventDefault();
        if ($('#avail_fqdn option:selected').length > 0) {
            $('#avail_fqdn option:selected').remove();
            S_LS_C.resetFqdnPane();
        }
    },

    addDevice: function (event) {
        event.preventDefault();
        $('#device_server_name').val();
        $('#active_devices_servers').empty();
        $('#add_error_device').hide();

        $('#filtered_devices_servers').empty();
        $.each(visibility_clients, function (index, item) {
            var id = item.id;
            var name = item.name + ' [' + item.sn + ']';
            $('#filtered_devices_servers').append('<option value=' + id + '>' + name + '</option>');
        });

        $('#dev_serv_info').html(S_DEVICE_INFO_TEXT);

        $('#specify_device_div')
            .modal()
            .find('h3').text(S_ADD_DEVICES_TITLE);
    },

    deviceDialogSave: function (event) {
        event.preventDefault();
        var id_list = [];
        var g_action = parseInt($('#select_action option:selected').val(), 10);
        $('#active_devices_servers option').each(function () {
            var id = $(this).val();
            id_list.push(id);
            id = parseInt(id, 10);
            var i, item;
            for (i = 0; i < visibility_clients.length; i++) {
                item = visibility_clients[i];
                if (item.id === id) {
                    // action can only be 3 values: 0(Discard), 1(Allow), -1(use the default action)
                    if (item.action === -1) {
                        // use the action opposite to the default one
                        item.action = 1 - g_action;
                    } else {
                        // use the action opposite to its current one
                        item.action = 1 - item.action;
                    }
                    break;
                }
            }
        });
        if (id_list.length > 0) {
            S_LS_C.refreshGrid();
            S_LS_C._selectDevice(id_list);
        }
        $('#specify_device_div').modal('hide');
    },

    _selectDevice: function (id_list) {
        var devices_table = $('#devices_table');
        var rows = devices_table.getRowData();
        var i, j;
        for (i = 0; i < id_list.length; i++) {
            for (j = 0; j < rows.length; j++) {
                if (id_list[i] === rows[j].id) {
                    devices_table.setSelection(j);
                }
            }
        }
    },

    deviceDialogClose: function (event) {
        event.preventDefault();
        $('#specify_device_div').modal('hide');
    },

    deviceDialogSearch: function () {
        var search = $('#device_server_name').val();
        $('#filtered_devices_servers').empty();

        var matching_list = $.map(visibility_clients, function (item) {
            var reg = new RegExp(search, "gi");
            if (item.name.match(reg) || item.sn.match(reg)) {
                return item;
            }
            return null;
        });

        $.each(matching_list, function (index, item) {
            var id = item.id;
            var name = item.name + ' [' + item.sn + ']';
            $('#filtered_devices_servers').append('<option value=' + id + '>' + name + '</option>');
        });
    },

    deviceDialogCopy: function (event) {
        event.preventDefault();
        var items = $('#filtered_devices_servers option:selected');
        $.each(items, function (index, item) {
            var value = item.value;
            var text = item.text;
            if ($('#active_devices_servers option[value =' + value + ']').length === 0) {
                $('#active_devices_servers').append('<option value=' + value + '>' + text + '</option>');
            }
        });
    },

    deviceDialogDel: function (event) {
        event.preventDefault();
        $('#active_devices_servers option:selected').remove();
    },

    removeDevice: function (event) {
        event.preventDefault();
        var selRowIds = $('#devices_table').jqGrid('getGridParam', 'selarrrow');
        if (selRowIds === null || selRowIds.length === 0) {
            return;
        }
        var defaultAction = $('#select_action option:selected').text();
        $("#remove_warning").html(S_MG_REMOVE_DEVICE_MSG.format(defaultAction));
        $("#confirm_dlg").modal();
    },

    confirmRemoveDevice: function (event) {
        event.preventDefault();
        $("#confirm_dlg").modal('hide');
        var selRowIds = $('#devices_table').jqGrid('getGridParam', 'selarrrow');
        // Note: no need to increase i
        var i, id;
        for (i = 0; i < selRowIds.length; i) {
            id = parseInt($('#devices_table').getCell(selRowIds[i], 'id'), 10);
            S_LS_C._changeVisibilityAction(id, -1);
            $('#devices_table').delRowData(selRowIds[i]);
        }
        S_LS_C._toggleRowChangeBtns();
    },

    _changeVisibilityAction: function (id, action) {
        var i;
        for (i = 0; i < visibility_clients.length; i++) {
            if (visibility_clients[i].id === id) {
                visibility_clients[i].action = action;
                break;
            }
        }
    },

    setAcceptAction: function (event) {
        event.preventDefault();
        S_LS_C._setCustomAction(1);
    },

    setDiscardAction: function (event) {
        event.preventDefault();
        S_LS_C._setCustomAction(0);
    },

    _setCustomAction: function (action) {
        var text = $('#select_action option[value=' + action + ']').text();
        var selRowIds = $('#devices_table').jqGrid('getGridParam', 'selarrrow');
        var i, id;
        for (i = 0; i < selRowIds.length; i++) {
            id = parseInt($('#devices_table').getCell(selRowIds[i], 'id'), 10);
            S_LS_C._changeVisibilityAction(id, action);
            $('#devices_table').setCell(selRowIds[i], 'action', text);
        }
    },

    enforceFqdnLimit: function () {
        // Disable the add button and show information that only 5 addresses can be added
        if ($('#avail_fqdn option').length === 5) {
            $('#add_address').attr('disabled', true);
            $('#fqdn_limit').removeClass('text-info')
                            .addClass('text-warning')
                            .text(S_FQDN_LIMIT);
        }
    },

    resetFqdnPane: function () {
        $('#add_address').attr('disabled', false);
        $('#rem_address').attr('disabled', true);
        $('#fqdn_limit').removeClass('text-warning')
                        .addClass('text-info')
                        .text('');
    },

    enableFqdnRemoveButton: function () {
        var selected_option = $('#avail_fqdn option:selected').attr('value');
        if (selected_option !== undefined) {
            $('#rem_address').attr('disabled', false);
        } else {
            $('#rem_address').attr('disabled', true);
        }
    },

    checkNotifEnable: function () {
        var some_checked = $('#notif_event_failure').is(':checked') || $('#notif_event_received').is(':checked');
        WGRD.enableUIElements(some_checked, ['#email_to_address', '#email_from_address', '#email_subject', '#test_email']);
    },

    showWindowsLog: function () {
        $('#logging_windows').show();
        $('#logging_syslog').hide();
    },

    showSyslog: function () {
        $('#logging_windows').hide();
        $('#logging_syslog').hide(); // don't show syslog until we expose configuring a remote syslog server
    },

    toggleEncryptionKeyEnable: function () {
        var enable = $('#change_encryption_key').is(':checked');
        WGRD.enableUIElements(enable, ['#encryption_key', '#encryption_key_confirm']);
    },

    toggleEventViewerEnable: function () {
        var enable = $('#event_viewer_enable').is(':checked');
        WGRD.enableUIElements(enable, ['#options_level_event_viewer']);
    },

    toggleSyslogEnable: function () {
        var enable = $('#syslog_enable').is(':checked');
        WGRD.enableUIElements(enable, ['#options_level_syslog']);
    },

    toggleFileEnable: function () {
        var enable = $('#file_enable').is(':checked');
        WGRD.enableUIElements(enable, ['#options_level_file']);
    },

    testEmail: function () {
        // check if any values have been changed and prompt to save first
        var changed = false;
        if ($('#email_to_address').val() !== org_email_to_address ||
                 $('#email_from_address').val() !== org_email_from_address ||
                 $('#email_subject').val() !== org_email_subject) {
            changed = true;
        }

        if (changed) {
            if (!confirm(S_CONFIRM_SAVE_BEFORE_TEST)) {
                return;
            }
        }

        $('#test_email').attr('disabled', true);
        $('#test_email_results').hide();
        $('#progress_test_email').show();

        $.ajax({
            url: 'test_email',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: S_LS_C.testEmailResults,
            error: S_LS_C.testEmailResultsError
        });
    },

    testEmailResults: function (data) {
        $('#progress_test_email').hide();

        if (data.status) {
            $('#test_email_results').attr('class', 'success');
        } else {
            $('#test_email_results').attr('class', 'fail');
        }
        $('#test_email_results').text(data.message);
        $('#test_email_results').show();
        $('#test_email').attr('disabled', false);
    },

    testEmailResultsError: function (data) {
        $('#progress_test_email').hide();
        $('#test_email_results').attr('class', 'fail');
        $('#test_email_results').text(data.statusText + ": " + data.status);
        $('#test_email_results').show();
        $('#test_email').attr('disabled', false);
    },

    // ajax call to get some updated db-related info and refresh the UI
    updateDBInfo: function () {
        $.ajax({
            url: 'db_data',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function (data) {
                S_LS_C.updateDBInfoUI(data);
            }
        });
    },

    // update the DB related UI from the ajax response data
    updateDBInfoUI: function (data) {
        curr_db_size = data.db_curr_size;
        last_db_backup_time = data.db_last_backup_runtime;
        next_db_backup_time = data.db_next_backup_runtime;

        $('#db_curr_size').text(data.db_curr_size + " ");
        $('#db_avail_space').text(data.db_avail_space + " " + S_GB + " (" + data.db_percent_free + ")");
        S_LS_C.updateLastDbBackupTime();
        S_LS_C.updateNextDbBackupTime();
    },

    restartLogServer: function () {
        $('#submit_button').attr('disabled', true);
        $('#progress_restarting').show();
        $.ajax({
            url: 'server_action?action=restart',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: S_LS_C.restartResults,
            error: S_LS_C.restartResultsError
        });
    },

    restartResults: function (data) {
        $('#progress_restarting').hide();
        $('#submit_button').removeAttr('disabled');
        if (!data.status) {
            writeErrorContainer(data.message, false);
        } else {
            // reload the page if we connected to a new DB
            location.reload();
        }
    },

    restartResultsError: function (data) {
        $('#progress_restarting').hide();
        $('#submit_button').removeAttr('disabled');
        writeErrorContainer(S_ERROR_RESTART_FAILED, false);
    },

    // ------------ Validation ---------------------------------------------------------

    // validate all UI input
    validateUI: function () {
        //
        // general tab
        //

        // see if we are changing the logging authentication key
        if (isChecked('#change_encryption_key')) {
            if ($('#encryption_key').val().length === 0) {
                // don't allow empty authentication key
                writeErrorContainer(S_ERROR_ENCRYPT_KEY_EMPTY, false);
                return false;
            }

            // validate authentication key values
            if ($('#encryption_key').val() !== $('#encryption_key_confirm').val()) {
                $('#tabs a[href="#visibility"]').tab('show');
                $('#encryption_key').focus();
                $('#encryption_key').select();
                writeErrorContainer(S_ERROR_ENCRYPT_KEY_MISMATCH, false);
                return false;
            }

        }

        // public accessibility
        if ($('#public_ip_port').is(':checked')) {
            // require at least one ip/name
            if ($('#avail_fqdn').has('option').length === 0) {
                $('#tabs a[href="#general"]').tab('show');
                $('#public_address').focus();
                $('#public_address').select();
                writeErrorContainer(S_ERR_FQDN_EMPTY, false);
                return false;
            }

            // validate the port number
            var pub_port_error = WGRD.isValidNumeric($('#public_port'), S_PUBLIC_PORT_NAME);
            if (pub_port_error && pub_port_error.length > 0) {
                $('#tabs a[href="#general"]').tab('show');
                $('#public_port').focus();
                $('#public_port').select();
                writeErrorContainer(pub_port_error, false);
                return false;
            }
        }

        // max db size - 1-10000
        // can't be less than current size
        if (!db_auto_size) {
            var db_max_size_error = WGRD.isValidNumeric($('#db_max_size'), S_MAX_DB_SIZE_NAME);
            if (!db_max_size_error || db_max_size_error.length === 0) {
                var db_max_size = parseInt($('#db_max_size').val(), 10);
                if (db_max_size < curr_db_size) {
                    db_max_size_error = S_ERROR_DB_SIZE_SMALL;
                }
            }
            if (db_max_size_error && db_max_size_error.length > 0) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_max_size').focus();
                $('#db_max_size').select();
                writeErrorContainer(db_max_size_error, false);
                return false;
            }
        }

        // log age deletion value
        if ($('#db_delete_log_age_enable').is(':checked')) {
            var db_delete_age_error = WGRD.isValidNumeric($('#db_delete_log_age'), S_DELETE_LOG_AGE_NAME);
            if (db_delete_age_error && db_delete_age_error.length > 0) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_delete_log_age').focus();
                $('#db_delete_log_age').select();
                writeErrorContainer(db_delete_age_error, false);
                return false;
            }
        }

        // backup settings
        if (isChecked('#db_auto_backup')) {
            // days 1-365
            var db_backup_day_error = WGRD.isValidNumeric($('#db_backup_day'), S_DB_BACKUP_DAY_NAME);
            if (db_backup_day_error && db_backup_day_error.length > 0) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_backup_day').focus();
                $('#db_backup_day').select();
                writeErrorContainer(db_backup_day_error, false);
                return false;
            }
        }

        // validate connectwise settings
        if (!S_LS_CW_REP.validateConnectWise()) {
            return false;
        }

        //
        // Command tab
        //

        // ,max device config revisions
        var max_revs_error = WGRD.isValidNumeric($('#max_config_revs'), S_MAX_REVS_NAME);
        if (max_revs_error && max_revs_error.length > 0) {
            $('#tabs a[href="#command"]').tab('show');
            $('#max_config_revs').focus();
            $('#max_config_revs').select();
            writeErrorContainer(max_revs_error, false);
            return false;
        }

        // max device config storage
        var max_storage_error = WGRD.isValidNumeric($('#max_config_storage'), S_MAX_STORAGE_NAME);
        if (max_storage_error && max_storage_error.length > 0) {
            $('#tabs a[href="#command"]').tab('show');
            $('#max_config_storage').focus();
            $('#max_config_storage').select();
            writeErrorContainer(max_storage_error, false);
            return false;
        }

        //
        // Notifications tab
        //

        // if any notifications are enabled, require email from/to/subject
        if ($('#notif_event_failure').is(':checked') || $('#notif_event_received').is(':checked')) {
            var patt = /^[^\s]+@[^\s]+$/;  // basic sanity checking

            // email to address
            if (!S_LS_C.validateEmptyField('#email_to_address', 1, S_ERROR_EMAIL_TO_EMPTY)) {
                return false;
            }
            if (!patt.test($('#email_to_address').val())) {
                $('#tabs a[href="#notifications"]').tab('show');
                $('#email_to_address').focus();
                $('#email_to_address').select();
                writeErrorContainer(S_ERROR_EMAIL_TO_INVALID, false);
                return false;
            }

            // email from address
            if (!S_LS_C.validateEmptyField('#email_from_address', 1, S_ERROR_EMAIL_FROM_EMPTY)) {
                return false;
            }
            if (!patt.test($('#email_from_address').val())) {
                $('#tabs a[href="#notifications"]').tab('show');
                $('#email_from_address').focus();
                $('#email_from_address').select();
                writeErrorContainer(S_ERROR_EMAIL_FROM_INVALID, false);
                return false;
            }
        }

        return true;
    },

    validateEmptyField: function (elm_str, tab_index, error_str) {
        if ($(elm_str).val().length === 0) {
            return S_LS_C._show_error_msg(elm_str, tab_index, error_str);
        }
        return true;
    },

    get_db_max_size: function () {
        if (db_auto_size) {
            return org_max_db_size;
        }
        return parseInt($('#db_max_size').val(), 10);
    },

    _show_error_msg: function (elm_str, tab_index, error_str) {
        $('#tabs li:eq(' + tab_index + ') a').tab('show');
        $(elm_str).focus();
        $(elm_str).select();
        writeErrorContainer(error_str, false);
        return false;
    },

    // called when the "Save" action is cancelled
    cancelSave: function () {
        $('#progress_save').hide();
        $('#submit_button').attr('disabled', false);
    },

    // entry point for submitting the changes to the server
    savePage: function () {
        $('#error_container').hide();
        $('#submit_button').attr('disabled', true);
        $('#progress_save').show();

        // validate the input
        if (!S_LS_C.validateUI()) {
            // validation failed
            $('#submit_button').removeAttr('disabled');
            $('#progress_save').hide();
            return;
        }

        // prompt for server restart, if needed, and then save
        S_LS_C._promptRestart();
    },

    // prompt for server restart, if needed, and then proceed to _savePage()
    _promptRestart: function () {
        // check to see if we need to restart due to log settings change
        var show_restart = false;
        var new_log_level_system = "-1";
        if (use_syslog === 1) {
            if ($('#syslog_enable').is(':checked')) {
                new_log_level_system = $('#options_level_syslog').val();
            }
        } else {
            if ($('#event_viewer_enable').is(':checked')) {
                new_log_level_system = $('#options_level_event_viewer').val();
            }
        }

        var new_log_level_file = -1;
        if ($('#file_enable').is(':checked')) {
            new_log_level_file = $('#options_level_file').val();
        }

        if (new_log_level_system !== org_system_log_level || new_log_level_file !== org_file_log_level) {
            show_restart = true;
        }

        if (show_restart) {
            $('#confirmBoxDiv h3').text(S_RESTART_TITLE);
            WGRD.confirmModal(S_RESTART_MSG, true, function () {
                $('#submit_button').attr('disabled', true);
                $('#progress_save').show();
                S_LS_C.needs_restart = true;
                S_LS_C._savePage();
            });
            $('#submit_button').attr('disabled', false);
            $('#progress_save').hide();
        } else {
            S_LS_C._savePage();
        }
    },

    // save the data to the server
    _savePage: function () {
        var obj = new LogServerConfigObj();

        obj.notif_event_failure = isChecked('#notif_event_failure');
        obj.notif_event_received = isChecked('#notif_event_received');

        obj.log_del_flag = 0;

        obj.email_address = org_email_address;  // not exposed; preserve the value
        obj.email_subject = $.trim($('#email_subject').val());
        obj.email_from_address = $.trim($('#email_from_address').val());
        obj.email_to_address = $.trim($('#email_to_address').val());

        if (isChecked('#change_encryption_key')) {
            obj.encryption_key = $('#encryption_key').val();
        } else {
            obj.encryption_key = '';
        }

        obj.db_max_size = S_LS_C.get_db_max_size();
        if ($('#db_delete_log_age_enable').is(':checked')) {
            obj.db_delete_log_age = parseInt($('#db_delete_log_age').val(), 10);
        } else {
            obj.db_delete_log_age = -1;
        }

        if ($('#public_ip_port').is(':checked')) {
            var fqdn_addresses = [];
            obj.public_port = parseInt($('#public_port').val(), 10);
            $('#avail_fqdn option').each(function () {
                var fqdn_address = this.value;
                fqdn_addresses.push(fqdn_address);
            });
            obj.public_addr_list = fqdn_addresses;
        }

        obj.db_backup_enable = isChecked('#db_auto_backup');
        obj.db_run_backup_day = parseInt($('#db_backup_day').val(), 10);
        obj.db_run_backup_time = dateToUTCTimeStr($('#db_backup_time').data('datetimepicker').getLocalDate());
        obj.db_backup_file_dir = $('#db_backup_dir').val();

        obj.add_new_devices = $('#allow_new_devices_logging').is(':checked') ? 1 : 0;

        obj.max_config_revs = parseInt($('#max_config_revs').val(), 10);
        obj.max_config_storage = parseInt($('#max_config_storage').val(), 10);

        obj.log_level_system = -1;
        if (use_syslog === 1) {
            if ($('#syslog_enable').is(':checked')) {
                obj.log_level_system = parseInt($('#options_level_syslog').val(), 10);
            }
        } else {
            if ($('#event_viewer_enable').is(':checked')) {
                obj.log_level_system = parseInt($('#options_level_event_viewer').val(), 10);
            }
        }

        if ($('#file_enable').is(':checked')) {
            obj.log_level_file = parseInt($('#options_level_file').val(), 10);
            obj.log_file_dir = org_log_file_dir;  // log location is not editable
        } else {
            obj.log_level_file = -1;
            obj.log_file_dir = org_log_file_dir;
        }

        // preserving
        obj.db_size_warning_limit = db_size_warning_limit;
        obj.db_run_delete_time = db_run_delete_time;
        obj.db_days_retain_log = db_days_retain_log;
        obj.log_del_flag = log_del_flag;

        //get ConnectWise settings from cw_rep_customization.js file
        obj.cw_obj = S_LS_CW_REP.get_cw_obj();

        // get report customization settings from cw_rep_customization.js file
        obj.report_cust_list = S_LS_CW_REP.get_rep_cust_list();
        obj.rep_customization_cw_only = 0; // Save everything by default

        // get ftp servers from cw_rep_customization.js file
        obj.ftp_servers_list = S_LS_CW_REP.get_ftp_servers_list();

        // diagnostic log messages
        obj.accept_diag_logs = parseInt($('#select_action option:selected').val(), 10);
        obj.visibility_clients = visibility_clients;

        // Anonymization settings
        obj.anonymize_reports = $('#enable_anonymization').is(':checked');
        obj.anonymize_title = $.trim($('#title_anonymize').val());
        obj.anonymize_desc = $.trim($('#desc_anonymize').val());

        if ($('#enable_page_visit_audits').is(':checked')) {
            if ($('#enable_page_visit_audits_deanon').is(':checked')) {
                obj.session_auditing = 2;  // only enabled for de-anonymized sessions
            } else {
                obj.session_auditing = 1;  // always enabled
            }
        } else {
            obj.session_auditing = 0;  // disabled
        }

        // save the data to the server
        WGRD.putData(obj).success(function (response) {
            // we need to do some things after the save operations is successful
            if (response.status) {

                //
                // update all saved org_ variables to the latest values
                //

                // general
                org_max_db_size = S_LS_C.get_db_max_size();

                // notifs (update vals from UI)
                org_email_to_address = $('#email_to_address').val();
                org_email_from_address = $('#email_from_address').val();
                org_email_subject = $('#email_subject').val();

                // logging - none
                org_system_log_level = obj.log_level_system.toString();
                org_file_log_level = obj.log_level_file.toString();

                // clear the "change logging authentication key" checkbox
                $("#change_encryption_key").attr('checked', false);
                $('#encryption_key').val('');
                $('#encryption_key_confirm').val('');
                S_LS_C.toggleEncryptionKeyEnable();

                //
                // update the db last run time and db size
                //
                S_LS_C.updateDBInfo();

                //
                // restart the server, if needed
                //
                if (S_LS_C.needs_restart) {
                    S_LS_C.restartLogServer();
                }

                // update page lock
                WGRD.updateModeUI(1);  //Update the user mode div
                WGRD.resetUserMode();  //Reset the lock after save
            }
        });
    },

    showwaitcursor: function (prefix) {
        $('#' + prefix + 'error').hide();
        $('#' + prefix + 'loading').show();
        return true;
    }
};
$(document).ready(S_LS_C.init);
