/*global system_enabled, is_amazon_ec2, is_azure, S_PANE_MSGS, HELP_LINK_OVERRIDE:true, showHideErrorMsg, installed_servers_list, S_FINISH_BUTTON, isValidIp, S_SERVER_SELECT_MSG, S_ORG_NAME_MSG, S_PASSPHRASE_EMPTY_MSG, S_ERR_HNAME_EMPTY, S_ERR_HNAME_LEN, S_ERR_HNAME_DASH_STARTS, S_ERR_HNAME_DASH_ENDS, S_ERR_HNAME_CHARS, S_ERR_IFACE_IP_MASK, IPHELPER, S_ERR_IFACE_GW, S_ERR_GW_NOT_ON_SAME_SUBNET, validateDomainName, S_ERR_DOMAIN, S_ERR_DNS_IP, cloud_local_hostname, tz, S_ENCRYPTION_KEY_EMPTY_MSG, S_PASSPHRASE_MATCH_MSG, S_DBASE_LOCATION_EMPTY_MSG, S_PASSPHRASE_LENGTH_MSG, S_ENCRYPTION_KEY_MATCH_MSG, S_IP_ADDRESS_MSG, S_VALID_IP_MSG, S_FIREBOX_PASSPHRASE_MSG, S_SETUP_TASK_MSGS, S_REVIEW_SYS, S_REVIEW_SYSTEM_NAME, S_REVIEW_PUB_HOST_NAME, S_REVIEW_AVAIL_ZONE, ec2_has_pub_ip, cloud_pub_ips, cloud_pub_hostnames, S_REVIEW_HOST_NAME, S_REVIEW_SYS, ec2_avail_zone, S_REVIEW_IP_TYPE, S_REVIEW_IP_ADDR, S_REVIEW_GWAY,S_REVIEW_DNS, S_REVIEW_DOMAIN_NAME, S_REVIEW_GEN, S_FINISH_MSG, S_ERR_STATIC_IP_MSG, S_USE_STATIC_IP_MSG, S_WAIT_MSG, ec2_has_pub_hostname, S_REVIEW_ADMIN_PASS, S_REVIEW_LS, S_REVIEW_DB_LOC, S_REVIEW_ENC_KEY, server_port, is_dhcp, static_info, S_DHCP_MSG, S_STATIC_MSG, S_SYSTEM_SETTING_SUCCESS_MSG, validateDomainNameStr, S_ERR_FQDN_ADDR, S_ERR_FQDN_ADDR_DUPLICATE, S_ERROR_DB_NAME_SIZE, S_ERROR_DB_NAME_LONG, S_ERROR_DB_NAME_CHARS, S_ERROR_DB_IP, S_DB_PORT_NAME, S_ERROR_DB_PORT_EMPTY, S_TITLE_CONFIRMATION, S_TITLE_WARNING, S_ERROR_CONNECTING_EXT_DB, db_remote, S_FQDN_LIMIT, S_FQDN_PORT_NAME, S_ERR_FQDN_EMPTY, S_REVIEW_PUB_IP4_ADDR, S_REVIEW_PUB_ADDR, S_REVIEW_PUB_PORT, S_REVIEW_4115_ENDPOINT, S_ERR_HNAME_ONLY_DIGITS, S_YES, S_NO, S_USERNAME_EMPTY_MSG, S_USERNAME_INVALID_MSG, S_REVIEW_ANONYMIZE_REP, S_REVIEW_ANONYMIZE_USER, S_ERR_LOCAL_USER, validatePassword, validateUsername, S_MIN_PASSPHRASE, S_MAX_PASSPHRASE, S_ERR_ACTION_RESTART, S_SERVER_RESTART_MSG, S_SERVER_RESTART_TITLE, alert*/
var SETUP_WIZ = {
    currentPane : 0,
    nextPane : 1,

    activePanes : [],
    activeTasks : [],

    serversConfigured: false,

    setupWizObj : {},
    setupResult : [],
    db_password_changed: false,
    db_password_value: '', // Used to restore the database password when a user clicks away from that field.

    init: function () {
        SETUP_WIZ.initUI();
        SETUP_WIZ.initEvents();
        SETUP_WIZ.stackComponents();
    },

    initUI: function () {
        //Increase height only if system is enabled to accommodate system page UI
        if (system_enabled === 1) {
            $('div.wizard_pane').css('height', '386px');
            $('#external_div').css('height', '260px')
                              .css('overflow', 'auto');
            $('#note').show()
                      .html(S_PANE_MSGS.system_info);
        } else {
            $('#note').hide();
            // These settings are only for dev env
            $('#external_div').css('height', '200px')
                              .css('overflow', 'auto');
            $('#fqdn_div').css('height', '150px')
                          .css('overflow', 'auto');
        }
        $('#db_div').hide();  //We dont need to expose this, sinces users cannot change it
        $('#back_btn').attr('disabled', true);

        $('#send_feedback_tooltip').tooltip();

        $('#db_type').prop('selectedIndex', 0);

        SETUP_WIZ.db_password_value = $('#db_password').val();
        SETUP_WIZ.initSettingsPane();
        SETUP_WIZ.enableFqdnRemButton();
    },

    //If the active form's width is less than or equal to 450
    //stack the UI components one below the other.
    stackComponents: function () {

        //Find the form that does not have 'hide' class.
        //Only the current active view will not have this class.
        var $active_form = $('div.wizard_pane').find('form:not([class*="hide"])');

        if ($active_form.width() <= 450) {
            $active_form.removeClass('form-horizontal');
        } else {
            $active_form.addClass('form-horizontal');
        }
    },

    initSettingsPane: function () {
        if (is_dhcp === 0) { // is static
            $('#iface_ip').val(static_info.ip_addr);
            $('#iface_mask').val(static_info.mask);
            $('#iface_gw').val(static_info.gw);
            $('#dns_server').val(static_info.dns_server);
            $('#dns_name').val(static_info.dns_name);
            SETUP_WIZ.current_static_address = $('#iface_ip').val();
            SETUP_WIZ.current_mask = $('#iface_mask').val();
            SETUP_WIZ.current_gw = $('#iface_gw').val();
            SETUP_WIZ.current_dns_server = $('#dns_server').val();
            SETUP_WIZ.current_dns_name = $('#dns_name').val();
        }
    },

    initEvents: function () {
        $('#iface_type').change(SETUP_WIZ.toggleIfaceType);

        $(window).resize(function () {
            SETUP_WIZ.stackComponents();
        });

        $('#back_btn').button()
                      .click(SETUP_WIZ.backAction);
        $('#next_btn').button()
                      .click(SETUP_WIZ.nextAction);
        $('#button_location').button()
                      .click(SETUP_WIZ.browseAction);

        $('#add_license_button').button()
                               .click(SETUP_WIZ.addLicenseAction);
        $('#remove_license_button').button()
                               .click(SETUP_WIZ.removeLicenseAction);
        $('#add_domain_button').button()
                               .click(SETUP_WIZ.addDomainAction);
        $('#remove_domain_button').button()
                               .click(SETUP_WIZ.removeDomainAction);

        $('#db_type').change(SETUP_WIZ.toggleDBType);
        $('#add_address').on('click', SETUP_WIZ.add_public_address);
        $('#rem_address').on('click', SETUP_WIZ.rem_public_address);
        $('#avail_fqdn').on('change', SETUP_WIZ.enableFqdnRemButton);
        $('#fqdn_hide').on('click', SETUP_WIZ.showFqdnUI);
        $('#fqdn_show').on('click', SETUP_WIZ.showFqdnUI);
        $('#test_db_conn').on('click', SETUP_WIZ.testDBConn);
        $('#user_confirm_save_btn').on('click', SETUP_WIZ.executeUserAction);

        $('#public_address').keydown(function (e) {
            if (e.which === 13) { // Pressing enter on this UI component results in form submission, prevent that.
                return false;
            }
        });

        // Indicate that the pass has changed, and store its new value.
        $('#db_password').change(function () {
            SETUP_WIZ.db_password_changed = true;
            SETUP_WIZ.db_password_value = $('#db_password').val();
        });
        // When the user selects the password field, empty it.
        $('#db_password').focus(function () {
            $('#db_password').val('');
        });

        // Set the db password back to what it was from its blank form when the user moves on.
        $('#db_password').blur(function () {
            $('#db_password').val(SETUP_WIZ.db_password_value);
        });

        $('#anonymize_yes').on('click', SETUP_WIZ.toggleAnonymizeDiv);
        $('#anonymize_no').on('click', SETUP_WIZ.toggleAnonymizeDiv);
        $('#create_user_no').on('click', SETUP_WIZ.toggleAnonymizeUserDiv);
        $('#create_user_yes').on('click', SETUP_WIZ.toggleAnonymizeUserDiv);
    },

    toggleAnonymizeDiv : function () {
        var checked = $('#anonymize_yes').is(':checked');
        if (checked) {
            $('#anonymize_div').show();
            SETUP_WIZ.toggleAnonymizeUserDiv();
        } else {
            $('#anonymize_div').hide();
            $('#anonymize_user_div').hide();
        }
    },

    toggleAnonymizeUserDiv : function () {
        var checked = $('#create_user_yes').is(':checked');
        if (checked) {
            $('#anonymize_user_div').show();
        } else {
            $('#anonymize_user_div').hide();
        }
    },

    anonymizeReports : function () {
        var anonymize_reports = $('#anonymize_yes').is(':checked');
        return anonymize_reports;
    },

    createAnonymizerUser : function () {
        var anonymize_reports = SETUP_WIZ.anonymizeReports();
        var add_anonymize_user = $('#create_user_yes').is(':checked');
        return (anonymize_reports && add_anonymize_user);
    },

    // return true if we are fully managing the system (including network interfaces)
    // for the amazon ec2 case, we manage the system, but not the IPs/Hostname
    isSystemInfsManaged: function () {
        return system_enabled && !is_amazon_ec2;
    },

    toggleIfaceType: function () {
        if ($('#iface_type')[0].selectedIndex === 0) {
            // static
            $('#static_div').show();
        } else {
            // dhcp
            $('#static_div').hide();
        }
    },

    browseAction: function () {
        return;
    },

    addLicenseAction: function () {
        return;
    },

    removeLicenseAction: function () {
        return;
    },

    addDomainAction: function () {
        return;
    },

    removeDomainAction: function () {
        return;
    },

    updateHelpID: function (currentPage) {
        switch (currentPage) {
        case 'welcome':
            HELP_LINK_OVERRIDE = 7000;
            break;
        case 'system':
            HELP_LINK_OVERRIDE = 7001;
            break;
        case 'adminpassphrase':
            HELP_LINK_OVERRIDE = 7002;
            break;
        case 'wlogserver':
            HELP_LINK_OVERRIDE = 7003;
            break;
        case 'review':
            HELP_LINK_OVERRIDE = 7004;
            break;
        case 'progress':
            HELP_LINK_OVERRIDE = 7005;
            break;
        case 'finish':
            HELP_LINK_OVERRIDE = 7006;
            break;
        case 'amazon_ec2':
            HELP_LINK_OVERRIDE = 7007;
            break;
        case 'dblocation':
            HELP_LINK_OVERRIDE = 7008;
            break;
        case 'fqdn':
            HELP_LINK_OVERRIDE = 7009;
            break;
        case 'azure':
            HELP_LINK_OVERRIDE = 7010;
            break;
        case 'anonymization':
            HELP_LINK_OVERRIDE = 7011;
            break;
        }
    },

    backAction: function () {
        SETUP_WIZ.nextPane -= 1;
        SETUP_WIZ.currentPane -= 1;

        SETUP_WIZ.togglePanes(SETUP_WIZ.currentPane, SETUP_WIZ.nextPane);
        SETUP_WIZ.updateButtonStates();
        SETUP_WIZ.updateHelpID(SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]);

        if (!SETUP_WIZ.showActivePaneMsg()) {
            if (SETUP_WIZ.currentPane === 0 && system_enabled === 1) {
                $('#note').show()
                          .html(S_PANE_MSGS.system_info);
            } else {
                $('#note').hide();
            }
        }
    },

    //Hide the current pane, show the nextPrevPane
    togglePanes: function (currentPane, nextPrevPane) {
        $('#' + SETUP_WIZ.activePanes[currentPane]).toggleClass('hide');
        $('#' + SETUP_WIZ.activePanes[nextPrevPane]).toggleClass('hide');
        SETUP_WIZ.stackComponents();
    },

    updateButtonStates: function () {
        var is_finish_pane = (SETUP_WIZ.currentPane === SETUP_WIZ.activePanes.length - 1);

        var back_button_state = (SETUP_WIZ.currentPane === 0 || is_finish_pane);

        $('#back_btn').attr('disabled', back_button_state);

        if (is_finish_pane) {
            $('#next_btn').text(S_FINISH_BUTTON);
        }
    },

    validatePane: function (pane) {

        function updateServers(serverID) {
            //If server is log server or report server and if 'pg' not already present, the add it to the array
            if (serverID === 'wlogserver') {
                SETUP_WIZ.activeTasks.push(serverID);
            }

            //Add org name pane only if wmserver is present
            if (serverID === 'wmserver') {
                SETUP_WIZ.activePanes.splice(1, 0, 'org');
            }
            //Add Report Server pane only if log server is not selected or installed
            if (serverID === 'wrserver' && $.inArray('wlogserver', SETUP_WIZ.activePanes) !== -1) {
                return;
            }
            SETUP_WIZ.activePanes.push(serverID);
            if (serverID === 'wmserver') {
                SETUP_WIZ.activePanes.push(serverID + '_license');
            }
        }

        function doEmptyCheck(elem, msg) {
            if ($(elem).val().length === 0) {
                showHideErrorMsg(elem, msg);
                return false;
            }
            showHideErrorMsg(elem);
            return true;
        }

        function doLengthCheck(elem, min_len, msg) {
            if ($(elem).val().length < min_len) {
                showHideErrorMsg(elem, msg);
                return false;
            }
            showHideErrorMsg(elem);
            return true;
        }

        function doMinMaxLenCheck(elem, min_len, max_len, msg) {
            if ($(elem).val().length < min_len ||
                    $(elem).val().length > max_len) {
                showHideErrorMsg(elem, msg);
                return false;
            }
            showHideErrorMsg(elem);
            return true;
        }

        function doIpCheck(elem, msg) {
            if (!isValidIp(elem)) {
                showHideErrorMsg(elem, msg);
                return false;
            }
            showHideErrorMsg(elem);
            return true;
        }

        function doEqualityCheck(elem1, elem2, msg) {
            if ($(elem1).val() !== $(elem2).val()) {
                showHideErrorMsg(elem1, msg);
                showHideErrorMsg(elem2, msg);
                return false;
            }
            showHideErrorMsg(elem1);
            showHideErrorMsg(elem2);
            return true;
        }

        var current_pane_id = SETUP_WIZ.activePanes[pane] || 'welcome';
        var $elems,
            i,
            elem,
            msg = '';
        //We need to make sure that the ids for each pane match the id below
        switch (current_pane_id) {
        case 'welcome':
            //Welcome pane
            var checked_servers_count = $('.select_one:checked').length;
            if (checked_servers_count === 0 && installed_servers_list.length > 1) {
                $('#note').show()
                          .html(S_SERVER_SELECT_MSG);
                return false;
            }
            //Reset setupObj
            SETUP_WIZ.setupWizObj = {};
            //populate the activePanes list
            SETUP_WIZ.activePanes = [];
            SETUP_WIZ.activeTasks = [];
            SETUP_WIZ.activePanes.push('welcome');

            if (system_enabled === 1) {
                if (is_amazon_ec2) {
                    SETUP_WIZ.activePanes.push('amazon_ec2');
                    SETUP_WIZ.activeTasks.push('amazon_ec2');
                } else if (is_azure) {
                    SETUP_WIZ.activePanes.push('azure');
                    SETUP_WIZ.activeTasks.push('azure');
                } else {
                    SETUP_WIZ.activePanes.push('system');
                    SETUP_WIZ.activeTasks.push('system');
                }
            }

            // UI ordering, show db, then fqdn then admin passphrase pane
            SETUP_WIZ.activePanes.push('dblocation');
            SETUP_WIZ.activePanes.push('fqdn');
            SETUP_WIZ.activePanes.push('adminpassphrase');

            // Saving order should first be admin passphrase, pg then fqdn matching the progress pane layout
            SETUP_WIZ.activeTasks.push('adminpassphrase');
            SETUP_WIZ.activeTasks.push('pg');
            SETUP_WIZ.activeTasks.push('fqdn');

            var serverID = '';
            if (installed_servers_list.length === 1) {
                serverID = installed_servers_list[0][0];
                updateServers(serverID);
            } else {
                $('.select_one:checked').each(function () {
                    serverID = $(this).attr('id');
                    var strSplit = serverID.split('_');

                    serverID = strSplit[1];
                    updateServers(serverID);
                });
            }
            SETUP_WIZ.activePanes.push('anonymization');
            SETUP_WIZ.activePanes.push('review', 'progress', 'finish');
            break;

        case 'dblocation':
            SETUP_WIZ.setupWizObj.external_db = 0; //builtin
            if ($('#db_type')[0].selectedIndex === 1) {
                if (!SETUP_WIZ.validate_external_db()) {
                    return false;
                }
                //Test if external db can be accessed
                SETUP_WIZ.checkExternalDBConn();
                SETUP_WIZ.setupWizObj.external_db = 1;
                return false;
            }
            break;

        case 'fqdn':
            var fqdn_configured = false;
            if (SETUP_WIZ._show_fqdn()) {
                if ($('#avail_fqdn').has('option').length === 0) { // require at least one ip/name
                    $('#public_address').focus();
                    $('#public_address').select();
                    showHideErrorMsg('#avail_fqdn', S_ERR_FQDN_EMPTY);
                    return false;
                }
                showHideErrorMsg('#avail_fqdn');

                var port_error = WGRD.isValidNumeric($('#fqdn_port'), S_FQDN_PORT_NAME);
                if (port_error && port_error.length > 0) {
                    $('#fqdn_port').focus();
                    $('#fqdn_port').select();
                    showHideErrorMsg('#fqdn_port', port_error);
                    return false;
                }
                showHideErrorMsg('#fqdn_port');

                SETUP_WIZ._save_fqdn();
                if (SETUP_WIZ.setupWizObj.fqdn_obj.fqdn_addresses.length !== 0) {
                    fqdn_configured = true;
                } else {
                    fqdn_configured = false;
                }
            }
            SETUP_WIZ._update_active_tasks('fqdn', fqdn_configured);
            break;

        case 'org':

            if (!doEmptyCheck('#org_name', S_ORG_NAME_MSG)) {
                return false;
            }
            SETUP_WIZ.setupWizObj.org_name = $('#org_name').val();
            break;

        case 'adminpassphrase':

            $elems = [ '#passphrase', '#confirm_passphrase' ];
            $('#note').show()
                      .html(S_PANE_MSGS.adminpassphrase);

            for (i = 0; i < $elems.length; i++) {
                elem = $elems[i];
                if (!doEmptyCheck(elem, S_PASSPHRASE_EMPTY_MSG)) {
                    return false;
                }
                if (!doLengthCheck(elem, 8, S_PASSPHRASE_LENGTH_MSG)) {
                    return false;
                }
            }

            if (!doEqualityCheck('#passphrase', '#confirm_passphrase', S_PASSPHRASE_MATCH_MSG)) {
                return false;
            }

            SETUP_WIZ.setupWizObj.admin_passphrase = $('#passphrase').val();
            break;
        case 'system':

            // hostname (alphanumeric plus dash and max 64 chars)
            var hname = $('#hostname').val();
            if (hname.length === 0) {
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_EMPTY);
                return false;
            }
            if (/^[0-9,.]*$/.test(hname) === true) {
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_ONLY_DIGITS);
                return false;
            }
            if (hname.length > 64) {
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_LEN);
                return false;
            }
            if (hname.indexOf('-') === 0) {  // can't start with dash
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_DASH_STARTS);
                return false;
            }
            if (/\-$/.test(hname) === true) {  // can't end with dash
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_DASH_ENDS);
                return false;
            }
            if (/^[a-z0-9\-]+$/i.test(hname) === false) {  // letters, numbers and dash
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_CHARS);
                return false;
            }
            showHideErrorMsg('#hostname');
            SETUP_WIZ.setupWizObj.host_name = $('#hostname').val();

            if ($('#iface_type')[0].selectedIndex === 0) {
                var ip_addr = $('#iface_ip').val();
                var mask = $('#iface_mask').val();
                var gw = $('#iface_gw').val();
                var dns_server = $('#dns_server').val();

                // validate IP and subnet mask
                if (IPHELPER.usableHostIP4(ip_addr) !== 0) {
                    $('#iface_ip').focus();
                    $('#iface_ip').select();
                    showHideErrorMsg('#iface_ip', S_ERR_IFACE_IP_MASK);
                    return false;
                }
                showHideErrorMsg('#iface_ip');
                SETUP_WIZ.setupWizObj.iface_ip = IPHELPER.trimIP4(ip_addr);

                if (mask.length === 0 || !$.isNumeric(mask) || parseInt(mask, 10) < 0 || parseInt(mask, 10) > 32) {
                    $('#iface_mask').focus();
                    $('#iface_mask').select();
                    showHideErrorMsg('#iface_mask', S_ERR_IFACE_IP_MASK);
                    return false;
                }
                showHideErrorMsg('#iface_mask');
                SETUP_WIZ.setupWizObj.iface_mask = mask;

                if (IPHELPER.usableHostIP4WithSlash(ip_addr + '/' + mask) !== 0) {
                    $('#iface_ip').focus();
                    $('#iface_ip').select();
                    showHideErrorMsg('#iface_ip', S_ERR_IFACE_IP_MASK);
                    return false;
                }
                showHideErrorMsg('#iface_ip');
                SETUP_WIZ.setupWizObj.iface_ip = IPHELPER.trimIP4(ip_addr);

                if (IPHELPER.usableHostIP4(gw) !== 0) {
                    $('#iface_gw').focus();
                    $('#iface_gw').select();
                    showHideErrorMsg('#iface_gw', S_ERR_IFACE_GW);
                    return false;
                }
                showHideErrorMsg('#iface_gw');
                SETUP_WIZ.setupWizObj.iface_gw = IPHELPER.trimIP4(gw);

                if (IPHELPER.usableHostIP4WithSlash(gw + '/' + mask) !== 0) {
                    $('#iface_gw').focus();
                    $('#iface_gw').select();
                    showHideErrorMsg('#iface_gw', S_ERR_IFACE_GW);
                    return false;
                }
                showHideErrorMsg('#iface_gw');
                SETUP_WIZ.setupWizObj.iface_gw = IPHELPER.trimIP4(gw);

                // check if default gw is on same subnet as ip
                if (!IPHELPER.isRange4OnSameSubnet(ip_addr, gw, mask)) {
                    $('#iface_gw').focus();
                    $('#iface_gw').select();
                    showHideErrorMsg('#iface_gw', S_ERR_GW_NOT_ON_SAME_SUBNET);
                    return false;
                }
                showHideErrorMsg('#iface_gw');
                SETUP_WIZ.setupWizObj.iface_gw = IPHELPER.trimIP4(gw);

                // domain name
                var dns_name = $('#dns_name').val();
                if (dns_name.length !== 0 && !validateDomainName('#dns_name')) {// validate only if dns_name is not empty
                    $('#dns_name').focus();
                    $('#dns_name').select();
                    showHideErrorMsg('#dns_name', S_ERR_DOMAIN);
                    return false;
                }
                showHideErrorMsg('#dns_name');
                SETUP_WIZ.setupWizObj.dns_name = dns_name;

                // verify server is valid ip
                if (dns_server.length === 0 || IPHELPER.usableHostIP4(dns_server) !== 0) {
                    $('#dns_server').focus();
                    $('#dns_server').select();
                    showHideErrorMsg('#dns_server', S_ERR_DNS_IP);
                    return false;
                }
                showHideErrorMsg('#dns_server');
                SETUP_WIZ.setupWizObj.dns_server = IPHELPER.trimIP4(dns_server);

                SETUP_WIZ.setupWizObj.dhcp_enabled = false;
            } else {
                SETUP_WIZ.setupWizObj.dhcp_enabled = true;
            }

            SETUP_WIZ.setupWizObj.tz = tz;
            SETUP_WIZ.setupWizObj.send_feedback = $('#send_feedback').is(':checked');
            // If system state has changed then save that information first
            if (SETUP_WIZ.checkSysStateChanged()) {
                $("#user_feedback_dlg h3").text(S_TITLE_CONFIRMATION);
                $("#user_feedback_dlg").modal();
                return false; // Pane state will be updated in saveSystemSettings() method
            }
            SETUP_WIZ.setupWizObj.save_dns_setting = SETUP_WIZ.hasDNSSettingChanged();
            break;

        case 'amazon_ec2':
        case 'azure':
            SETUP_WIZ.setupWizObj.host_name = cloud_local_hostname;
            SETUP_WIZ.setupWizObj.send_feedback = $('#send_feedback').is(':checked');
            break;

        case 'wlogserver':  //validate log server pane
            $elems = [ ['#encryption_key', S_ENCRYPTION_KEY_EMPTY_MSG],
                           ['#confirm_encryption_key', S_ENCRYPTION_KEY_EMPTY_MSG],
                           ['#dbase_location', S_DBASE_LOCATION_EMPTY_MSG]
                         ];

            for (i = 0; i < $elems.length; i++) {
                elem = $elems[i][0];
                msg = $elems[i][1];
                // The trim applies only to logging authentication key, making the behavior consistent to WSM
                if ($(elem).val().trim().length === 0) {
                    showHideErrorMsg(elem, msg);
                    return false;
                }
                showHideErrorMsg(elem);
            }

            if (!doEqualityCheck('#encryption_key', '#confirm_encryption_key', S_ENCRYPTION_KEY_MATCH_MSG)) {
                return false;
            }

            // The allowed range for the logging Authentication Key is 8–32 characters. You can use all characters except spaces and slashes (/ or \).
            if ($('#encryption_key').val().length < 8 || $('#encryption_key').val().length > 32) {
                showHideErrorMsg('#encryption_key', S_ENCRYPTION_KEY_INVALID_LENGTH);
                return false;
            }
            if (/[\s\/\\]/.test($('#encryption_key').val())) {
                showHideErrorMsg('#encryption_key', S_ENCRYPTION_KEY_INVALID_CHARACTER);
                return false;
            }

            SETUP_WIZ.setupWizObj.encryption_key = $('#encryption_key').val();
            SETUP_WIZ.setupWizObj.pg_db_location = $('#dbase_location').val();
            break;

        case 'anonymization': // validate anonymization pane
            if (SETUP_WIZ.createAnonymizerUser()) {
                var username = $('#anonymizer_name').val();
                var password = $('#anonymizer_passphrase').val();
                var confirm_password = $('#confirm_anonymizer_passphrase').val();
                var val = validateUsername('#anonymizer_name');
                var err_msg;
                if (val !== 0) {
                    err_msg = SETUP_WIZ._invalid_username_msg(val);
                    showHideErrorMsg('#anonymizer_name', err_msg);
                    return false;
                }
                showHideErrorMsg('#anonymizer_name');
                val = validatePassword(password);
                if (val !== 0) {
                    $('#anonymizer_passphrase').focus();
                    $('#anonymizer_passphrase').select();
                    err_msg = SETUP_WIZ._invalid_password_msg(val);
                    showHideErrorMsg('#anonymizer_passphrase', err_msg);
                    return false;
                }
                if (password !== confirm_password) {
                    $('#anonymizer_passphrase').focus();
                    $('#anonymizer_passphrase').select();
                    showHideErrorMsg('#anonymizer_passphrase', S_PASSPHRASE_MATCH_MSG);
                    return false;
                }
                showHideErrorMsg('#anonymizer_passphrase');
                SETUP_WIZ.setupWizObj.anonymize_reports = 1;
                SETUP_WIZ.setupWizObj.anonymizer_username = username;
                SETUP_WIZ.setupWizObj.anonymizer_passphrase = password;
            } else if (SETUP_WIZ.anonymizeReports()) { // Admin wants to only anonymize reports and create user later
                SETUP_WIZ.setupWizObj.anonymize_reports = 1;
            }
            break;

        case 'wrserver': //validate report server pane

            $elems = [ ['#ls_ip', S_IP_ADDRESS_MSG],
                           ['#ls_password', S_PASSPHRASE_EMPTY_MSG],
                           ['#rs_dbase_location', S_DBASE_LOCATION_EMPTY_MSG]
                         ];

            for (i = 0; i < $elems.length; i++) {
                elem = $elems[i][0];
                msg = $elems[i][1];

                if (!doEmptyCheck(elem, msg)) {
                    return false;
                }
            }

            if (!doIpCheck('#ls_ip', S_VALID_IP_MSG)) {
                return false;
            }

            if (!doLengthCheck('#ls_password', 8, S_PASSPHRASE_LENGTH_MSG)) {
                return false;
            }

            SETUP_WIZ.setupWizObj.logserver_ip = $('#ls_ip').val();
            SETUP_WIZ.setupWizObj.logserver_password = $('#ls_password').val();
            SETUP_WIZ.setupWizObj.pg_db_location = $('#rs_dbase_location').val();
            break;

        case 'wmserver': //validate management server pane

            $elems = [ ['#firebox_ip', S_IP_ADDRESS_MSG],
                           ['#status_password', S_PASSPHRASE_EMPTY_MSG],
                           ['#readwrite_password', S_PASSPHRASE_EMPTY_MSG]
                         ];

            for (i = 0; i < $elems.length; i++) {
                elem = $elems[i][0];
                msg = $elems[i][1];

                if (!doEmptyCheck(elem, msg)) {
                    return false;
                }
            }

            if (!doIpCheck('#firebox_ip', S_VALID_IP_MSG)) {
                return false;
            }

            if (!doMinMaxLenCheck('#status_password', 8, 32, S_FIREBOX_PASSPHRASE_MSG)) {
                return false;
            }

            if (!doMinMaxLenCheck('#readwrite_password', 8, 32, S_FIREBOX_PASSPHRASE_MSG)) {
                return false;
            }

            break;

        case 'wmserver_license': //validate mgmt server license pane
            break;

        case 'wqserver': //validate quarantine server pane
            break;

        default:
            break;
        }
        return true;
    },

    _invalid_username_msg : function (error_val) {
        var err_msg = S_USERNAME_EMPTY_MSG;
        if (error_val === 2) {
            err_msg = S_USERNAME_INVALID_MSG;
        } else if (error_val === 3) {
            err_msg = S_ERR_LOCAL_USER;
        }
        return err_msg;
    },

    _invalid_password_msg : function (error_val) {
        var err_msg = S_PASSPHRASE_EMPTY_MSG;
        if (error_val === 2) {
            err_msg = S_MIN_PASSPHRASE;
        } else if (error_val === 3) {
            err_msg = S_MAX_PASSPHRASE;
        }
        return err_msg;
    },

    updateStatus: function () {
        $.ajax({
            url: 'get_progress',
            success: function (data) {
                var dataSplit = data.split(',');
                var val = '';

                if (dataSplit.length > 1) {
                    var tr = ('#setup_' + dataSplit[0]);
                    var $first_td_tag = $(tr + ' td:first');

                    var img_tag = $('#setup_' + dataSplit[0] + ' td:first').has('img');
                    var msg_key = '';
                    if (img_tag.length === 0) { //Add the img tag only if already does not exist
                        $('<img></img>').attr('src', dataSplit[2])
                                        .appendTo($first_td_tag);
                        msg_key = dataSplit[0] + '_' + dataSplit[1];
                        $(tr + ' td:last').text(S_SETUP_TASK_MSGS[msg_key]);
                    } else {
                        $('#setup_' + dataSplit[0] + ' td:first img').attr('src', dataSplit[2]);
                        msg_key = dataSplit[0] + '_' + dataSplit[1];
                        $(tr + ' td:last').text(S_SETUP_TASK_MSGS[msg_key]);
                    }
                    val = parseInt(dataSplit[3], 10);
                } else {
                    val = parseInt(dataSplit, 10);
                }
                if (val < 100) {
                    setTimeout(SETUP_WIZ.updateStatus, 1000);
                }
            }
        });
    },

    beginServerConfigAction: function () {

        setTimeout(SETUP_WIZ.updateStatus);

        SETUP_WIZ.setupWizObj.tasks = SETUP_WIZ.activeTasks;

        $('#back_btn').attr('disabled', true);
        $('#next_btn').attr('disabled', true);

        $.ajax({
            url: 'configure_servers',
            type: 'POST',
            data: JSON.stringify(SETUP_WIZ.setupWizObj),
            contentType: 'application/json',
            dataType: 'json',
            success: function (data) {
                SETUP_WIZ.serversConfigured = true;
                SETUP_WIZ.setupResult = data;
                $('#next_btn').attr('disabled', false);
                if (SETUP_WIZ.setupResult.status.length > 0) {
                    $("#note").show()
                          .html(S_PANE_MSGS.progress_fail);
                } else {
                    $("#note").show()
                              .html(S_PANE_MSGS.progress);
                }
            }
        });
    },

    prepareReviewPaneContents: function () {
        $('#dl_review').empty();

        if (system_enabled) {
            if (is_amazon_ec2) {
                $('<dt>' + S_REVIEW_SYS + '</dt>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_SYSTEM_NAME + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.host_name + '</dd>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_PUB_HOST_NAME + '</i>&nbsp;' + ec2_has_pub_hostname + '</dd>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_PUB_IP4_ADDR + '</i>&nbsp;' + ec2_has_pub_ip + '</dd>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_AVAIL_ZONE + '</i>&nbsp;' + ec2_avail_zone + '</dd>').appendTo($('#dl_review'));
                $('<dd><br/></dd>').appendTo($('#dl_review'));
            } else if (is_azure) {
                $('<dt>' + S_REVIEW_SYS + '</dt>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_SYSTEM_NAME + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.host_name + '</dd>').appendTo($('#dl_review'));

                // add row if there are endpoints, but 4115 is not among them
                var has_4115_endpoint = S_NO;
                if (cloud_pub_ips && cloud_pub_ips.length > 0) {
                    $.each(cloud_pub_ips, function (index, value) {
                        if (value.public_port === '4115' && value.private_port === '4115') {
                            has_4115_endpoint = S_YES;
                            return false;  // break the loop
                        }
                    });
                    $('<dd><i>' + S_REVIEW_4115_ENDPOINT + '</i>&nbsp;' + has_4115_endpoint + '</dd>').appendTo($('#dl_review'));
                }
                $('<dd><br/></dd>').appendTo($('#dl_review'));
            } else {
                $('<dt>' + S_REVIEW_SYS + '</dt>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_HOST_NAME + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.host_name + '</dd>').appendTo($('#dl_review'));
                var dhcp_enabled = SETUP_WIZ.setupWizObj.dhcp_enabled;
                if (dhcp_enabled) {
                    $('<dd><i>' + S_REVIEW_IP_TYPE + '</i>&nbsp;DHCP' + '</dd>').appendTo($('#dl_review'));
                } else {
                    $('<dd><i>' + S_REVIEW_IP_ADDR + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.iface_ip  + '/' + SETUP_WIZ.setupWizObj.iface_mask + '</dd>').appendTo($('#dl_review'));
                    $('<dd><i>' + S_REVIEW_GWAY + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.iface_gw + '</dd>').appendTo($('#dl_review'));
                    $('<dd><i>' + S_REVIEW_DNS + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.dns_server + '</dd>').appendTo($('#dl_review'));
                    $('<dd><i>' + S_REVIEW_DOMAIN_NAME + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.dns_name + '</dd>').appendTo($('#dl_review'));
                }
                $('<dd><br/></dd>').appendTo($('#dl_review'));
            }
        }

        $('<dt>' + S_REVIEW_DB_LOC + '</dt>').appendTo($('#dl_review'));
        var db_location = SETUP_WIZ.setupWizObj.pg_db_location;
        if (SETUP_WIZ.setupWizObj.external_db === 1) {
            db_location = SETUP_WIZ.setupWizObj.db_obj.host;
        }
        $('<dd>' + db_location + '</dd>').appendTo($('#dl_review'));
        $('<dd><br/></dd>').appendTo($('#dl_review'));

        if (SETUP_WIZ._show_fqdn()) {
            var fqdn_obj = SETUP_WIZ.setupWizObj.fqdn_obj;
            var fqdn_addresses = fqdn_obj.fqdn_addresses;
            var fqdn_port = fqdn_obj.fqdn_port;
            if (fqdn_addresses.length > 0) {
                $('<dt>' + S_REVIEW_PUB_ADDR + '</dt>').appendTo($('#dl_review'));
                $.each(fqdn_addresses, function (index, value) {
                    $('<dd>' + value + '</dd>').appendTo($('#dl_review'));
                });
                $('<dt>' + S_REVIEW_PUB_PORT + '</dt>').appendTo($('#dl_review'));
                $('<dd>' + fqdn_port + '</dd>').appendTo($('#dl_review'));
                $('<dd><br/></dd>').appendTo($('#dl_review'));
            }
        }

        $('<dt>' + S_REVIEW_GEN  + '</dt>').appendTo($('#dl_review'));
        $('<dd>' + S_REVIEW_ADMIN_PASS + '</dd>').appendTo($('#dl_review'));
        $('<dd><br/></dd>').appendTo($('#dl_review'));

        $('<dt>' + S_REVIEW_LS + '</dt>').appendTo($('#dl_review'));
        $('<dd>' + S_REVIEW_ENC_KEY + '</dd>').appendTo($('#dl_review'));
        if (SETUP_WIZ.createAnonymizerUser()) {
            $('<dd>' + S_REVIEW_ANONYMIZE_REP + '</dd>').appendTo($('#dl_review'));
            $('<dd>' + S_REVIEW_ANONYMIZE_USER + '</dd>').appendTo($('#dl_review'));
        } else if (SETUP_WIZ.anonymizeReports()) {
            $('<dd>' + S_REVIEW_ANONYMIZE_REP + '</dd>').appendTo($('#dl_review'));
        }
    },

    updatePaneAndButton: function () {
        SETUP_WIZ.togglePanes(SETUP_WIZ.currentPane, SETUP_WIZ.nextPane);
        SETUP_WIZ.nextPane += 1;
        SETUP_WIZ.currentPane += 1;
        SETUP_WIZ.updateButtonStates();
    },

    _restartAction: function () {
        $.ajax({
            url: 'restart_server',
            type: 'POST',
            dataType: '',
            success: function (response) {
                if (response.status === 0) {
                    WGRD.enableUIElements(false, ['#next_btn']);
                    WGRD.okMessageModal(S_SERVER_RESTART_MSG, S_SERVER_RESTART_TITLE);
                    // wait for the wsserver to restart and reload the page
                    var startTime = new Date().getTime();
                    var timeout = 2 * 60 * 1000; // 2 mins
                    var pollfunc = function () {
                        var currTime = new Date().getTime();
                        if (WGRD.isServerOnline() || startTime + timeout < currTime) {
                            WGRD.closeModal();
                            window.location.href = '/auth/login';
                        } else {
                            setTimeout(pollfunc, 1000);
                        }
                    };
                    setTimeout(pollfunc, 5000);
                } else {
                    alert(S_ERR_ACTION_RESTART);
                }
            },
            error: function (response) {
                alert(S_ERR_ACTION_RESTART);
            }
        });
        return true;
    },

    nextAction: function () {

        if (SETUP_WIZ.currentPane === SETUP_WIZ.activePanes.length - 1) {  //Finish Pane
            if (SETUP_WIZ.setupWizObj.external_db === 1) {
                SETUP_WIZ._restartAction();
            } else {
                WGRD.logout();
            }
        } else if (SETUP_WIZ.nextPane === SETUP_WIZ.activePanes.length - 1) { //Progress Pane
            if (SETUP_WIZ.serversConfigured) {
                if (SETUP_WIZ.setupResult.status.length > 0) {
                    $('#finish_success').hide();
                    $('#finish_msg').removeClass('hide');

                    $.each(SETUP_WIZ.setupResult.status, function (index, val) {
                        var li_text = S_SETUP_TASK_MSGS[val + '_error'];
                        $('<li>' + li_text + '</li>').addClass('text-error').appendTo($('#finish_msg_list'));
                    });
                }
                $('#note')
                         .show()
                         .html(S_PANE_MSGS.finish);
                SETUP_WIZ.updatePaneAndButton();
                SETUP_WIZ.updateHelpID(SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]);
                return;
            }
        } else if (SETUP_WIZ.nextPane === SETUP_WIZ.activePanes.length - 2) { //Review Pane
            $('.server_setup').each(function () {
                var idStr = $(this).attr('id');
                var strSplit = idStr.split('_');
                idStr = strSplit[1];

                if ($.inArray(idStr, SETUP_WIZ.activeTasks) !== -1) {
                    $(this).removeClass('hide');
                } else {
                    $(this).addClass('hide');
                }
            });
            SETUP_WIZ.updatePaneAndButton();
            SETUP_WIZ.beginServerConfigAction();
        } else {
            //stay on the currentPane if validation fails
            if (!SETUP_WIZ.validatePane(SETUP_WIZ.currentPane)) {
                return;
            }
            SETUP_WIZ.updatePaneAndButton();
        }

        var current_pane_id = SETUP_WIZ.activePanes[SETUP_WIZ.currentPane];
        if (current_pane_id === 'review') {
            SETUP_WIZ.prepareReviewPaneContents();
        }
        if (current_pane_id === 'progress') {
            var wait_msg = S_WAIT_MSG;
            if (system_enabled) {
                wait_msg = wait_msg + '<br>' + S_PANE_MSGS.system_info;
            }
            $('#note').html(wait_msg);
        } else {
            if (!SETUP_WIZ.showActivePaneMsg()) {
                $('#note').hide();
            }
        }
        SETUP_WIZ.updateHelpID(SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]);
    },

    showActivePaneMsg: function () {
        var activePane = SETUP_WIZ.activePanes[SETUP_WIZ.currentPane];
        var activePaneMsg = S_PANE_MSGS[activePane];

        if (activePaneMsg) {
            if (activePane === 'fqdn') { //Special handling for the fqdn pane.
                SETUP_WIZ.showFqdnUI();
            } else {
                $('#note').show()
                          .html(activePaneMsg);
            }
            return true;
        }
        return false;
    },

    toggleDBType: function () {
        $('#builtin_div').toggle();
        $('#external_div').toggle();
    },

    /*
    For the following cases return true:
      1. If the current 'IP Address Method' drop down in UI does not match the current system state
      2. OR if user is in 'Static' state and changes the IPv4 address.
    Otherwise return false
     */
    checkSysStateChanged: function () {
        var iface_type = $('#iface_type')[0].selectedIndex;

        // Check if current selected index is not the same as current system state
        if (iface_type !== is_dhcp) {
            $("#user_feedback_dlg p").text(S_STATIC_MSG);
            return true;
        }
        // If current selected index is 0, check if ip address changed.
        if (iface_type === 0) {
            var ip_addr = $('#iface_ip').val().trim();
            var mask = $('#iface_mask').val();
            var gw = $('#iface_gw').val();
            if (SETUP_WIZ.current_static_address !== ip_addr ||
                    SETUP_WIZ.current_mask !== mask ||
                    SETUP_WIZ.current_gw !== gw) {
                $("#user_feedback_dlg p").text(S_STATIC_MSG);
                return true;
            }
        }
        return false;
    },

    hasDNSSettingChanged: function () {
        var dns_server = $('#dns_server').val();
        var dns_name = $('#dns_name').val();
        if (SETUP_WIZ.current_dns_server !== dns_server ||
                SETUP_WIZ.current_dns_name !== dns_name) {
            return true;
        }
        return false;
    },

    /*
    Inform users that the system state has been changed and it will be saved immediately. Let them know
    that they will be redirected to the login page.
     */
    saveSystemSettings: function () {
        //disable the UI
        WGRD.enableUI(false, '#system');

        //disable back and next buttons
        WGRD.enableUIElements(false, ['#back_btn', '#next_btn']);

        var iface_type = $('#iface_type')[0].selectedIndex;

        $('#note').text(S_DHCP_MSG);
        if (iface_type === 0) { //static
            $('#note').text(S_STATIC_MSG);
        }

        //show information message
        $('#system_settings_save').show();
        //save system settings
        setTimeout(function () {
            $.ajax({
                url: 'save_system_settings',
                type: 'POST',
                data: JSON.stringify(SETUP_WIZ.setupWizObj),
                contentType: 'application/json',
                dataType: 'json'
            }).done(function (response) {
                $('#progress_save_sys').hide();
                if (response.status === 0) {
                    $('#system_settings_save span:first').removeClass('text-info')
                                                         .addClass('text-success');
                    if (iface_type === 0) {
                        $('#system_settings_save span:first').html(S_SYSTEM_SETTING_SUCCESS_MSG.format(SETUP_WIZ.setupWizObj.iface_ip, server_port));
                    } else {
                        $('#system_settings_save span:first').html(S_SYSTEM_SETTING_SUCCESS_MSG.format(SETUP_WIZ.setupWizObj.host_name, server_port));
                    }
                } else {
                    $('#note')
                        .addClass('alert-error')
                        .removeClass('alert-info')
                        .html(S_PANE_MSGS.finish_static_error);
                }
            }).error(function (response) {
                $('#progress_save_sys').hide();
                $('#note').html(S_PANE_MSGS.finish_static_error);
            });
        }, 5000);
    },

    validate_fqdn: function (public_address) {

        var addr_valid_ip = IPHELPER.validIP4(public_address);

        // verify address is valid ip
        if (addr_valid_ip.length === 0 || (!addr_valid_ip && !validateDomainNameStr(public_address))) {
            $('#public_address').focus();
            $('#public_address').select();

            showHideErrorMsg('#public_address', S_ERR_FQDN_ADDR);
            return false;
        }

        if (addr_valid_ip) {
            public_address = IPHELPER.trimIP4(public_address);
        }

        // don't allow duplicates
        if ($('#avail_fqdn option[value="' + public_address + '"]').length > 0) {
            $('#public_address').focus();
            $('#public_address').select();

            showHideErrorMsg('#public_address', S_ERR_FQDN_ADDR_DUPLICATE);
            return false;
        }
        $('#public_address').val("");
        showHideErrorMsg('#public_address');
        return true;
    },

    add_public_address: function (event) {
        event.preventDefault();

        // clear empty list error
        showHideErrorMsg('#avail_fqdn');

        // Disable the add button if 5 addresses are already added
        if ($('#avail_fqdn option').length === 5) {
            return;
        }

        var public_address = $('#public_address').val().trim();
        if (SETUP_WIZ.validate_fqdn(public_address)) {
            $('#avail_fqdn').append('<option value="' + public_address + '">' + public_address + '</option>');
        }
        SETUP_WIZ.enforce_fqdn_limit();
    },

    rem_public_address: function (event) {
        event.preventDefault();
        $('#avail_fqdn option:selected').remove();
        SETUP_WIZ.reset_fqdn_pane();
    },

    enforce_fqdn_limit: function () {
        // Disable the add button and show information that only 5 addresses can be added
        if ($('#avail_fqdn option').length === 5) {
            $('#add_address').attr('disabled', true);
            $('#fqdn_limit').removeClass('text-info')
                            .addClass('text-warning')
                            .text(S_FQDN_LIMIT);
        }
    },

    reset_fqdn_pane: function () {
        $('#add_address').attr('disabled', false);
        $('#rem_address').attr('disabled', true);
        $('#fqdn_limit').removeClass('text-warning')
                        .addClass('text-info')
                        .text('');
    },

    enableFqdnRemButton: function () {
        var selected_option = $('#avail_fqdn option:selected').attr('value');
        if (selected_option !== undefined) {
            $('#rem_address').attr('disabled', false);
        } else {
            $('#rem_address').attr('disabled', true);
        }
    },

    toggleFqdnNote: function () {
        if (SETUP_WIZ._show_fqdn()) {
            $('#note').html(S_PANE_MSGS.fqdn_on);
        } else {
            $('#note').html(S_PANE_MSGS.fqdn);
        }
    },

    showFqdnUI: function () {
        if (is_azure) {
            // automatically add the current hostname to the list when the list is empty
            if (cloud_pub_hostnames.length > 0 && $('#avail_fqdn').has('option').length === 0) {
                $('#avail_fqdn').append($('<option/>', {value: cloud_pub_hostnames[0], text: cloud_pub_hostnames[0]}));
            }
        }
        SETUP_WIZ.toggleFqdnNote();
        WGRD.showUIElements(SETUP_WIZ._show_fqdn(), ["#fqdn_div"]);
    },

    testDBConn: function () {
        if (!SETUP_WIZ.validate_external_db()) {
            return false;
        }

        SETUP_WIZ.disableDBPane(true);
        SETUP_WIZ._testDB(SETUP_WIZ.testDbResults, SETUP_WIZ.testDbResultsError);
        return false;
    },

    disableDBPane: function (disable) {
        $('#test_db_conn').attr('disabled', disable);
        $('#back_btn').attr('disabled', disable);
        $('#next_btn').attr('disabled', disable);

        if (disable) {
            WGRD.enableUI(false, '#dblocation');
            $('#test_db_conn_results').hide();
            $('#progress_test_db_conn').show();
        } else {
            $('#progress_test_db_conn').hide();
        }
    },

    _testDB: function (successFunction, errorFunction) {
        var db_password = SETUP_WIZ.db_password_changed ? $('#db_password').val() : null;

        var test_data = {
                'name': $('#db_name').val(),
                'user': $('#db_user_name').val(),
                'host': IPHELPER.trimIP4($('#db_host').val()),
                'password': db_password,
                'port': parseInt($('#db_port').val(), 10),
                'sslmode': $('#db_ssl_mode').val()
            };

        $.ajax({
            url: 'test_db_conn',
            type: 'POST',
            dataType: 'json',
            data: test_data
        }).done(function (resp_data) {
            successFunction(resp_data);
        }).fail(function (resp_data) {
            errorFunction(resp_data);
        });
    },

    testDbResults: function (data) {
        SETUP_WIZ.disableDBPane(false);
        if (data.status) {
            $('#test_db_conn_results').attr('class', 'text-success');
        } else {
            $('#test_db_conn_results').attr('class', 'text-error');
        }
        $('#test_db_conn_results').text(data.message);
        $('#test_db_conn_results').show().fadeOut(10000);
        $('#test_db_conn').attr('disabled', false);
        WGRD.enableUI(true, '#dblocation');
    },

    testDbResultsError: function (data) {
        SETUP_WIZ.disableDBPane(false);
        $('#test_db_conn_results').text(data.statusText + ": " + data.status);
        $('#test_db_conn_results').show().fadeOut(10000);
        $('#test_db_conn').attr('disabled', false);
        WGRD.enableUI(true, '#dblocation');
    },

    testDbResultsBackGround: function (data) {
        WGRD.enableUI(true, '#dblocation');
        SETUP_WIZ.disableDBPane(false);
        if (!data.status) {
            SETUP_WIZ.showDBConnectionMsg();
        } else {
            SETUP_WIZ._save_external_db_setting();
            SETUP_WIZ.moveToNextPane();
        }
    },

    testDbResultsErrorBackGround: function (data) {
        WGRD.enableUI(true, '#dblocation');
        SETUP_WIZ.disableDBPane(false);
        SETUP_WIZ.showDBConnectionMsg();
    },

    showDBConnectionMsg: function () {
        $("#user_feedback_dlg h3").text(S_TITLE_WARNING);
        $("#user_feedback_dlg p").html(S_ERROR_CONNECTING_EXT_DB);
        $("#user_feedback_dlg").modal();
    },

    checkExternalDBConn: function () {
        SETUP_WIZ.disableDBPane(true);
        SETUP_WIZ._testDB(SETUP_WIZ.testDbResultsBackGround, SETUP_WIZ.testDbResultsErrorBackGround);
    },

    executeUserAction: function () {
        $('#user_feedback_dlg').modal("hide");
        if (SETUP_WIZ.currentPane === 1) {
            SETUP_WIZ.saveSystemSettings();
        } else { // Show the next pane
            SETUP_WIZ._save_external_db_setting();
            SETUP_WIZ.moveToNextPane();
        }
    },

    _save_fqdn: function () {
        var fqdn_obj = {};
        var fqdn_addresses = [];
        var fqdn_port = parseInt($('#fqdn_port').val(), 10);
        $('#avail_fqdn option').each(function () {
            var fqdn_address = this.value;
            fqdn_addresses.push(fqdn_address);
        });
        fqdn_obj.fqdn_addresses = fqdn_addresses;
        fqdn_obj.fqdn_port = fqdn_port;

        SETUP_WIZ.setupWizObj.fqdn_obj = fqdn_obj;
    },

    _save_external_db_setting: function () {
        var db_obj = {};
        db_obj.dbname = $.trim($('#db_name').val());
        db_obj.host = IPHELPER.trimIP4($.trim($('#db_host').val()));
        db_obj.port = parseInt($('#db_port').val(), 10);
        db_obj.sslmode = $('#db_ssl_mode').val();
        db_obj.user = $('#db_user_name').val();
        db_obj.password = SETUP_WIZ.db_password_changed ? $('#db_password').val() : '';
        SETUP_WIZ.setupWizObj.db_obj = db_obj;
    },

    validate_external_db: function () {
        var patt = /.*[@=,\/_;#'"*?`\[\]\\].*/;
        var db_name = $('#db_name').val().trim();
        var host = $('#db_host').val().trim();
        var db_port = $('#db_port').val().trim();
        // db name can't be empty or larger than 64 chars
        if (db_name.length === 0) {
            showHideErrorMsg('#db_name', S_ERROR_DB_NAME_SIZE);
            return false;
        }
        if (db_name.length > 64) {
            $('#db_name').focus();
            $('#db_name').select();
            showHideErrorMsg('#db_name', S_ERROR_DB_NAME_LONG);
            return false;
        }
        if (patt.test($('#db_name').val())) {
            $('#db_name').focus();
            $('#db_name').select();
            showHideErrorMsg('#db_name', S_ERROR_DB_NAME_CHARS);
            return false;
        }
        showHideErrorMsg('#db_name');
        // IP address - allow 127.0.0.1 plus IpHelper.isUsableHostIP()
        if (host.length === 0) {
            showHideErrorMsg('#db_host', S_ERROR_DB_IP);
            return false;
        }

        var is_usable_ip = (IPHELPER.usableHostIP4(host) === 0);

        var is_valid = is_usable_ip || validateDomainNameStr(host);
        //Not a valid IPv4 address or hostname
        if (!is_valid) {
            $('#db_host').focus();
            $('#db_host').select();
            showHideErrorMsg('#db_host', S_ERROR_DB_IP);
            return false;
        }

        showHideErrorMsg('#db_host');
        // port - 1-65535
        if (db_port.length === 0) {
            showHideErrorMsg('#db_port', S_ERROR_DB_PORT_EMPTY);
            return false;
        }
        var db_port_error = WGRD.isValidNumeric($('#db_port'), S_DB_PORT_NAME);
        if (db_port_error && db_port_error.length > 0) {
            $('#db_port').focus();
            $('#db_port').select();
            showHideErrorMsg('#db_port', db_port_error);
            return false;
        }
        showHideErrorMsg('#db_port');
        return true;
    },

    moveToNextPane: function () {
        SETUP_WIZ.updatePaneAndButton();
        SETUP_WIZ.updateHelpID(SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]);
        $('#note').show()
                  .html(S_PANE_MSGS[SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]]);
    },

    /*
      For the passed in task name, based on the action parameter
      either remove it from the activeTasks or add it to activeTasks array

      Currently used to add/remove fqdn task based on whether user added public addresses or not
     */
    _update_active_tasks: function (task_name, action) {
        if (task_name === 'fqdn') {
            var fqdn_index = SETUP_WIZ.activeTasks.indexOf('fqdn');
            var addFqdn = action && fqdn_index === -1;
            var remFqdn = !action && fqdn_index !== -1;
            if (addFqdn) {
                var add_index = SETUP_WIZ.activeTasks.length - 1;
                SETUP_WIZ.activeTasks.splice(add_index, 0, 'fqdn');
            } else if (remFqdn) {
                SETUP_WIZ.activeTasks.splice(fqdn_index, 1);
            }
        }
    },

    _show_fqdn: function () {
        return is_azure || $('#fqdn_show').is(':checked');
    }
};

$(document).ready(SETUP_WIZ.init);
