/*global POLLER, HELP_LINK_OVERRIDE:true, IPHELPER, validateDomainNameStr, validateSRVRecordStr, alert, installed_packages, email_enabled, netdiag_host, netdiag_util, netdiag_opt, netdiag_tools, netdiag_traceroute_options, netdiag_host_options,
S_RUN, S_STOP, S_ERR_HOSTNAME, S_ERR_INVALID_PACKAGE, S_GET_DIAGS_TITLE, S_GET_DIAGS_ERROR, S_SEND_DIAGS_OK, S_SSH_PORT_NAME, S_ERR_GET_SSH_CONFIG, S_QUEUE_FLUSHED, S_QUEUE_PURGED, S_ERR_QUEUE_FLUSH, S_ERR_QUEUE_PURGE, S_ERR_EMPTY_EMAIL, S_ERR_INVALID_EMAIL, S_TASK_HISTORY */
var SYS_D = {

    LOG_TYPES : ['server', 'mail'],

    pollServerStatus : null,
    pollEmailStatus : null,

    netdiagTid : '-1',

    // setup the page
    init: function () {
        SYS_D.initUI();
        SYS_D.initEvents();
        SYS_D.initHelp();
    },

    // initialize UI elements
    initUI: function () {
        $('#progress_refresh_diag').hide();
        $('#progress_refresh_status_report').hide();

        $('#progress_email_flush').hide();
        $('#email_flush_results').hide();
        $('#progress_email_purge').hide();
        $('#email_purge_results').hide();

        SYS_D.initNetDiag();
        SYS_D.toggleUtilSelect();
        SYS_D.doStatusReport();
        SYS_D.updateServerInfo();
        SYS_D.updateEmailInfo();
        $.each(SYS_D.LOG_TYPES, function (index, log_type) {
            SYS_D.refreshLog(log_type);
        });
        SYS_D.initTaskHistoryTable();
    },

    // add event handlers
    initEvents: function () {
        $('#btn_run').button().click(SYS_D.doDiag);
        $('#ip_address_hostname').keypress(function (event) {
            if (event.which === 13) {
                $('#btn_run').focus();
                $('#btn_run').click();
                return false;
            }
        });
        $('#options_network_diag').change(SYS_D.toggleUtilSelect);
        $('#btn_sys_update').button().click(SYS_D.doSysUpdate);
        $('#btn_status_report').button().click(SYS_D.doStatusReportDownload);
        $('#btn_send_status_report').button().click(SYS_D.doSendStatusReport);
        $('#btn_refresh_status_report').button().click(function () {
            var attr = $('#btn_refresh_status_report').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                SYS_D.doStatusReport();
            }
        });

        $('#ssh_btn').button().click(SYS_D.sshAction);
        $('#ssh_enabled').click(SYS_D.toggleSshEnabled);

        $.each(SYS_D.LOG_TYPES, function (index, log_type) {
            $('#refresh_' + log_type + '_log').button().click(function () {
                var attr = $('#refresh_' + log_type + '_log').attr('disabled');
                if (attr !== 'true' && attr !== 'disabled') {
                    SYS_D.refreshLog(log_type);
                }
            });
        });

        $("#refresh_task_history").click(SYS_D.refreshGrid);

        $(window).bind('resizeEnd', function () {
            SYS_D._doResizeGrid();
        });

        // start a poller to refresh the system info
        SYS_D.pollServerStatus = new POLLER('server_info', null, 30000, SYS_D.updateServerInfoHandler, SYS_D.serverInfoRefreshErrorHandler);

        // same for email queue info
        SYS_D.pollEmailStatus = new POLLER('email_info', null, 30000, SYS_D.updateEmailInfoHandler, SYS_D.emailInfoRefreshErrorHandler);

        WGRD.enableUIElements(email_enabled, ['#btn_email_test']);
        $('#btn_email_flush').button().click(SYS_D.doEmailFlush);
        $('#btn_email_purge').button().click(SYS_D.doEmailPurge);
        $('#btn_email_test').button().click(SYS_D.doEmailTest);
    },

    initHelp: function () {
        // Update help link based on tab selected
        $('#tabs a[href="#os"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7362;
        });
        $('#tabs a[href="#server"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7363;
        });
    },

    initNetDiag: function () {
        // initialize Network Diagnostics fields

        // set default values when given values is either null or invalid
        $("#options_network_diag").val($("#options_network_diag option:first").val());
        $("#options_dnslookup_querytype").val($("#options_dnslookup_querytype option:first").val());

        // set the utility to be used
        if ($.inArray(netdiag_util.toLowerCase(), netdiag_tools) > -1) {
            $("#options_network_diag").val(netdiag_util.toLowerCase());
        }

        // set the host options
        if (($("#options_network_diag").val() === 'host') && ($.inArray(netdiag_opt.toLowerCase(), netdiag_host_options) > -1)) {
            $("#options_dnslookup_querytype").val(netdiag_opt.toLowerCase());
        }

        // set the ip address or hostname 
        $('#ip_address_hostname').val(netdiag_host);

    },

    doDiag: function () {
        if ($('#btn_run').text() === S_RUN) {
            SYS_D.netdiagTid = '-1';
            $('#diag_results').val('');

            // get the hostname
            var host = $('#ip_address_hostname').val();

            // get the diagnostic command
            var diag_cmd = $('#options_network_diag').val();

            // get the diagnostic command option
            var diag_opt = SYS_D._get_diagnostic_option(diag_cmd);

            // validate the host
            if (host.length === 0 || (!IPHELPER.validIP4(host) && !validateDomainNameStr(host) && !validateSRVRecordStr(host))) {
                $('#diag_results').val(S_ERR_HOSTNAME + host);
                return;
            }

            // toggle the UI state
            $('#progress_refresh_diag').show();
            $('#btn_run').text(S_STOP);

            // jquery's ajax request doesn't support readystatechange events, so we do it manually to support the streaming response
            var netdiag_req = new XMLHttpRequest();
            netdiag_req.open('POST', 'start_netdiag?host=' + host + '&util=' + diag_cmd + '&opt=' + diag_opt);
            var csrf_token = $("#csrf_token").val();
            netdiag_req.setRequestHeader('X-CSRFToken', csrf_token);
            netdiag_req.onreadystatechange = function () {
                // check status is 200
                var results_str;
                if (this.status === 200) {
                    if (this.readyState === 3) {  // in progress
                        results_str = SYS_D.save_and_strip_tid(this.responseText);
                        $('#diag_results').val(results_str);
                    } else if (this.readyState === 4) {  // done
                        results_str = SYS_D.save_and_strip_tid(this.responseText);
                        $('#diag_results').val(results_str);
                        $('#btn_run').text(S_RUN);
                        $('#progress_refresh_diag').hide();
                    }
                } else if (this.readyState > 1) {  // readystate<1 means haven't sent data yet; IE will have status=0 with readystate=1
                    // error
                    $('#diag_results').val(this.responseText);
                    $('#btn_run').text(S_RUN);
                    $('#progress_refresh_diag').hide();
                }
            };
            netdiag_req.send();
        } else { // assume it is stop
            $.ajax({
                url: 'stop_netdiag',
                type: 'POST',
                data: {'tid': SYS_D.netdiagTid},
                // success: // don't need to do anything - handled by complete()
                error: function (response) {
                    var curr_data = $('#diag_results').val();
                    $('#diag_results').val(curr_data + response.responseText);
                },
                complete: function () {
                    $('#btn_run').text(S_RUN);
                    $('#progress_refresh_diag').hide();
                }
            });
        }
    },

    save_and_strip_tid: function (responseText) {
        // we use a special line of text to indicate the task id
        // this detects, stores and deletes that line
        var tid_text = '$NETDIAG_TID$=';
        var index;

        if (responseText.lastIndexOf(tid_text, 0) === 0) {
            index = responseText.indexOf('\n');
            if (index >= 0) {
                SYS_D.netdiagTid = responseText.substring(tid_text.length, index);
                return responseText.substring(index + 1, responseText.length);
            }
        }
        return responseText;
    },

    // ------------ System Update  -----------------------------------------------------

    doSysUpdate: function () {
        WGRD.doModal('#update_dlg',
                     SYS_D.initSysUpdateModal,
                     SYS_D.saveSysUpdateModal);
    },

    initSysUpdateModal: function () {
        // clear the package text field
        $('#update_package').val('');

        return true;
    },

    saveSysUpdateModal: function () {
        // check if the package name is valid
        var pname = $('#update_package').val();
        if (pname.length === 0 || $.inArray(pname, installed_packages) === -1) {
            return S_ERR_INVALID_PACKAGE;
        }

        // send the task request to the server
        var err = null;
        $.ajax({
            url: 'update_package?package=' + pname,
            type: 'POST',
            async: false,
            error: function (data) {
                err = data.statusText;
            }
        });

        return err;
    },

    // ------------ System Update (end) ------------------------------------------------


    doStatusReportDownload: function () {
        WGRD.enableUIElements(false, ['#btn_status_report']);

        $('#progress_dlg').modal();

        $.ajax({
            url: 'gen_diag_file',
            method: 'POST',
            dataType: 'json',
            success: function (response) {
                $('#progress_dlg').modal('hide');
                if (response.status === 0) {
                    var file_args = '?tmp_file_name=' + response.tmp_file_name + '&file_name=' + response.file_name;
                    window.location = 'get_tmp_file' + file_args;
                } else {
                    var msg = S_GET_DIAGS_ERROR;
                    if (response.message) {
                        msg += '<br/>' + response.message;
                    }
                    WGRD.okMessageModal(msg, S_GET_DIAGS_TITLE);
                }
            },
            error: function (response) {
                $('#progress_dlg').modal('hide');
                WGRD.okMessageModal(S_GET_DIAGS_ERROR, S_GET_DIAGS_TITLE);
            },
            complete: function () {
                WGRD.enableUIElements(true, ['#btn_status_report']);
            }
        });
    },

    doSendStatusReport: function () {
        WGRD.enableUIElements(false, ['#btn_send_status_report']);

        $('#progress_dlg').modal();

        $.ajax({
            url: 'send_diag_file',
            dataType: 'json',
            success: function (response) {
                $('#progress_dlg').modal('hide');
                WGRD.okMessageModal(S_SEND_DIAGS_OK, S_GET_DIAGS_TITLE);
            },
            error: function (response) {
                $('#progress_dlg').modal('hide');
                WGRD.okMessageModal(S_GET_DIAGS_ERROR, S_GET_DIAGS_TITLE);
            },
            complete: function () {
                WGRD.enableUIElements(true, ['#btn_send_status_report']);
            }
        });
    },

    doStatusReport: function () {
        WGRD.enableUIElements(false, ['#btn_refresh_status_report']);
        $('#progress_refresh_status_report').show();
        $('#status_report_results').val('');

        $.ajax({
            url: 'get_status_report',
            type: 'POST',
            dataType: 'json',
            success: function (response) {
                // update the text area with the new data
                $('#status_report_results').val(response.data);
            },
            error: function (response) {
                $('#status_report_results').val('');
            },
            complete: function () {
                $('#progress_refresh_status_report').hide();
                WGRD.enableUIElements(true, ['#btn_refresh_status_report']);
            }
        });
    },

    // ------------ SSH  ---------------------------------------------------------------

    toggleSshEnabled: function (event) {
        var enable = $('#ssh_enabled').is(':checked');
        WGRD.enableUIElements(enable, ['#ssh_port']);
    },

    sshAction: function () {
        WGRD.doModal('#ssh_dlg',
                     SYS_D.initSshModal,
                     SYS_D.saveSshModal);
    },

    initSshModal: function () {
        // get the current ssh setting
        var cfg_ssh = null;
        $.ajax({
            url: 'get_support_access_state',
            dataType: 'json',
            async: false,
            success: function (response) {
                cfg_ssh = response;
            },
            error: function (response) {
                alert(S_ERR_GET_SSH_CONFIG);
            }
        });

        if (!cfg_ssh) {
            return false;
        }

        $('#ssh_enabled').prop('checked', cfg_ssh.enabled);
        $('#ssh_port').val(cfg_ssh.port);
        SYS_D.toggleSshEnabled();

        return true;
    },

    saveSshModal: function () {
        // save the ssh setting
        var enabled = $('#ssh_enabled').is(':checked');

        if (enabled) {
            var ssh_port_error = WGRD.isValidNumeric($('#ssh_port'), S_SSH_PORT_NAME);
            if (ssh_port_error && ssh_port_error.length > 0) {
                $('#ssh_port').focus();
                $('#ssh_port').select();
                return ssh_port_error;
            }
        }

        var err = null;
        var port = parseInt($('#ssh_port').val(), 10);
        $.ajax({
            url: 'set_support_access_state?enabled=' + enabled + '&port=' + port,
            type: 'POST',
            async: false,
            error: function (data) {
                err = data.statusText;
            }
        });

        return err;
    },

    // ------------ SSH (end) ----------------------------------------------------------

    updateServerInfoHandler: function (response) {
        SYS_D.updateServerInfoUI(response);
        return true;
    },

    serverInfoRefreshErrorHandler: function (response, num_failed) {
        return true;
    },

    // ajax call to get some updated server info and refresh the UI
    updateServerInfo: function () {
        $.ajax({
            url: 'server_info',
            type: 'POST',
            dataType: 'json',
            success: function (data) {
                SYS_D.updateServerInfoUI(data);
            }
        });
    },

    updateServerInfoUI: function (data) {
        $('#ws_uptime').html('');
        if (data.ws_uptime !== undefined) {
            $('#ws_uptime').html(data.ws_uptime);
        }
        $('#ws_memory').html('');
        if (data.ws_memory !== undefined) {
            $('#ws_memory').html(data.ws_memory);
        }

        if (data.ws_cpu_tooltip !== undefined) {
            $('#ws_cpu').html(data.ws_cpu + '&nbsp;<a id="ws_cpu_tooltip" data-toggle="tooltip"><i class="icon-question-sign"></i></a>');
            $('#ws_cpu_tooltip').tooltip({
                html: true,
                placement: 'right',
                title: data.ws_cpu_tooltip
            });
        } else if (data.ws_cpu !== undefined) {
            $('#ws_cpu').html(data.ws_cpu);
        } else {
            $('#ws_cpu').html('');
        }
    },

    refreshLog: function (log_type) {
        WGRD.enableUIElements(false, ['#refresh_' + log_type + '_log']);
        $('#progress_refresh_' + log_type + '_log').show();
        $('#' + log_type + '_log').val('');

        var lines = 100;  // default
        var error = WGRD.isValidNumeric($('#' + log_type + '_log_lines'), '');
        if (!error || error.length === 0) {
            lines = parseInt($('#' + log_type + '_log_lines').val(), 10);
        } else {
            $('#' + log_type + '_log_lines').val(lines);
        }

        $.ajax({
            url: 'get_log',
            type: 'POST',
            dataType: 'json',
            data: {'log_type' : log_type, 'num_lines': lines},
            success: function (response) {
                // update the text area with the new data
                $('#' + log_type + '_log').val(response.data);
            },
            error: function (response) {
                $('#' + log_type + '_log').val('');
            },
            complete: function () {
                $('#progress_refresh_' + log_type + '_log').hide();
                WGRD.enableUIElements(true, ['#refresh_' + log_type + '_log']);
            }
        });
    },

    // ------------ System Task History ------------------------------------------------

    initTaskHistoryTable: function () {
        $("#task_history_table").jqGrid({
            datatype: SYS_D.refreshGrid,
            // The colNames are placed in the template so we can localize them.
            colNames: [
                S_TASK_HISTORY.column_names.state,
                S_TASK_HISTORY.column_names.task_type,
                S_TASK_HISTORY.column_names.creation_time,
                S_TASK_HISTORY.column_names.last_update_time,
                S_TASK_HISTORY.column_names.general_info
            ],
            colModel: [
                { name: 'state', sortable: true },
                { name: 'task_type', sortable: true },
                { name: 'creation_time', sortable: true },
                { name: 'last_update_time', sortable: true },
                { name: 'general_info', sortable: true }
            ],
            rowNum: 10,
            rowList: [10, 20, 30],
            viewrecords: true,
            gridview: true,
            autoencode: true,
            shrinktofit: true,
            autowidth: true,
            height: "auto",
            sortname: 'last_update_time',
            sortorder: 'desc',
            pager: "#task_history_pager"
        });
    },

    refreshGrid: function () {
        WGRD.enableUIElements(false, ['#refresh_task_history']);
        $('#progress_refresh_task_history').show();
        $("#task_history_error").hide();
        $.ajax({
            url: "get_task_history",
            type: 'GET',
            dataType: 'json',
            data: '',
            success: function (data) {
                // update the table with the new data
                SYS_D._loadSpecificData(data);
            },
            error: function (data) {
                $("#task_history_error").show();
            },
            complete: function (data) {
                $('#progress_refresh_task_history').hide();
                WGRD.enableUIElements(true, ['#refresh_task_history']);
                SYS_D._doResizeGrid();
            }
        });
    },

    _loadSpecificData: function (data) {
        $("#task_history_table").jqGrid('clearGridData');
        $("#task_history_table").jqGrid("setGridParam", {
            "datatype": 'local',
            "data": data
        });
        $("#task_history_table").trigger('reloadGrid');
    },

    _doResizeGrid: function () {
        var pad = parseInt($("#full_width_row").css('margin-left'), 10);
        var row_width = $("#full_width_row").width();
        pad *= 2;
        if (pad === 0) {
            pad += row_width / 110;  // add padding to keep the grid smaller than the parent
        }
        var grid_width = row_width - pad;
        $('#task_history_table').setGridWidth(grid_width);
    },

    // ------------ Email  ------------------------------------------------

    // ajax call to get some updated email info and refresh the UI
    updateEmailInfo: function () {
        $.ajax({
            url: 'email_info',
            type: 'POST',
            dataType: 'json',
            success: function (data) {
                SYS_D.updateEmailInfoUI(data);
            }
        });
    },

    updateEmailInfoUI: function (data) {
        $('#queue_size').html('');
        var queued_msg_count = 0;
        if (data.queue_size !== undefined) {
            $('#queue_size').html(data.queue_size);
        }
        $('#email_status').html('');
        if (data.email_system_status !== undefined) {
            $('#email_status').html(data.email_system_status);
        }
        if (data.queued_msg_count !== undefined) {
            queued_msg_count = data.queued_msg_count;
        }
        $('#progress_email_flush').hide();
        $('#progress_email_purge').hide();
        $('#email_op_results').show();
        WGRD.enableUIElements(queued_msg_count !== 0, ['#btn_email_flush', '#btn_email_purge']);
    },

    emailInfoRefreshErrorHandler: function (response, num_failed) {
        return true;
    },

    updateEmailInfoHandler: function (response) {
        SYS_D.updateEmailInfoUI(response);
        return true;
    },

    doEmailFlush: function () {
        WGRD.enableUIElements(false, ['#btn_email_flush', '#btn_email_purge']);
        $('#progress_email_purge').hide();
        $('#email_op_results').hide();
        $('#progress_email_flush').show();

        $.ajax({
            url: 'email_flush',
            type: 'POST',
            dataType: 'json',
            success: function (response) {
                $('#email_op_results').attr('class', 'success');
                $('#email_op_results').text(S_QUEUE_FLUSHED);
            },
            error: function (response) {
                $('#email_op_results').attr('class', 'fail');
                $('#email_op_results').text(S_ERR_QUEUE_FLUSH);
            },
            complete: function () {
                // slight delay before we update the UI ... maybe task will finish
                setTimeout(SYS_D.updateEmailInfo, 2000);
            }
        });
    },

    doEmailPurge: function () {
        WGRD.enableUIElements(false, ['#btn_email_flush', '#btn_email_purge']);
        $('#progress_email_flush').hide();
        $('#email_op_results').hide();
        $('#progress_email_purge').show();

        $.ajax({
            url: 'email_purge',
            type: 'POST',
            dataType: 'json',
            success: function (response) {
                $('#email_op_results').attr('class', 'success');
                $('#email_op_results').text(S_QUEUE_PURGED);
            },
            error: function (response) {
                $('#email_op_results').attr('class', 'fail');
                $('#email_op_results').text(S_ERR_QUEUE_PURGE);
            },
            complete: function () {
                // slight delay before we update the UI ... maybe task will finish
                setTimeout(SYS_D.updateEmailInfo, 2000);
            }
        });
    },

    doEmailTest: function () {
        WGRD.doModal('#test_email_dlg', SYS_D.initTestEmailModal, SYS_D.sendTestEmailModal);
    },

    initTestEmailModal: function (params) {
        return true;
    },

    validateEmailAddr: function (addr) {
        if (!addr || !addr.length) {
            return S_ERR_EMPTY_EMAIL;
        }
        var patt = /^[^\s]+@[^\s]+$/;  // basic sanity checking
        if (!patt.test(addr)) {
            return S_ERR_INVALID_EMAIL;
        }
        return;
    },

    sendTestEmailModal: function (params) {
        var email_from = $('#te_from').val();
        var email_to = $('#te_to').val();
        var email_subj = $('#te_subject').val();

        var errmsg = SYS_D.validateEmailAddr(email_to);
        if (errmsg) {
            $('#te_to').focus();
            return errmsg;
        }
        errmsg = SYS_D.validateEmailAddr(email_from);
        if (errmsg) {
            $('#te_from').focus();
            return errmsg;
        }

        $.ajax({
            url: 'email_test',
            type: 'POST',
            dataType: 'json',
            data: {'email_from' : email_from, 'email_to': email_to, 'email_subj': email_subj},
            success: function (response) {
                $('#email_test_results').attr('class', 'success');
                $('#email_test_results').text(response.message);
            },
            error: function (response) {
                $('#email_test_results').attr('class', 'fail');
                $('#email_test_results').text(response.message);
            },
            complete: function () {
                SYS_D.refreshLog('mail');
            }
        });

        return;
    },

    _get_diagnostic_option: function (diag_cmd) {
        var diag_opt = '';

        if (diag_cmd === "traceroute") {
            diag_opt = "icmp";  // always use ICMP probes
        } else if (diag_cmd === "host") {
            diag_opt = $('#options_dnslookup_querytype').val();
        }
        return diag_opt;
    },

    toggleUtilSelect: function () {
        switch ($('#options_network_diag').val()) {
        case 'ping':
            $('#lookup_query_type_div').hide();
            break;
        case 'traceroute':
            $('#lookup_query_type_div').hide();
            break;
        case 'host':
            $('#lookup_query_type_div').show();
            break;
        }
    }
};

$(document).ready(SYS_D.init);
