#!/bin/sh
# wg-apttoken.sh - Retrieve APT token for this system from WatchGuard

if [ -r /etc/default/wg_system ] ; then
    . /etc/default/wg_system

    WG_PYTHON_BIN=${WG_BINDIR}/python
    WG_CALLHOME_PYC=${WG_BINDIR}/wg_callhome.pyc
    WG_CALLHOME_METHOD="dimension_gettoken"

    if [ ! -f "${WG_PYTHON_BIN}" -o ! -x "${WG_PYTHON_BIN}" ]; then
        echo "{WG_PYTHON_BIN} does not exist or is not an executable."
        exit 1
    fi

    if [ ! -f "${WG_CALLHOME_PYC}" -o ! -s "${WG_CALLHOME_PYC}" ]; then
        echo "File ${WG_CALLHOME_PYC} does not exist or is empty."
        exit 1
    fi

    "${WG_PYTHON_BIN}" "${WG_CALLHOME_PYC}" "${WG_CALLHOME_METHOD}"
fi
