#!/bin/sh

# This script assumes PostgreSQL log settings as follows:

# wglog=# SELECT name, setting FROM pg_settings WHERE name ~ '^log_(filename|rotation)';
#        name        |            setting             
# -------------------+--------------------------------
#  log_filename      | postgresql-%Y-%m-%d_%H%M%S.log
#  log_rotation_age  | 1440
#  log_rotation_size | 10240
# (3 rows)

get_log_file_count() {
    get_log_files | wc -l
}

get_log_files() {
    /bin/ls -U $LOG_FILENAMES 2>/dev/null || true
}

get_log_files_cronologically() {
    /bin/ls -tr $LOG_FILENAMES 2>/dev/null || true
}

get_log_sizes() {
    /usr/bin/du -k $LOG_FILENAMES 2>/dev/null || true
}

get_oldest_log_file() {
    get_log_files_cronologically | head -n 1
}

get_total_log_size() {
    get_log_sizes | awk 'BEGIN {total = 0} {total += $1} END {print total}'
}

remove_oldest_log_file() {
    OLDEST_LOG_FILE=`get_oldest_log_file`
    echo "Removing log" $OLDEST_LOG_FILE
    /bin/rm -f "$OLDEST_LOG_FILE"
}

#########################
# Execution begins here #
#########################

set -eu

DEFAULTS=/etc/default/wg_system

if [ ! -f $DEFAULTS ]; then
    exit 0
fi

. $DEFAULTS

LIMIT_SIZE=51200
LOG_FILENAMES="$WG_VARDIR/logs/postgres/postgresql-*.log*"

FILE_COUNT=`get_log_file_count`

if [ "$FILE_COUNT" -le 1 ]; then
    exit 0
fi

TOTAL_SIZE=`get_total_log_size`

if [ "$TOTAL_SIZE" -le "$LIMIT_SIZE" ]; then
    exit 0
fi

echo "Initial total log size:" $TOTAL_SIZE "kiB"

while [ "$FILE_COUNT" -gt 1 -a "$TOTAL_SIZE" -gt "$LIMIT_SIZE" ]; do
    remove_oldest_log_file
    FILE_COUNT=`get_log_file_count`
    TOTAL_SIZE=`get_total_log_size`
done

echo "Final total log size:" $TOTAL_SIZE "kiB"
