/*global escapeHtml, unescapeHtml, config_revert_perm, S_DEFAULT_REVERT_COMMENT, S_REVERT_CONFIG_ERROR_MSG, S_DIFF_CONFIG_ERROR_MSG, S_DIFF_CONFIG_PREFIX_TEXT, colConfigHistoryModel, colConfigHistoryNames, getRadioVal, createRsSingleGrid, S_REVERT_CONFIG_SUCCESS_MSG, control_connected, S_DIFF_AGAINST_PREVIOUS_REV_TEXT, S_DIFF_AGAINST_SPECIFIC_REV_TEXT, S_REVERT_INFO_TEXT, member_sn, S_EDIT_PRESERVE_TEXT, S_EDIT_PRESERVE_ANNOTATION_ERR_MSG, S_EDIT_ANNOTATION_LEN_ERR_MSG */

var CONTROL_CONFIG_HISTORY = {
        urlSn: 'all',
        urlMsn: '',
        tid: null,
        updateTimeout: 300000,
        config_history: null,

        init: function () {
            $.getUrlVars();
            CONTROL_CONFIG_HISTORY.urlSn = $.getUrlVar('sn');
            CONTROL_CONFIG_HISTORY.urlMsn = $.getUrlVar('msn');
            CONTROL_CONFIG_HISTORY.initUI();
            CONTROL_CONFIG_HISTORY.initEvents();
            CONTROL_CONFIG_HISTORY.uiState();
        },

        initUI: function () {
            $('#msg_container').hide();

            if (control_connected === 1) {
                $('#btn_revert').show();
            } else {
                $('#btn_revert').hide();
            }

            CONTROL_CONFIG_HISTORY.getConfigHistoryData();
        },

        uiState: function () {

            WGRD.enableUIElements(false, ['#btn_diff', '#btn_revert', '#btn_export', '#btn_edit']);
            var config_history = CONTROL_CONFIG_HISTORY.getSortedConfigHistory();
            if (config_history === null) {
                return;
            }
            var entries = config_history.length;

            if (entries >= 1) {
                var selrow = $('#grid_config_history').jqGrid('getGridParam', 'selrow');
                if (selrow) {
                    if (entries === 1) {
                        WGRD.enableUIElements(true, ['#btn_export', '#btn_edit']);
                    } else {
                        WGRD.enableUIElements(true, ['#btn_diff', '#btn_export', '#btn_edit']);
                    }
                    if (config_revert_perm === 1) {//User can revert
                        var rowVal = $('#grid_config_history').jqGrid('getRowData', selrow);
                        if (config_history[entries - 1].config_revision !== parseInt(rowVal.revision, 10)) {
                            WGRD.enableUIElements(true, ['#btn_revert']);
                        }
                    }
                    else {
                        // If user have no revert permission, user can't edit and export either.
                        WGRD.enableUIElements(false, ['#btn_edit']);
                        WGRD.enableUIElements(false, ['#btn_export']);
                    }
                }
            }
        },

        initEvents: function () {
            $("a").click(function () {
                // Custom to disable anchor if it's been set to 'disabled'
                return ($(this).attr('disabled')) ? false : true;
            });

            $(window).bind('resizeEnd', function () {
                CONTROL_CONFIG_HISTORY.doResize();
            });

            $('#btn_refresh').button().click(function () {
                CONTROL_CONFIG_HISTORY.refreshGrid();
                $('#msg_container').hide();
            });

            $('#btn_revert').button().click(function () {
                var selRow = $('#grid_config_history').jqGrid('getGridParam', 'selrow');
                if (selRow) {
                    CONTROL_CONFIG_HISTORY.revertConfigDialog(selRow);
                    CONTROL_CONFIG_HISTORY.uiState();
                }
            });

            $('#btn_diff').button().click(function () {
                var selRow = $('#grid_config_history').jqGrid('getGridParam', 'selrow');
                if (selRow) {
                    CONTROL_CONFIG_HISTORY.diffConfigDialog(selRow);
                    CONTROL_CONFIG_HISTORY.uiState();
                }
                $('#msg_container').hide();
            });

            $('#btn_export').button().click(function () {
                var selRow = $('#grid_config_history').jqGrid('getGridParam', 'selrow');
                if (selRow) {
                    CONTROL_CONFIG_HISTORY.exportConfig(selRow);
                }
                CONTROL_CONFIG_HISTORY.refreshGrid();
                $('#msg_container').hide();
            });

            $('#btn_edit').button().click(function () {
                var selRow = $('#grid_config_history').jqGrid('getGridParam', 'selrow');

                if (selRow) {
                    var rowData = $('#grid_config_history').getRowData(selRow);
                    CONTROL_CONFIG_HISTORY.editConfigDialog(rowData);
                }
                CONTROL_CONFIG_HISTORY.refreshGrid();
                $('#msg_container').hide();
            });

            $('#grid_config_history').click(function () {
                $('#msg_container').hide();
            });

            $('#compare_revision').click(function () {
                $("input:radio[name='radio_diff_revision']").prop("checked", false); // clear first
                $("input:radio[name='radio_diff_revision']").filter("[value='0']").prop("checked", true);
            });
        },

        refreshGrid: function () {
            CONTROL_CONFIG_HISTORY.getConfigHistoryData();
            CONTROL_CONFIG_HISTORY.uiState();
        },

        loadGridConfigurationHistory : function () {
            var grid = '#grid_config_history';
            var config_history = CONTROL_CONFIG_HISTORY.getSortedConfigHistory();
            var entries = config_history.length;
            var history_entries = [];
            var i;
            var revision;

            for (i = entries - 1; i >= 0; --i) {
                if (config_history[i].preserved) {
                    revision = config_history[i].config_revision + "*";
                } else {
                    revision = config_history[i].config_revision;
                }
                history_entries.push({'revision': revision, 'when': config_history[i].update_time,
                    'user': config_history[i].user_name, 'comment': config_history[i].user_comment,
                    'preserved': config_history[i].preserved, 'annotation': config_history[i].annotation });
            }

            if ($("#grid_config_history")[0].grid) {
                // If already initialized, clear the grid, load the new data and return
                $('#grid_config_history').jqGrid('clearGridData');
                $("#grid_config_history").setGridParam({
                    data: history_entries
                }).trigger("reloadGrid");

                return;
            }

            jQuery(grid).GridUnload(grid);
            var optparams = {
                    pager : '#gridpager',
                    loadComplete: function () {
                        CONTROL_CONFIG_HISTORY.uiState();
                    }
                };

            createRsSingleGrid(colConfigHistoryNames, colConfigHistoryModel, grid, optparams);

            var $grid = $(grid);

            $grid.setGridParam({
                data: history_entries
            }).trigger("reloadGrid");

            $grid.click(function () {
                CONTROL_CONFIG_HISTORY.uiState();
            });
        },

        getConfigHistoryData: function () {
            clearTimeout(CONTROL_CONFIG_HISTORY.tid);
            CONTROL_CONFIG_HISTORY.toggleSpinner(true);
            var url = 'get_config_history?sn=' + CONTROL_CONFIG_HISTORY.urlSn;
            $.ajax({
                url: url,
                method: 'GET',
                dataType: 'json',
                success: function (data) {
                    if (data.status) {
                        CONTROL_CONFIG_HISTORY.receivedConfigHistoryData(data);
                    } else {
                        //Error                      
                        $('#msg_container').show()
                                           .attr('class', 'alert alert-error')
                                           .text(data.message);
                    }
                },
                complete: function () {
                    CONTROL_CONFIG_HISTORY.toggleSpinner(false);
                    CONTROL_CONFIG_HISTORY.tid = setTimeout(CONTROL_CONFIG_HISTORY.refreshGrid, CONTROL_CONFIG_HISTORY.updateTimeout);
                    CONTROL_CONFIG_HISTORY.doResize();
                }
            });
        },

        /* Show the received config history data in the history table 
         */
        receivedConfigHistoryData: function (data) {
            CONTROL_CONFIG_HISTORY.config_history = data.config_history;
            CONTROL_CONFIG_HISTORY.loadGridConfigurationHistory();
        },

        revertConfigDialog: function (rowid) {
            WGRD.doModal('#config_revert_modal',
                    CONTROL_CONFIG_HISTORY.initRevertModal,
                    CONTROL_CONFIG_HISTORY.doDeviceConfigRevert,
                    rowid);
        },

        diffConfigDialog: function (rowid) {
            WGRD.doModal('#config_diff_modal',
                    CONTROL_CONFIG_HISTORY.initDiffModal,
                    CONTROL_CONFIG_HISTORY.doDeviceConfigDiff,
                    rowid);
        },

        diffReportDialog: function (diff_data) {
            WGRD.doModal('#config_diff_report_modal', function () {
                if (diff_data.status) {
                    $('#config_diff_modal_error').hide();

                    var diff_report = diff_data.diff_report;
                    $('#diff_report_text').text(diff_report);
                } else {
                    $('#config_diff_modal_error').show();
                    $('#config_diff_modal_error').text(S_DIFF_CONFIG_ERROR_MSG);
                }
                return true;
            }, function () {
                return;
            }
                );
        },

        initRevertModal: function (rowid) {
            var $grid = $('#grid_config_history');
            $('#config_revert_modal_error').hide();
            $('#revert_comment_div').hide(); //Hide comment support for now
            var rowVal = $grid.jqGrid('getRowData', rowid);

            $('#revert_comment_text').attr('placeholder', S_DEFAULT_REVERT_COMMENT.format(rowVal.revision));
            $('#revert_info_text').text(S_REVERT_INFO_TEXT.format(rowVal.revision));
            return true;
        },

        doDeviceConfigRevert: function (rowid) {
            var $grid = $('#grid_config_history');
            var rowVal = $grid.jqGrid('getRowData', rowid);
            clearTimeout(CONTROL_CONFIG_HISTORY.tid);
            CONTROL_CONFIG_HISTORY.toggleSpinner(true);
            var sn = CONTROL_CONFIG_HISTORY.urlSn;
            var url = 'revert_config_revision?sn=' + sn + '&revision=' + parseInt(rowVal.revision, 10);

            if (member_sn) {
                url += '&msn=' + member_sn;
            }

            $.ajax({
                url: url,
                method: 'POST',
                dataType: 'json',
                success: function (data) {
                    if (data) {
                        if (data.status) {
                            $('#msg_container').show()
                                               .text(S_REVERT_CONFIG_SUCCESS_MSG)
                                               .attr('class', 'alert alert-success')
                                               .delay(2500)
                                               .fadeOut();
                        } else {
                            //Error
                            $('#msg_container').show()
                                               .attr('class', 'alert alert-error')
                                               .text(S_REVERT_CONFIG_ERROR_MSG.format(data.message));
                        }
                    }
                },
                complete: function () {
                    CONTROL_CONFIG_HISTORY.toggleSpinner(false);
                    CONTROL_CONFIG_HISTORY.tid = setTimeout(CONTROL_CONFIG_HISTORY.refreshGrid, 2800); //Wait before refresh so the new revision may be available
                    CONTROL_CONFIG_HISTORY.doResize();
                }
            });

            return;
        },

        initDiffModal: function (rowid) {
            var $grid = $('#grid_config_history');
            var config_history = CONTROL_CONFIG_HISTORY.getSortedConfigHistory();
            var entries = config_history.length;
            $('#config_diff_modal_error').hide();
            var selRowVal = rowid ? $grid.jqGrid('getRowData', rowid) : null;
            var i, revision;

            //Populate the revision listing
            $('#compare_revision')[0].options.length = 0; // clear the existing options first
            for (i = entries - 1; i >= 0; --i) {
                revision = config_history[i].config_revision;
                if (revision === parseInt(selRowVal.revision, 10)) { //Skip the selected revision in the listing to compare against
                    continue;
                }
                $('#compare_revision').append($("<option>").attr('value', revision).text(revision));
            }

            if (parseInt(selRowVal.revision, 10) === config_history[0].config_revision) {//first revision/last row
                $('#chosen_revision').prop('checked', true);
                WGRD.enableUIElements(false, ['#previous_revision']); //disable previous revision option
                WGRD.enableUIElements(true, ['#cbx_revision_group']);
            } else {
                //by default let the selection be on previous revision
                $('#previous_revision').prop('checked', true);
                WGRD.enableUIElements(true, ['#previous_revision']);
                WGRD.enableUIElements(false, ['#cbx_revision_group']);
            }

            $('#diff_against_previous_rev').text(S_DIFF_AGAINST_PREVIOUS_REV_TEXT.format(selRowVal.revision));
            $('#diff_against_specific_rev').text(S_DIFF_AGAINST_SPECIFIC_REV_TEXT.format(selRowVal.revision));

            return true;
        },

        doDeviceConfigDiff: function (rowid) {
            var $grid = $('#grid_config_history');
            var rids = $grid.getDataIDs();
            var newer_revision, older_revision;

            if (rids.length === 0) {
                return;
            }

            var selRowVal = $grid.jqGrid('getRowData', rowid); //Selected row
            var previousRowVal = $grid.jqGrid('getRowData', (parseInt(rowid, 10) + 1).toString()); //previous revision/next row

            var diff_against = parseInt(getRadioVal('radio_diff_revision'), 10);
            var diff_revision;

            if (diff_against === 1) {
                //Second Last revision; second row
                diff_revision = parseInt(previousRowVal.revision, 10);
            } else {
                diff_revision = parseInt($('#compare_revision').val(), 10);
            }

            newer_revision = Math.max(diff_revision, parseInt(selRowVal.revision, 10));
            older_revision = Math.min(diff_revision, parseInt(selRowVal.revision, 10));

            CONTROL_CONFIG_HISTORY.getDeviceDiffReport(older_revision, newer_revision);
            return;
        },

        getDeviceDiffReport: function (older_revision, newer_revision) {
            var url = 'diff_config_revisions?sn=' + CONTROL_CONFIG_HISTORY.urlSn + '&revision0=' + older_revision + '&revision1=' + newer_revision;
            var report_prefix = S_DIFF_CONFIG_PREFIX_TEXT.format(newer_revision, older_revision);

            //Call the config_diff script and show the results.
            $.ajax({
                url: url,
                method: 'GET',
                dataType: 'json',
                success: function (data) {
                    if (data) {
                        data.diff_report = report_prefix + data.diff_report;
                        CONTROL_CONFIG_HISTORY.diffReportDialog(data);
                    } else {
                        //Error                      
                        $('#msg_container').show()
                                           .attr('class', 'alert alert-error')
                                           .text(S_DIFF_CONFIG_ERROR_MSG);
                    }
                },
                complete: function () {
                    CONTROL_CONFIG_HISTORY.toggleSpinner(false);
                    CONTROL_CONFIG_HISTORY.doResize();
                }
            });
        },

        initEditModal: function (rowData) {
            var $grid = $('#grid_config_history');
            var selRowVal = rowData;
            var preserved = selRowVal.preserved === 'true' ? true : false;
            var annotation = selRowVal.annotation;

            $('#preserve_config').prop('checked', preserved);
            $('#config_edit_text').val(annotation);
            $('#edit_preserve_text').text(S_EDIT_PRESERVE_TEXT.format(selRowVal.revision.replace("*", "")));
            $('#config_edit_modal_error').hide();
            return true;
        },

        doDeviceConfigEdit: function (rowData) {
            var $grid = $('#grid_config_history');
            var selRowVal = rowData;
            var annotation = $('#config_edit_text').val();
            var preserved = $('#preserve_config').is(':checked');
            var revision = selRowVal.revision.replace("*", "");
            var url = 'update_config_revision?sn=' + CONTROL_CONFIG_HISTORY.urlSn + '&revision=' + revision + '&preserved=' + preserved + '&annotation=' + encodeURIComponent(escapeHtml(annotation));

            if (!CONTROL_CONFIG_HISTORY.doMinMaxLenCheck('#config_edit_text', 0, 128, "test message")) {
                $('#config_edit_modal_error').show();
                return S_EDIT_ANNOTATION_LEN_ERR_MSG;
            }

            $.ajax({
                url: url,
                method: 'POST',
                async: false,
                success: function (data) {
                    if (data) {
                        if (!data.status) {
                            WGRD.okMessageModal(S_EDIT_PRESERVE_ANNOTATION_ERR_MSG.format(data.err), '');
                        }
                    }
                },
                complete: function () {
                    CONTROL_CONFIG_HISTORY.refreshGrid();
                    CONTROL_CONFIG_HISTORY.doResize();
                }
            });
            return;
        },

        editConfigDialog: function (rowData) {
            WGRD.doModal('#config_edit_modal',
                    CONTROL_CONFIG_HISTORY.initEditModal,
                    CONTROL_CONFIG_HISTORY.doDeviceConfigEdit,
                    rowData);
        },

        exportConfig: function (rowid) {
            var $grid = $('#grid_config_history');
            var rowVal = $grid.jqGrid('getRowData', rowid);
            var url = 'export_config_file?sn=' + CONTROL_CONFIG_HISTORY.urlSn + '&revision=' + rowVal.revision.replace("*", "") + '&createtime=' + encodeURIComponent(rowVal.when);
            if (CONTROL_CONFIG_HISTORY.urlMsn) {
                url += '&msn=' + CONTROL_CONFIG_HISTORY.urlMsn;
            }
            WGRD.enableUIElements(false, ['#btn_export']);
            $('#progress_dlg').modal();
            $.ajax({
                url: url,
                dataType: 'json',
                success: function (response) {
                    if (response.status === 0) {
                        var file_args = '?sn=' + CONTROL_CONFIG_HISTORY.urlSn + '&tmp_file_name=' + response.tmp_file_name + '&file_name=' + response.file_name;
                        window.location = '/system/get_tmp_file' + file_args;
                    } else {
                        if (response.message) {
                            WGRD.okMessageModal(response.message, "");
                        }
                    }
                },
                complete: function () {
                    $('#progress_dlg').modal('hide');
                }
            });
        },

        getSortedConfigHistory: function () {
            var config_history = CONTROL_CONFIG_HISTORY.config_history;
            if (config_history === null) {
                return null;
            }
            config_history.sort(function (a, b) {
                return (a.config_revision > b.config_revision) ? 1 : ((b.config_revision > a.config_revision) ? -1 : 0);
            });
            return config_history;
        },

        toggleSpinner: function (b) {
            WGRD.showUIElements(b, ["#detail_loading_spinner"]);
        },

        doResize: function () {
            $(".frontpanelUnitGrid").width(0);
            var fp_div_width = $(".frontpanelUnitGrid").parent().width();
            $(".frontpanelUnitGrid").width(fp_div_width);
            $(".resizableGrid").setGridWidth(fp_div_width - 1);
            CONTROL_CONFIG_HISTORY.resizeGrids();
        },

        resizeGrids: function () {
            $('#grid_config_history').setGridWidth(100, true);
            $('#grid_config_history').setGridWidth($('#div_config_history_cont').width(), true);
        },

        doMinMaxLenCheck: function (elem, min_len, max_len, msg) {
            if ($(elem).val().length < min_len ||
                    $(elem).val().length > max_len) {
                return false;
            }
            return true;
        }
    };
$(document).ready(CONTROL_CONFIG_HISTORY.init);
