/*global breadcrumb_title, D_GWC_AP_SUMMARY, D_GWC_MAX_BYTES, D_GWC_MAX_CLIENTS, D_GWC_HOURS, D_GWC_NUM_CLIENTS, D_GWC_BY_CLIENTS, D_GWC_BY_BYTES, D_GWC_ALL_AP, D_GWC_ALL_SSID, D_GWC_ALL_BAND, D_GWC_SSID_SUMMARY, D_GWC_BAND_SUMMARY, D_GWC_AP_TITLE, D_GWC_SSID_TITLE, D_GWC_BAND_TITLE, D_GWC_FORMAT_GB, D_GWC_FORMAT_MB, D_GWC_FORMAT_KB, D_GWC_FORMAT_BYTES, D_GWC_CLIENTS, D_GWC_BYTES, D_GWC_DATE, escapeHtml, checkLoginPageRedirect*/
var GWC_DASHBOARD = {
    gwc_stacked_data: '',
    filter_selector: [],
    filter_data: [],
    sb_chart: '',
    ssids: [],
    ap_names: [],
    bands: [],
    xaxis_minute_format: {format: '%I:%M', tickFunc: d3.time.minute, tickInterval: 30},
    xaxis_hour_format: {format: '%I %p', tickFunc: d3.time.hour},
    xaxis_day_format: {format: '%a %d', tickFunc: d3.time.day},
    xaxis_week_format: {format: '%b %d', tickFunc: d3.time.week},
    xaxis_month_format: {format: '%b %d', tickFunc: d3.time.month},
    xaxis_year_format: {format: '%Y', tickFunc: d3.time.year},
    axisAttrs: {xaxis_key: 'update_time',
                yaxis_key: 'clients',
                stack_by_key: 'key',
                xaxis: {format: '%I %p', tickFunc: d3.time.hour}
               },
    legendAttrs: {
        legend_title: '',
        legend_summary: []
    },
    axisLblTxts: {xAxisLblTxt: '', yAxisLblTxt: ''},
    byClientsBytes: 'clients',
    viewBandBy: ['wap_name', 'ssid', 'band'],
    color_palettesAP: ['#2BBED8', '#2382AB', '#00467F', '#9A4351', '#B73384',
                       '#F26824', '#F89829', '#937E32', '#4AAB53', '#44B494'],
    color_palettesSSID: ['#B73384', '#937E32', '#9A4351'],
    color_palettesBAND: ['#F89829', '#F26824'],
    colorMap: {},
    GWC_HEIGHT: 600,
    max_clients_all: {key: '', clients: 0, date: ''},
    max_bytes_all: {key: '', bytes: 0, date: ''},
    max_clients: {key: '', clients: 0, date: ''},
    max_bytes: {key: '', bytes: 0, date: ''},
    urlSn: '',
    curInterval: '',
    initialState: '',

    init: function () {
        WGRD.init();
        GWC_DASHBOARD.urlSn = $.getUrlVar('sn');
        GWC_DASHBOARD.initEvents();
    },
    initEvents: function () {
        GWC_DASHBOARD.initGWCView();
        $("#custom_datepicker_trigger").bind('click', function () {
            // Indicates user already had chart, and now is changing the view for a diff time range
            if (GWC_DASHBOARD.initialState) {
                GWC_DASHBOARD.initialState = false;
            } else {
                GWC_DASHBOARD.doRefresh();
            }
        });
        $(document).on('click', '.gwc_data_filter', function (event) {
            var clicked_node = event.currentTarget.id;
            var index = GWC_DASHBOARD.filter_data.indexOf(clicked_node);
            if (index !== -1) {
                GWC_DASHBOARD.filter_selector.splice(index + 1);
                GWC_DASHBOARD.filter_data.splice(index + 1);
                GWC_DASHBOARD.updateBCLink();
            }
        });
        $(document).on('click', '.root_breadcrumb', function (eo) {
            GWC_DASHBOARD.doRefresh();
        });

        $("#btn_gwc_refresh").click(function (eo) {
            GWC_DASHBOARD.doRefresh();
        });

        $(".sort_select").click(function (eo) {
            var selector = this.id;
            var name = $("#" + selector).html();
            $("#btn_combo_sort").html(name + '  <span class="caret"></span>');
            GWC_DASHBOARD.byClientsBytes = selector;
            GWC_DASHBOARD.handleClientByteChange(selector);
            return;
        });

        $('.gwc_view_select').on('click', GWC_DASHBOARD.gwcViewChangeHandler);

        $(window).bind('resizeEnd', function () {
            if (GWC_DASHBOARD.sb_chart) {
                GWC_DASHBOARD.sb_chart
                                 .width($('#gwc_chart').width())
                             .resize();
            }
        });
    },
    initAxisFormat: function (interval) {
        switch (interval) {
        case 'min':
            GWC_DASHBOARD.axisAttrs.xaxis = GWC_DASHBOARD.xaxis_minute_format;
            break;
        case 'hr':
            GWC_DASHBOARD.axisAttrs.xaxis = GWC_DASHBOARD.xaxis_hour_format;
            break;
        case 'day':
            GWC_DASHBOARD.axisAttrs.xaxis = GWC_DASHBOARD.xaxis_day_format;
            break;
        case 'week':
            GWC_DASHBOARD.axisAttrs.xaxis = GWC_DASHBOARD.xaxis_week_format;
            break;
        case 'month':
            GWC_DASHBOARD.axisAttrs.xaxis = GWC_DASHBOARD.xaxis_month_format;
            break;
        }
    },
    getCurView: function () {
        var selected_view = $('#btn_combo_gwc_view').text().trim();
        var selector = 'wap_name';
        if (selected_view === D_GWC_ALL_SSID) {
            selector = 'ssid';
        } else if (selected_view === D_GWC_ALL_BAND) {
            selector = 'band';
        }
        return selector;
    },
    doRefresh: function () {
        var selector = GWC_DASHBOARD.getCurView();
        GWC_DASHBOARD.gwcViewChange(selector);
    },
    initGWCView: function () {
        // Clean up 
        d3.select("svg").remove();
        $('#btn_combo_sort').text(D_GWC_BY_CLIENTS)
                               .append(' <span class="caret"></span>');
        $('#btn_combo_gwc_view').text(D_GWC_ALL_AP)
                               .append(' <span class="caret"></span>');
        GWC_DASHBOARD.toggleSpinner(true);
        GWC_DASHBOARD.getData();
        GWC_DASHBOARD.initialState = true;
    },
    toggleSpinner: function (b) {
        WGRD.enableUIElements(!b, ['#btn_gwc_refresh',
                                   '#btn_combo_sort',
                                   '#btn_combo_gwc_view'
                                  ]);
        $("#gwc_popup").hide();
        if (b) {
            $('#gwc_loading_spinner').show();
        } else {
            $('#gwc_loading_spinner').hide();
        }
    },
    getData: function () {
        GWC_DASHBOARD.filter_selector = [];
        GWC_DASHBOARD.filter_data = [];
        GWC_DASHBOARD.toggleSpinner(true);
        var url = 'get_gwc_data?sn=' + GWC_DASHBOARD.urlSn + "&client_tz=" + WGRD.client_tz;

        url += '&gwc_view=wap_name';

        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                GWC_DASHBOARD.toggleSpinner(false);
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                GWC_DASHBOARD.toggleSpinner(false);
                if (!data.data.length) {
                    return;
                }
                GWC_DASHBOARD.ap_data = data.data;
                GWC_DASHBOARD.curInterval = data.interval;
                GWC_DASHBOARD.initAxisFormat(data.interval);
                GWC_DASHBOARD.parseData();
                GWC_DASHBOARD.initGWCChart();
            }
        });
    },
    callBackPopUpFunc: function (filter_by, filter_obj) {
        var title = '';
        var resources = '<table>';
        if (filter_by === GWC_DASHBOARD.viewBandBy[0]) { // name ie AP
            title = D_GWC_AP_TITLE + escapeHtml(filter_obj[filter_by]);
        } else if (filter_by === GWC_DASHBOARD.viewBandBy[1]) { // by ssid
            title = D_GWC_SSID_TITLE + escapeHtml(filter_obj[filter_by]);
        } else if (filter_by === GWC_DASHBOARD.viewBandBy[2]) { // by band
            title = D_GWC_BAND_TITLE + escapeHtml(filter_obj[filter_by]);
        }
        resources += '<tr><td>' + D_GWC_DATE + ' </td><td>' + filter_obj.update_time + '</td></tr>';
        if (filter_obj.bytes > 0) {
            resources += '<tr><td>' + D_GWC_BYTES + '</td><td>' + $.formatBytes(filter_obj.bytes, D_GWC_FORMAT_GB, D_GWC_FORMAT_MB, D_GWC_FORMAT_KB, D_GWC_FORMAT_BYTES) + '</td></tr>';
        }
        resources += '<tr><td>' + D_GWC_CLIENTS + ' </td><td>' + filter_obj.clients + '</td></tr>';
        resources += '</table>';
        $("#gwc_popup_title").html(title);
        $("#gwc_popup_resources").html(resources);
    },
    callBackFunc: function (filter_by, filter_val) {
        if (GWC_DASHBOARD.filter_data.length > 0) {
            var last_data = GWC_DASHBOARD.filter_data[GWC_DASHBOARD.filter_data.length - 1];
            if (filter_val === last_data) {
                return;
            }
            GWC_DASHBOARD.filter_selector.push(filter_by);
            GWC_DASHBOARD.filter_data.push(filter_val);
        } else {
            GWC_DASHBOARD.filter_selector.push(filter_by);
            GWC_DASHBOARD.filter_data.push(filter_val);
        }
        GWC_DASHBOARD.updateBCLink();
    },
    updateBCLink: function () {
        $("#breadcrumb_lhs").html('');
        $("#breadcrumb_lhs").html('<span id="" class="root_breadcrumb"><a href="#">' + breadcrumb_title + '</a></span>');
        $.each(GWC_DASHBOARD.filter_data, function (index) {
            if ((index + 1) === GWC_DASHBOARD.filter_data.length) {
                $("#breadcrumb_lhs").append('<span id="data_filter_divider" class="divider">/</span><span id="' + this + '">' +
                    this + '</span>');
            } else {
                $("#breadcrumb_lhs").append('<span id="data_filter_divider" class="divider">/</span><span id="' + this + '" class="gwc_data_filter">' +
                    '<a href="#">' + this + '</a></span>');
            }
        });
        GWC_DASHBOARD._get_filtered_data();
    },
    _get_filtered_data: function () {
        GWC_DASHBOARD.toggleSpinner(true);
        var selector = GWC_DASHBOARD.filter_selector;
        var fil_data = GWC_DASHBOARD.filter_data;
        var selected_view = $('#btn_combo_gwc_view').text().trim();

        var sel = selector[selector.length - 1];
        var fil_d = fil_data[fil_data.length - 1];

        var url = 'get_gwc_data?sn=' + GWC_DASHBOARD.urlSn + "&client_tz=" + WGRD.client_tz;

        if ((selected_view === D_GWC_ALL_SSID && sel === 'ssid') ||
                (selected_view === D_GWC_ALL_BAND && sel === 'band')) {
            url += '&gwc_view=wap_name';
        } else if ((selected_view === D_GWC_ALL_AP && sel === 'wap_name') ||
                   (selected_view === D_GWC_ALL_BAND && sel === 'wap_name')) {
            url += '&gwc_view=ssid';
        }
        url += '&filtercol=' + selector;
        url += '&filterdata=' + encodeURIComponent(fil_data.join(','));

        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                GWC_DASHBOARD.toggleSpinner(false);
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                GWC_DASHBOARD.toggleSpinner(false);
                if (!data.data.length) {
                    return;
                }
                GWC_DASHBOARD.ap_data = data.data;

                GWC_DASHBOARD._initFilters();
                GWC_DASHBOARD.initAxisFormat(data.interval);
                if (selected_view === D_GWC_ALL_AP) {
                    if (sel === 'wap_name') {
                        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[1], GWC_DASHBOARD.ssids);
                        GWC_DASHBOARD.handleSSIDChange(fil_d, 1);
                    } else if (sel === 'ssid') {
                        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[2], GWC_DASHBOARD.bands);
                        GWC_DASHBOARD.handleBandChange(fil_d, 2);
                    } else if (sel === 'band') {
                        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[2], GWC_DASHBOARD.bands);
                        GWC_DASHBOARD.handleBandChange(fil_d, 2);
                    }
                } else if (selected_view === D_GWC_ALL_SSID) {
                    if (sel === 'ssid') {
                        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[0], GWC_DASHBOARD.ap_names);
                        GWC_DASHBOARD.handleAPChange(fil_d, 0);
                    } else if (sel === 'wap_name') {
                        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[2], GWC_DASHBOARD.bands);
                        GWC_DASHBOARD.handleBandChange(fil_d, 2);
                    } else if (sel === 'band') {
                        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[2], GWC_DASHBOARD.bands);
                        GWC_DASHBOARD.handleBandChange(fil_d, 2);
                    }
                } else if (selected_view === D_GWC_ALL_BAND) {
                    if (sel === 'band') {
                        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[0], GWC_DASHBOARD.ap_names);
                        GWC_DASHBOARD.handleAPChange(fil_d, 0);
                    } else if (sel === 'wap_name') {
                        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[1], GWC_DASHBOARD.ssids);
                        GWC_DASHBOARD.handleSSIDChange(fil_d, 1);
                    } else if (sel === 'ssid') {
                        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[1], GWC_DASHBOARD.ssids);
                        GWC_DASHBOARD.handleSSIDChange(fil_d, 1);
                    }
                }
            }
        });
    },
    parseData: function () {
        GWC_DASHBOARD.initGWCObjs();
        GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[0], GWC_DASHBOARD.ap_names);
        GWC_DASHBOARD.legendAttrs.legend_title = D_GWC_AP_SUMMARY;
        GWC_DASHBOARD.legendAttrs.legend_summary = GWC_DASHBOARD.getLegendSummary(GWC_DASHBOARD.ap_data.length);
        GWC_DASHBOARD.axisLblTxts.xAxisLblTxt = "";
        GWC_DASHBOARD.axisLblTxts.yAxisLblTxt = D_GWC_NUM_CLIENTS;
    },
    initGWCObjs: function () {
        GWC_DASHBOARD._initFilters();
        GWC_DASHBOARD.maxClientsBytes(GWC_DASHBOARD.ap_data, 'all');
    },
    _initFilters: function () {
        var i = 0, j = 0, k = 0;
        GWC_DASHBOARD.ap_names = [];
        GWC_DASHBOARD.ssids = [];
        GWC_DASHBOARD.bands = [];
        GWC_DASHBOARD.ap_data.forEach(function (d) {
            if (GWC_DASHBOARD.ap_names.indexOf(d.wap_name) === -1) {
                GWC_DASHBOARD.colorMap[d.wap_name] = GWC_DASHBOARD.color_palettesAP[i];
                GWC_DASHBOARD.ap_names.push(d.wap_name);
                i++;
            }
            if (GWC_DASHBOARD.ssids.indexOf(d.ssid) === -1) {
                GWC_DASHBOARD.colorMap[d.ssid] = GWC_DASHBOARD.color_palettesSSID[j];
                GWC_DASHBOARD.ssids.push(d.ssid);
                j++;
            }
            if (GWC_DASHBOARD.bands.indexOf(d.band) === -1) {
                GWC_DASHBOARD.colorMap[d.band] = GWC_DASHBOARD.color_palettesBAND[k];
                GWC_DASHBOARD.bands.push(d.band);
                k++;
            }
            d.clients = parseInt(d.clients, 10);
            d.bytes = parseFloat(d.bytes, 10);
        });
        GWC_DASHBOARD.ap_names.sort();
        GWC_DASHBOARD.ssids.sort();
        GWC_DASHBOARD.bands.sort();
    },
    dateFormat: function () {
        var format = d3.time.format("%Y-%m-%d %H:%M:%S");
        return format;
    },
    formatBytes: function (d) {
        var b = $.formatBytes(d, D_GWC_FORMAT_GB, D_GWC_FORMAT_MB, D_GWC_FORMAT_KB, D_GWC_FORMAT_BYTES);
        return b;
    },
    getActiveKey: function () {
        var selector = GWC_DASHBOARD.filter_selector;
        var selected_view = $('#btn_combo_gwc_view').text().trim();
        var sel = selector[selector.length - 1];
        var activeKey = 'wap_name';

        if (sel) {
            activeKey = sel;
        } else if (selected_view === D_GWC_ALL_AP) {
            activeKey = 'wap_name';
        } else if (selected_view === D_GWC_ALL_SSID) {
            activeKey = 'ssid';
        } else if (selected_view === D_GWC_ALL_BAND) {
            activeKey = 'band';
        }
        return activeKey;
    },
    maxClientsBytes: function (data, max_for) {
        var obj = {};
        var max_clients = 0,
            max_bytes = 0,
            dList = [];
        var activeKey = GWC_DASHBOARD.getActiveKey();

        $.each(data, function () {
            if (dList.indexOf(this.update_time) === -1) {
                dList.push(this.update_time);
                obj[this.update_time] = {'ckey': this[activeKey], 'bkey': this[activeKey], 'clients': parseInt(this.clients, 10), 'bytes': parseFloat(this.bytes, 10)};
            } else {
                var c = parseInt(obj[this.update_time].clients, 10);
                var b = parseFloat(obj[this.update_time].bytes, 10);
                if (c < parseInt(this.clients, 10)) {
                    c = parseInt(this.clients, 10);
                    obj[this.update_time].clients = c;
                    obj[this.update_time].ckey = this[activeKey];
                }
                if (b < parseFloat(this.bytes, 10)) {
                    b = parseFloat(this.bytes, 10);
                    obj[this.update_time].bytes = b;
                    obj[this.update_time].bkey = this[activeKey];
                }
            }
        });

        $.each(obj, function (k, v) {
            var clients = v.clients;
            var bytes = v.bytes;
            if (clients >= max_clients) {
                max_clients = clients;
            }
            if (bytes > max_bytes) {
                max_bytes = bytes;
            }
        });
        var obj_arr = d3.entries(obj);
        var obj_clients_filter = obj_arr.filter(function (d) {
            if (d.value.clients === max_clients) {
                return true;
            }
        });
        var obj_bytes_filter = obj_arr.filter(function (d) {
            if (d.value.bytes === max_bytes) {
                return true;
            }
        });

        var format = GWC_DASHBOARD.dateFormat();
        var formattedDate = d3.time.format("%a, %b %d, %I %p, %Y"); //Eg: Mon, Aug 10, 2015
        if (max_for === 'all') {
            GWC_DASHBOARD.max_clients_all.clients = max_clients;
            GWC_DASHBOARD.max_clients_all.date = '';
            if (obj_clients_filter) {
                GWC_DASHBOARD.max_clients_all.key = obj_clients_filter[0].value.ckey;
                GWC_DASHBOARD.max_clients_all.date = formattedDate(format.parse(obj_clients_filter[0].key));
            }

            GWC_DASHBOARD.max_bytes_all.bytes = max_bytes;
            GWC_DASHBOARD.max_bytes_all.date = '';
            if (obj_bytes_filter) {
                GWC_DASHBOARD.max_bytes_all.key = obj_bytes_filter[0].value.bkey;
                GWC_DASHBOARD.max_bytes_all.date = formattedDate(format.parse(obj_bytes_filter[0].key));
            }
        } else {
            GWC_DASHBOARD.max_clients.clients = max_clients;
            GWC_DASHBOARD.max_clients.date = '';
            if (obj_clients_filter) {
                GWC_DASHBOARD.max_clients.key = obj_clients_filter[0].value.ckey;
                GWC_DASHBOARD.max_clients.date = formattedDate(format.parse(obj_clients_filter[0].key));
            }

            GWC_DASHBOARD.max_bytes.bytes = max_bytes;
            GWC_DASHBOARD.max_bytes.date = '';
            if (obj_bytes_filter) {
                GWC_DASHBOARD.max_bytes.key = obj_bytes_filter[0].value.bkey;
                GWC_DASHBOARD.max_bytes.date = formattedDate(format.parse(obj_bytes_filter[0].key));
            }
        }
    },
    gwcViewChangeHandler: function () {
        var selector = this.id;
        var name = $("#" + selector).html();
        $("#btn_combo_gwc_view").html(name + '  <span class="caret"></span>');
        GWC_DASHBOARD.gwcViewChange(selector);
    },
    gwcViewChange: function (selector) {
        $("#breadcrumb_lhs").html('<span class="">' + breadcrumb_title + '</span>');
        GWC_DASHBOARD.filter_selector = [];
        GWC_DASHBOARD.filter_data = [];
        GWC_DASHBOARD.toggleSpinner(true);
        var url = 'get_gwc_data?sn=' + GWC_DASHBOARD.urlSn + "&client_tz=" + WGRD.client_tz;

        url += '&gwc_view=' + selector;

        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                GWC_DASHBOARD.toggleSpinner(false);
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                GWC_DASHBOARD.toggleSpinner(false);
                if (!data.data.length) {
                    return;
                }
                GWC_DASHBOARD.ap_data = data.data;
                GWC_DASHBOARD.initAxisFormat(data.interval);
                GWC_DASHBOARD.initGWCObjs();
                if (data.interval !== GWC_DASHBOARD.curInterva) {
                    GWC_DASHBOARD.sb_chart
                                 .axisAttrs(GWC_DASHBOARD.axisAttrs)
                                 .refreshScales(true);
                }
                if (selector === 'wap_name') {
                    GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[0], GWC_DASHBOARD.ap_names);
                    GWC_DASHBOARD.handleAPChange();
                } else if (selector === 'ssid') {
                    GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[1], GWC_DASHBOARD.ssids);
                    GWC_DASHBOARD.handleSSIDChange();
                } else if (selector === 'band') {
                    GWC_DASHBOARD.gwc_stacked_data = GWC_DASHBOARD.getStackedData(GWC_DASHBOARD.viewBandBy[2], GWC_DASHBOARD.bands);
                    GWC_DASHBOARD.handleBandChange();
                }
            }
        });
    },
    sortByKey: function (a, b) {
        return a.key > b.key ? 1 : -1;
    },
    initGWCChart: function () {
        GWC_DASHBOARD.sb_chart = d3.wgchart.sb();
        GWC_DASHBOARD.gwc_stacked_data.sort(GWC_DASHBOARD.sortByKey);
        GWC_DASHBOARD.sb_chart.data(GWC_DASHBOARD.gwc_stacked_data)
                              .width($('#gwc_chart').width())
                              .height(GWC_DASHBOARD.GWC_HEIGHT)
                              .viewBandBy(GWC_DASHBOARD.viewBandBy[0])
                              .axisAttrs(GWC_DASHBOARD.axisAttrs)
                              .axisLabels(GWC_DASHBOARD.axisLblTxts)
                              .legendAttrs(GWC_DASHBOARD.legendAttrs)
                              .barColors(GWC_DASHBOARD.colorMap)
                              .callBackHandler(GWC_DASHBOARD.callBackFunc)
                              .callBackPopUpHandler(GWC_DASHBOARD.callBackPopUpFunc);
        GWC_DASHBOARD.sb_chart('#gwc_chart');
    },
    getStackedData: function (stack_by, filter_list) {
        var formatted_data = GWC_DASHBOARD.assignDefaultValues(GWC_DASHBOARD.ap_data, filter_list, stack_by);
        var nested_data = d3.nest()
                            .key(function (d) {return d[stack_by]; })
                            .entries(formatted_data);
        return nested_data;
    },
    sortByDate: function (a, b) {
        return a.update_time > b.update_time ? 1 : -1;
    },
    assignDefaultValues: function (dataset, filter_list, stack_by) {
        var defaultValue = 0;
        var keys = filter_list;
        var i;
        var hadData = [];
        for (i = 0; i < filter_list.length; i++) {
            hadData.push(true);
        }

        var newData = [];
        var previousdate = new Date();
        var def_name, def_band, def_ssid = "";

        dataset.sort(GWC_DASHBOARD.sortByDate);
        dataset.forEach(function (row) {
            if (row.update_time.valueOf() !== previousdate.valueOf()) {
                for (i = 0; i < keys.length; ++i) {
                    if (hadData[i] === false) {
                        if (stack_by === 'wap_name') {
                            def_name = keys[i];
                        } else if (stack_by === 'band') {
                            def_band = keys[i];
                        } else {
                            def_ssid = keys[i];
                        }
                        newData.push({ wap_name: def_name,
                                       clients: defaultValue,
                                       bytes: defaultValue,
                                       band: def_band,
                                       ssid: def_ssid,
                                       update_time: previousdate });
                    }
                    hadData[i] = false;
                }
                previousdate = row.update_time;
            }
            hadData[keys.indexOf(row[stack_by])] = true;
        });

        for (i = 0; i < keys.length; ++i) {
            if (hadData[i] === false) {
                if (stack_by === 'wap_name') {
                    def_name = keys[i];
                } else if (stack_by === 'band') {
                    def_band = keys[i];
                } else {
                    def_ssid = keys[i];
                }
                newData.push({wap_name: def_name, clients: defaultValue,
                                       bytes: defaultValue,
                                       band: def_band,
                                       ssid: def_ssid,
                                update_time: previousdate});
            }
        }
        return dataset.concat(newData).sort(GWC_DASHBOARD.sortByDate);
    },
    handleClientByteChange: function (by_client_byte) {
        if (!GWC_DASHBOARD.ap_data) {
            return;
        }

        GWC_DASHBOARD.toggleSpinner(true);
        var y_key = 'clients';
        var yLblTxt = D_GWC_NUM_CLIENTS;
        if (by_client_byte === 'bytes') {
            y_key = 'bytes';
            yLblTxt = "";
        }
        GWC_DASHBOARD.sb_chart
                     .axisAttrs({yaxis_key: y_key})
                     .axisLabels({yAxisLblTxt: yLblTxt})
                     .filterChart();

        GWC_DASHBOARD.toggleSpinner(false);
    },
    clientsOrBytes: function () {
        return GWC_DASHBOARD.byClientsBytes;
    },
    getLegendSummary: function (option) {
        var summary_text = [D_GWC_MAX_CLIENTS + GWC_DASHBOARD.max_clients.clients +  ' (' + GWC_DASHBOARD.max_clients.key + ') ' + GWC_DASHBOARD.max_clients.date,
                            D_GWC_MAX_BYTES + GWC_DASHBOARD.formatBytes(GWC_DASHBOARD.max_bytes.bytes) +  ' (' + GWC_DASHBOARD.max_bytes.key + ') ' + GWC_DASHBOARD.max_bytes.date
                           ];
        if (option > 1) {
            summary_text = [D_GWC_MAX_CLIENTS + GWC_DASHBOARD.max_clients_all.clients +  ' (' + GWC_DASHBOARD.max_clients_all.key + ') ' + GWC_DASHBOARD.max_clients_all.date,
                            D_GWC_MAX_BYTES + GWC_DASHBOARD.formatBytes(GWC_DASHBOARD.max_bytes_all.bytes) +  ' (' + GWC_DASHBOARD.max_bytes_all.key + ') ' + GWC_DASHBOARD.max_bytes_all.date
                           ];
        }
        return summary_text;
    },
    handleAPChange: function (option, view_by) {
        if (view_by === undefined) {
            view_by = 0;
        }
        GWC_DASHBOARD._handleViewChange(view_by, D_GWC_AP_SUMMARY);
    },
    handleSSIDChange: function (option, view_by) {
        if (view_by === undefined) {
            view_by = 1;
        }
        GWC_DASHBOARD._handleViewChange(view_by, D_GWC_SSID_SUMMARY);
    },
    handleBandChange: function (option, view_by) {
        if (view_by === undefined) {
            view_by = 2;
        }
        GWC_DASHBOARD._handleViewChange(view_by, D_GWC_BAND_SUMMARY);
    },
    _handleViewChange: function (view_band_by, title) {
        var filtered_data = GWC_DASHBOARD.gwc_stacked_data;
        var count = filtered_data.length;
        if (count === 1) {
            GWC_DASHBOARD.maxClientsBytes(filtered_data[0].values);
        } else {
            GWC_DASHBOARD.maxClientsBytes(GWC_DASHBOARD.ap_data, 'all');
        }
        if (GWC_DASHBOARD.filter_data.length !== 0) {
            GWC_DASHBOARD.legendAttrs.legend_title = title + ' (' + GWC_DASHBOARD.filter_data[GWC_DASHBOARD.filter_data.length - 1] + ')';
        } else {
            GWC_DASHBOARD.legendAttrs.legend_title = title;
        }
        GWC_DASHBOARD.legendAttrs.legend_summary = GWC_DASHBOARD.getLegendSummary(count);

        GWC_DASHBOARD.sb_chart
                     .data(filtered_data)
                     .legendAttrs(GWC_DASHBOARD.legendAttrs)
                     .viewBandBy(GWC_DASHBOARD.viewBandBy[view_band_by]);
        GWC_DASHBOARD.handleClientByteChange(GWC_DASHBOARD.clientsOrBytes());
    }
};
$(document).ready(GWC_DASHBOARD.init);
