/*global breadcrumb_title,escapeHtml,R_DATE_NAVBAR,D_CXN_DEVICE_NAME,D_CXNLIST_POPUP,D_CXN_FWATCH_WLOG,D_CXN_BYTES,D_CXN_CONNECTIONS,D_CXN_FILTER,D_CXN_VIEWCONNECTIONS,D_CXN_FORMAT_GB,D_CXN_FORMAT_MB,D_CXN_FORMAT_KB,D_CXN_FORMAT_BYTES,D_CXN_FILTERON,D_CXN_VIEWCONNECTIONS,D_CXN_FS_TOPAPP,D_CXN_FS_TOPSOURCE,D_CXN_FS_TOPDOMAINS,D_CXN_FS_TOPPROTOCOL,D_CXN_FS_TOPWEBBLOCKER,D_CXN_FS_TOPDESTINATION*/
var D_CXN = {
    fwatchd_capable: true,
    hideBytes: false,
    w: 600,
    h: 600,
    gVis: null,
    mousePopup: false, // is mouse over the popup?
    mouseX: 0,
    mouseY: 0,
    graph_type: 'bytes',
    view_type: 'view_all',
    data_popup_name: '',
    tid: null,
    tidFullscreen: null,
    tidFullscreenHideBtns: null,
    fullscreenTimeout: 10000,
    updateTimeout: 90000,
    urlSn: 'all',

    minutes: 30,
    fullscreen_timeranges: [30, 60, 360],
    fullscreen_selectors: ['source', 'destination', 'domains', 'app', 'webblocker', 'protocol'],
    fullscreen_current_selectors: ['source', 'destination', 'domains', 'app', 'webblocker', 'protocol'],

    data_selector: 'source',    // Grouping, e.g. 'source'
    data_filter_selector: '',   // Filter, e.g. 'destination'
    data_filter_data: '',       // Filter data, e.g. 'user@domain.com'

    treemap: null,
    treemapFill: null,
    treemapMainDiv: null,
    treemapLastNodes: null,

    zoomX: null, //d3.scale.linear().range([0, D_CXN.w]),
    zoomY: null, //d3.scale.linear().range([0, D_CXN.h]),

    urlID: '',

    init: function () {
        $.getUrlVars();
        D_CXN.urlID = $.getUrlVar('id');
        D_CXN.urlSn = $.getUrlVar('sn');
        D_CXN.initUI();
        D_CXN.initEvents();

        D_CXN.zoomX = d3.scale.linear().range([0, D_CXN.w]);
        D_CXN.zoomY = d3.scale.linear().range([0, D_CXN.h]);
    },
    initUI: function () {

        $("#connections_btn_refresh").button({ icons: { primary: "ui-icon-refresh" }, text: false, width: 16, height: 16 });

        D_CXN.toggleFilterOptions(false, "", "");

        $("#chart").hide();
        D_CXN.initTreemap();
        $("#combo_sort").val(0);
    },
    initEvents: function () {
        $("#connections_btn_refresh").click(function (e) {
            D_CXN.refresh();
        });

        $(document).on('click', '.root_breadcrumb', function (eo) {
            $("#breadcrumb_lhs").html('<span class="">' + breadcrumb_title + '</span>');
            $("#fullscreen_breadcrumb_lhs").html('<span class="">' + D_CXN_DEVICE_NAME + '</span>');

            /* Clear filter string */
            D_CXN.data_selector = D_CXN.data_filter_selector;
            D_CXN.toggleFilterOptions(false, D_CXN.data_filter_selector, D_CXN.data_filter_data);

            /* Refresh */
            if (D_CXN.data_selector === "pcy_name") {
                $("#tab_policy").click();
            } else {
                $("#tab_" + D_CXN.data_selector).click();
            }
        });

        $(".sort_select").click(function (eo) {
            var name = $("#" + this.id).html();
            $("#btn_sort_dropdown").html(name + '  <span class="caret"></span>');
            D_CXN.graph_type = this.id;
            D_CXN.drawGraphTreemapNewData(D_CXN.treemapLastNodes);

            return;
        });
        $("#popup_cxnlist_close").click(function (eo) {
            $("#popup_cxnlist").modal('hide');
        });

        $("#cxn_popup")
            .mouseenter(function () {
                D_CXN.mousePopup = true;
            })
            .mouseleave(function () {
                D_CXN.mousePopup = false;
            });

        // Close popup
        $(document).keyup(function (eo) {
            if (eo.keyCode === 27) {
                D_CXNLIST_POPUP.closePopup();
            } else if (eo.ctrlKey && eo.keyCode === 13) {
                WGRD.doFullScreen("#main_div_row");
            }
        });
        $("#popup_connections .close").click(function (eo) {
            D_CXNLIST_POPUP.closePopup();
        });

        $("#chart").mouseleave(function () {
            $("#cxn_popup").hide();
        });
        $("#main_div_row").mousemove(function (eo) {
            clearTimeout(D_CXN.tidFullscreenHideBtns);
            WGRD.showUIElements(true, ["#fullscreen_hidden_btns"]);
            $("#main_div_row").css("cursor", "default");
            if (WGRD.isFullScreen()) {
                D_CXN.tidFullscreenHideBtns = setTimeout(function () {
                    if (!$("#fullscreen_hidden_btns").is(":hover")) {
                        clearTimeout(D_CXN.tidFullscreenHideBtns);
                        WGRD.showUIElements(false, ["#fullscreen_hidden_btns"]);
                        $("#main_div_row").css("cursor", "none");
                    }
                }, 2000);
            }
        });
        $("#chart").mousemove(function (eo) {
            D_CXN.mouseX = eo.pageX;
            D_CXN.mouseY = eo.pageY;
        });

        $("#cxn_popup").mouseleave(function (eo) {
            $("#cxn_popup").hide();
        });

        $(".cxntab").click(function (eo) {
            $(".cxntab").removeClass("fg");
            $(".cxntab").addClass("bg");
            $(this).removeClass("bg");
            $(this).addClass("fg");

            if (this.id === 'tab_source') {
                D_CXN.data_selector = 'source';
            } else if (this.id === 'tab_domains') {
                D_CXN.data_selector = 'domains';
            } else if (this.id === 'tab_destination') {
                D_CXN.data_selector = 'destination';
            } else if (this.id === 'tab_app') {
                D_CXN.data_selector = 'app';
            } else if (this.id === 'tab_webblocker') {
                D_CXN.data_selector = 'webblocker';
            } else if (this.id === 'tab_policy') {
                D_CXN.data_selector = 'pcy_name';
                if (D_CXN.fwatchd_capable) {
                    D_CXN.data_selector = 'policy';
                }
            } else if (this.id === 'tab_port') {
                D_CXN.data_selector = 'dst_port';
            } else if (this.id === 'tab_protocol') {
                D_CXN.data_selector = 'protocol';
            } else if (this.id === 'tab_in_if') {
                D_CXN.data_selector = 'in_if';
            } else if (this.id === 'tab_out_if') {
                D_CXN.data_selector = 'out_if';
            }

            D_CXN.refresh();

        });

        $(document).on('click', '.popupFilterLink', function (eo) {
            D_CXN.treemapClick({ 'name': D_CXN.data_popup_name });
        });

        $(document).on('click', '.popupCxnsLink', function (eo) {
            D_CXN.doConnectionList();
        });

        /* Respond to resizeEnd event */
        $(window).bind('resizeEnd', function () {
            D_CXN.doResize();
        });

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            D_CXNLIST_POPUP.closePopup();
            D_CXN.getData();
            D_CXN.doResize();
        });

        WGRD.FullScreen_Register("#main_div_row", D_CXN.onEnterFullScreen_Pre, D_CXN.onEnterFullScreen_Post, D_CXN.onExitFullScreen, "#btn_fullscreen, #btn_fullscreen_close");
        $(".fullscreen_update_select").click(function (eo) {
            clearTimeout(D_CXN.tidFullscreen);
            var name = $("#" + this.id).html();
            $("#btn_fullscreen_update_dropdown").html(name + '  <span class="caret"></span>');
            switch (this.id) {
            case "fullscreen_update_5":
                D_CXN.fullscreenTimeout = 5000;
                break;
            case "fullscreen_update_10":
                D_CXN.fullscreenTimeout = 10000;
                break;
            case "fullscreen_update_15":
                D_CXN.fullscreenTimeout = 15000;
                break;
            case "fullscreen_update_30":
                D_CXN.fullscreenTimeout = 30000;
                break;
            case "fullscreen_update_60":
                D_CXN.fullscreenTimeout = 60000;
                break;
            }
            D_CXN.tidFullscreen = setTimeout(D_CXN.stepFullscreen, D_CXN.fullscreenTimeout);

            return;
        });
        $(".fullscreen_groups_select").click(function (eo) {
            clearTimeout(D_CXN.tidFullscreen);
            D_CXN.fullscreen_current_selectors = [];
            var i, selector;
            for (i = 0; i < D_CXN.fullscreen_selectors.length; i++) {
                selector = D_CXN.fullscreen_selectors[i];
                if ($("#fullscreen_groups_" + selector).is(":checked")) {
                    D_CXN.fullscreen_current_selectors.push(selector);
                }
            }

            D_CXN.tidFullscreen = setTimeout(D_CXN.stepFullscreen, D_CXN.fullscreenTimeout);

            return;
        });
    },
    toggleSpinner: function (b) {
        WGRD.enableUIElements(!b, ['#btn_sort_dropdown']);

        if (b) {
            $('.loading_spinner').remove();
            $('#filterbuttons').prepend('  <span class="loading_spinner pull-left"><img src="/images/loader.gif" /></span>');
            $("#topn_text").hide();

        } else {
            $('.loading_spinner').remove();
            $("#topn_text").show();

            if (D_CXN.hideBytes) {
                // No bandwidth data
                WGRD.enableUIElements(false, ['#btn_sort_dropdown']);
                var name = $("#connections").html();
                $("#btn_sort_dropdown").html(name + '  <span class="caret"></span>');
                D_CXN.graph_type = 'connections';
            } else {
                WGRD.enableUIElements(true, ['#btn_sort_dropdown']);
            }
        }
    },
    getData: function () {
        clearTimeout(D_CXN.tid);
        D_CXN.toggleSpinner(true);

        var minutes = null;
        if (WGRD.isFullScreen()) {
            minutes = D_CXN.minutes;
        }

        D_CXN_FWATCH_WLOG.getData(D_CXN.drawGraphTreemapNewData, D_CXN.data_selector,
            D_CXN.data_filter_selector, D_CXN.data_filter_data, 'ESTABLISHED', D_CXN.view_type, D_CXN.urlSn, minutes);

        D_CXN.tid = setTimeout(D_CXN.doRefresh, D_CXN.updateTimeout);
    },
    doResize: function () {
        var contentwidth = $("#main_div_row").width();
        var winheight = $(window).height();
        var pos = $("#chart").offset();
        D_CXN.h = winheight - pos.top - 10;
        if (D_CXN.h < 320) {
            D_CXN.h = 320;
        }

        if (!WGRD.isFullScreen()) {
            contentwidth -= $(".date_navbar_td").width();
        } else {
            contentwidth -= 7;
        }

        $("#chart").show();
        /* Treemap */
        D_CXN.w = contentwidth;
        if (D_CXN.treemap) {
            D_CXN.treemap
                .size([D_CXN.w, D_CXN.h]);

            if (D_CXN.treemapMainDiv) {
                D_CXN.treemapMainDiv
                    .style("width", D_CXN.w + "px")
                    .style("height", D_CXN.h + "px");
            }
            D_CXN.drawGraphTreemapNewData(D_CXN.treemapLastNodes);
        }

        /* Popup */
        D_CXNLIST_POPUP.doResize(D_CXN.data_selector, D_CXN.data_filter_selector, D_CXN.data_filter_data, D_CXN.w);
    },
    toggleFilterOptions: function (enable, filter_selector, filter_data) {
        if (enable) {
            if (D_CXN.data_filter_selector !== '') {
                $('#tab_' + D_CXN.data_filter_selector).show();
            }
            $('#tab_' + filter_selector).hide();
            D_CXN.data_filter_selector = filter_selector;
            D_CXN.data_filter_data = filter_data;

            $("#breadcrumb_lhs").html('');
            $("#breadcrumb_lhs").html('<span id="" class="root_breadcrumb"><a href="#">' + breadcrumb_title + '</a></span>');
            $("#breadcrumb_lhs").append('<span id="data_filter_divider" class="divider">/</span><span id="data_filter_data">' + escapeHtml(filter_data) + '</span>');
            $("#fullscreen_breadcrumb_lhs").html('');
            $("#fullscreen_breadcrumb_lhs").html('<span id="" class="root_breadcrumb"><a href="#">' + D_CXN_DEVICE_NAME + '</a></span>');
            $("#fullscreen_breadcrumb_lhs").append('<span id="" class="divider">&#8250;</span><span id="">' + escapeHtml(filter_data) + '</span>');
        } else {
            $('#tab_' + D_CXN.data_filter_selector).show();
            D_CXN.data_filter_selector = "";
            D_CXN.data_filter_data = "";
        }
    },
    doRefresh: function () {
        $("#cxn_popup").hide();
        D_CXN.refresh();
    },
    refresh: function () {
        $("#cxn_popup").hide();
        D_CXN.getData();

    },
    category4grn: function () {
        var idx = 0;
        if (D_CXN.data_selector === 'source') {
            idx = 2;
        } else if (D_CXN.data_selector === 'destination') {
            idx = 1;
        } else if (D_CXN.data_selector === 'domains') {
            idx = 0;
        } else if (D_CXN.data_selector === 'app') {
            idx = 9;
        } else if (D_CXN.data_selector === 'webblocker') {
            idx = 8;
        } else if (D_CXN.data_selector === 'in_if') {
            idx = 7;
        } else if (D_CXN.data_selector === 'protocol') {
            idx = 10;
        }
        var colors = $.get_hsl_colors(10);
        return d3.scale.ordinal().range(colors[idx]);
    },
    initTreemap: function () {
        var width = D_CXN.w,
            height = D_CXN.h;

        // Make sure everything is removed
        d3.select("#chart").select(".mychart").remove();
        D_CXN.treemapMainDiv = null;

        D_CXN.treemapFill = D_CXN.category4grn();
        D_CXN.treemap = d3.layout.treemap()
            .size([width, height])
            .sticky(false)
            .sort(function (a, b) {
                if (D_CXN.graph_type === 'connections') {
                    return a.connections - b.connections;
                }
                if (D_CXN.graph_type === 'bytes') {
                    return a.bytes - b.bytes;
                }
                if (D_CXN.graph_type === 'time') {
                    return a.duration - b.duration;
                }
                return null;
            })
            .round(true)
            .value(D_CXN.treemapValueCB);

        D_CXN.treemapMainDiv = d3.select("#chart").append("div")
            .attr("class", "mychart")
            .style("position", "relative")
            .style("width", width + "px")
            .style("height", height + "px")
            .style("background", function (d) { return "#555555"; });

    },
    drawGraphTreemapNewData: function (nodes_devices) {
        if (!nodes_devices || !nodes_devices.children || nodes_devices.children.length === 0) {
            D_CXN.toggleSpinner(false);
            return;
        }

        var total_bytes = 0;
        var node;
        for (node in nodes_devices.children) {
            if (nodes_devices.children.hasOwnProperty(node)) {
                total_bytes += parseInt(nodes_devices.children[node].bytes, 10);
            }
        }
        D_CXN.hideBytes = false;
        if (total_bytes === 0 || isNaN(total_bytes)) {
            D_CXN.hideBytes = true;
        }
        D_CXN.toggleSpinner(false);
        D_CXN.treemapFill = D_CXN.category4grn();
        var cell = D_CXN.treemapMainDiv.data([nodes_devices]).selectAll("div")
            .data(D_CXN.treemap.nodes, function (d) { return d.name; });

        var delay = 750;
        if (nodes_devices.children.length > 200) {
            delay = 1000;
        }
        if (nodes_devices.children.length > 400) {
            delay = 1250;
        }

        var start_x = "0px";
        var start_y = "0px";
        var end_x = D_CXN.w + "px";
        var end_y = D_CXN.h + "px";
        var start_w = null;
        var start_h = null;
        var bExitLeft = true;
        switch (D_CXN.data_selector) {
        case 'source':
            bExitLeft = false;
            start_h = "0px";
            //start_w = "0px";
            break;
        case 'destination':
        case 'domains':
            start_x = "0px";
            start_y = D_CXN.h + "px";
            end_y = "0px";
            start_h = "0px";
            bExitLeft = false;
            break;
        case 'protocol':
            start_w = "0px";
            break;
        case 'app':
        case 'webblocker':
            start_x = D_CXN.w + "px";
            end_x = "0px";
            start_w = "0px";
            break;
        case 'domains2':
            bExitLeft = false;
            start_h = "0px";
            break;
        }
        if (bExitLeft) {
            cell.exit().transition().duration(delay).ease("quad-out").style("left", end_x).style("width", "0px").remove();
        } else {
            cell.exit().transition().duration(delay).ease("quad-out").style("top", end_y).style("height", "0px").remove();
        }
        cell.enter().append("div")
            .attr("id", function (d) { return d.value; })
            .on("click", D_CXN.treemapOnMouseOver)
            .on("mouseover", D_CXN.treemapOnMouseOver)
            .attr("class", D_CXN.treemapClassCB)
            .style("left", function (d) { if (start_x) { return start_x; } return d.x + "px"; })
            .style("top", start_y)
            .style("width", function (d) { if (start_w) { return start_w; } return Math.max(0, d.dx - 1) + "px"; })
            .style("height", function (d) { if (start_h) { return start_h; } return Math.max(0, d.dy - 2) + "px"; })
            .style("background", function (d) { return D_CXN.treemapFill2(d); })
            .html(D_CXN.treemapHtmlCB);

        D_CXN.treemapMainDiv.selectAll("div")
            .data(D_CXN.treemap.value(D_CXN.treemapValueCB), function (d) { return d.name; })
              .style("background", function (d) { return D_CXN.treemapFill2(d); })
              .html(D_CXN.treemapHtmlCB)
              .transition()
                .duration(delay)
                .ease("quad-out")
                .attr("class", D_CXN.treemapClassCB)
              .call(D_CXN.treemapCellCB);

        $("#fullscreen_header_timerange").text(nodes_devices.time_s);
        $("#fullscreen_header_title").text(D_CXN.getTitle());
        D_CXN.treemapLastNodes = nodes_devices;
    },
    treemapFill2: function (d) {
        if (d.connections === undefined) {
            // Root item
            return "#555555";
        }
        return D_CXN.treemapFill(d.value);
    },
    treemapValueCB: function (d) {
        if (D_CXN.graph_type === 'connections') {
            return d.connections;
        }
        if (D_CXN.graph_type === 'bytes') {
            return d.bytes;
        }
        if (D_CXN.graph_type === 'time') {
            return d.duration;
        }
    },
    treemapTextCB: function (d) {
        if (d.dx < 20) {
            // Don't display any text for really small cells
            return '';
        }
        return d.name;
    },
    treemapClassCB: function (d) {
        if (d.dx < 60) {
            return "cell cell_device_smallest";
        }
        if (d.dx < 80) {
            return "cell cell_device_smaller";
        }
        if (d.dx < 120) {
            return "cell cell_device_small";
        }
        if (d.dx < 200) {
            return "cell cell_device";
        }
        if (d.dx < 400) {
            return "cell cell_device_bigger";
        }
        return "cell cell_device_biggest";
    },

    isHtmlVisible: function (d) {
        return (d.dx > 60);
    },
    treemapHtmlCB: function (d) {
        if (!d.name || !d.connections) {
            return;
        }

        var html = '<span><span style="padding-bottom: 2px;">' + escapeHtml(d.name) + '</span><br />';
        if (D_CXN.isHtmlVisible(d)) {
            html += '<span class="cell_device_info">';
            if (d.bytes > 0) {
                html += '<span style="margin-left: 5px;">' + D_CXN_BYTES + ' ' + $.formatBytes(d.bytes) + '</span><br />';
            }
            html += '<span style="margin-left: 5px;">' + D_CXN_CONNECTIONS + ' ' + d.connections + '</span><br />';
            html += '<a class="popupFilterLink" href="#" style="margin-left: 5px;">' + D_CXN_FILTER + '</a><br />';
            html += '<a class="popupCxnsLink" href="#" style="margin-left: 5px;">' + D_CXN_VIEWCONNECTIONS + '</a><br />';
            html += '</span>';
            html += '</span>';
        }
        return html;
    },
    treemapCellCB: function () {
        this
            .style("left", function (d) { return d.x + "px"; })
            .style("top", function (d) { return d.y + "px"; })
            .style("width", function (d) { return Math.max(0, d.dx - 1) + "px"; })
            .style("border-width", "1px")
            .style("height", function (d) { return Math.max(0, d.dy - 2) + "px"; });
    },
    treemapClick: function (d) {

        D_CXN.toggleFilterOptions(true, D_CXN.data_selector, d.name);

        if (D_CXN.data_selector === 'source') {
            D_CXN.data_selector = "domains";
            $("#tab_domains").click();
        } else {
            D_CXN.data_selector = "source";
            $("#tab_source").click();
        }
        // The .click() will call refresh(), no need to do anything further
    },
    doConnectionList: function () {
        D_CXN.toggleSpinner(true);
        $("#cxn_popup_spinner").show();
        $(".popupCxnsLink").hide();
        clearTimeout(D_CXN.tid);
        if (D_CXN.data_filter_selector !== '' && D_CXN.data_filter_data !== '') {
            D_CXN_FWATCH_WLOG.getConnectionList(D_CXN.doConnectionListSuccess, '0',
                                D_CXN.data_filter_selector, D_CXN.data_filter_data, D_CXN.data_filter_data,
                                D_CXN.data_selector, D_CXN.data_popup_name, D_CXN.data_popup_name, D_CXN.urlSn, '');
        } else {
            D_CXN_FWATCH_WLOG.getConnectionList(D_CXN.doConnectionListSuccess, '0',
                                D_CXN.data_selector, D_CXN.data_popup_name, D_CXN.data_popup_name, '', '', '', D_CXN.urlSn, '');
        }
    },
    doConnectionListSuccess: function (data, selector, selector_data, filter_selector, filter_data) {
        var series = data.items;
        D_CXNLIST_POPUP.fullScreenPopup(series, selector, selector_data, filter_selector, filter_data);

        var chartunique = {};
        var chartseries1 = [];
        var chartseries2 = [];
        var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();

        var startEndSecs = R_DATE_NAVBAR.getStartEndSeconds();
        var seriesLength = (startEndSecs[1] - startEndSecs[0]) / 60 / 60;
        // Normalize chart data
        var i, start_time, count, bytes;
        for (i = 0; i < series.length; i++) {
            start_time = series[i].start_time.substring(0, series[i].start_time.lastIndexOf(':'));
            start_time = start_time.substring(0, start_time.lastIndexOf(':'));

            count = parseInt(series[i].count, 10);
            bytes = parseInt(series[i].bytes, 10);
            start_time += ":00";
            if (chartunique[start_time]) {
                chartunique[start_time][0] += count;
                chartunique[start_time][1] += bytes;
            } else {
                chartunique[start_time] = [ count, bytes ];
            }
        }

        chartseries1.push([startEnd[0], 0, 0]);
        chartseries2.push([startEnd[0], 0, 0]);
        var item;
        for (item in chartunique) {
            if (chartunique.hasOwnProperty(item)) {
                chartseries1.push([item, chartunique[item][0]]);
                chartseries2.push([item, chartunique[item][1]]);
            }
        }
        chartseries1.push([startEnd[1], 0, 0]);
        chartseries2.push([startEnd[1], 0, 0]);

        $("#popup_connections_limit_warning").hide();
        if (series.length >= data.max_items) {
            $("#popup_connections_limit_warning").show();
        }

        D_CXNLIST_POPUP.updateChartData(seriesLength, chartseries1, chartseries2);

        D_CXN.doResize();
        D_CXN.toggleSpinner(false);
    },
    treemapOnMouseOver: function (d) {
        D_CXN.treemapOnMouseOverSummary(d);
        var dx = 350;
        var dy = 145;
        return D_CXN.treemapOnMouseOverPosition(d, dx, dy);
    },
    treemapOnMouseOverSummary: function (d) {
        if (d.connections === undefined) {
            return;
        }
        D_CXN.data_popup_name = d.name;
        $("#cxn_popup").show();

        $("#cxn_popup_title").html(escapeHtml(d.name))
                             .addClass('nowrap_ellipsis');

        var resources = '<table>';
        if (d.bytes > 0) {
            resources += '<tr><td>' + D_CXN_BYTES + '</td><td>' + $.formatBytes(d.bytes, D_CXN_FORMAT_GB, D_CXN_FORMAT_MB, D_CXN_FORMAT_KB, D_CXN_FORMAT_BYTES) + '</td></tr>';
        }
        resources += '<tr><td>' + D_CXN_CONNECTIONS + ' </td><td>' + d.connections + '</td></tr>';
        resources += '</table>';
        resources += '<div class="nowrap_ellipsis" style="padding-top:7px;">' + D_CXN_FILTERON + ' <a class="popupFilterLink" href="#">' + escapeHtml(d.name) + '</a></div>';
        resources += '<div class="nowrap_ellipsis" style="font-size:1.0em;">' + D_CXN_VIEWCONNECTIONS + ' <a class="popupCxnsLink" href="#">' + escapeHtml(d.name) + '</a>';
        resources += '<span id="cxn_popup_spinner" class="loading"><img width="14" height="14" src="/images/loader.gif" /></span>';
        resources += '</div>';
        $("#cxn_popup_resources").html(resources);
        $("#cxn_popup_spinner").hide();
    },
    treemapOnMouseOverPosition: function (d, dx, dy) {
        // Position overlay
        var pos = $("#chart").offset();
        var chart_width = $("#chart").width();
        var chart_height = $("#chart").height();

        $("#cxn_popup").removeClass("left right");
        var myleft = pos.left + d.dx;
        if (d.x - dx < 0) {
            if ((d.x + d.dx + dx > chart_width)
                    && (d.x + d.dx > chart_width / 2)) {
                myleft = pos.left + d.x + d.dx / 2;
                $("#cxn_popup").addClass("right");
            } else {
                myleft = pos.left + d.x + d.dx;
                $("#cxn_popup").addClass("right");
            }
        } else if (d.x + d.dx + dx < chart_width && d.x < 2 * (chart_width / 3)) {
            myleft = pos.left + d.x + d.dx;
            $("#cxn_popup").addClass("right");
        } else {
            myleft = pos.left + chart_width - (chart_width - d.x) - dx;
            $("#cxn_popup").addClass("left");
        }
        var mytop = pos.top + d.y + (d.dy / 2) - dy / 2;
        if (d.y + dy > chart_height) {
            $("#cxn_popup").removeClass("left right");
            mytop = pos.top + chart_height - dy;
        }

        $("#cxn_popup").offset({ top: mytop, left: myleft });
        $("#cxn_popup").width(dx);
        $("#cxn_popup").height(dy);
        // <-- Position overlay
    },
    getTitle: function () {
        var title = D_CXN_FS_TOPSOURCE;
        switch (D_CXN.data_selector) {
        case 'source':
            title = D_CXN_FS_TOPSOURCE;
            break;
        case 'destination':
            title = D_CXN_FS_TOPDESTINATION;
            break;
        case 'domains':
            title = D_CXN_FS_TOPDOMAINS;
            break;
        case 'app':
            title = D_CXN_FS_TOPAPP;
            break;
        case 'webblocker':
            title = D_CXN_FS_TOPWEBBLOCKER;
            break;
        case 'protocol':
            title = D_CXN_FS_TOPPROTOCOL;
            break;
        }
        if (D_CXN.graph_type === 'connections') {
            title = title[1];
        } else {
            title = title[0];
        }
        return title;
    },
    onEnterFullScreen_Pre: function () {
        // Hide everything before zoom
        WGRD.showUIElements(false, [".reports_toolbar", ".breadcrumb", "#cxntab_row", "#chart", "#fullscreen_header"]);
        WGRD.showUIElements(true, ["#fullscreen_header"]);
    },
    onEnterFullScreen_Post: function () {
        WGRD.showUIElements(false, [".reports_toolbar", ".breadcrumb", "#cxntab_row"]);
        WGRD.showUIElements(true, ["#fullscreen_header", "#chart"]);
        D_CXN.stepFullscreen(true);
        D_CXN.doResize();
    },
    onExitFullScreen: function () {
        $("#main_div_row").css("cursor", "default");
        clearTimeout(D_CXN.tidFullscreen);
        WGRD.showUIElements(false, ["#fullscreen_header"]);
        WGRD.showUIElements(true, [".reports_toolbar", ".breadcrumb", "#cxntab_row"]);
        D_CXN.doResize();
        D_CXN.tid = setTimeout(D_CXN.doRefresh, 1000); //reset back to current time range
    },
    stepFullscreen: function (bInit) {
        var bNeedData = true;
        var selector = D_CXN.data_selector;
        var timeout = D_CXN.fullscreenTimeout;
        var bNext = true;

        var timeIndex = D_CXN.fullscreen_timeranges.indexOf(D_CXN.minutes);
        D_CXN.minutes = D_CXN.fullscreen_timeranges[0];
        if (timeIndex >= 0 && timeIndex < D_CXN.fullscreen_timeranges.length - 1) {
            bNext = false;
            D_CXN.minutes = D_CXN.fullscreen_timeranges[timeIndex + 1];
        }

        D_CXN.graph_type = 'bytes';
        if (bInit) {
            //D_CXN.data_selector = 'protocol';
            bNext = false;
            D_CXN.data_filter_data = '';
            D_CXN.data_filter_selector = '';
            D_CXN.minutes = 30;
            timeout = 3000;
        }
        if (bNext) {
            selector = D_CXN.fullscreen_current_selectors[0];
            var nCurrent = D_CXN.fullscreen_current_selectors.indexOf(D_CXN.data_selector);
            if (nCurrent >= 0 && nCurrent < D_CXN.fullscreen_current_selectors.length - 1) {
                selector = D_CXN.fullscreen_current_selectors[nCurrent + 1];
            }
        }
        if (selector === 'webblocker') {
            D_CXN.graph_type = 'connections';
        }
        if (bNeedData) {
            $("#tab_" + selector).click();
        } else {
            $("#" + D_CXN.graph_type).click();
        }

        D_CXN.tidFullscreen = setTimeout(D_CXN.stepFullscreen, timeout);
    }

};
$(document).ready(D_CXN.init);

