/*global flowmap_breadcrumb_title,checkLoginPageRedirect,escapeHtml,D_CXN_FWATCH_WLOG,D_CXNLIST_POPUP,R_DATE_NAVBAR,R_DATE_NAVBAR_FLOWMAP,D_FLOWMAP_FLOWS,D_FLOWMAP_BYTES,D_FLOWMAP_CONNECTIONS,D_FLOWMAP_FORMAT_GB,D_FLOWMAP_FORMAT_MB,D_FLOWMAP_FORMAT_KB,D_FLOWMAP_FORMAT_BYTES,D_FLOWMAP_APP,D_FLOWMAP_APPDENY,D_FLOWMAP_WEBBLOCKER,D_FLOWMAP_POLICY,D_FLOWMAP_PROTOCOL,D_FLOWMAP_SUBSCRIPTION,D_FLOWMAP_IN_IF,D_FLOWMAP_OUT_IF,D_FLOWMAP_DENY_SOURCE,D_FLOWMAP_DENY_PROTOCOL,D_FLOWMAP_IPS,D_FLOWMAP_DLP,D_FLOWMAP_GAV,D_FLOWMAP_APT,D_FLOWMAP_JUMPTO,D_FLOWMAP_COLNAME_APP,D_FLOWMAP_COLNAME_IN_IF,D_FLOWMAP_COLNAME_OUT_IF,D_FLOWMAP_COLNAME_DISP,D_FLOWMAP_COLNAME_POLICY,D_FLOWMAP_COLNAME_WEBBLOCKER,D_FLOWMAP_COLNAME_SUBSCRIPTION,D_FLOWMAP_COLNAME_PROTOCOL,D_FLOWMAP_COLNAME_GAV,D_FLOWMAP_COLNAME_IPS,D_FLOWMAP_COLNAME_IPS_SEVERITY,D_FLOWMAP_COLNAME_IPS,D_FLOWMAP_COLNAME_DLP,D_FLOWMAP_COLNAME_APT,D_FLOWMAP_COLNAME_APT_THREAT_LEVEL,D_FLOWMAP_COLNAME_OTHER,D_CXN_POPUP_COL_NAMES,D_FLOWMAP_FILTERON,D_FLOWMAP_VIEWCONNECTIONS,D_FLOWMAP_FLOWS*/
var D_FLOWMAP = {
    w: 320,
    h: 160,
    urlSn: 'all',
    formatNumber: d3.format(",.0f"),
    disp_deny: '1',
    disps: '',
    selector_sidx: 'connections',
    data_selector: '',
    data_filter_selector: '',
    data_filter_data: '',
    data_filter_name: '',
    flowView: 'policy',
    flowmapSvg: null,
    flowmapSankey: null,
    flowmapLinkPath: null,
    flowmapMainDiv: null,
    flowmapClickData: null,
    updateTimeout: 30000,
    flowmapLastNodes: { 'nodes': [], 'links': [], 'flowcnt': 0, 'unique_links': [], 'total_connections': 0, 'total_bytes': 0 },
    nodeWidth: 30,

    init: function () {
        $.getUrlVars();
        D_FLOWMAP.urlSn = $.getUrlVar('sn');
        D_FLOWMAP.initUI();
        D_FLOWMAP.initEvents();

        D_FLOWMAP.initFlowMap(false, false, "flowmap_div");
    },
    initUI: function () {
        D_FLOWMAP.toggleFilterOptions(false, "", "");

        D_FLOWMAP.doResize();
    },
    initEvents: function () {
        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            D_FLOWMAP.doRefresh();
        });

        $("#btn_flowmap_refresh").click(function (eo) {
            D_FLOWMAP.doRefresh();
        });
        $(".sort_select").click(function (eo) {
            var selector = this.id;
            var name = $("#" + selector).html();
            $("#btn_combo_sort").html(name + '  <span class="caret"></span>');
            D_FLOWMAP.selector_sidx = selector;
            D_FLOWMAP.doRefresh();
            return;
        });

        $(".flowview_select").click(function (eo) {
            var selector = this.id;
            var name = $("#" + selector).html();
            var ar = selector.split('_');
            if (ar.length !== 2) {
                return;
            }
            D_FLOWMAP.flowView = ar[1];
            $("#btn_combo_flowview").html(name + '  <span class="caret"></span>');
            D_FLOWMAP.doRefresh();
        });

        $(document).on('click', '#flowmap_root_breadcrumb', function (eo) {
            $("#flowmap_breadcrumb_lhs").html('<span class="">' + flowmap_breadcrumb_title + '</span>');

            /* Clear filter string */
            D_FLOWMAP.toggleFilterOptions(false, '', '');
            D_FLOWMAP.doRefresh();
        });

        // Close popup
        $(document).keyup(function (eo) {
            if (eo.keyCode === 27) {
                D_CXNLIST_POPUP.closePopup();
            }
        });
        $(document).on('click', '#cxn_popup .close', function (eo) {
            $("#cxn_popup").hide();
        });
        $(document).on('click', '#popup_connections .close', function (eo) {
            D_CXNLIST_POPUP.closePopup();
        });
        $(".breadcrumb").click(function (eo) {
            D_CXNLIST_POPUP.closePopup();
        });

        $(document).on('click', '.popupJumpLink', function (eo) {
            $("#flowview_" + this.id).click();
        });
        $(document).on('click', '.popupFilterLink', function (eo) {
            D_FLOWMAP.data_filter_selector = D_FLOWMAP.flowmapClickData.type.trim();
            D_FLOWMAP.data_filter_data = D_FLOWMAP.flowmapClickData.data_name.trim();
            D_FLOWMAP.data_filter_name = D_FLOWMAP.flowmapClickData.name.trim();

            D_FLOWMAP.toggleFilterOptions(true, D_FLOWMAP.data_filter_selector, D_FLOWMAP.data_filter_data, D_FLOWMAP.data_filter_name);
            $("#cxn_popup").hide();
            D_FLOWMAP.doRefresh();
        });

        $(document).on('click', '.popupCxnsLink', function (eo) {
            D_FLOWMAP.doConnectionList();
        });

        /* Respond to resizeEnd event */
        $(window).bind('resizeEnd', function () {
            D_FLOWMAP.doResize();
        });
    },
    toggleSpinner: function (b) {
        WGRD.enableUIElements(!b, ['#btn_flowmap_refresh', '#btn_combo_flow', '#btn_groups_dropdown', '#btn_combo_sort', '#btn_combo_flowview']);
        $("#cxn_popup").hide();
        if (b) {
            $('#flowmap_loading_spinner').show();
        } else {
            $('#flowmap_loading_spinner').hide();

            if (D_FLOWMAP.hideBytes) {
                // No bandwidth data
                WGRD.enableUIElements(false, ['#btn_combo_sort']);
                var name = $("#connections").html();
                $("#btn_combo_sort").html(name + '  <span class="caret"></span>');
            } else {
                WGRD.enableUIElements(true, ['#btn_combo_sort']);
            }
        }
    },
    toggleFilterOptions: function (enable, filter_selector, filter_data, filter_name) {
        if (enable) {
            D_FLOWMAP.data_filter_selector = filter_selector;
            D_FLOWMAP.data_filter_data = filter_data;
            D_FLOWMAP.data_filter_name = filter_name;

            $("#flowmap_breadcrumb_lhs").html('');
            $("#flowmap_breadcrumb_lhs").html('<span id="flowmap_root_breadcrumb" class=""><a href="#">' + flowmap_breadcrumb_title + '</a></span>');

            var name = filter_name;
            if (!name) {
                filter_name = filter_data;
            }
            $("#flowmap_breadcrumb_lhs").append('<span class="divider"> / </span><span id="data_filter_data">' + name + '</span>');
        } else {
            D_FLOWMAP.data_filter_selector = "";
            D_FLOWMAP.data_filter_data = "";
            D_FLOWMAP.data_filter_name = "";
        }
    },
    formatEllipsis: function (s, len) {
        if (s.length > len) {
            return s.substring(0, len - 3) + "...";
        }
        return s;
    },
    formatTitle: function (d) {
        var ret = "";
        ret += d.name + "\n";
        ret += D_FLOWMAP.formatNumber(d.flow_list.length) + " " + D_FLOWMAP_FLOWS;
        ret += "\n";
        if (d.bytes > 0) {
            ret += D_FLOWMAP.formatNumber(d.bytes) + " " + D_FLOWMAP_BYTES;
            ret += "\n";
        }
        ret += D_FLOWMAP.formatNumber(d.connections) + " " + D_FLOWMAP_CONNECTIONS;
        return ret;
    },
    flowmapGradient: function (defs, name, clr1, clr2) {
        var gradient = defs
            .append("svg:linearGradient")
            .attr("id", name)
            .attr("x1", "0%")
            .attr("y1", "100%")
            .attr("x2", "100%")
            .attr("y2", "100%")
            .attr("spreadMethod", "pad");

        gradient.append("svg:stop")
            .attr("offset", "0%")
            .attr("stop-color", clr1)
            .attr("stop-opacity", 1);

        gradient.append("svg:stop")
            .attr("offset", "100%")
            .attr("stop-color", clr2)
            .attr("stop-opacity", 1);

        return "url(#" + name + ")";
    },
    createGradients: function () {
        var defs = D_FLOWMAP.flowmapSvg.append("defs");
        D_FLOWMAP.flowmapFillDefault = D_FLOWMAP.createGradient(defs, 'default', false); // Default
        D_FLOWMAP.flowmapFillProtocol = D_FLOWMAP.createGradient(defs, 'protocol', false);
        D_FLOWMAP.flowmapFillInIf = D_FLOWMAP.createGradient(defs, 'in_if', false);
        D_FLOWMAP.flowmapFillOutIf = D_FLOWMAP.createGradient(defs, 'out_if', false);
        D_FLOWMAP.flowmapFillApp = D_FLOWMAP.createGradient(defs, 'app', false);
        D_FLOWMAP.flowmapFillWebBlocker = D_FLOWMAP.createGradient(defs, 'webblocker', false);
        D_FLOWMAP.flowmapFillPolicy = D_FLOWMAP.createGradient(defs, 'policy', false);

        D_FLOWMAP.flowmapFillDeny = D_FLOWMAP.createGradient(defs, 'disp', true);
        D_FLOWMAP.flowmapFillAllow = D_FLOWMAP.createGradient(defs, 'disp', false);
    },
    getColors: function (type, deny) {
        var name = 'gradient_default';
        var start = 'rgba(255,217,15, 0.9)';
        var end = 'rgb(255,217,15)';
        switch (type) {
        case 'in_if':
        case 'out_if':
            name = 'gradient_inif';
            start = 'rgba(43,190,216, 0.9)';
            end = 'rgb(43,190,216)';
            break;
        case 'policy':
            name = 'gradient_policy';
            start = 'rgba(248,152,41, 0.9)';
            end = 'rgb(248,152,41)';
            break;
        case 'app':
        case 'app_cat':
            name = 'gradient_app';
            start = 'rgba(183,51,132, 0.9)';
            end = 'rgb(183,51,132)';
            break;
        case 'webblocker':
            name = 'gradient_webblocker';
            start = 'rgba(183,51,132, 0.9)';
            end = 'rgb(183,51,132)';
            break;
        case 'protocol':
            name = 'gradient_protocol';
            start = 'rgba(183,51,132, 0.9)';
            end = 'rgb(183,51,132)';
            break;
        case 'disp':
            if (deny) {
                name = 'gradient_deny';
                start = 'rgba(248,69,41, 0.9)';
                end = 'rgb(248,69,41)';
            } else {
                name = 'gradient_disp';
                start = 'rgba(74,171,83, 1.0)';
                end = 'rgb(74,171,83)';
            }
            break;
        }
        return { 'name': name, 'start': start, 'end': end };
    },
    createGradient: function (defs, type, deny) {
        var colorobj = D_FLOWMAP.getColors(type, deny);
        return D_FLOWMAP.flowmapGradient(defs, colorobj.name, colorobj.start, colorobj.end);
    },
    flowmapFill: function (d) {
        if (d.deny) {
            return D_FLOWMAP.flowmapFillDeny;
        }
        switch (d.type) {
        case 'app':
        case 'app_cat':
            return D_FLOWMAP.flowmapFillApp;
        case 'policy':
            return D_FLOWMAP.flowmapFillPolicy;
        case 'webblocker':
            return D_FLOWMAP.flowmapFillWebBlocker;
        case 'in_if':
        case 'out_if':
            return D_FLOWMAP.flowmapFillInIf;
        case 'protocol':
            return D_FLOWMAP.flowmapFillProtocol;
        case 'disp':
            return D_FLOWMAP.flowmapFillAllow;
        }
        return D_FLOWMAP.flowmapFillDefault;
    },
    flowmapClick: function (d) {
        D_FLOWMAP.flowmapClickData = d;
        D_FLOWMAP.doNodePopover(d);
        var dx = 350;
        var dy = 145;
        return D_FLOWMAP.doPositionNodePopover(d, dx, dy);
    },
    onMouseOut: function (d) {
        D_FLOWMAP.flowmapMainDiv.selectAll(".link")
            .classed("linkhover", false);
    },
    onMouseOver: function (d) {
        var flowid;
        if (d.flow_list) {
            for (flowid in d.flow_list) {
                if (d.flow_list.hasOwnProperty(flowid)) {
                    D_FLOWMAP.flowmapMainDiv.selectAll("." + d.flow_list[flowid])
                        .classed("linkhover", true);
                }
            }
        }
    },
    linkClassCB: function (d) {
        var cl = "link";
        if (d.disp === '2' || d.disp === '3' || d.disp === '4' || d.disp === '5' || d.disp === '6' ||
                d.disp === '7' || d.disp === '8' || d.disp === '9' || d.disp === '10' || d.disp === '11' ||
                d.disp === '12') {
            cl += " denied";
        } else if (d.deny === 'left') {
            cl += " denied";
        }

        return cl + " " + d.flowid;
    },
    resizeFlowMap: function (w, h, parent) {
        var margin = { top: 1, right: 1, bottom: 1, left: 1 };
        var width = w - margin.left - margin.right,
            height = h - margin.top - margin.bottom;
        margin = { top: 5, right: 25, bottom: 25, left: 5 };

        D_FLOWMAP.flowmapSankey
            .size([width - margin.left - margin.right, height - margin.top - margin.bottom]);

        d3.select("#" + parent).selectAll(".flowmapSvg")
            .attr("width", width)
            .attr("height", height);
        d3.select("#" + parent).selectAll(".headerSvg")
            .attr("width", width);
    },
    flowmapDrawLink: function () {
        function flowmapDrawLink(d) {
            var minVal = 1;
            var x0 = d.source.x + d.source.dx,
                x1 = d.target.x,
                x2 = x0 + (x1 - x0) / 2,
                x3 = x0 + (x1 - x0) / 2,
                y0 = d.source.y + d.sy,
                y1 = d.target.y + d.ty;
            var y2 = y0 + d.dy,
                y3 = y1 + d.dy;
            if (y3 - y1 < minVal) {
                y3 = y1 + minVal;
            }
            if (y2 - y0 < minVal) {
                y2 = y0 + minVal;
            }

            var linkpath = "M" + x0 + "," + y0 + "C" + x2 + "," + y0 + " " + x3 + "," + y1 + " " + x1 + "," + y1;
            linkpath += "L" + x1 + "," + y3;
            linkpath += "C" + x3 + "," + y3 + " " + x2 + "," + y2 + " " + x0 + "," + y2;
            linkpath += "L" + x0 + "," + y0;

            return linkpath;
        }

        return flowmapDrawLink;
    },
    initFlowMap: function (overlapSources, overlapTargets, parent) {
        var margin = { top: 1, right: 1, bottom: 1, left: 1 };
        var header_height = '4.5em';
        var width = D_FLOWMAP.w - margin.left - margin.right,
            height = D_FLOWMAP.h - margin.top - margin.bottom;
        margin = { top: 5, right: 25, bottom: 25, left: 5 };

        // Clean up 
        d3.select("#" + parent).select("svg").transition().remove();

        D_FLOWMAP.headerSvg = d3.select("#" + parent).append("svg")
            .attr("class", "headerSvg")
            .attr("width", width)
            .attr("height", header_height)
            .append("g")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");
        D_FLOWMAP.headerSvg.append("g")
              .attr("class", "headers");

        D_FLOWMAP.flowmapSvg = d3.select("#" + parent).append("svg")
            .attr("width", width)
            .attr("height", height)
            .attr("class", "flowmapSvg")
            .append("g")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");
        D_FLOWMAP.createGradients();

        D_FLOWMAP.flowmapSankey = d3.sankey()
            .nodeWidth(D_FLOWMAP.nodeWidth)
            .nodePadding(7)
            .size([width - margin.left - margin.right, height - margin.top - margin.bottom]);

        D_FLOWMAP.flowmapLinkPath = D_FLOWMAP.flowmapDrawLink();
        D_FLOWMAP.flowmapMainDiv = D_FLOWMAP.flowmapSvg.append("g");
    },
    doFlowMap: function (data) {
        var nodes = {};
        var links = [];
        var node_id = 0;
        D_FLOWMAP.hideBytes = false;
        if (data.total_bytes === 0 || isNaN(data.total_bytes)) {
            D_FLOWMAP.selector_sidx = 'connections';
            D_FLOWMAP.hideBytes = true;
        }

        // Copy links and compute nodes from links
        if (data.links.length > 300) {
            links = $.extend(true, [], data.unique_links);
        } else {
            links = $.extend(true, [], data.links);
        }
        links.forEach(function (link) {
            if (nodes[link.source]) {
                if (nodes[link.source].sourcenode) {
                    nodes[link.source].bytes += link.bytes;
                    nodes[link.source].connections += link.connections;
                    nodes[link.source].flow_list = nodes[link.source].flow_list.concat(link.flow_list);
                }
                link.source = nodes[link.source];
            } else {
                node_id = Object.keys(nodes).length;
                nodes[link.source] = { node_id: node_id, name: link.source, data_name: link.source_data, type: link.source_type, col: link.source_col,
                        sourcenode: true, bytes: link.bytes, connections: link.connections, disps: link.disps,
                        flow_list: link.flow_list, deny: false
                    };
                if (link.deny === 'left') {
                    // Shouldn't ever happen, disp is never far left
                    nodes[link.source].deny = true;
                }
                link.source = nodes[link.source];
            }
            if (nodes[link.target]) {
                nodes[link.target].flow_list = nodes[link.target].flow_list.concat(link.flow_list);
                if (!nodes[link.target].sourcenode) {
                    // Counts for nodes on the far right
                    nodes[link.target].bytes += link.bytes;
                    nodes[link.target].connections += link.connections;
                }
                link.target = nodes[link.target];
            } else {
                node_id = Object.keys(nodes).length;
                nodes[link.target] = { node_id: node_id, name: link.target, data_name: link.target_data, type: link.target_type, col: link.target_col,
                        sourcenode: false, bytes: link.bytes, connections: link.connections, disps: link.disps,
                        flow_list: link.flow_list, deny: false
                    };
                if (link.deny === 'right') {
                    nodes[link.target].deny = true;
                }
                link.target = nodes[link.target];
            }
            if (D_FLOWMAP.hideBytes) {
                link.value = link.connections;
            }
        });
        nodes = d3.values(nodes);
        D_FLOWMAP.flowmapLastNodes = { 'nodes': nodes, 'links': data.links, 'flowcnt': data.flowcnt, 'unique_links': data.unique_links, 'total_connections': data.total_connections, 'total_bytes': data.total_bytes };

        D_FLOWMAP.flowmapSankey
            .nodes(nodes)
            .links(links)
            .layout(32);

        // Build links
        var link = D_FLOWMAP.flowmapMainDiv.selectAll(".link")
            .data(links, function (d) {
                return d.linkid;
            })
            .attr("class", D_FLOWMAP.linkClassCB);
        link.selectAll("title").remove();
        link.selectAll("path").remove();
        link.exit().remove();
        link
            .enter().append("path")
            .attr("class", D_FLOWMAP.linkClassCB)
            .style("stroke-width", "0")
            .on("mouseout", D_FLOWMAP.onMouseOut)
            .on("mouseover", D_FLOWMAP.onMouseOver)
            .style("opacity", function (d) { return 0.2; })
            .sort(function (a, b) { if (!a || !b || !a.dy || !b.dy) { return 0; } return b.dy - a.dy; });

        link.append("title")
            .text(D_FLOWMAP.formatTitle);

        var column_positions = {};
        // Build nodes
        var node = D_FLOWMAP.flowmapMainDiv.selectAll(".node")
            .data(nodes);
        node.selectAll("text").remove();
        node.exit().remove();
        node.selectAll("g").remove();
        node.selectAll("rect").remove();
        node
            .enter().append("g")
            .on("mouseover", D_FLOWMAP.onMouseOver)
            .on("mouseout", D_FLOWMAP.onMouseOut)
            .attr("class", "node")
            .attr("transform", function (d) { return "translate(" + d.x + ", 0)"; });

        node.append("rect")
            .attr("rx", function (d) { return 2; })
            .attr("ry", function (d) { return 2; })
            .attr("y", "-2")
            .attr("height", function (d) { return (d.dy < 5) ? 5 : d.dy + 4; })
            .attr("width", function (d) {
                column_positions[d.x] = d.type;
                return D_FLOWMAP.flowmapSankey.nodeWidth();
            })
            .style("fill", function (d) { return D_FLOWMAP.flowmapFill(d); })
            .on("click", D_FLOWMAP.flowmapClick)
            .append("title")
                .text(D_FLOWMAP.formatTitle);


        var colwidth = 100;
        var keys = Object.keys(column_positions).sort(function (a, b) {
            return a - b;
        });
        if (keys.length > 1) {
            colwidth = keys[1] - keys[0] - D_FLOWMAP.nodeWidth;
        }
        var tnode = node.append("text")
            .attr("x", -6)
            .attr("y", function (d) { return d.dy / 2; })
            .attr("dy", ".35em")
            .attr("text-anchor", "end")
            .attr("transform", null)
            .attr("class", "textnode")
            .text(function (d) {
                var maxchars = colwidth / 6;
                return D_FLOWMAP.formatEllipsis(d.name, maxchars);
            });
        tnode.filter(function (d) {  return d.dy < 30; })
            .style("font-weight", "normal");
        tnode.filter(function (d) {  return d.dy < 5; })
            .style("font-size", "0.8em");
        tnode.filter(function (d) { return d.sourceLinks.length > 0; })
            .attr("x", 6 + D_FLOWMAP.flowmapSankey.nodeWidth())
            .attr("text-anchor", "start");
        tnode.filter(function (d) { return d.dy > 30; })
            .append("tspan")
            .attr("x", -6)
            .attr("dy", "1.2em")
            .attr("text-anchor", "end")
            .attr("transform", null)
            .attr("class", "textdata")
            .text(function (d) {
                if (D_FLOWMAP.selector_sidx === 'connections') {
                    return D_FLOWMAP.formatNumber(d.connections);
                }
                return $.formatBytes(d.bytes, D_FLOWMAP_FORMAT_GB, D_FLOWMAP_FORMAT_MB, D_FLOWMAP_FORMAT_KB, D_FLOWMAP_FORMAT_BYTES);
            })
            .filter(function (d) { return d.sourceLinks.length > 0; })
                .attr("x", 6 + D_FLOWMAP.flowmapSankey.nodeWidth())
                .attr("text-anchor", "start");

        D_FLOWMAP.flowmapMainDiv.selectAll("g")
            .transition()
            .attr("transform", function (d) { return "translate(" + d.x + "," + d.y + ")"; });

        D_FLOWMAP.flowmapMainDiv.selectAll(".link")
            .style("fill", function (d) {
                var colorobj = D_FLOWMAP.getColors(d.source.type, d.source.deny);
                return colorobj.start;
            })
            .transition()
            .attr("d", D_FLOWMAP.flowmapLinkPath);

        D_FLOWMAP.drawLegend(data.total_bytes, data.total_connections, column_positions);
    },
    getFlowmapTitle: function (viewType) {
        var name = R_DATE_NAVBAR_FLOWMAP;
        switch (viewType) {
        case 'app':
            name = D_FLOWMAP_APP;
            break;
        case 'appdeny':
            name = D_FLOWMAP_APPDENY;
            break;
        case 'webblocker':
            name = D_FLOWMAP_WEBBLOCKER;
            break;
        case 'other':
            name = D_FLOWMAP_POLICY;
            break;
        case 'policy':
            name = D_FLOWMAP_POLICY;
            break;
        case 'deny_source':
            name = D_FLOWMAP_DENY_SOURCE;
            break;
        case 'deny_protocol':
            name = D_FLOWMAP_DENY_PROTOCOL;
            break;
        case 'ips':
            name = D_FLOWMAP_IPS;
            break;
        case 'dlp':
            name = D_FLOWMAP_DLP;
            break;
        case 'apt':
            name = D_FLOWMAP_APT;
            break;
        case 'in_if':
            name = D_FLOWMAP_IN_IF;
            break;
        case 'out_if':
            name = D_FLOWMAP_OUT_IF;
            break;
        case 'protocol':
            name = D_FLOWMAP_PROTOCOL;
            break;
        case 'subscription':
            name = D_FLOWMAP_SUBSCRIPTION;
            break;
        case 'gav':
            name = D_FLOWMAP_GAV;
            break;
        }
        return name;
    },
    getFlowmapColumns: function (viewType) {
        var name = D_FLOWMAP_COLNAME_POLICY;
        switch (viewType) {
        case 'app':
            name = D_FLOWMAP_COLNAME_APP;
            break;
        case 'appdeny':
            name = D_FLOWMAP_COLNAME_APP;
            break;
        case 'app_cat':
            name = D_FLOWMAP_COLNAME_APP;
            break;
        case 'webblocker':
            name = D_FLOWMAP_COLNAME_WEBBLOCKER;
            break;
        case 'other':
            name = D_FLOWMAP_COLNAME_POLICY;
            break;
        case 'policy':
            name = D_FLOWMAP_COLNAME_POLICY;
            break;
        case 'deny_source':
            name = D_FLOWMAP_COLNAME_OTHER;
            break;
        case 'deny_protocol':
            name = D_FLOWMAP_COLNAME_OTHER;
            break;
        case 'ips_severity':
            name = D_FLOWMAP_COLNAME_IPS_SEVERITY;
            break;
        case 'ips':
            name = D_FLOWMAP_COLNAME_IPS;
            break;
        case 'dlp':
            name = D_FLOWMAP_COLNAME_DLP;
            break;
        case 'apt_threat_level':
            name = D_FLOWMAP_COLNAME_APT_THREAT_LEVEL;
            break;
        case 'apt':
            name = D_FLOWMAP_COLNAME_APT;
            break;
        case 'in_if':
            name = D_FLOWMAP_COLNAME_IN_IF;
            break;
        case 'out_if':
            name = D_FLOWMAP_COLNAME_OUT_IF;
            break;
        case 'protocol':
            name = D_FLOWMAP_COLNAME_PROTOCOL;
            break;
        case 'subscription':
            name = D_FLOWMAP_COLNAME_SUBSCRIPTION;
            break;
        case 'gav':
            name = D_FLOWMAP_COLNAME_GAV;
            break;
        case 'disp':
            name = D_FLOWMAP_COLNAME_DISP;
            break;
        }
        return name;
    },
    drawLegend: function (total_bytes, total_connections, columns) {
        D_FLOWMAP.headerSvg.selectAll(".flowmap-header").remove();
        var list = [];
        var i;
        var title = D_FLOWMAP.getFlowmapTitle(D_FLOWMAP.flowView);

        list.push(D_FLOWMAP.flowmapLastNodes.flowcnt + " " + D_FLOWMAP_FLOWS);
        if (total_bytes > 0) {
            list.push($.formatBytes(total_bytes, D_FLOWMAP_FORMAT_GB, D_FLOWMAP_FORMAT_MB, D_FLOWMAP_FORMAT_KB, D_FLOWMAP_FORMAT_BYTES));
        }
        list.push(D_FLOWMAP.formatNumber(total_connections) + " " + D_FLOWMAP_CONNECTIONS);

        var margin_right = 25;
        var legend = D_FLOWMAP.headerSvg.append("g")
            .attr("class", "flowmap-header");
        var txt = legend
            .append("text")
            .attr("x", 0)
            .attr("y", 6);
        txt
            .append("tspan")
                .attr("dy", ".35em")
                .style("font-family", "Raleway")
                .style("line-height", "2em")
                .style("font-size", "18px")
                .style("fill", "#666")
                .text(title);
        var summary = '';
        for (i = 0; i < list.length; i++) {
            if (summary.length > 0) {
                summary += ' / ';
            }
            summary += list[i];
        }
        legend.append("text")
            .attr("x", D_FLOWMAP.w - margin_right)
            .attr("y", "0.8em")
            .style("fill", "#666")
            .style("font-size", "12px")
            .style("text-anchor", "end")
            .text(summary);

        var headers = D_FLOWMAP.headerSvg.selectAll(".headers");
        headers.selectAll("text").remove();
        i = 0;
        var key, val = '';
        var keys = Object.keys(columns).sort(function (a, b) {
            return a - b;
        });
        var lastidx = false;
        var header;
        var x = 0;
        for (i = 0; i < keys.length; i++) {
            key = keys[i];
            val = columns[key];
            x = parseInt(key, 10);
            if (i === keys.length - 1) {
                x += D_FLOWMAP.nodeWidth;
                lastidx = true;
            } else if (i > 0) {
                x += D_FLOWMAP.nodeWidth / 2;
            }
            title = D_FLOWMAP.getFlowmapColumns(val);

            header = headers
                .append("text")
                .attr("x", x)
                .attr("y", "4em")
                .style("text-transform", "uppercase")
                .style("font-weight", "bold")
                .style("fill", "#666")
                .text(title);
            if (lastidx) {
                header.attr("text-anchor", "end");
            } else if (i > 0) {
                header.attr("text-anchor", "middle");
            }
        }
    },
    getSelectors: function () {
        var selectors = 'in_if,policy,out_if';
        var bFilter = (D_FLOWMAP.data_filter_selector !== '');
        switch (D_FLOWMAP.flowView) {
        case 'policy':
            D_FLOWMAP.disp_deny = '0';
            selectors = 'in_if,policy,disp,out_if';
            break;
        case 'app':
            D_FLOWMAP.disp_deny = '0';
            selectors = 'in_if,policy,app_cat,disp,out_if';
            if (bFilter) {
                selectors = 'in_if,policy,app,disp';
            }
            break;
        case 'webblocker':
            D_FLOWMAP.disp_deny = '0';
            selectors = 'in_if,policy,webblocker,disp';
            if (bFilter) {
                selectors = 'in_if,policy,webblocker,disp';
            }
            break;
        case 'protocol':
            D_FLOWMAP.disp_deny = '0';
            selectors = 'in_if,policy,protocol,disp,out_if';
            break;
        case 'ips':
            D_FLOWMAP.disp_deny = '0';
            selectors = 'in_if,policy,ips_severity,disp,out_if';
            if (bFilter) {
                selectors = 'in_if,policy,ips,disp,out_if';
            }
            break;
        case 'gav':
            D_FLOWMAP.disp_deny = '0';
            selectors = 'in_if,protocol,gav,disp,policy';
            break;
        case 'dlp':
            D_FLOWMAP.disp_deny = '0';
            selectors = 'in_if,policy,dlp,disp,out_if';
            break;
        case 'apt':
            D_FLOWMAP.disp_deny = '0';
            selectors = 'in_if,policy,apt_threat_level,disp,out_if';
            if (bFilter) {
                selectors = 'in_if,policy,apt,disp,out_if';
            }
            break;
        case 'subscription':
            D_FLOWMAP.disp_deny = '0';
            selectors = 'in_if,policy,subscription,disp,out_if';
            break;
        }
        return selectors;
    },
    getData: function (sidx) {
        D_FLOWMAP.toggleSpinner(true);
        var selectors = D_FLOWMAP.getSelectors();
        var url = 'dboard_get_flowmap_data';
        url += '?selectors=' + selectors + '&sidx=' + sidx;
        url += "&disp_deny=" + D_FLOWMAP.disp_deny;
        url += "&flow_view=" + D_FLOWMAP.flowView;
        if (D_FLOWMAP.data_filter_selector !== '' && D_FLOWMAP.data_filter_data !== '') {
            url += '&filtercol=' + D_FLOWMAP.data_filter_selector + '&filterdata=' + D_FLOWMAP.data_filter_data;
        }
        url += '&sn=' + D_FLOWMAP.urlSn;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                D_FLOWMAP.toggleSpinner(false);
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                D_FLOWMAP.doFlowMap(data);
                D_FLOWMAP.doResize();
                D_FLOWMAP.toggleSpinner(false);
            }
        });
    },
    doNodePopover: function (d) {
        if (d.connections === undefined) {
            return;
        }
        D_FLOWMAP.data_popup_name = d.name;
        D_FLOWMAP.disps = d.disps;
        $("#cxn_popup").show();

        $("#cxn_popup_title").html(escapeHtml(d.name));

        var resources = '<table>';
        if (d.bytes > 0) {
            resources += '<tr><td>' + D_FLOWMAP_BYTES + '</td><td>' + $.formatBytes(d.bytes, D_FLOWMAP_FORMAT_GB, D_FLOWMAP_FORMAT_MB, D_FLOWMAP_FORMAT_KB, D_FLOWMAP_FORMAT_BYTES) + '</td></tr>';
        }
        resources += '<tr><td>' + D_FLOWMAP_CONNECTIONS + ' </td><td>' + $.commaify(d.connections) + '</td></tr>';
        resources += '</table>';
        if (d.type === 'subscription') {
            var title = D_FLOWMAP.getFlowmapTitle(d.data_name.trim());
            var id = d.data_name.trim();
            resources += '<div style="padding-top:7px;">' + D_FLOWMAP_JUMPTO + ' <a class="popupJumpLink" id="' + id + '" href="#">' + escapeHtml(title) + '</a></div>';
        } else {
            resources += '<div style="padding-top:7px;white-space:nowrap;overflow:hidden;">' + D_FLOWMAP_FILTERON + ' <a class="popupFilterLink" href="#">' + escapeHtml(d.name) + '</a></div>';
            resources += '<div style="font-size:1.0em;">' + D_FLOWMAP_VIEWCONNECTIONS + ' <a class="popupCxnsLink" href="#">' + escapeHtml(d.name) + '</a>';
        }
        resources += '<span id="cxn_popup_spinner" class="loading"><img width="14" height="14" src="/images/loader.gif" /></span>';
        resources += '</div>';
        $("#cxn_popup_resources").html(resources);
        $("#cxn_popup_spinner").hide();
    },

    /* Popover and connection list popup */
    doConnectionList: function () {
        D_FLOWMAP.toggleSpinner(true);
        var selector = D_FLOWMAP.flowmapClickData.type;
        var flowView = D_FLOWMAP.flowView;
        if (selector.indexOf('deny_') === 0) {
            selector = selector.substring('deny_'.length);
        }
        if (D_FLOWMAP.data_filter_selector !== '' && D_FLOWMAP.data_filter_data !== '') {
            D_CXN_FWATCH_WLOG.getConnectionList(D_FLOWMAP.doConnectionListSuccess, D_FLOWMAP.disps,
                                D_FLOWMAP.data_filter_selector.trim(), D_FLOWMAP.data_filter_data.trim(), D_FLOWMAP.data_filter_name.trim(),
                                selector.trim(), D_FLOWMAP.flowmapClickData.data_name.trim(), D_FLOWMAP.flowmapClickData.name.trim(), D_FLOWMAP.urlSn, flowView);
        } else {
            D_CXN_FWATCH_WLOG.getConnectionList(D_FLOWMAP.doConnectionListSuccess, D_FLOWMAP.disps,
                                selector.trim(), D_FLOWMAP.flowmapClickData.data_name.trim(), D_FLOWMAP.flowmapClickData.name.trim(), '', '', '', D_FLOWMAP.urlSn, flowView);
        }
    },
    doConnectionListSuccess: function (data, selector, selector_data, filter_selector, filter_data) {
        var series = data.items;
        var i, idx, item;
        if (!series) {
            D_FLOWMAP.toggleSpinner(false);
            return;
        }
        for (idx in series) {
            if (series.hasOwnProperty(idx)) {
                if (series[idx].dst_domain[0] === '') {
                    series[idx].dst_domain[0] = series[idx].dst_ip;
                }
            }
        }
        selector = D_FLOWMAP.data_selector;
        D_CXNLIST_POPUP.fullScreenPopup(series, selector, selector_data, filter_selector, filter_data);

        var chartunique = {};
        var chartseries1 = [];
        var chartseries2 = [];
        var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();

        var startEndSecs = R_DATE_NAVBAR.getStartEndSeconds();
        var seriesLength = (startEndSecs[1] - startEndSecs[0]) / 60 / 60;
        // Normalize chart data
        var start_time, count, bytes;
        for (i = 0; i < series.length; i++) {
            start_time = series[i].start_time.substring(0, series[i].start_time.lastIndexOf(':'));
            start_time = start_time.substring(0, start_time.lastIndexOf(':'));

            count = parseInt(series[i].count, 10);
            bytes = parseInt(series[i].bytes, 10);
            start_time += ":00";
            if (chartunique[start_time]) {
                chartunique[start_time][0] += count;
                chartunique[start_time][1] += bytes;
            } else {
                chartunique[start_time] = [count, bytes];
            }
        }

        chartseries1.push([startEnd[0], 0, 0]);
        chartseries2.push([startEnd[0], 0, 0]);
        for (item in chartunique) {
            if (chartunique.hasOwnProperty(item)) {
                chartseries1.push([item, chartunique[item][0]]);
                chartseries2.push([item, chartunique[item][1]]);
            }
        }
        chartseries1.push([startEnd[1], 0, 0]);
        chartseries2.push([startEnd[1], 0, 0]);

        $("#popup_connections_limit_warning").hide();
        if (series.length >= data.max_items) {
            $("#popup_connections_limit_warning").show();
        }

        D_CXNLIST_POPUP.updateChartData(seriesLength, chartseries1, chartseries2);

        D_FLOWMAP.doResize();
        D_FLOWMAP.toggleSpinner(false);
    },
    doPositionNodePopover: function (d, dx, dy) {
        // Position overlay
        var pos = $("#flowmap_div").offset();
        var chart_width = $("#flowmap_div").width();
        var chart_height = $("#flowmap_div").height();

        $("#cxn_popup").removeClass("left right");
        var myleft = pos.left + d.dx;
        if (d.x - dx < 0) {
            if ((d.x + d.dx + dx > chart_width)
                    && (d.x + d.dx > chart_width / 2)) {
                myleft = pos.left + d.x + d.dx / 2;
                $("#cxn_popup").addClass("right");
            } else {
                myleft = pos.left + d.x + d.dx;
                $("#cxn_popup").addClass("right");
            }
        } else if (d.x + d.dx + dx < chart_width && d.x < 2 * (chart_width / 3)) {
            myleft = pos.left + d.x + d.dx;
            $("#cxn_popup").addClass("right");
        } else {
            myleft = pos.left + chart_width - (chart_width - d.x) - dx;
            $("#cxn_popup").addClass("left");
        }
        var mytop = pos.top + d.y + (d.dy / 2) - dy / 2;
        if (d.y + dy > chart_height) {
            $("#cxn_popup").removeClass("left right");
            mytop = pos.top + chart_height - dy;
        }

        $("#cxn_popup").offset({ top: mytop, left: myleft });
        $("#cxn_popup").width(dx);
        $("#cxn_popup").height(dy);
        // <-- Position overlay
    },

    /* Resize */
    doRefresh: function () {
        D_FLOWMAP.toggleSpinner(true);
        D_FLOWMAP.getData(D_FLOWMAP.selector_sidx);
    },
    doResize: function () {
        var winheight = $(window).height();
        var pos = $("#flowmap_div").offset();
        var contentwidth = $("#main_div_row").width();
        contentwidth -= $(".date_navbar_td").width();
        var MIN_WIDTH = 450;
        if (contentwidth < MIN_WIDTH) {
            contentwidth = MIN_WIDTH;
        }

        var MIN_HEIGHT = 400;
        D_FLOWMAP.h = winheight - pos.top - 25;
        if (D_FLOWMAP.h < MIN_HEIGHT) {
            D_FLOWMAP.h = MIN_HEIGHT;
        }
        var nodeCnt = (D_FLOWMAP.flowmapLastNodes) ? D_FLOWMAP.flowmapLastNodes.nodes.length : 0;
        if (nodeCnt * 10 > D_FLOWMAP.h) {
            // Allow to drop out of the viewport if there's lots of flows
            D_FLOWMAP.h = nodeCnt * 15;
        } else if (nodeCnt === 4) {
            D_FLOWMAP.h = 75;
        } else if (nodeCnt < 6) {
            D_FLOWMAP.h = 125;
        } else if (nodeCnt < 15) {
            D_FLOWMAP.h = 320;
        } else if (nodeCnt < 25) {
            D_FLOWMAP.h = 500;
        }
        $(".breadcrumb").width(contentwidth);
        /* FlowMap */
        D_FLOWMAP.w = contentwidth;
        if (D_FLOWMAP.flowmapSankey) {

            D_FLOWMAP.resizeFlowMap(D_FLOWMAP.w, D_FLOWMAP.h, "flowmap_div");
            if (D_FLOWMAP.flowmapLastNodes) {
                D_FLOWMAP.doFlowMap(D_FLOWMAP.flowmapLastNodes);
            }
        }

        D_CXNLIST_POPUP.doResize(D_FLOWMAP.data_selector, D_FLOWMAP.data_filter_selector, D_FLOWMAP.data_filter_data, D_FLOWMAP.w - 5);
    }
};

$(document).ready(D_FLOWMAP.init);
