/*global S_LOG_DEVICES, S_NEXT_BUTTON, S_MEMBER_EMTPY_MSG, S_DEVICE_NAME_EMPTY_MSG, S_DEVICE_NAME_LEN_MSG, S_SN_EMPTY_MSG, S_SN_VALID_MSG, S_SN_EXISTS_MSG, S_SAVE_DEVICE_MSG, S_FINISH_BUTTON, S_DOWNLOAD_MSG, S_DUPLICATE_SN_FOR_MEMBER_MSG, showHideErrorMsg, DeviceInfoObj, S_MEMBER_REQ_MSG, S_MEMBER_LIMIT_MSG, S_ENABLED_STATUS, S_ADD_DEVICE, S_EDIT_DEVICE, S_DISABLED_STATUS, S_ENABLED_STATUS, S_UPDATE_DEVICE_MSG , S_CLUSTER_LABEL, S_DEVICE_LABEL, S_LATITUDE_MSG, S_LONGITUDE_MSG, S_CLUSTER_NAME_MSG, global_access_perm, S_NOT_APPLICABLE_STATUS, S_WELCOME_INFO_MSG, S_WELCOME_INFO1_MSG, S_WELCOME_INFO2_MSG, S_WELCOME_HELP_MSG, HELP_LINK_PATH, S_LOGGING_DIV_NO_LICENSE_INFO, S_LOGGING_DIV_CLICK_INFO, S_DEVICE_NAME_VALIDATION_MSG, S_DOWNLOAD_MSG, S_SAVE_DEVICE_LSS_MSG, S_CONFIG_DEVICE_MSG, S_ACCEPT_EULA_MSG, S_ADMIN_ACCEPT_EULA_MSG, S_DEVICE_INFO_TITLE_SINGLE, S_DEVICE_INFO_TITLE_CLUSTER, has_sa_credentials */

var DEVICE_WIZ = {

    // wizard pages and their callbacks
    pages : [
        {
            page_id: '#startPage',
            reset: null,
            initPage: function () { return DEVICE_WIZ.initPage_startPage(); },
            validate: function () { return DEVICE_WIZ.validate_startPage(); },
            save: null
        },

        {
            page_id: '#provModePage',
            reset: function () { return DEVICE_WIZ.reset_provModePage(); },
            initPage: function () { return DEVICE_WIZ.initPage_provModePage(); },
            validate: function () { return DEVICE_WIZ.validate_provModePage(); },
            save: null
        },

        {
            page_id: '#liveSecurityPage',
            reset: function () { return DEVICE_WIZ.reset_liveSecurityPage(); },
            initPage: function () { return DEVICE_WIZ.initPage_liveSecurityPage(); },
            validate: function () { return DEVICE_WIZ.validate_liveSecurityPage(); },
            save: function (nextPage) { return DEVICE_WIZ.save_liveSecurityPage(nextPage); }
        },

        {
            page_id: '#deviceInfoPage',
            reset: function () { return DEVICE_WIZ.reset_deviceInfoPage(); },
            initPage: function () { return DEVICE_WIZ.initPage_deviceInfoPage(); },
            validate: function () { return DEVICE_WIZ.validate_deviceInfoPage(); },
            save: function (nextPage) { return DEVICE_WIZ.save_deviceInfoPage(nextPage); }
        },

        {
            page_id: '#existingDevicePage',
            reset: function () { return DEVICE_WIZ.reset_existingDevicePage(); },
            initPage: function () { return DEVICE_WIZ.initPage_existingDevicePage(); },
            validate: function () { return DEVICE_WIZ.validate_existingDevicePage(); },
            save: function (nextPage) { return DEVICE_WIZ.save_existingDevicePage(nextPage); }
        },

        {
            page_id: '#finishPage',
            reset: null,
            initPage: function () { return DEVICE_WIZ.initPage_finishPage(); },
            validate: function () { return DEVICE_WIZ.validate_finishPage(); },
            save: function (nextPage) { return DEVICE_WIZ.closeDeviceDialog(); }
        }
    ],

    // provisioning modes
    modes : {
        RAPID: 0,
        EXISTING: 1,
        MANUAL: 2
    },

    provisionMode : null,  // see DEVICE_WIZ.modes
    deviceID : '',
    has_sa_credentials: 0,

    init : function () {
        DEVICE_WIZ.initUI();
        DEVICE_WIZ.initEvents();
    },

    initUI : function () {
        DEVICE_WIZ.has_sa_credentials = has_sa_credentials;
    },

    initEvents : function () {
        // close, save and help are visible when editing a device
        $('#closeButton').on('click', DEVICE_WIZ.closeDeviceDialog);
        $('#saveButton').on('click', DEVICE_WIZ.updateDevice);
        $('#helpButton').on('click', function () {
            window.open(HELP_LINK_PATH + 7059, 'help_window');
        });

        // refresh the table when the dialog/wizard is closed
        $('#manage_device_dlg').on('hidden', function () {
            var attr = $('#btn_refresh_tabs').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                $('#error_container').delay(2000).fadeOut();
                S_LOG_DEVICES.doRefreshTabs();
            }
        });

        // button listeners
        $('#download_button').on('click', DEVICE_WIZ._downloadConfig);
        $('#clusterType').on('change', DEVICE_WIZ.toggleMemberUI);
        $('#add_member').on('click', DEVICE_WIZ.showMemberDialog);
        $('#rem_member').on('click', DEVICE_WIZ.remMember);
        $('#specify_members_close').on('click', DEVICE_WIZ.closeMemberDialog);
        $('#specify_members_save').on('click', DEVICE_WIZ.saveMember);
        $('#cluster_members').on('change', DEVICE_WIZ.enableRemButton);
        $('#logging_button').button().on('click', DEVICE_WIZ.toggleLoggingButton);
        $('#config_download').on('click', DEVICE_WIZ._archive_download);

        // If enter key is pressed and the device wizard dialog is visible,
        // trigger the nextButtonAction() unless backButton is currently highlighted in which
        // case trigger to backButtonAction
        $(document).keydown(function (e) {
            if (e.which === 13 && $('#manage_device_dlg').is(":visible")) {
                var focused = $(document.activeElement);
                // If members div is visible trigger the save Action when user presses enter key
                // otherwise trigger nextButton action
                if ($('#specify_members_div').is(":visible")) {
                    if (focused[0].id === 'specify_members_close') {
                        DEVICE_WIZ.closeMemberDialog();
                    } else {
                        DEVICE_WIZ.saveMember();
                    }
                } else {
                    if (focused[0].id === 'backButton' && $('#backButton').is(":visible") && $('#backButton').attr('disabled') !== 'disabled') {
                        $('#backButton').click();
                    } else if ($('#nextButton').is(":visible") && $('#nextButton').attr('disabled') !== 'disabled') {
                        $('#nextButton').click();
                    }
                }
                return false;
            }
            if (e.which === 27 && $('#specify_members_div').is(":visible")) { //escape key pressed
                $('#main_device_div').show();
                $('#specify_members_div').hide();
            }
        });

        $('#deviceDomain').change(function () {
            if ($('#deviceDomain').val() === 'AD') {
                $('#deviceAdDomain_div').show();
            } else {
                $('#deviceAdDomain_div').hide();
            }
            DEVICE_WIZ.update_next_button_state_existing_device();
        });

        $('#deviceName, #sn, #clusterName').on('keyup', DEVICE_WIZ.update_next_button_state_device_info);
        $('#lssUsername, #lssPassphrase').on('keyup', DEVICE_WIZ.update_next_button_state_live_security);
        $('#chk_eula').on('change', DEVICE_WIZ.update_next_button_state_live_security);
        $('#deviceIp, #deviceUsername, #devicePassphrase, #deviceAdDomain').on('keyup', DEVICE_WIZ.update_next_button_state_existing_device);
    },

    showDeviceDialog : function (action) {
        WGRD.doModal('#manage_device_dlg',
                     DEVICE_WIZ.initializeDeviceDlg,
                     null,
                     action);
    },

    initializeDeviceDlg : function (param) {
        // hide all the UI
        $.each(DEVICE_WIZ.pages, function (index, value) {
            $(value.page_id).hide();
        });
        $('#editDevicePage').hide();

        // show/update appropriate UI depending on Add versus Edit mode
        if (param === 'add') {
            // Add Wizard
            $('#closeButton').hide();
            $('#saveButton').hide();
            $('.modal-header h3').text(S_ADD_DEVICE);
            DEVICE_WIZ.resetWizardUI();
            WGRD.doWizard('#add_device_wizard', DEVICE_WIZ.pages);
        } else {
            // Edit Dialog
            $('#helpButton').hide();
            $('#nextButton').hide();
            $('#backButton').hide();
            $('#finishButton').hide();

            $('#editDevicePage').show();
            $('#closeButton').show();
            $('#saveButton').show();
            $('.modal-header h3').text(S_EDIT_DEVICE);
            DEVICE_WIZ.populateEditUI();
        }
        DEVICE_WIZ.hideNotification();

        return true;
    },

    // ----------------------------------------------------------------------------------------------------------------
    // -- Edit Dialog
    // ----------------------------------------------------------------------------------------------------------------

    populateEditUI : function () {
        var gridSelector = "#grid_entities";
        var selRowId = $(gridSelector).jqGrid('getGridParam', 'selrow');
        if (selRowId !== null) {
            $.ajax({
                url: 'get_device_details',
                data: {'device_id': selRowId},
                success: function (response) {
                    var is_cluster = response.device_members;
                    if (is_cluster.length !== 0) {
                        $('[for=editDeviceName]').text(S_CLUSTER_LABEL);
                        $('#editSnDiv').hide();
                        var member = response.device_members[0];
                        $('#archive_device_id').val(member.id);
                    } else {
                        $('[for=editDeviceName]').text(S_DEVICE_LABEL);
                        $('#editSnDiv').show();
                        $('#editSn').val(response.device_sn);
                        $('#archive_device_id').val(response.device_id);
                    }
                    $('#device_id').val(response.device_id);
                    $('#editDeviceName').val(response.device_name);

                    $('#latitude').val(response.latitude);
                    $('#longitude').val(response.longitude);

                    var logging_status = response.logging_status;
                    var management_status = response.management_status;
                    WGRD.enableUIElements(true, ['#logging_button']);
                    $('#logging_div_info').text(S_LOGGING_DIV_CLICK_INFO);

                    if (logging_status === 2) {
                        $('#logging_button').text(S_DISABLED_STATUS)
                                            .removeClass('btn-success')
                                            .addClass('btn-danger')
                                            .addClass('active');
                        $('#loggingStatusText').attr('placeholder', S_DISABLED_STATUS);
                    } else if (logging_status === -1) {
                        $('#loggingStatusText').attr('placeholder', S_NOT_APPLICABLE_STATUS);
                    } else if (logging_status === 3) {
                        $('#logging_button').text(S_DISABLED_STATUS)
                                            .removeClass('btn-success')
                                            .addClass('btn-danger')
                                            .addClass('active');
                        $('#loggingStatusText').attr('placeholder', S_DISABLED_STATUS);
                        $('#logging_div_info').text(S_LOGGING_DIV_NO_LICENSE_INFO);
                        WGRD.enableUIElements(false, ['#logging_button']);
                    } else {
                        $('#logging_button').text(S_ENABLED_STATUS)
                                            .removeClass('btn-danger')
                                            .addClass('btn-success')
                                            .addClass('active');
                        $('#loggingStatusText').attr('placeholder', S_ENABLED_STATUS);
                    }

                    if (global_access_perm === 1 || logging_status === -1) {
                        $('#logging_div').hide();
                        $('#loggingStatusText').show();
                    } else {
                        $('#logging_div').show();
                        $('#loggingStatusText').hide();
                    }
                    if (management_status === 1) {
                        $('#config_download_div').show();
                    } else {
                        $('#config_download_div').hide();
                    }
                }
            });
        }
    },

    toggleLoggingButton : function () {
        var current_status = $('#logging_button').text();

        if (current_status === S_DISABLED_STATUS) {
            $(this).removeClass('btn-danger')
                   .addClass('btn-success')
                   .text(S_ENABLED_STATUS);
        } else {
            $(this).removeClass('btn-success')
                   .addClass('btn-danger')
                   .text(S_DISABLED_STATUS);
        }
    },

    hideNotification : function () {
        $('#notification').hide();
        $('#notification_text').text('').removeClass();
    },

    updateDevice : function () {
        var logging_status = $('#logging_button').text();
        var latitude = $('#latitude').val().trim();
        var longitude = $('#longitude').val().trim();

        var device_obj = new DeviceInfoObj();
        device_obj.device_id = $('#device_id').val();
        var archive_device_id = $('#archive_device_id').val();
        // If editing a cluster, pass in member id too
        if (device_obj.device_id !== archive_device_id) {
            var member_info = {'member_name': '', 'member_id': archive_device_id};
            device_obj.device_members = [member_info];
        }
        device_obj.device_name = $('#editDeviceName').val();
        device_obj.device_sn = $('#editSn').val();
        device_obj.mode = 1;

        if (logging_status === S_ENABLED_STATUS) {
            device_obj.logging_status = 1;
        } else {
            device_obj.logging_status = 2;
        }
        //If user entered a value for latitude, validate it
        if (latitude.length) {
            var parse_latitude = parseFloat(latitude);
            if (isNaN(parse_latitude) || parse_latitude < -90 || parse_latitude > 90) {
                showHideErrorMsg('#latitude', S_LATITUDE_MSG);
                return;
            }
            showHideErrorMsg('#latitude');
            device_obj.latitude = latitude;
        }

        //If user entered a value for longitude, validate it
        if (longitude.length) {
            var parse_longitude = parseFloat(longitude);
            if (isNaN(parse_longitude) || parse_longitude < -180 || parse_longitude > 180) {
                showHideErrorMsg('#longitude', S_LONGITUDE_MSG);
                return;
            }
            showHideErrorMsg('#longitude');
            device_obj.longitude = longitude;
        }

        $('#notification').show();
        $('#loading').show();
        $('#notification_text').text(S_UPDATE_DEVICE_MSG)
                               .removeClass('text-error');
        $('#closeButton').prop("disabled", true);
        $('#saveButton').prop("disabled", true);

        WGRD.enableUIElements(false, ['#latitude', '#longitude']);
        //save device information
        setTimeout(function () {
            WGRD.putData(device_obj).success(function (response) {
                $('#closeButton').prop("disabled", false);
                $('#saveButton').prop("disabled", false);
                WGRD.enableUIElements(true, ['#latitude', '#longitude']);
                $('#loading').hide();
                if (!response.status) {
                    $('#notification_text').text(response.message)
                                           .addClass('text-error');
                } else {
                    DEVICE_WIZ.closeDeviceDialog();
                }
            });
        }, 5000);
    },

    _archive_download : function (event) {
        event.preventDefault();
        var device_id = $('#archive_device_id').val();
        $.ajax({
            url: 'gen_config_file',
            dataType: 'json',
            data: {'device_id' : device_id},
            success: function (response) {
                $('#loading').hide();
                if (response.status === 0) {
                    DEVICE_WIZ.hideNotification();
                    var file_args = '&tmp_file_name=' + response.tmp_file_name + '&file_name=' + response.file_name;
                    window.location = 'get_tmp_file?device_id=' + response.device_id + file_args;
                } else {
                    $('#notification').show();
                    $('#notification_text').text(response.message)
                                           .addClass('text-error');
                }
            },
            error: function (response) {
                $('#notification').show();
                $('#notification_text').text(response.message)
                                       .addClass('text-error');
            },
            complete: function () {
                $('#download_button').attr('disabled', false);
            }
        });
        return false;
    },

    closeDeviceDialog : function () {
        $('#manage_device_dlg').modal('hide');
    },

    // -- End Edit Dialog ---------------------------------------------------------------------------------------------

    // ----------------------------------------------------------------------------------------------------------------
    // -- Add Device Wizard
    // ----------------------------------------------------------------------------------------------------------------

    resetWizardUI : function () {
        $.each(DEVICE_WIZ.pages, function (index, value) {
            if (value.reset) {
                value.reset();
            }
        });
        $('#nextButton').prop("disabled", false);
    },

    /* Start Page */
    initPage_startPage : function () {
        DEVICE_WIZ.hideNotification();
        $('#helpButton').show();
        $('#nextButton').prop("disabled", false);
        return false;
    },

    validate_startPage : function () {
        $('#helpButton').hide();
        return '#provModePage';
    },

    /* Provisioning Mode Page */
    reset_provModePage : function () {
        $('#existingModeRadio').prop('checked', true);
        DEVICE_WIZ.provisionMode = DEVICE_WIZ.modes.RAPID;
    },

    initPage_provModePage : function () {
        DEVICE_WIZ.hideNotification();
        $('#nextButton').prop("disabled", false);
        return false;
    },

    validate_provModePage : function () {
        if ($('#rapidModeRadio').prop('checked')) {
            DEVICE_WIZ.provisionMode = DEVICE_WIZ.modes.RAPID;
            return '#liveSecurityPage';
        }
        if ($('#existingModeRadio').prop('checked')) {
            DEVICE_WIZ.provisionMode = DEVICE_WIZ.modes.EXISTING;
            return '#existingDevicePage';
        }
        if ($('#manualModeRadio').prop('checked')) {
            DEVICE_WIZ.provisionMode = DEVICE_WIZ.modes.MANUAL;
            return '#deviceInfoPage';
        }
    },

    /* LiveSecurity Page */
    reset_liveSecurityPage : function () {
        $('#lssUsername').val('');
        $('#lssPassphrase').val('');
        showHideErrorMsg('#lssUsername');
        showHideErrorMsg('#lssPassphrase');
        if ($('#chk_eula').length > 0) {
            $('#chk_eula').prop('checked', false);
        }
        showHideErrorMsg('#chk_eula');
    },

    initPage_liveSecurityPage : function () {
        DEVICE_WIZ.hideNotification();
        DEVICE_WIZ.update_next_button_state_live_security();
        if ($('#chk_eula').length > 0 && !$('#chk_eula').is(':checked') && DEVICE_WIZ.has_sa_credentials === 0) {
            $('#notification').show();
            $('#loading').hide();
            $('#notification_text').text(S_ADMIN_ACCEPT_EULA_MSG).addClass('text-error');
            WGRD.enableUIElements(false, ['#chk_eula']);
        } else {
            WGRD.enableUIElements(true, ['#chk_eula']);
        }
        return false;
    },

    validate_liveSecurityPage : function () {
        if ($('#lssUsername').val().length === 0 || $('#lssPassphrase').val().length === 0) {
            return null;
        }
        if ($('#chk_eula').length > 0 && !$('#chk_eula').is(':checked')) {
            showHideErrorMsg('#chk_eula', S_ACCEPT_EULA_MSG);
            return null;
        }

        return '#deviceInfoPage';
    },

    save_liveSecurityPage : function (nextPage) {
        nextPage();
    },

    /* Device Info Page */
    reset_deviceInfoPage : function () {
        DEVICE_WIZ.resetMembers();
        $('#deviceName').val('');
        $('#sn').val('');
        $('#enable_logging').prop('checked', true);
        showHideErrorMsg('#deviceName');
        showHideErrorMsg('#sn');
    },

    initPage_deviceInfoPage : function () {
        DEVICE_WIZ.hideNotification();
        DEVICE_WIZ.update_next_button_state_device_info();
        DEVICE_WIZ.deviceID = '';

        if (DEVICE_WIZ.provisionMode === DEVICE_WIZ.modes.RAPID) {
            // hide the type control (only support single device)
            $('#clusterType').prop('selectedIndex', 0);
            DEVICE_WIZ.toggleMemberUI();
            $('#deviceInfoType').hide();
            $('#deviceInfoTitle').text(S_DEVICE_INFO_TITLE_SINGLE);
        } else {
            // show the type control (support single device or cluster)
            $('#deviceInfoType').show();
            $('#deviceInfoTitle').text(S_DEVICE_INFO_TITLE_CLUSTER);

        }
        return false;
    },

    validate_deviceInfoPage : function () {
        DEVICE_WIZ.hideNotification();
        var index = $('#clusterType')[0].selectedIndex;

        if (index === 0) {
            if (!DEVICE_WIZ.validate_name('#deviceName')) {
                return null;
            }
            if (!DEVICE_WIZ.validate_sn('#sn')) {
                return null;
            }
        } else {
            if (!DEVICE_WIZ.validate_name('#clusterName')) {
                return null;
            }
            if (!DEVICE_WIZ.checkDuplicateClusterName()) {
                return null;
            }
            if ($('#cluster_members option').length === 0) {
                showHideErrorMsg('#cluster_members', S_MEMBER_EMTPY_MSG);
                return null;
            }
        }

        return '#finishPage';
    },

    save_deviceInfoPage : function (nextPage) {
        DEVICE_WIZ._saveDeviceInfo(nextPage);
    },

    /* Existing Device Page */
    reset_existingDevicePage : function () {
        $('#deviceIp').val('');
        $('#deviceUsername').val('');
        $('#devicePassphrase').val('');
        $('#deviceDomain').val('Firebox-DB');
        $('#deviceAdDomain_div').hide();
        $('#deviceLogging').prop('checked', true);
        showHideErrorMsg('#deviceIp');
        showHideErrorMsg('#deviceUsername');
        showHideErrorMsg('#devicePassphrase');
        showHideErrorMsg('#deviceAdDomain');
    },

    initPage_existingDevicePage : function () {
        DEVICE_WIZ.hideNotification();
        DEVICE_WIZ.update_next_button_state_existing_device();
        DEVICE_WIZ.deviceID = '';
        return false;
    },

    validate_existingDevicePage : function () {
        if ($('#deviceIp').val().length === 0 || $('#deviceUsername').val().length === 0 ||
                $('#devicePassphrase').val().length === 0 || ($('#deviceDomain').val() === 'AD' && $('#deviceAdDomain').val().length === 0)) {
            return null;
        }

        return '#finishPage';
    },

    save_existingDevicePage : function (nextPage) {
        DEVICE_WIZ._saveExistingDevice(nextPage);
    },

    /* Finish Page */
    initPage_finishPage : function () {
        if (DEVICE_WIZ.provisionMode === DEVICE_WIZ.modes.RAPID) {
            $('#notification').show();
            $('#notification_text').text('NOTE, RapidDeploy is not yet supported.').addClass('text-error');
            $('#download_div').hide();
        } else if (DEVICE_WIZ.provisionMode === DEVICE_WIZ.modes.EXISTING) {
            $('#download_div').hide();
        } else if (DEVICE_WIZ.provisionMode === DEVICE_WIZ.modes.MANUAL) {
            $('#download_div').show();
        }

        $('#backButton').hide();
        return true;
    },

    validate_finishPage : function () {
        return '';
    },

    /*
      Add a device to dimension, show the load image and notification image
      before making the ajax call.
      Add a timeout so that user sees some progress or delay before moving on to next pane
      Move to next pane if add succeeds else stay on current pane
    */
    _saveDeviceInfo : function (nextPage) {
        var device_obj = new DeviceInfoObj();
        var index = $('#clusterType')[0].selectedIndex;
        var device_name = $('#deviceName').val().trim();
        var enable_logging = $('#enable_logging').is(':checked');

        var device_members = [];
        if (index === 1) {
            // cluster case
            device_name = $('#clusterName').val().trim();
            $('#cluster_members option').each(function () {
                var member_name = this.value;
                var member_id = this.id;
                var member_info = {'member_name': member_name, 'member_id': member_id};
                device_members.push(member_info);
            });
        }
        device_obj.device_members = device_members;

        device_obj.device_name = device_name;
        device_obj.device_sn = $('#sn').val().trim();
        if (enable_logging) {
            device_obj.logging_status = 1;
        } else {
            device_obj.logging_status = 2;
        }

        $('#notification').show();
        $('#loading').show();
        $('#notification_text').text(S_SAVE_DEVICE_MSG).removeClass('text-error');
        $('#backButton').prop("disabled", true);
        $('#nextButton').prop("disabled", true);

        WGRD.enableUIElements(false, ['#deviceName', '#sn', '#clusterName']);
        //save device information
        setTimeout(function () {
            WGRD.putData(device_obj).success(function (response) {
                if (!response.status) {
                    $('#backButton').prop("disabled", false);
                    $('#nextButton').prop("disabled", false);
                    WGRD.enableUIElements(true, ['#deviceName', '#sn', '#clusterName']);
                    $('#loading').hide();
                    $('#notification_text').text(response.message).addClass('text-error');
                } else {
                    DEVICE_WIZ.deviceID = response.id;

                    if (DEVICE_WIZ.provisionMode === DEVICE_WIZ.modes.RAPID) {
                        DEVICE_WIZ._handle_rapiddeploy(nextPage);
                    } else {
                        $('#backButton').prop("disabled", false);
                        $('#nextButton').prop("disabled", false);
                        WGRD.enableUIElements(true, ['#deviceName', '#sn', '#clusterName']);
                        $('#loading').hide();
                        DEVICE_WIZ.hideNotification();
                        nextPage();
                    }
                }
            });
        }, 5000);
    },

    // remove the device from dimension
    _remove_device : function (errorMsg) {
        var appid_data = [{'device_id': DEVICE_WIZ.deviceID}];
        if ($('#clusterType')[0].selectedIndex === 1) {
            appid_data[0].cluster_name = $('#clusterName').val();
        }

        $.ajax({
            url: 'delete_client',
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            data: JSON.stringify(appid_data),
            complete: function () {
                $('#notification').show();
                $('#notification_text').text(errorMsg).addClass('text-error');
                $('#backButton').prop("disabled", false);
                $('#nextButton').prop("disabled", false);
                WGRD.enableUIElements(true, ['#deviceName', '#sn', '#clusterName']);
                $('#loading').hide();
            }
        });
    },

    // tell the server to generate and upload the rapid deploy payload for this device
    _handle_rapiddeploy : function (nextPage) {
        $('#notification').show();
        $('#notification_text').text(S_SAVE_DEVICE_LSS_MSG);

        var lssUsername = $('#lssUsername').val();
        var lssPassphrase = $('#lssPassphrase').val();

        $.ajax({
            url: 'upload_rapiddeploy_payload',
            type: 'POST',
            dataType: 'json',
            data: {
                'lss_username': lssUsername,
                'lss_passphrase': lssPassphrase,
                'device_id': DEVICE_WIZ.deviceID
            },
            success: function (data, textSatus, jqXHR) {
                if (data.status) {
                    $('#backButton').prop("disabled", false);
                    $('#nextButton').prop("disabled", false);
                    WGRD.enableUIElements(true, ['#deviceName', '#sn', '#clusterName']);
                    $('#loading').hide();
                    DEVICE_WIZ.hideNotification();
                    nextPage();
                } else {
                    // remove the device from dimension, if there was an error
                    DEVICE_WIZ._remove_device(data.message);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                DEVICE_WIZ._remove_device(errorThrown);
            }
        });
    },

    _saveExistingDevice : function (nextPage) {
        $('#notification').show();
        $('#notification_text').text(S_CONFIG_DEVICE_MSG).removeClass('text-error');
        $('#loading').show();

        var deviceIp = $('#deviceIp').val();
        var deviceUsername = $('#deviceUsername').val();
        var devicePassphrase = $('#devicePassphrase').val();
        var deviceDomain = $('#deviceDomain').val();
        if (deviceDomain === 'AD') {
            deviceDomain = $('#deviceAdDomain').val();
        }
        var deviceLogging = $('#deviceLogging').is(':checked');

        WGRD.enableUIElements(false, ['#deviceIp', '#deviceUsername', '#devicePassphrase', '#deviceDomain', '#deviceAdDomain']);
        $('#backButton').prop("disabled", true);
        $('#nextButton').prop("disabled", true);
        setTimeout(function () {
            $.ajax({
                url: 'configure_device',
                type: 'POST',
                dataType: 'json',
                data: {
                    'device_ip': deviceIp,
                    'device_username': deviceUsername,
                    'device_passphrase': devicePassphrase,
                    'device_domain': deviceDomain,
                    'enable_logging': deviceLogging
                },
                success: function (data, textSatus, jqXHR) {
                    if (data.status) {
                        DEVICE_WIZ.hideNotification();
                        nextPage();
                    } else {
                        $('#notification_text').text(data.message).addClass('text-error');
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    $('#notification_text').text(errorThrown).addClass('text-error');
                },
                complete: function (jqXHR, textStatus) {
                    $('#backButton').prop("disabled", false);
                    $('#nextButton').prop("disabled", false);
                    WGRD.enableUIElements(true, ['#deviceIp', '#deviceUsername', '#devicePassphrase', '#deviceDomain', '#deviceAdDomain']);
                    $('#loading').hide();
                }
            });
        }, 1000);
    },

    _downloadConfig : function () {
        $('#download_button').attr('disabled', true);
        $('#notification').show();
        $('#loading').show();
        $('#notification_text').text(DEVICE_WIZ.S_DOWNLOAD_MSG).removeClass('text-error');
        $.ajax({
            url: 'gen_config_file',
            dataType: 'json',
            data: {'device_id' : DEVICE_WIZ.deviceID},
            success: function (response) {
                $('#loading').hide();
                if (response.status === 0) {
                    DEVICE_WIZ.hideNotification();
                    var file_args = '&tmp_file_name=' + response.tmp_file_name + '&file_name=' + response.file_name;
                    window.location = 'get_tmp_file?device_id=' + response.device_id + file_args;
                } else {
                    $('#notification_text').text(response.message)
                                           .addClass('text-error');
                }
            },
            error: function (response) {
                $('#notification_text').text(response.message)
                                       .addClass('text-error');
            },
            complete: function () {
                $('#download_button').attr('disabled', false);
            }
        });
    },

    // -- End Add Device Wizard ---------------------------------------------------------------------------------------

    // ----------------------------------------------------------------------------------------------------------------
    // -- Cluster Functions
    // ----------------------------------------------------------------------------------------------------------------

    resetMembers : function () {
        DEVICE_WIZ.showMemberUI(false);
        $('#clusterName').val('');
        showHideErrorMsg('#clusterName');
        $('#cluster_members').empty();
        showHideErrorMsg('#cluster_members');
        $('#clusterType').prop('selectedIndex', 0);
        $('#add_member').attr('disabled', false);
        $('#rem_member').attr('disabled', true);
        $('#members_limit').text(S_MEMBER_REQ_MSG);
        $('#no_cluster_div').show();
        $('#members_div').hide();
        $('#enable_logging').prop('checked', true);
    },

    toggleMemberUI : function () {
        var index = $('#clusterType')[0].selectedIndex;
        if (index === 0) {
            $('#no_cluster_div').show();
            $('#members_div').hide();
        } else {
            $('#no_cluster_div').hide();
            $('#members_div').show();
        }
        DEVICE_WIZ.update_next_button_state_device_info();
    },

    /*
     Add cluster members, restrict to only 2 members
    */
    showMemberDialog : function (event) {
        event.preventDefault();
        // Disable the add button and show information that only 2 members can be added
        if ($('#cluster_members option').length === 2) {
            return;
        }
        DEVICE_WIZ.showMemberUI(true);
        $('input:text:visible:first').focus();
        $('#memberName').val('');
        $('#memberSN').val('');
        showHideErrorMsg('#memberName');
        showHideErrorMsg('#memberSN');
    },

    remMember : function (event) {
        event.preventDefault();
        // Disable the remove button if no members present
        if ($('#rem_member').attr('disabled')) {
            return;
        }
        $('#cluster_members option:selected').remove();
        $('#add_member').attr('disabled', false);
        $('#rem_member').attr('disabled', true);
        $('#members_limit').text(S_MEMBER_REQ_MSG);
        DEVICE_WIZ.update_next_button_state_device_info();
    },

    showMemberUI : function (show) {
        if (show) {
            $('#add_device_wizard').hide();
            $('#specify_members_div').show();
        } else {
            $('#add_device_wizard').show();
            $('#specify_members_div').hide();
        }
    },

    closeMemberDialog : function () {
        DEVICE_WIZ.showMemberUI(false);
    },

    saveMember : function () {
        var member_name =  $('#memberName').val().trim();
        var member_sn =  $('#memberSN').val().trim();

        if (!DEVICE_WIZ.validate_name('#memberName')) {
            return false;
        }

        if (!DEVICE_WIZ.validate_sn('#memberSN')) {
            return false;
        }

        if ($('#cluster_members option').length === 1) {
            var curr_mem_sn = $('#cluster_members option').attr('id');
            //Check if the sn does not exists in the members list
            if (curr_mem_sn.toLowerCase() === member_sn.toLowerCase()) {
                showHideErrorMsg('#memberSN', S_DUPLICATE_SN_FOR_MEMBER_MSG);
                return false;
            }
        }
        var member_name_sn = member_name + ' (' + member_sn + ')';

        $('#cluster_members').append('<option id="' + member_sn + '" value="' + member_name + '">' + member_name_sn + '</option>');
        // Disable the add button and show information that only 2 members can be added
        if ($('#cluster_members option').length === 2) {
            $('#add_member').attr('disabled', true);
            $('#members_limit').text(S_MEMBER_LIMIT_MSG);
        }
        showHideErrorMsg('#cluster_members');
        DEVICE_WIZ.update_next_button_state_device_info();
        DEVICE_WIZ.closeMemberDialog();
    },

    enableRemButton : function () {
        var selected_option = $('#cluster_members option:selected').attr('id');
        if (selected_option !== undefined) {
            $('#rem_member').attr('disabled', false);
        } else {
            $('#rem_member').attr('disabled', true);
        }
    },

    // -- End Cluster Functions ---------------------------------------------------------------------------------------

    // ----------------------------------------------------------------------------------------------------------------
    // -- Validation Functions
    // ----------------------------------------------------------------------------------------------------------------

    checkDuplicateClusterName : function () {
        var cluster_name = $('#clusterName').val();
        //check for duplicate cluster name
        var data = $("#grid_entities").jqGrid('getGridParam', 'data');
        if (data) {
            var i, len;
            for (i = 0, len = data.length; i < len; i++) {
                if (data[i].cluster && data[i].cluster.toLowerCase() === cluster_name.toLowerCase()) {
                    showHideErrorMsg('#clusterName', S_CLUSTER_NAME_MSG);
                    return false;
                }
                showHideErrorMsg('#clusterName');
            }
        }
        return true;
    },

    validate_name : function (name_id) {
        var device_name = $(name_id).val().trim();
        var patt = /^[\w\.\-]+$/;
        showHideErrorMsg(name_id);
        //check if device name is empty
        if (device_name.length === 0) {
            showHideErrorMsg(name_id, S_DEVICE_NAME_EMPTY_MSG);
            return false;
        }
        if (!patt.test(device_name)) {
            showHideErrorMsg(name_id, S_DEVICE_NAME_VALIDATION_MSG);
            return false;
        }
        if (device_name.length > 255) {
            showHideErrorMsg(name_id, S_DEVICE_NAME_LEN_MSG);
            return false;
        }

        return true;
    },

    validate_sn : function (sn_id) {
        var sn = $(sn_id).val().trim();
        //check if serial number is empty
        if (sn.length === 0) {
            showHideErrorMsg(sn_id, S_SN_EMPTY_MSG);
            return false;
        }
        showHideErrorMsg(sn_id);

        var alphaNumericTest = /^[a-z0-9]+$/i;
        if (alphaNumericTest.test(sn) === false || sn.length !== 13) {//letters, numbers only and 13 chars
            showHideErrorMsg(sn_id, S_SN_VALID_MSG);
            return false;
        }
        showHideErrorMsg(sn_id);

        //check for duplicate SN
        var data = $("#grid_entities").jqGrid('getGridParam', 'data');
        var cluster_members, member;
        if (data) {
            var i, len;
            for (i = 0, len = data.length; i < len; i++) {
                //For clusters sn will be null. Hence check if sn exists
                if (data[i].sn && data[i].sn.toLowerCase() === sn.toLowerCase()) {
                    showHideErrorMsg(sn_id, S_SN_EXISTS_MSG);
                    return false;
                }
                // Check if device is a cluster, if so, check if member does not have the sn
                if (data[i].is_cluster === 1) {
                    cluster_members = data[i].members;
                    for (i = 0, len = cluster_members.length; i < len; i++) {
                        member = cluster_members[i];
                        if (member.sn.toLowerCase() === sn.toLowerCase()) {
                            showHideErrorMsg(sn_id, S_SN_EXISTS_MSG);
                            return false;
                        }
                    }
                }
                showHideErrorMsg(sn_id);
            }
        }
        return true;
    },

    // -- End Validation Functions ------------------------------------------------------------------------------------

    // ----------------------------------------------------------------------------------------------------------------
    // -- Helper Functions
    // ----------------------------------------------------------------------------------------------------------------

    update_next_button_state_device_info : function () {
        var index = $('#clusterType')[0].selectedIndex;
        var disableNextButton = true;

        if (index === 0) {
            var deviceName = $('#deviceName').val().trim();
            var sn = $('#sn').val().trim();

            if (deviceName.length !== 0 && sn.length !== 0) {
                disableNextButton = false;
            }
        } else {
            var clusterName = $('#clusterName').val().trim();
            var cluster_members  = $('#cluster_members option').length;

            if (clusterName.length !== 0 && cluster_members !== 0) {
                disableNextButton = false;
            }
        }
        $('#nextButton').attr('disabled', disableNextButton);
    },

    update_next_button_state_live_security : function () {
        var disableNextButton = $('#lssUsername').val().length === 0 || $('#lssPassphrase').val().length === 0 ||
            ($('#chk_eula').length > 0 && !$('#chk_eula').is(':checked'));
        $('#nextButton').attr('disabled', disableNextButton);
    },

    update_next_button_state_existing_device : function () {
        var disableNextButton = $('#deviceIp').val().length === 0 || $('#deviceUsername').val().length === 0 ||
            $('#devicePassphrase').val().length === 0 || ($('#deviceDomain').val() === 'AD' && $('#deviceAdDomain').val().length === 0);
        $('#nextButton').attr('disabled', disableNextButton);
    }

    // -- End Helper Functions ----------------------------------------------------------------------------------------

};
$(document).ready(DEVICE_WIZ.init);
