/*global checkLoginPageRedirect,escapeHtml,S_EXPORTING_LOGS,S_PROCESSING,S_LOG_FREQUENCY,*/
var S_LOG_DEVICE = {
    urlSn: '',
    urlCluster: '',
    urlLt: 'tr',
    urlName: '',
    urlTz: '',
    plot_pie: null,
    init: function () {
        $.getUrlVars();
        S_LOG_DEVICE.urlSn = $.getUrlVar('sn');
        S_LOG_DEVICE.urlCluster = $.getUrlVar('cluster_id');
        S_LOG_DEVICE.urlLt = $.getUrlVar('l_t');
        if (!S_LOG_DEVICE.urlLt) {
            S_LOG_DEVICE.urlLt = 'tr';
        }
        S_LOG_DEVICE.urlName = $.getUrlVar('name');
        S_LOG_DEVICE.urlTz = $.getUrlVar('tz');

        S_LOG_DEVICE.initUI();
        S_LOG_DEVICE.initEvents();

        $(".logViewTable").show();
    },
    initUI: function () {
        /* -=-=-=- Search -=-=-=- */
        $("#btn_search").click(function () {
            var search = $("#search_box").val();
            if (search === '') {
                return;
            }
            window.location = "/log/search?sn=" + S_LOG_DEVICE.urlSn + "&l_t=" + S_LOG_DEVICE.urlLt + "&search=" + encodeURIComponent(search);
        });
        $('#search_box').bind('keypress', function (e) {
            if (e.keyCode === 13) {
                $("#btn_search").click();
            }
        });

        /* -=-=-=- Log type buttons -=-=-=- */
        $("#tr, #al, #ev, #db, #pe, #all").click(function (eo) {
            if (S_LOG_DEVICE.urlLt === this.id) {
                return;
            }
            S_LOG_DEVICE.redirect_log_type(this.id);
        });

        /* Set default log type radio button */
        var selector = "#tr";
        if (S_LOG_DEVICE.urlLt !== null) {
            selector = "#" + S_LOG_DEVICE.urlLt;
        }
        $(selector).attr('checked', 'checked').button('refresh');

        $("#" + S_LOG_DEVICE.urlLt).addClass('active');
    },
    initEvents: function () {
        /* -=-=-=- Actions -=-=-=- */
        $('.li_action').hover(
            function () {
                var selector = "#" + this.id;
                $(selector).css("background-color", "#333");
                $(selector).css("color", "#fff");
            },
            function () {
                var selector = "#" + this.id;
                $(selector).css("background-color", "#fff");
                $(selector).css("color", "black");
            }
        );

        /* Register a handler for selecting the action drop down */
        $(".li_action").bind('click', function (event) {
            event.preventDefault();
            switch (this.id) {
            case "csv":
                WGRD.progressModal(S_EXPORTING_LOGS, S_PROCESSING);
                $.ajax({
                    url: "/log/export?id=" + S_LOG_DEVICE.urlSn + "&l_t=" + S_LOG_DEVICE.urlLt + "&client_tz=" + WGRD.client_tz,
                    method: 'GET',
                    dataType: 'json',
                    error: checkLoginPageRedirect,
                    success: function (data) {
                        if (!data.status) {
                            if (data.message) {
                                WGRD.okMessageModal(data.message);
                            }
                            return true;
                        }
                        var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                        window.location = "/log/get_export_file?id=" + S_LOG_DEVICE.urlSn + file_args;
                        return false;
                    },
                    complete: function (filename) {
                        WGRD.progressModalClose();
                    }
                });
                break;
            case "print":
                var selector = "#current_grid";
                $(selector).printElement({ printMode: 'popup', leaveOpen: true });
                break;
            case "distribution":
                $.ajax({
                    url: 'log_html_distribution?id=' + S_LOG_DEVICE.urlSn,
                    method: 'GET',
                    dataType: 'html',
                    error: checkLoginPageRedirect,
                    success: S_LOG_DEVICE.onDistHtmlData
                });
                break;
            }

        });

        /* -=-=-=- Timerange (Last N minutes) -=-=-=- */
        //$("#btn_refresh").button({ icons: { primary: "ui-icon-refresh" }, text: false, width: 16 });
        $("#btn_refresh").click(function (e) {
            e.preventDefault();
            /* Reload the grid data */
            $("#logs_grid").setGridParam().trigger("reloadGrid");

            /* Tell the log frequency graph to update */
            $("#custom_timerange_trigger").click();
        });

        $("#detailview_close").click(function () {
            $("#detailview").modal('hide');
        });
        /* -=-=-=- Page resizing -=-=-=- */
        $(window).bind('resizeEnd', function () {
            var fpwidth = $("#main_div_row").width();
            fpwidth -= $(".date_navbar_td").width();
            var padleft = 0;
            var grid_width = fpwidth - padleft * 2;

            $('#logs_grid').setGridWidth(grid_width);
            S_LOG_FREQUENCY.doResize();
        });

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            S_LOG_DEVICE.getGridData();
        });


    },
    getGridData: function () {
        var grid_type = S_LOG_DEVICE.urlLt;
        $.ajax({
            url: 'log_grid_columns?l_t=' + grid_type,
            method: 'GET',
            dataType: 'json',
            success: S_LOG_DEVICE.onColumnDataReceived
        });
    },
    utcDateFormatter: function (cellvalue, options, rowObject) {
        return $.getDateDisplay(cellvalue, true, S_LOG_DEVICE.urlTz);
    },
    colorCodeFormatter: function (cellvalue, options, rowObject) {
        /* Intentionally do nothing */
        return cellvalue;
    },
    onColumnDataReceived: function (columns) {
        // Unload the grid and then recreate it 
        jQuery("#logs_grid").GridUnload("#logs_grid");
        S_LOG_DEVICE.createGrid(columns.col_names, columns.col_model);

        /* Reload the grid data */
        $("#logs_grid").setGridParam().trigger("reloadGrid");

        /* Tell the log frequency graph to update */
        $("#custom_timerange_trigger").click();
    },
    createGrid: function (colNames, colModel) {
        var padleft = parseInt($("#grid_parent").css('margin-left'), 10);
        var grid_width = $("#grid_parent").width() - padleft * 2;
        $("#logs_grid").jqGrid({
            altRows: true,
            altclass: 'gridAltRow',
            autoencode: true,
            url: 'logs?id=' + S_LOG_DEVICE.urlSn,
            datatype: 'json',
            mtype: 'GET',
            colNames: colNames,
            colModel: colModel,
            pager: '#pager',
            pagerpos: 'right',
            loadui: 'block',
            rowNum: 25,
            rowList: [25, 100, 250, 500],
            sortname: 'update_time',
            sortorder: 'asc',
            caption: '',
            height: 'auto',
            width: grid_width, //'auto',
            viewrecords: true,
            recordpos: 'left',
            toppager: true,
            shrinkToFit: true,
            jsonReader: {
                root: "data",
                page: "currpage",
                total: "totalpages",
                records: "totalrecords",
                repeatitems: false
            },
            loadComplete: function (data) {
                $(window).resize();
            },
            loadError: checkLoginPageRedirect,
            onCellSelect: function (rowid, iCol, cellcontent, e) { /**/
                if (S_LOG_DEVICE.urlLt === 'tr') {
                    S_LOG_DEVICE.doDetailViewTraffic(rowid, e.pageX, e.pageY);
                } else if (S_LOG_DEVICE.urlLt === 'all') {
                    S_LOG_DEVICE.doDetailViewAll(rowid, e.pageX, e.pageY);
                } else if (S_LOG_DEVICE.urlLt === 'al') {
                    S_LOG_DEVICE.doDetailViewAlarm(rowid, e.pageX, e.pageY);
                } else if (S_LOG_DEVICE.urlLt === 'ev') {
                    S_LOG_DEVICE.doDetailViewEvent(rowid, e.pageX, e.pageY);
                }
            },
            onSortCol: function (index, iCol, sortorder) {
                if (index !== 'update_time') {
                    var numberOfRecords = $("#logs_grid").getGridParam("records");
                    if (numberOfRecords > 1000000) {
                        var sort_max_string = $("#sort_max_string").html();
                        WGRD.okMessageModal(sort_max_string);
                        return 'stop';
                    }
                }
                return '';
            }
        }).navGrid("#pager", { refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});

        $("#logs_grid_toppager_right").css("width", "400px");
        $("#pager_right").css("width", "400px");

        $("#logs_grid").setColProp('update_time', { formatter: S_LOG_DEVICE.utcDateFormatter });
        $("#logs_grid").setColProp('disposition', { formatter: S_LOG_DEVICE.colorCodeFormatter });
        $("#logs_grid").setColProp('log_type', { formatter: S_LOG_DEVICE.colorCodeFormatter });
    },
    /* Handler for redirecting log type */
    redirect_log_type: function (l_t) {
        window.location = "/log/device?sn=" + S_LOG_DEVICE.urlSn + "&l_t=" + l_t;
    },
    /* -=-=-=- Log Distribution -=-=-=- */
    pie_options: {
        title: '',
        seriesDefaults: {
            renderer: $.jqplot.PieRenderer,
            rendererOptions: {
                sliceMargin: 3,
                showDataLabels: true
            }
        },
        seriesColors : ['#2BBED8', '#2382AB', '#00467F', '#9A4351', '#B73384', '#F26824', '#F89829', '#937E32', '#4AAB53', '#44B494'],
        cursor: {
            show: false
        },
        highlighter: {
            show: true,
            formatString: '%s',
            tooltipLocation: 'sw',
            useAxesFormatters: false
        },
        legend: { show: true }
    },
    onDistData: function (series) {
        $('#chart').show();
        $('#chart_loading').hide();
        var b_time = $.getDateDisplay(series.b_time + " GMT", false, S_LOG_DEVICE.urlTz);
        var e_time = $.getDateDisplay(series.e_time + " GMT", false, S_LOG_DEVICE.urlTz);
        $("#distribution_begin_time").html(b_time);
        $("#distribution_end_time").html(e_time);
        $("#distribution_timerange").show();

        if (S_LOG_DEVICE.plot_pie) {
            $("#chart *").unbind();
            S_LOG_DEVICE.plot_pie.destroy();
        }

        S_LOG_DEVICE.plot_pie = $.jqplot('chart', [series.data], S_LOG_DEVICE.pie_options);
        S_LOG_DEVICE.plot_pie.replot();

        $("#arrival_rate").html(series.rate);
        $("#total_log_count").html(series.totalrecords);

    },
    getDistributionData: function () {
        $('#chart').hide();
        $('#chart_loading').show();
        $.ajax({
            url: '/log/log_data_distribution?id=' + S_LOG_DEVICE.urlSn,
            method: 'GET',
            dataType: 'json',
            success: S_LOG_DEVICE.onDistData
        });
    },
    onDistHtmlData: function (data) {
        /* Get the html to display and then get the data*/
        $("#distributioncontainer").html(data);
        $("#distributionview").modal();
        S_LOG_DEVICE.getDistributionData();
    },
    doDetailViewTraffic: function (id, pageX, pageY) {
        var disp = $("#logs_grid").jqGrid('getCell', id, 'disposition');
        var update_time = $("#logs_grid").jqGrid('getCell', id, 'update_time');
        var src_ip = $("#logs_grid").jqGrid('getCell', id, 'src_ip');
        var src_port = $("#logs_grid").jqGrid('getCell', id, 'src_port');
        var src_intf = $("#logs_grid").jqGrid('getCell', id, 'src_intf');
        var dst_ip = $("#logs_grid").jqGrid('getCell', id, 'dst_ip');
        var dst_port = $("#logs_grid").jqGrid('getCell', id, 'dst_port');
        var dst_intf = $("#logs_grid").jqGrid('getCell', id, 'dst_intf');
        var policy = $("#logs_grid").jqGrid('getCell', id, 'policy');
        var proxy_act = $("#logs_grid").jqGrid('getCell', id, 'proxy_act');
        var info_1 = $("#logs_grid").jqGrid('getCell', id, 'info_1');
        var info_2 = $("#logs_grid").jqGrid('getCell', id, 'info_2');
        var info_3 = $("#logs_grid").jqGrid('getCell', id, 'info_3');
        var info_4 = $("#logs_grid").jqGrid('getCell', id, 'info_4');
        var info_5 = $("#logs_grid").jqGrid('getCell', id, 'info_5');
        var info_6 = $("#logs_grid").jqGrid('getCell', id, 'info_6');
        var info_7 = $("#logs_grid").jqGrid('getCell', id, 'info_7');
        var info_8 = $("#logs_grid").jqGrid('getCell', id, 'info_8');
        var info_9 = $("#logs_grid").jqGrid('getCell', id, 'info_9');
        var info_10 = $("#logs_grid").jqGrid('getCell', id, 'info_10');
        var info_11 = $("#logs_grid").jqGrid('getCell', id, 'info_11');
        var info_12 = $("#logs_grid").jqGrid('getCell', id, 'info_12');
        var msg_id = $("#logs_grid").jqGrid('getCell', id, 'msg_id');
        var msg = $("#logs_grid").jqGrid('getCell', id, 'msg');
        var app_portal = $("#logs_grid").jqGrid('getCell', id, 'app_portal');
        var ips_portal = $("#logs_grid").jqGrid('getCell', id, 'ips_portal');
        var url = $("#logs_grid").jqGrid('getCell', id, 'url');
        var src_nat = $("#logs_grid").jqGrid('getCell', id, 'src_nat');
        var dst_nat = $("#logs_grid").jqGrid('getCell', id, 'dst_nat');
        var misc = $("#logs_grid").jqGrid('getCell', id, 'misc');

        if (proxy_act !== "") {
            msg = proxy_act + ": " + msg;
        }
        var title = disp + " [" + policy + "]";
        if (src_nat.indexOf('0.0.0.0') >= 0) {
            src_nat = '';
        }
        if (dst_nat.indexOf('0.0.0.0') >= 0) {
            dst_nat = '';
        }
        var output =
                "<table width='100%' style='padding: 3px;'>"
                + "<tr><td colspan='10'>" + update_time + "</td></tr>"
                + "<tr><td width='150'>" + src_ip + "</td><td width='50'>" + src_port + "</td><td width='120'>" + src_intf + "</td><td>" + src_nat + "</td><td colspan='7'></td></tr>"
                + "<tr><td>" + dst_ip + "</td><td>" + dst_port + "</td><td>" + dst_intf + "</td><td>" + dst_nat + "</td><td colspan='7'></td></tr>"
                + "<tr><td colspan='10'></td></tr>"
                + "<tr><td colspan='10'>" + msg + "</td></tr>";

        if (msg_id !== "") {
            output += "<tr><td colspan='10'>" + msg_id + "</td></tr>";
        }
        if (info_1 !== "") {
            output += "<tr><td colspan='10'>" + info_1 + "</td></tr>";
        }
        if (info_2 !== "") {
            output += "<tr><td colspan='10'>" + info_2 + "</td></tr>";
        }
        if (info_3 !== "") {
            output += "<tr><td colspan='10'>" + info_3 + "</td></tr>";
        }
        if (info_4 !== "") {
            output += "<tr><td colspan='10'>" + info_4 + "</td></tr>";
        }
        if (url !== null && url !== "") {
            output += "<tr><td colspan='10'></td></tr>";
            output += "<tr><td colspan='10'>" + url + "</td></tr>";
        } else {
            if (info_5 !== "") {
                output += "<tr><td colspan='10'>" + info_5 + "</td></tr>";
            }
            if (info_6 !== "") {
                output += "<tr><td colspan='10'>" + escapeHtml(info_6) + "</td></tr>";
            }
        }
        if (info_7 !== "") {
            output += "<tr><td colspan='10'>" + info_7 + "</td></tr>";
        }
        if (info_8 !== "") {
            output += "<tr><td colspan='10'>" + info_8 + "</td></tr>";
        }
        if (info_9 !== "") {
            output += "<tr><td colspan='10'>" + info_9 + "</td></tr>";
        }
        if (info_10 !== "") {
            output += "<tr><td colspan='10'>" + info_10 + "</td></tr>";
        }
        if (info_11 !== "") {
            // Deal with APT messages
            if (info_11.indexOf('task_uuid') !== -1 && info_11.indexOf('md5') !== -1) {
                var field, i;
                var fields = info_11.split(/;\s*/);
                for (i = 0; i < fields.length; i++) {
                    field = fields[i];
                    output += "<tr><td colspan='10'>" + field + "</td></tr>";
                }
            } else {
                output += "<tr><td colspan='10'>" + info_11 + "</td></tr>";
            }
        }
        if (info_12 !== "") {
            output += "<tr><td colspan='10'>" + info_12 + "</td></tr>";
        }
        output += "<tr><td colspan='10'>&nbsp;</td></tr>";

        var anchor = '';
        if (app_portal !== "") {
            anchor = "<a href='" + app_portal + "' target='appportal'>" + app_portal + "</a>";
            output += "<tr><td colspan='10'>" + anchor + "</td></tr>";
        }

        if (ips_portal !== "") {
            anchor = "<a href='" + ips_portal + "' target='ipsportal'>" + ips_portal + "</a>";
            output += "<tr><td colspan='10'>" + anchor + "</td></tr>";
        }
        output += "<tr><td colspan='10' style='font-size: 0.8em;'>" + misc + "</td></tr>";
        output += "</table>";
        output += "<div>&nbsp;</div>";
        $("#detailview .modal-body").html("<div>" + output + "</div>");

        $("#detailview .modal-header h3").html(title);
        $("#detailview").modal({ keyboard: true, backdrop: false });
    },
    doDetailViewAll: function (id, pageX, pageY) {
        var update_time = $("#logs_grid").jqGrid('getCell', id, 'update_time');
        var log_type = $("#logs_grid").jqGrid('getCell', id, 'log_type');
        var xml_log = $("#logs_grid").jqGrid('getCell', id, 'xml_log');

        if (log_type.indexOf('Traffic') === -1) {
            return;
        }
        var output = "<table width='100%' style='padding: 3px;'>";
        output += "<tr><td colspan='10'>" + escapeHtml(update_time) + "</td></tr>";

        var field, i;
        var disp = '', policy = '';
        var sig_id = '', app_id = '', cat_id = '';
        var sig_vers = '';
        var fields = xml_log.split(/[,;]\s*/);
        for (i = 0; i < fields.length; i++) {
            field = fields[i];
            if (field.indexOf('disp') !== -1) {
                disp = field.split(/\s*=\s*/)[1];
            } else if (field.indexOf('policy') !== -1) {
                policy = field.split(/\s*=\s*/)[1];
            } else if (field.indexOf('signature_id') !== -1) {
                sig_id = field.split(/\s*=\s*/)[1];
            } else if (field.indexOf('app_cat_id') !== -1) {
                cat_id = field.split(/\s*=\s*/)[1];
            } else if (field.indexOf('app_id') !== -1) {
                app_id = field.split(/\s*=\s*/)[1];
            } else if (field.indexOf('sig_vers') !== -1) {
                sig_vers = field.split(/\s*=\s*/)[1];
            }
            output += "<tr><td colspan='10'>" + escapeHtml(field) + "</td></tr>";
        }

        var title = $("#traffic_title").val() + ' ' + disp + " [" + policy + "]";
        var anchor = '';
        var is_tdts_engine = false;
        var is_idp_engine = false;
        if (sig_vers !== '') {
            sig_vers = sig_vers.split('.')[0];
            sig_vers = parseInt(sig_vers, 10);
            if (sig_vers === 18) {
                is_tdts_engine = true;
            }
            else if (sig_vers < 18) {
                is_idp_engine = true;
            }
        }
        else {
            is_idp_engine = true;
        }
        if (sig_id !== '') {
            var ips_portal = 'https://securityportal.watchguard.com/Threats/Detail?ruleId=' + sig_id;
            anchor = "<a href='" + ips_portal + "' target='ipsportal'>" + ips_portal + "</a>";
            output += "<tr><td colspan='10'>&nbsp;</td></tr>";
            output += "<tr><td colspan='10'>" + anchor + "</td></tr>";
        } else if (app_id !== '' && cat_id !== '') {
            app_id = parseInt(app_id, 10);
            cat_id = parseInt(cat_id, 10);
            if (app_id < 65535) {
                var app_portal;
                if (is_tdts_engine) {
                    app_portal = 'https://securityportal.watchguard.com/Applications/Detail?appId=' + app_id + '&catId=' + cat_id + '&sigVers=18';
                }
                else if (is_idp_engine) {
                    app_id = (((cat_id + 128) << 8) | app_id);
                    app_portal = 'https://securityportal.watchguard.com/Applications/Detail?appId=' + app_id + '&sigVers=4';
                }
                anchor = "<a href='" + app_portal + "' target='appportal'>" + app_portal + "</a>";
                output += "<tr><td colspan='10'>&nbsp;</td></tr>";
                output += "<tr><td colspan='10'>" + anchor + "</td></tr>";
            }
        }
        output += "</table>";
        output += "<div>&nbsp;</div>";

        $("#detailview .modal-body").html("<div>" + output + "</div>");
        $("#detailview .modal-header h3").html(title);
        $("#detailview").modal({ keyboard: true, backdrop: false });
    },
    doDetailViewAlarm: function (id, pageX, pageY) {
        var update_time = $("#logs_grid").jqGrid('getCell', id, 'update_time');
        var alarm_name = $("#logs_grid").jqGrid('getCell', id, 'alarm_name');
        var msg = $("#logs_grid").jqGrid('getCell', id, 'msg');

        var title = alarm_name;
        var output = "<table width='100%' style='padding: 3px;'>";
        output += "<tr><td colspan='10'>" + update_time + "</td></tr>";

        var field, pos, i;
        var sig_id = '', app_id = '', cat_id = '';
        var fields = msg.split(':');
        for (i = 0; i < fields.length; i++) {
            field = fields[i].toLowerCase();
            pos = field.indexOf('signature id');
            if (pos !== -1) {
                sig_id = fields[i + 1].match(/\d+/)[0];
                break;
            }
            pos = field.indexOf('app cat id');
            if (pos !== -1) {
                cat_id = fields[i + 1].match(/\d+/)[0];
                if (app_id !== '') {
                    break;
                }
            }
            pos = field.indexOf('app id');
            if (pos !== -1) {
                app_id = fields[i + 1].match(/\d+/)[0];
                if (cat_id !== '') {
                    break;
                }
            }
        }

        msg = $("#msg_title").val() + ' ' + msg;
        output += "<tr><td colspan='10'>" + msg + "</td></tr>";

        var anchor = '';
        if (sig_id !== '') {
            var ips_portal = 'https://securityportal.watchguard.com/Threats/Detail?ruleId=' + sig_id;
            anchor = "<a href='" + ips_portal + "' target='ipsportal'>" + ips_portal + "</a>";
            output += "<tr><td colspan='10'>&nbsp;</td></tr>";
            output += "<tr><td colspan='10'>" + anchor + "</td></tr>";
        } else if (app_id !== '' && cat_id !== '') {
            app_id = parseInt(app_id, 10);
            cat_id = parseInt(cat_id, 10);
            if (app_id < 65535) {
                var app_portal;
                app_id = (((cat_id + 128) << 8) | app_id);
                app_portal = 'https://securityportal.watchguard.com/Applications/Detail?appId=' + app_id + '&sigVers=4';
                anchor = "<a href='" + app_portal + "' target='appportal'>" + app_portal + "</a>";
                output += "<tr><td colspan='10'>&nbsp;</td></tr>";
                output += "<tr><td colspan='10'>" + anchor + "</td></tr>";
            }
        }
        output += "</table>";
        output += "<div>&nbsp;</div>";

        $("#detailview .modal-body").html("<div>" + output + "</div>");
        $("#detailview .modal-header h3").html(title);
        $("#detailview").modal({ keyboard: true, backdrop: false });
    },
    doDetailViewEvent: function (id, pageX, pageY) {
        var update_time = $("#logs_grid").jqGrid('getCell', id, 'update_time');
        var msg = $("#logs_grid").jqGrid('getCell', id, 'msg');

        var title = $("#event_title").val();
        var output = "<table width='100%' style='padding: 3px;'>";
        output += "<tr><td colspan='10'>" + escapeHtml(update_time) + "</td></tr>";
        msg = $("#msg_title").val() + ' ' + escapeHtml(msg);
        output += "<tr><td colspan='10'>" + msg + "</td></tr>";

        output += "</table>";
        output += "<div>&nbsp;</div>";

        $("#detailview .modal-body").html("<div>" + output + "</div>");
        $("#detailview .modal-header h3").html(title);
        $("#detailview").modal({ keyboard: true, backdrop: false });
    }

};
$(document).ready(S_LOG_DEVICE.init);



