/*global HELP_LINK_ID, HELP_LINK_PATH, HELP_LINK_OVERRIDE, S_PASSPRHASE_MISMATCH, S_PASSPRHASE_CHANGE_SUCCESS, S_PASSPHRASE_CHANGE_FAILED, S_MIN_PASSPHRASE, validatePassword, S_PASSPRHASE_EMPTY, S_MAX_PASSPHRASE, S_PASSPHRASE_CHANGE_FAILED_1, S_PO_USERNAME_EMPTY, S_PO_PASSPHRASE_EMPTY, S_PO_SUCCESS, S_PO_FAILED, S_PO_PERM, anonymization_enabled, anonymize_desc, S_ANON_DESC */
var NAVBAR = {
    init : function () {
        NAVBAR.initUI();
        NAVBAR.initEvents();
    },

    initUI : function () {
        if (anonymization_enabled === 1 && !anonymize_desc) {
            $('#anonymization_desc').html(S_ANON_DESC);
        }
        NAVBAR.initPassPhraseDialog();
        NAVBAR.initDeAnonymizationDialog();
    },

    initEvents : function () {
        $('.help_link').click(NAVBAR.launchHelpPg);
        $('.change_pwd').click(NAVBAR.showPassPhraseDialog);
        $('#change_pwd_save_btn').click(NAVBAR.changePassphrase);
        $('.de_anyonymize').click(NAVBAR.showDeAnonymizationDialog);
        $('#anonymization_save_btn').click(NAVBAR.deAnonymizeDimension);
        $(document).keydown(function (eo) {
            if (eo.which === 13) { // enter key pressed
                if ($('#anonymization_dlg').is(":visible")) {
                    $('#anonymization_save_btn').click();
                    return;
                }
            }
        });
        $('#anonymization_dlg').on('shown.bs.modal', function () {
            $(this).find('[autofocus]').focus();
        });
    },

    launchHelpPg : function (ev) {
        ev.preventDefault();
        if (HELP_LINK_OVERRIDE !== '') {
            window.open(HELP_LINK_PATH + HELP_LINK_OVERRIDE, 'help_window');
        } else {
            window.open(HELP_LINK_PATH + HELP_LINK_ID, 'help_window');
        }
    },

    initDeAnonymizationDialog : function () {
        $('#po_name').val('');
        $('#po_passphrase').val('');
        NAVBAR.anonymizationDivToggle(true);
    },

    anonymizationDivToggle : function (show) {
        $('#anonymization_info_msg').text('')
                                    .hide();
        if (show) {
            $('#ao_div').show();
            $('#ao_radius_div').hide();
        } else {
            $('#ao_radius_div').show();
            $('#ao_div').hide();
        }
        WGRD.enableUIElements(true, ['#anonymization_cancel_btn', '#anonymization_save_btn']);
    },

    showDeAnonymizationDialog : function (ev) {
        ev.preventDefault();
        NAVBAR.initDeAnonymizationDialog();
        $("#anonymization_dlg").modal();
    },

    initPassPhraseDialog : function () {
        $('#info_msg').text('')
                      .hide();
        $('#current_passphrase').val('');
        $('#new_passphrase').val('');
        $('#confirm_user_passphrase').val('');
        WGRD.enableUIElements(true, ['#change_pwd_save_btn', '#change_pwd_cancel_btn']);
    },

    showPassPhraseDialog : function (ev) {
        ev.preventDefault();
        NAVBAR.initPassPhraseDialog();
        $("#change_pwd_dlg").modal();
    },

    deAnonymizeDimension : function () {
        var ao_radius = $('#ao_radius_div').is(':visible');
        if (ao_radius) {
            NAVBAR.challengeResponseAOUser();
            return;
        }
        var val = NAVBAR.validatePrivOfficer();
        if (val) {
            var po_username = $('#po_name').val();
            var po_passphrase = $('#po_passphrase').val();
            var user_data = {'username': po_username, 'passphrase': po_passphrase};
            WGRD.enableUIElements(false, ['#anonymization_cancel_btn', '#anonymization_save_btn']);
            $.ajax({
                url: '/usersandroles/disable_anonymization',
                type: 'POST',
                dataType: 'json',
                data: user_data,
                success : function (data) {
                    NAVBAR._ao_success(data);
                },
                error : function (data) {
                    NAVBAR._ao_error();
                }
            });
        }
    },

    challengeResponseAOUser : function () {
        var ao_radius_response = $('#ao_radius_response').val();
        var user_data = {'response': ao_radius_response};
        WGRD.enableUIElements(false, ['#anonymization_cancel_btn', '#anonymization_save_btn']);
        $.ajax({
            url: '/usersandroles/check_response',
            type: 'POST',
            dataType: 'json',
            data: user_data,
            success : function (data) {
                NAVBAR._ao_success(data);
                $('#ao_radius_question').val("");
                $('#ao_radius_response').val("");
            },
            error : function (data) {
                NAVBAR._ao_error();
            }
        });
    },

    _ao_success : function (data) {
        if (data.status === 0) {
            if (data.has_challenge) {
                NAVBAR.anonymizationDivToggle(false);
                $('#ao_radius_question').text(data.challenge_q);
                $('#ao_radius_response').focus();
                return;
            }
            // Check for PO perm
            if (!data.has_perm) {
                // If user does not have perm, hide the RADIUS div
                NAVBAR.anonymizationDivToggle(true);
                NAVBAR._show_success_error_msg('#anonymization_info_msg', S_PO_PERM, false);
            } else {
                NAVBAR._show_success_error_msg('#anonymization_info_msg', S_PO_SUCCESS, true);
                setTimeout(function () {
                    document.location.reload(true);
                }, 1000);
            }
        } else {
            NAVBAR._show_success_error_msg('#anonymization_info_msg', S_PO_FAILED, false);
            WGRD.enableUIElements(true, ['#anonymization_cancel_btn', '#anonymization_save_btn']);
        }
    },

    _ao_error : function () {
        NAVBAR._show_success_error_msg('#anonymization_info_msg', S_PO_FAILED, false);
        WGRD.enableUIElements(true, ['#anonymization_cancel_btn', '#anonymization_save_btn']);
    },

    changePassphrase : function () {
        var saveChanges = NAVBAR.validateUI();
        if (saveChanges) {
            var cur_password = $('#current_passphrase').val();
            var new_password = $('#new_passphrase').val();
            var error_msg = S_PASSPHRASE_CHANGE_FAILED;
            var user_data = {'old_password': cur_password, 'new_password': new_password};
            WGRD.enableUIElements(false, ['#change_pwd_save_btn', '#change_pwd_cancel_btn']);
            $.ajax({
                url: '/usersandroles/change_user_passphrase',
                type: 'POST',
                dataType: 'json',
                async: false,
                data: user_data,
                success : function (data) {
                    if (data.status) {
                        NAVBAR._show_success_error_msg('#info_msg', S_PASSPRHASE_CHANGE_SUCCESS, true);
                        setTimeout(function () {
                            $("#change_pwd_dlg").modal('hide');
                        }, 1000);
                    } else {
                        if (data.error_code === 1) {
                            error_msg = S_PASSPHRASE_CHANGE_FAILED_1;
                        }
                        NAVBAR._show_success_error_msg('#info_msg', error_msg, false);
                        WGRD.enableUIElements(true, ['#change_pwd_save_btn', '#change_pwd_cancel_btn']);
                    }
                },
                error : function (data) {
                    if (data.error_code === 1) {
                        error_msg = S_PASSPHRASE_CHANGE_FAILED_1;
                    }
                    NAVBAR._show_success_error_msg('#info_msg', error_msg, false);
                    WGRD.enableUIElements(true, ['#change_pwd_save_btn', '#change_pwd_cancel_btn']);
                }
            });
        }
    },

    _show_success_error_msg : function (elem, msg, success) {
        $(elem).text(msg)
                      .show();
        if (success) {
            $(elem).addClass("alert-success wgrd-modal-success")
                   .removeClass("alert-error wgrd-modal-error");
        } else {
            $(elem).removeClass("alert-success wgrd-modal-success")
                   .addClass("alert-error wgrd-modal-error");
        }
    },

    _invalid_password_msg : function (error_val) {
        var err_msg = S_PASSPRHASE_EMPTY;
        if (error_val === 2) {
            err_msg = S_MIN_PASSPHRASE;
        } else if (error_val === 3) {
            err_msg = S_MAX_PASSPHRASE;
        }
        return err_msg;
    },

    validateUI : function () {
        var new_password = $('#new_passphrase').val();
        var confirm_password = $('#confirm_user_passphrase').val();

        var val = validatePassword(new_password);
        if (val !== 0) {
            $('#new_passphrase').focus()
                                .select();
            var err_msg = NAVBAR._invalid_password_msg(val);
            NAVBAR._show_success_error_msg('#info_msg', err_msg, false);
            return false;
        }

        if (new_password.trim() !== confirm_password.trim()) {
            $('#new_passphrase').focus()
                                .select();
            NAVBAR._show_success_error_msg('#info_msg', S_PASSPRHASE_MISMATCH, false);
            return false;
        }
        return true;
    },

    validatePrivOfficer : function () {
        var po_user_name = $('#po_name').val();
        var po_passphrase = $('#po_passphrase').val();
        if ($.trim(po_user_name) === '') {
            $('#po_name').focus()
                         .select();
            NAVBAR._show_success_error_msg('#anonymization_info_msg', S_PO_USERNAME_EMPTY, false);
            return false;
        }

        if ($.trim(po_passphrase) === '') {
            $('#po_passphrase').focus()
                               .select();
            NAVBAR._show_success_error_msg('#anonymization_info_msg', S_PO_PASSPHRASE_EMPTY, false);
            return false;
        }
        return true;
    }
};
$(document).ready(NAVBAR.init);
