$(document).ready(function() {                    
    var reportName;  
    var portal_link = "https://securityportal.watchguard.com/Threats/Detail?ruleId=";
    var allVars = $.getUrlVars();
    var urlSn = $.getUrlVar('sn');
    var repType = $.getUrlVar('reptype');    
    var date = $.getUrlVar('date');
    var id = $.getUrlVar('id');
    var period = $.getUrlVar('period');    
    var urlTz = $.getUrlVar('tz');         
    var htmlDate = $("#date").val();
    var htmlSn = $("#sn").val();    
    var startTime = '';
    var endTime = '';
    var seriesEarliestRecord = '';
    var seriesLatestRecord = '';
    var resultData = new Object();
    var showDetailView = false;
    var show_bw_hits_rep_list = ['top_cli_app_usage_users', 'top_cli_app_usage_hosts',
                                 'top_cli_app_usage_by_user', 'top_cli_app_usage_by_ip',
                                 'top_cli_app_usage_devices', 'top_cli_app_usage_by_device'];
     
    var summary_detail_reports_map = {'appusage':'top_cli_app_usage_users_detail',
                                      'appblocked':'top_cli_app_block_users_detail'};

    var app_default_list = ['top_cli_app_usage_users', 'top_cli_app_usage_hosts',
                            'top_cli_app_block_users', 'top_cli_app_block_hosts',
                            'top_cli_app_usage_devices', 'top_cli_app_block_devices'];
    var user_default_list = ['top_cli_app_usage_by_user', 'top_cli_app_block_by_user'];  
    var ip_default_list = ['top_cli_app_usage_by_ip', 'top_cli_app_block_by_ip'];
    var device_default_list = ['top_cli_app_usage_by_device', 'top_cli_app_block_by_device'];

    var detail_rep_path = 'detail?sn=';
    var reportPath = this.location.pathname;
    showHideDetailsLink();

    // Set the report type from the url
    if(repType != null){
        $('#chart_select').val(repType);
    }
    if(period != null && period == 'custom'){
        $('#chart_select').hide();
    }   
        
    $('#pdf_link').click(function(){
        resultData.grid_data = updateTimezones(resultData.grid_data, resultData.col_model);
        resultData.user_data = updateUserTimezones(resultData.user_data, resultData.user_col_model);

        data = JSON.stringify(resultData);

        var reportType = $('#chart_select option:selected').val();
        reportType = getRepType(reportType);
        var tzOffsetStart = $.getDateUTCOffsetString(seriesEarliestRecord, urlTz);
        var tzOffsetEnd = $.getDateUTCOffsetString(seriesLatestRecord, urlTz);

        WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

        $.ajax({
            url:  "saveAsPdf?serial=" + htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + reportType + "&start_time=" + seriesEarliestRecord + "&end_time=" + seriesLatestRecord +
                  "&tz_offset_start=" + tzOffsetStart +  "&tz_offset_end=" + tzOffsetEnd,
            type: 'POST',
            data: data,
            contentType: 'application/json',
            success: function(data) {
                if(!data.status){
                    if(data.message){
                        alert(data.message);
                    }
                    return true;
                }
                var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                window.location = "get_pdf_file?serial=" + htmlSn + file_args;
                return false;
            },
            complete: function (filename) {
                WGRD.progressModalClose();
            }
        });
    });
        
    // Add handler for change the type of chart
    $("#chart_select").change(function () {   getData();  });
    $("#bw_hits_select").change(function () {   getData();  });

    $("#custom_datepicker_trigger").bind('click', function() {
        // Listen fora click on this div, it means the date changed 
        // and a refresh is needed
        getData();
    });       

    function getRepType (repType) {
        if ($.inArray(repType, show_bw_hits_rep_list) !== -1) {
            repType = repType + $('#bw_hits_select option:selected').val();
        }
        return repType;
    }

    function getData(){
        var filter_view = '';
        var report_type = $('#chart_select option:selected').val();
        if ($.inArray(report_type, show_bw_hits_rep_list) === -1) {
            $('#bw_hits_select').hide();
            $('#chart_select').css('width','187px');
        } 
        else {
            $('#bw_hits_select').show();
            $('#chart_select').css('width','140px');
            filter_view = $('#bw_hits_select option:selected').val();
        }

        var filter = {'filter_view': filter_view, 'filter_data': ''};
        //Once the date is set, refresh all the charts
        var jqxhr = getChartData('chart', htmlSn, true, id, filter);
        jqxhr.success(dataReceived);
    }
     
    // Return data handler functions
    function dataReceived(series){
        resultData = series;

        showHideLinkIcon(series, 'pdf');

        seriesEarliestRecord = series.earliest_record;
        seriesLatestRecord = series.latest_record;
        startTime = $.getDateDisplay(series.earliest_record, true, urlTz);
        endTime = $.getDateDisplay(series.latest_record, true, urlTz);
        showDetailView = series.detail_view;        
        reportName = $('#chart_select option:selected').text(); 
                
        // Notify the date navbar the report range changed
        $('#report_range').trigger('reportRange', { start_time: startTime, 
                                                    end_time: endTime, 
                                                    name: reportName });        

        var report_type = $('#chart_select option:selected').val();
        if ($.inArray(report_type, show_bw_hits_rep_list) !== -1) {
            if (series.chart_type === "bar" && $('#bw_hits_select option[value="_band"]').length !== 0) {
                // It means no bandwidth data, only show 'by Hits' option.
                $('#bw_hits_select option[value="_band"]').remove();
            }
            if (series.chart_type !== "bar" && $('#bw_hits_select option[value="_band"]').length === 0) {
                $('#bw_hits_select').prepend("<option value='_band'>" + S_BY_BANDWIDTH + "</option>");
            }
        }
        // Unload the grid and then recreate it and populate the rows
        jQuery("#app_grid_area").GridUnload("#app_grid_area");
        createAppGrid(series.col_names, series.col_model, series.grid_sort);

        for(i=0;i<=series.grid_data.length;i++) {
            $("#app_grid_area").jqGrid('addRowData',i+1,series.grid_data[i]);
        }
        $("#app_grid_area").setGridParam({rowNum:i});        
        $("#app_grid_area").jqGrid('footerData','set', series.footer, false);
        setGridHeight();
    }          
     
    // Application list DataGrid
    function createAppGrid(colNames, colModel, gridSort){
        var repType = $('#chart_select option:selected').val();
        $('#app_grid_area').jqGrid({ 
            datatype: "local", 
            colNames:colNames,
            colModel:colModel,        
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder, 
            autoencode: true,
            autowidth: true,
            shrinkToFit: true,
            subGrid: true,
            footerrow:true,
            subGridRowExpanded: function(subgrid_id, row_id){
                var subgrid_table_id, pager_id;
                subgrid_table_id = "subgrid" + row_id;
                $("#" + subgrid_id).html("<table id='" + subgrid_table_id + "'></table>");
                jQuery("#" + subgrid_table_id).jqGrid({
                    datatype: "local",
                    colNames: resultData.user_col_names,
                    colModel: resultData.user_col_model,
                    sortname: resultData.user_grid_sort.sortname,
                    sortorder: resultData.user_grid_sort.sortorder, 
                    height: '100%',
                    width: '100%',
                    onCellSelect: function(id, iCol, cellcontent, e) {
                        if(showDetailView){
                            doDetailView(id, subgrid_table_id, e.pageX, e.pageY);
                        }
                    }    
                });

                var filed_name = '';
                if ($.inArray(repType, app_default_list) !== -1) {
                    filed_name = 'application';
                } else if ($.inArray(repType, user_default_list) !== -1) {
                    filed_name = 'user';
                } else if ($.inArray(repType, ip_default_list) !== -1) {
                    filed_name = 'ip';
                } else if ($.inArray(repType, device_default_list) !== -1) {
                    filed_name = 'device';
                }

                var app  =  $("#app_grid_area").jqGrid('getCell',row_id, filed_name);

                // Need to parse the actual application or user or ip from hyperlinks.
                if (anonymization_enabled !== 1) {
                    $("#" + subgrid_table_id).setColProp('host', { formatter: linkFormatter });
                    $("#" + subgrid_table_id).setColProp('ip', { formatter: linkFormatter });
                    $("#" + subgrid_table_id).setColProp('user', { formatter: linkFormatter });
                    $("#" + subgrid_table_id).setColProp('device', { formatter: linkFormatter });
                    $("#" + subgrid_table_id).setColProp('application', { formatter: appLinkFormatter });

                    var splitArray = app.split(">");
                    var str2 = splitArray[1];
                    var start = str2.indexOf("<");
                    if(start !== -1) {
                        app = str2.substring(0, start);
                    }
                }
                var row_data = resultData.user_data[app];

                for(var i=0;i<=row_data.length;i++) {
                    $("#" + subgrid_table_id).jqGrid('addRowData',i+1, row_data[i]);
                }
                $("#" + subgrid_table_id).setGridParam({rowNum:i});
                setGridHeight();
            },
            subGridRowColapsed: function(subgrid_id, row_id){
                /* IE doesn't resize grids with sub grids properly, so set the height manually  */
                /* subtract the height of the subgrid that's being collapsed from the grids height */
                var sub_height = $('#' + subgrid_id).height();
                var height = $('#app_grid_area').height();
                $('#app_grid_area').setGridHeight(height - sub_height);
            }          
        });

        if (anonymization_enabled !== 1) {
           if ($.inArray(repType, app_default_list) !== -1) {
               $("#app_grid_area").setColProp('application', { formatter: appLinkFormatter});
           }
           if ($.inArray(repType, user_default_list) !== -1) {
               $("#app_grid_area").setColProp('user', { formatter: linkFormatter});
           }
           if ($.inArray(repType, ip_default_list) !== -1) {
               $("#app_grid_area").setColProp('ip', { formatter: linkFormatter});
           }
           if ($.inArray(repType, device_default_list) !== -1) {
               $("#app_grid_area").setColProp('device', { formatter: linkFormatter});
           }
        }
    }
    
    /* IE doesn't resize grids with sub grids properly, so set the height manually  */
    function setGridHeight(){
        var height = $('#app_grid_area').height();
        $('#app_grid_area').setGridHeight(height);    
    }

    linkFormatter = function(elem, cellval, opts){
        return formatPerClientLink(elem, cellval, opts);
    }

    function formatPerClientLink(elem, cellval, opts){
        var index = startTime.indexOf(' ');
        var start_date = startTime.substring(0,index);
        var start_time = startTime.substring(index + 1, startTime.length);
        index = endTime.indexOf(' ');
        var end_date = endTime.substring(0,index);
        var end_time = endTime.substring(index + 1, endTime.length);            

        var uri = 'perclient?sn=' + urlSn + 
              '&start_date=' + start_date + 
              '&start_time=' + start_time + 
              '&end_date=' + end_date + 
              '&end_time=' + end_time;
        uri += createURLToPerClient(elem, cellval, opts);
        return "<a href='" + uri + "'>" + escapeHtml(elem) + "</a>";
    }
    
    // Show the detail link only for those summary reports that have a corresponding details report
    function showHideDetailsLink() {
        var rep_type_from_path = reportPath.substring(reportPath.lastIndexOf('/') + 1, reportPath.length);

        $('#view_details_link').hide();
        if (rep_type_from_path !== undefined) {
          var detail_rep_name = summary_detail_reports_map[rep_type_from_path];
          if (detail_rep_name !== undefined && anonymization_enabled !== 1) {
              $('#view_details_link').show();
              var detail_href = detail_rep_path + htmlSn + '&reptype=' + detail_rep_name;
              $('#view_details_link').attr('href', detail_href);
          }
        }
    }

    function appLinkFormatter(elem, cellval, opts) {
        var uri = '';

        if(cellval.colModel.name === 'application') {
            var reportType = $('#chart_select option:selected').val();
            var band_or_Hit = $('#bw_hits_select option:selected').val();
            uri = 'detail?sn=' + urlSn;
            if(reportType === "top_cli_app_usage_users" || reportType === "top_cli_app_usage_by_user") {
                uri = uri + '&reptype=top_cli_app_usage_users_detail&search=' + encodeURIComponent('app=' + elem) + '&band_or_Hit=' + band_or_Hit;
            }else if(reportType === "top_cli_app_usage_hosts" || reportType === "top_cli_app_usage_by_ip") {
                uri = uri + '&reptype=top_cli_app_usage_hosts_detail&search=' + encodeURIComponent('app=' + elem) + '&band_or_Hit=' + band_or_Hit;
            }else if(reportType === "top_cli_app_usage_devices" || reportType === "top_cli_app_usage_by_device") {
                uri = uri + '&reptype=top_cli_app_usage_devices_detail&search=' + encodeURIComponent('app=' + elem) + '&band_or_Hit=' + band_or_Hit;
            }else if(reportType === "top_cli_app_block_users" || reportType === "top_cli_app_block_by_user") {
                uri = uri + '&reptype=top_cli_app_block_users_detail&search=' + encodeURIComponent('app=' + elem);
            }else if(reportType === "top_cli_app_block_hosts" || reportType === "top_cli_app_block_by_ip") {
                uri = uri + '&reptype=top_cli_app_block_hosts_detail&search=' + encodeURIComponent('app=' + elem);
            }else if(reportType === "top_cli_app_block_devices" || reportType === "top_cli_app_block_by_device") {
                uri = uri + '&reptype=top_cli_app_block_devices_detail&search=' + encodeURIComponent('app=' + elem);
            }
        }

        return "<a href='" + uri + "'>" + elem + "</a>";
    }

    /* -=-=-=- detail view -=-=-=- */
    $("#detailview").dialog(
        {
            width: 600,
            resizable: false,
            autoOpen: false
        }
    );
    
    function doDetailView(id, subgrid_table_id, pageX, pageY) {
        var time = $("#" + subgrid_table_id).jqGrid('getCell',id,'time');    
        var output = "<table width='100%' style='padding: 3px;'>";
        
        for (var i=0; i<resultData.user_col_model.length; i++){
            var val = $("#" + subgrid_table_id).jqGrid('getCell',id, resultData.user_col_model[i].index);
            var name = resultData.user_col_names[i];
            output += "<tr><td width='150'>" + name + "</td><td>" + val + "</td></tr>";
        }
        output += "<tr><td colspan='2'>&nbsp;</td></tr>";
        
        var sig_id = $("#" + subgrid_table_id).jqGrid('getCell',id,'sig_id');    
        if(sig_id != ""){
            output += "<tr><td colspan='2'><a href='" + portal_link + sig_id +"' target='ipsportal'>"+ portal_link + sig_id + "</a></td></tr>";
            output += "<tr><td colspan='2'>&nbsp;</td></tr>";
        }
                        
        output += "</table>";
        output += "<div>&nbsp;</div>";
        $("#detailview").html("<div>" + output + "</div>");

        /* 
        * If the detail view has scrolled out of view, reposition it centered
        * and below the row that was clicked
        */
        offset = $("#detailview").offset();
        if (offset != null) {
            var scrollTop = $(document).scrollTop();
            var h_win = $(window).height();
            if (offset.top < scrollTop
                || offset.top > scrollTop + h_win) {
                w_doc = $(document).width();
                w_dlg = $("#detailview").width();
                var x = (w_doc - w_dlg) / 2;
                var y = pageY - scrollTop + 10;
                $("#detailview").dialog({ position: [x, y] });
            }
        }

        /* Reset the height to 'auto' for IE */
        $("#detailview").dialog({ height: 'auto' });
        $("#detailview").dialog({ title: time });
        $("#detailview").dialog("open");
                 
    }
    
    $(window).bind('resizeEnd', function() {
        if(window.plot_trend){        
            var grid = "#app_grid_area";
            var parent = "#grid_data";
            var grid_width = resizegrid();
            $("#webui_content").width(grid_width);
            $(grid).setGridWidth(100, true); 
            $(grid).setGridWidth($(parent).width(), true);
            plot_trend.replot();
        }
    });      
});
