/*global unescape, createDateFromStr, SM_PASS_ON, SM_FAIL_ON, SM_FAILED*/
var S_MOBILE_DETAIL = {
    init : function () {
        S_MOBILE_DETAIL.initEvents();
    },

    initEvents : function () {
        $('#mobile_ok').click(function () {
            $('#mobile_detail_dlg').modal("hide");
        });
    },

    showDetailsDialog : function (event) {
        event.preventDefault();

        var checkinfo = unescape($(event.currentTarget).data('checkinfo'));
        checkinfo = checkinfo.split(';');
        var datatime = checkinfo[0];
        var comp_status = parseInt(checkinfo[1], 10);
        var comp_setting = {'comp_setting': checkinfo[2], 'device_type': checkinfo[3]};

        $('#mobile_error_msg').hide();
        $('#mobile_title').hide();
        $('#mobile_caption').hide();
        $('#mobile_setting').empty();

        $.ajax({
            url: '/report/get_comp_setting_details',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: comp_setting,
            error : function () {
                $('.modal-body').append('<p class="text-error">' + SM_FAILED + '</p>');
            },
            success : function (data) {
                if (data.status) {
                    var format_time = createDateFromStr(datatime).format('HH:MM mm/dd/yyyy');
                    var img_src = '';
                    var title = '';
                    if (comp_status === 1) {
                        img_src = '/images/wizard/success.png';
                        title = SM_PASS_ON + format_time;
                    } else if (comp_status === 3) {
                        img_src = '/images/wizard/error.png';
                        title = SM_FAIL_ON + format_time;
                    }
                    $('#mobile_title').show();
                    $('#mobile_title').find('img').attr('src', img_src);
                    $('#mobile_title').find('span').text(title);

                    $('#mobile_caption').show();

                    $('#mobile_setting').show();
                    var mobile_setting = data.comp_setting_details;
                    if (mobile_setting.length > 0) {
                        $.each(mobile_setting, function (index, value) {
                            var row = '<tr><td><img src="' + img_src + '"></img></td><td>&nbsp;&nbsp;' + value + '</td></tr>';
                            $('#mobile_setting').append(row);
                        });
                    }
                    //If more than one dialog is up, then first hide the current active modal dialog
                    //then show the new dialog, when the new one is closed, show the previous one
                    //This is done to prevent an Uncaught RangeError: Maximum call stack size exceeded exception that 
                    //is shown in the console if two dialogs are up at the same time.
                    var $currentModals = $('.modal.in');
                    if ($currentModals.length > 0) {
                        $currentModals.one('hidden', function () {
                            // when they've finished hiding
                            $('#mobile_detail_dlg').modal('show');
                            $('#mobile_detail_dlg').one('hidden', function () {
                                // when we close the dialog
                                $currentModals.modal('show');
                            });
                        }).modal('hide');
                    } else {
                        $("#mobile_detail_dlg").show();
                    }
                } else {
                    $('#error_msg').show().find('p').text(data.message);
                }

                $("#mobile_detail_dlg").modal();
            }
        });
    }
};
$(document).ready(S_MOBILE_DETAIL.init);
