$(document).ready(function() {                      
    var htmlSn = $("#sn").val();       
    var reportType = $("#report_type").val();               
    var urlTz = $.getUrlVar('tz');          
                       
    /*
     * Define a name for each widget in this page, this name is appended
     * div suffixes to show/hide/render widget pieces
     */
          
    getData();
    
    // Get the report data and setup the grid with the response
    function getData(sn){        
        $('#chart_empty').hide();
        var b_time = $('#start_time_picker').val();
        var e_time = $('#end_time_picker').val();
        var begin_time = $.getDateLocalToSecs(b_time);
        var end_time = $.getDateLocalToSecs(e_time); 
                    
        if(!begin_time || !end_time){ return; }
            
        var jqxhr = $.ajax({
           url: 'get_detail_data?report_type=' + reportType + '&sn=' + htmlSn + '&div=detail&on_demand=1&start_time=' + begin_time + '&end_time=' + end_time,
           method: 'GET',
           dataType: 'json',
           success: onSuccess,
           error: errorHandler
        });     
        return jqxhr;
    }     
    function onSuccess(series){
        // The column names and model are returned, once the grid is created it'll handle
        // the callbacks to retrieve the data
        jQuery('#report_table').GridUnload('#report_table');
        createDataGrid(series.col_names, series.col_model);
                
        $("#report_table").jqGrid('setGridParam',{datatype:'json'}).trigger('reloadGrid');        
    }    
                                                                
    function createDataGrid(col_names, col_model){
        $("#report_table").jqGrid({
            url:'detail_report?sn=' + htmlSn,
            datatype: 'json',
            mtype: 'GET',
            colNames: col_names,
            colModel: col_model,
            autoencode: true,
            pager: '#pager',
            pagerpos: 'right',
            toppager: true,
            rowNum: 100,
            rowList:[25, 50, 75, 100],
            sortname: 'name',
            sortorder: 'desc',
            caption: '',
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            loadui: 'block',
        
            loadError: errorHandler,
            loadComplete: function (data) {          
                if(data.records == 0){
                    $('#chart_empty').show();
                    $('#grid_data').hide();
                    return;
                }
                
                var startTime = $.getDateDisplay(data.time_range_begin, true, urlTz);
                var endTime = $.getDateDisplay(data.time_range_end, true, urlTz);
                jQuery("#report_table").jqGrid('setCaption', startTime + " - " + endTime); 
            }
        }).navGrid("#pager",{refresh:false,search:false,edit:false,add:false,del:false},{},{width:350},{});

        /*
        $("#searchBox").focus(function() {
            if ($(this).val() == "Search") {
                $(this).val(''); 
            }
        });
        */
    }

    function resizeme() {
        //$("#accordion").accordion('resize');
    }

    $(window).resize(function(){
        resizeme();
        //$("#accordion").height(800); //resize(120); //accordion('resize');
        //$("#list").setGridHeight($(window).height()-190);
    });               
    
    $(window).bind('resizeEnd', function() {
        var grid = "#report_table";
        var parent = "#grid_data";
        var grid_width = resizegrid();
        $("#webui_content").width(grid_width);
        $(grid).setGridWidth(100, true); 
        $(grid).setGridWidth($(parent).width(), true);
    });                                                                                                                                                                                                                                                                                                                                                                      
});
