var SERVER = {
    chosen: '',

    init: function(){
        SERVER.initUI();
        SERVER.initEvents();

        var tab_string = $('#mtabs > li:first > a').attr('id');
        SERVER.getTabData(tab_string);
    },

    initUI: function(){
    },

    initEvents: function(){
        $('#mtabs a').click(function (e) {
            var tab_string = $(this).attr('id');
            SERVER.getTabData(tab_string);
        })

        $(window).bind('resizeEnd', function() {
            if(SERVER.chosen == 'server_auth_audit_tab'){
                SERVER.resizeGrid("#grid_area","#auth_grid_data");
            }else if(SERVER.chosen == 'server_audit_summary_tab'){
                SERVER.resizeGrid("#audit_sum_grid_area","#audit_sum_grid_data");
            }else if(SERVER.chosen == 'server_audit_detail_tab'){
                SERVER.resizeGrid("#audit_grid_area","#audit_grid_data");    
            }
        });
    },

    getTabData: function(tab_string){
        SERVER.setPagesChosenTab(tab_string);
        $.ajax({
            url: '/report/get_server_tab?tab_name=' + tab_string,
            method: 'GET',
            dataType: 'html',
            success: SERVER.onDataReceived
        }); 
    },

    setPagesChosenTab: function(tab_string){
        if (tab_string === undefined){
            //If no tab has been set, do nothing.
        }else if (tab_string.indexOf('server_auth_audit') >= 0) {
            HELP_LINK_OVERRIDE = 7056;
            SERVER.chosen = 'server_auth_audit_tab';
        }else if (tab_string.indexOf('server_audit_detail') >= 0) {
            HELP_LINK_OVERRIDE = 7057;
            SERVER.chosen = 'server_audit_detail_tab';
        }else if (tab_string.indexOf('server_audit_summary') >= 0) {
            HELP_LINK_OVERRIDE = 7058;
            SERVER.chosen = 'server_audit_summary_tab';
        }
    },

    onDataReceived: function(data) {
        if (SERVER.chosen === undefined){
            //If no tab has been set, do nothing.
        }else if(SERVER.chosen == 'server_auth_audit_tab'){
            $('#auth_audit').html(data);
        }else if(SERVER.chosen == 'server_audit_summary_tab'){
            $('#audit_summary').html(data);
        }else if(SERVER.chosen == 'server_audit_detail_tab'){
            $('#audit_detail').html(data);
        }
        $("#custom_datepicker_trigger").click();
    },
    
    resizeGrid: function(grid, parent){
        var grid_width = resizegrid();
        $("#webui_content").width(grid_width);
        $(grid).setGridWidth(100, true); 
        $(grid).setGridWidth($(parent).width(), true);
        if(SERVER.chosen === 'server_audit_summary_tab'){
            if(window.plot_trend){
                plot_trend.replot();
            }
        }
        return;
    }
};

$(document).ready(SERVER.init);
