/*global IPHELPER, S_USER_MODE, lock_page, is_page_locked, writeErrorContainer, isChecked, validateDomainNameStr, show_db_builtin, org_db_ssl_mode:true, org_db_remote:true, org_db_user_name:true, org_db_host:true, org_db_port:true, org_db_name:true, org_db_location:true, org_db_name:true, host_validation_info, DatabaseConfigObj, confirm,
S_ERROR_RESTART_FAILED, S_DB_CHANGE_CONFIRMATION, S_ERROR_DB_NAME_SIZE, S_ERROR_DB_NAME_LONG, S_ERROR_DB_NAME_CHARS, S_ERROR_DB_HOST, S_ERROR_DB_HOST_LOCAL, S_ERROR_DB_PORT_NAME, S_ERROR_DB_USER_NAME_SIZE, S_ERROR_DB_USER_NAME_LONG, S_ERROR_DB_USER_NAME_CHARS, S_ERROR_DB_PASSWORD_EMPTY, S_DB_PORT_NAME, S_SHOW_ADV_SETTINGS, S_HIDE_ADV_SETTINGS,
S_RESTART_DB_TITLE, S_RESTART_DB_MSG, S_ERROR_VAL_NAN, S_ERROR_VAL_MIN, S_MAX_CONNECTIONS_NAME, S_SHARED_BUFFERS_NAME, S_WORK_MEM_NAME, S_CHECKPOINT_SEGMENTS_NAME, S_MAX_LOCKS_PER_TRANSACTION_NAME, S_EFFECTIVE_CACHE_SIZE_NAME  */
var S_DB_C = {

    needs_restart: false,   // track if we need to restart the server after save
    db_password_changed: false,
    db_password_value: '',  // Used to restore the database password when a user clicks away from that field.

    // setup the page
    init: function () {
        S_DB_C.initUI();
        S_DB_C.initEvents();
    },

    // initialize UI elements
    initUI: function () {
        $('#progress_test_db_conn').hide();
        $('#test_db_conn_results').hide();
        $('#progress_restarting').hide();
        $('#progress_save').hide();
        $('#error_container').hide();

        S_DB_C.db_password_value = $('#db_password').val();

        // DB location settings
        if (show_db_builtin === 'checked') {
            S_DB_C.showDbBuiltin();
        } else {
            S_DB_C.showDbExternal();
        }

        $('#db_ssl_mode').val(org_db_ssl_mode);

        // detect if any fields are changed
        var flds = $("input, textarea", window.document);
        $(flds).on('change keyup', flds, function (eo) {
            $('#error_container').hide();
            $('#test_db_conn_results').hide();
        });

        S_USER_MODE.show_warning_msg = true;

        // Check if the lock_page is in sessionStorage, this will be true
        // if user acquired a lock and clicked on refresh on the same page
        // and is in the same browser tab.
        S_DB_C.pg_tracker = window.sessionStorage.getItem(lock_page);

        $("#db_advanced").hide();

        var viewMode = WGRD.userInViewMode(is_page_locked, S_DB_C.pg_tracker);

        if (viewMode) {
            WGRD.enableUI(false, '#database_config');
            WGRD.enableUI(false, '#db_advanced');
        }
        S_USER_MODE.initUI(['#submit_button'], viewMode);
    },

    // add event handlers
    initEvents: function () {
        WGRD.pgUnloadCallBack(S_DB_C.pg_tracker, lock_page);
        // Indicate that the pass has changed, and store its new value.
        $('#db_password').change(function () {
            S_DB_C.db_password_changed = true;
            S_DB_C.db_password_value = $('#db_password').val();
        });

        // When the user selects the password field, empty it.
        $('#db_password').focus(function () {
            $('#db_password').val('');
        });

        // Set the db password back to what it was from its blank form when the user moves on.
        $('#db_password').blur(function () {
            $('#db_password').val(S_DB_C.db_password_value);
        });

        $('#radio_db_builtin').change(S_DB_C.showDbBuiltin);
        $('#radio_db_external').change(S_DB_C.showDbExternal);
        $('#test_db_conn').button().click(S_DB_C.testDbConn);
        $('#submit_button').button().click(S_DB_C.startSave);

        $('#advanced_settings_btn').click(S_DB_C.showHideAdvSettings);
        $('#restore_defaults_btn').button().click(S_DB_C.restoreAdvDefaults);

        S_USER_MODE.initEvents();
    },

    restoreAdvDefaults: function () {
        $('#max_connections').val(200);
        $('#shared_buffers').val('128');
        $('#work_mem').val('256');
        $('#checkpoint_segments').val('5');
        $('#max_locks_per_transaction').val('64');
        $('#effective_cache_size').val('1024');
    },

    showHideAdvSettings: function (event) {
        event.preventDefault();
        if ($('#db_advanced').is(':visible')) {
            $('#advanced_settings_btn').text(S_SHOW_ADV_SETTINGS);
        } else {
            $('#advanced_settings_btn').text(S_HIDE_ADV_SETTINGS);
        }
        $('#db_advanced').slideToggle();
    },

    showDbBuiltin: function () {
        $('#db_builtin').show();
        $('#db_external').hide();
        WGRD.enableUI(true, '#db_advanced');
        $("#adv_btn_div").show();
    },

    showDbExternal: function () {
        $('#db_builtin').hide();
        $('#db_external').show();
        WGRD.enableUI(false, '#db_advanced');
        $("#db_advanced").hide();
        $('#advanced_settings_btn').text(S_SHOW_ADV_SETTINGS);
        $("#adv_btn_div").hide();
    },


    testDbConn: function () {
        if (!S_DB_C.validateExternalDB()) {
            return;
        }

        $('#test_db_conn').button({'disabled': true});
        $('#test_db_conn_results').hide();
        $('#progress_test_db_conn').show();

        var db_password = S_DB_C.db_password_changed ? $('#db_password').val() : null;

        var test_data = {
            'name': $('#db_name').val(),
            'user': $('#db_user_name').val(),
            'host': IPHELPER.trimIP4($('#db_host').val()),
            'password': db_password,
            'port': parseInt($('#db_port').val(), 10),
            'sslmode': $('#db_ssl_mode').val()
        };

        $.ajax({
            url: 'test_db_conn',
            type: 'POST',
            dataType: 'json',
            data: test_data,
            success: S_DB_C.testDbResults,
            error: S_DB_C.testDbResultsError
        });
    },

    testDbResults: function (data) {
        $('#progress_test_db_conn').hide();

        if (data.status) {
            $('#test_db_conn_results').attr('class', 'success');
        } else {
            $('#test_db_conn_results').attr('class', 'fail');
        }
        $('#test_db_conn_results').text(data.message);
        $('#test_db_conn_results').show();
        $('#test_db_conn').button({'disabled': false});
    },

    testDbResultsError: function (data) {
        $('#progress_test_db_conn').hide();
        $('#test_db_conn_results').attr('class', 'fail');
        $('#test_db_conn_results').text(data.statusText + ": " + data.status);
        $('#test_db_conn_results').show();
        $('#test_db_conn').button({'disabled': false});
    },

    restartLogServer: function () {
        $('#submit_button').attr('disabled', true);
        $('#progress_restarting').show();
        $.ajax({
            url: 'restart_ls',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: S_DB_C.restartResults,
            error: S_DB_C.restartResultsError
        });
    },

    restartResults: function (data) {
        if (!data.status) {
            $('#progress_restarting').hide();
            $('#submit_button').removeAttr('disabled');
            writeErrorContainer(data.message, false);
        } else {
            // restart the wsserver/dxcpserver
            S_DB_C.restartWsserver();
        }
    },

    restartResultsError: function (data) {
        $('#progress_restarting').hide();
        $('#submit_button').removeAttr('disabled');
        writeErrorContainer(S_ERROR_RESTART_FAILED, false);
    },

    restartWsserver: function () {
        $.ajax({
            url: 'restart_wsserver',
            type: 'POST',
            data: '',
            success: function () {
                // wait for the wsserver to restart and reload the page
                var startTime = new Date().getTime();
                var timeout = 2 * 60 * 1000; // 2 mins
                var pollfunc = function () {
                    var currTime = new Date().getTime();
                    if (WGRD.isServerOnline() || startTime + timeout < currTime) {
                        S_DB_C._update_pagelock();  // reload the page / update the page lock
                    } else {
                        setTimeout(pollfunc, 1000);
                    }
                };
                setTimeout(pollfunc, 5000);
            },
            error: S_DB_C.restartResultsError
        });
    },

    startSave: function () {
        $('#error_container').hide();
        $('#submit_button').attr('disabled', true);
        $('#progress_save').show();

        // reset the needs_restart flag; this may be set in validateUI() and may be used after putData()
        S_DB_C.needs_restart = false;

        // validate the input
        if (!S_DB_C.validateUI()) {
            // validation failed
            $('#submit_button').removeAttr('disabled');
            $('#progress_save').hide();
            return;
        }

        S_DB_C.savePage();
    },

        // validate all UI input
    validateUI: function () {
        // validate the external DB settings
        if (!S_DB_C.validateExternalDB()) {
            return false;
        }

        // validate the advanced DB settings
        if (!S_DB_C.validateAdvancedDB()) {
            return false;
        }

        // warn the user if the db settings are changing
        var warn = false;

        // check the external db for changes
        if ((org_db_remote === '0' && isChecked('#radio_db_external')) || (org_db_remote === '1' && !isChecked('#radio_db_external'))) {
            warn = true;
        }
        if (isChecked('#radio_db_external') && !warn) {
            if ($('#db_user_name').val() !== org_db_user_name) {
                warn = true;
            } else if (S_DB_C.db_password_changed) {
                warn = true;
            } else if (IPHELPER.trimIP4($('#db_host').val()) !== org_db_host) {
                warn = true;
            } else if ($('#db_port').val() !== org_db_port) {
                warn = true;
            } else if ($('#db_ssl_mode').val() !== org_db_ssl_mode) {
                warn = true;
            } else if ($('#db_name').val() !== org_db_name) {
                warn = true;
            }
        }
        if (warn) {
            if (!confirm(S_DB_CHANGE_CONFIRMATION)) {
                return false;
            }
            S_DB_C.needs_restart = true;
        }

        // check the builtin db for changes
        if (!warn && isChecked('#radio_db_builtin')) {
            if ($('#max_connections').val() !== org_db_max_connections) {
                warn = true;
            } else if ($('#shared_buffers').val() !== org_db_shared_buffers) {
                warn = true;
            } else if ($('#work_mem').val() !== org_db_working_memory) {
                warn = true;
            } else if ($('#checkpoint_segments').val() !== org_db_checkpoint_segments) {
                warn = true;
            } else if ($('#max_locks_per_transaction').val() !== org_db_max_locks_per_transaction) {
                warn = true;
            } else if ($('#effective_cache_size').val() !== org_db_effective_cache_size) {
                warn = true;
            }
            if (warn) {
                if (!confirm(S_RESTART_DB_MSG)) {
                    return false;
                }
            }
        }

        return true;
    },

    validateExternalDBHost: function (host) {
        var is_usable_ip = (IPHELPER.usableHostIP4(host) === 0);
        var is_valid = is_usable_ip || validateDomainNameStr(host);
        //Not a valid IPv4 address or hostname
        if (!is_valid) {
            return 1;
        }

        // No validation information
        if (host_validation_info.length === 0) {
            return 0;
        }

        var i = 0;
        var validation = host_validation_info[0];
        // validate IP address
        if (is_usable_ip) {
            var sys_ips = validation.sys_ips;
            for (i = 0; i < sys_ips.length; i++) {
                if (host === sys_ips[i].ip_addr.split('/')[0]) {
                    return 2;
                }
            }
            // vm-host public IP addresses
            if (validation.is_vmhost === 1) {
                var sys_public_ips = validation.sys_public_ips;
                for (i = 0; i < sys_public_ips.length; i++) {
                    if (host === sys_public_ips[i].ip) {
                        return 2;
                    }
                }
            }
        } else {
            var sys_hostname = validation.sys_hostname;
            if (host === sys_hostname) {
                return 2;
            }
            // vm-host public hostnames
            if (validation.is_vmhost === 1) {
                var sys_public_hostnames = validation.sys_public_hostnames;
                for (i = 0; i < sys_public_hostnames.length; i++) {
                    if (host === sys_public_hostnames[i].name) {
                        return 2;
                    }
                }
            }
        }
        return 0;
    },

    validateExternalDB: function () {
        // external DB
        if (isChecked('#radio_db_external')) {

            var patt = /.*[@=,\/_;#'"*?`\[\]\\].*/;

            // db name can't be empty or larger than 64 chars
            if (!S_DB_C.validateEmptyField('#db_name', 0, S_ERROR_DB_NAME_SIZE)) {
                return false;
            }
            if ($('#db_name').val().length > 64) {
                $('#db_name').focus();
                $('#db_name').select();
                writeErrorContainer(S_ERROR_DB_NAME_LONG, false);
                return false;
            }
            if (patt.test($('#db_name').val())) {
                $('#db_name').focus();
                $('#db_name').select();
                writeErrorContainer(S_ERROR_DB_NAME_CHARS, false);
                return false;
            }

            // validate datebase host, a IPv4 address or hostname,
            // also can't be Dimension's own local/public IPv4 addresses or hostnames.
            var ret = S_DB_C.validateExternalDBHost($.trim($('#db_host').val()));
            if (ret === 1) {
                $('#db_host').focus();
                $('#db_host').select();
                writeErrorContainer(S_ERROR_DB_HOST, false);
                return false;
            }
            if (ret === 2) {
                $('#db_host').focus();
                $('#db_host').select();
                writeErrorContainer(S_ERROR_DB_HOST_LOCAL, false);
                return false;
            }

            // port - 1-65535
            var db_port_error = WGRD.isValidNumeric($('#db_port'), S_DB_PORT_NAME);
            if (db_port_error && db_port_error.length > 0) {
                $('#db_port').focus();
                $('#db_port').select();
                writeErrorContainer(db_port_error, false);
                return false;
            }

            /* username - can't be empty or larger than 64 chars. For now
             * apply the same restrictions as we do for database name,
             * except for allowing the @ character. We will need to eventually
             * relax this and only enforce the length restriction. But to do
             * that we need to make sure the connection string has the username
             * quoted using ' characters and any ' and \ characters in the name
             * escaped. This needs to be done for both the C and Python wgdb
             * interfaces.
             */
            var user_patt = /.*[=,\/_;#'"*?`\[\]\\].*/;
            if (!S_DB_C.validateEmptyField('#db_user_name', 0, S_ERROR_DB_USER_NAME_SIZE)) {
                return false;
            }
            if ($('#db_name').val().length > 64) {
                $('#db_user_name').focus();
                $('#db_user_name').select();
                writeErrorContainer(S_ERROR_DB_USER_NAME_LONG, false);
                return false;
            }

            if (user_patt.test($('#db_user_name').val())) {
                $('#db_user_name').focus();
                $('#db_user_name').select();
                writeErrorContainer(S_ERROR_DB_USER_NAME_CHARS, false);
                return false;
            }

            // password cannot be empty
            if (!S_DB_C.validateEmptyField('#db_password', 0, S_ERROR_DB_PASSWORD_EMPTY)) {
                return false;
            }
        }

        return true;
    },

    validateEmptyField: function (elm_str, tab_index, error_str) {
        if ($(elm_str).val().length === 0) {
            return S_DB_C._show_error_msg(elm_str, tab_index, error_str);
        }
        return true;
    },

    validateAdvancedDB: function () {
        if (isChecked('#radio_db_builtin')) {
            // maximum connections - 200+
            var max_conn_val = parseInt($('#max_connections').val(), 10);
            var max_conn_min = parseInt($('#max_connections').attr("min"), 10);
            if (!isFinite(max_conn_val) || $('#max_connections').val() !== max_conn_val.toString()) {
                writeErrorContainer(S_ERROR_VAL_NAN.format(S_MAX_CONNECTIONS_NAME), false);
                return false;
            }
            if (max_conn_val < max_conn_min) {
                writeErrorContainer(S_ERROR_VAL_MIN.format(S_MAX_CONNECTIONS_NAME, max_conn_min), false);
                return false;
            }

            // shared buffers - 128-50% system memory
            var shared_buffers_error = WGRD.isValidNumeric($('#shared_buffers'), S_SHARED_BUFFERS_NAME);
            if (shared_buffers_error && shared_buffers_error.length > 0) {
                $('#shared_buffers').focus();
                $('#shared_buffers').select();
                writeErrorContainer(shared_buffers_error, false);
                return false;
            }

            // working memory - 64-256
            var work_mem_error = WGRD.isValidNumeric($('#work_mem'), S_WORK_MEM_NAME);
            if (work_mem_error && work_mem_error.length > 0) {
                $('#work_mem').focus();
                $('#work_mem').select();
                writeErrorContainer(work_mem_error, false);
                return false;
            }

            // checkpoint segments - 5+
            var check_seg_val = parseInt($('#checkpoint_segments').val(), 10);
            var check_seg_min = parseInt($('#checkpoint_segments').attr("min"), 10);
            if (!isFinite(check_seg_val) || $('#checkpoint_segments').val() !== check_seg_val.toString()) {
                writeErrorContainer(S_ERROR_VAL_NAN.format(S_CHECKPOINT_SEGMENTS_NAME), false);
                return false;
            }
            if (check_seg_val < check_seg_min) {
                writeErrorContainer(S_ERROR_VAL_MIN.format(S_CHECKPOINT_SEGMENTS_NAME, check_seg_min), false);
                return false;
            }

            // maximum locks per transaction - 64-256
            var max_locks_per_transaction_error = WGRD.isValidNumeric($('#max_locks_per_transaction'), S_MAX_LOCKS_PER_TRANSACTION_NAME);
            if (max_locks_per_transaction_error && max_locks_per_transaction_error.length > 0) {
                $('#max_locks_per_transaction').focus();
                $('#max_locks_per_transaction').select();
                writeErrorContainer(max_locks_per_transaction_error, false);
                return false;
            }

            // effective cache size - 1024- typical OS disk cache size
            var effective_cache_size_error = WGRD.isValidNumeric($('#effective_cache_size'), S_EFFECTIVE_CACHE_SIZE_NAME);
            if (effective_cache_size_error && effective_cache_size_error.length > 0) {
                $('#effective_cache_size').focus();
                $('#effective_cache_size').select();
                writeErrorContainer(effective_cache_size_error, false);
                return false;
            }
        }

        return true;
    },

    _show_error_msg: function (elm_str, tab_index, error_str) {
        $(elm_str).focus();
        $(elm_str).select();
        writeErrorContainer(error_str, false);
        return false;
    },

    _update_pagelock: function () {
        WGRD.updateModeUI(1);  // Update the user mode div
        WGRD.resetUserMode();  // Reset the lock
    },

    // entry point for submitting the changes to the server
    savePage: function () {
        $('#error_container').hide();
        $('#submit_button').attr('disabled', true);
        $('#progress_save').show();

        var obj = new DatabaseConfigObj();
        obj.db_remote = isChecked('#radio_db_external');
        obj.db_name = $.trim($('#db_name').val());
        obj.db_host = IPHELPER.trimIP4($.trim($('#db_host').val()));
        obj.db_port = parseInt($('#db_port').val(), 10);
        obj.db_ssl_mode = $('#db_ssl_mode').val();
        obj.db_user_name = $('#db_user_name').val();
        obj.db_password = S_DB_C.db_password_changed ? $('#db_password').val() : null;
        obj.db_location = org_db_location; // preserve the DB location

        if ((org_db_remote === '0' && obj.db_remote) || (org_db_remote === '1' && !obj.db_remote)) {
            obj.db_remote_changed = true;
        } else {
            obj.db_remote_changed = false;
        }

        obj.db_max_connections = parseInt($('#max_connections').val(), 10);
        obj.db_shared_buffers = parseInt($('#shared_buffers').val(), 10);
        obj.db_working_memory = parseInt($('#work_mem').val(), 10);
        obj.db_checkpoint_segments = parseInt($('#checkpoint_segments').val(), 10);
        obj.db_max_locks_per_transaction = parseInt($('#max_locks_per_transaction').val(), 10);
        obj.db_effective_cache_size = parseInt($('#effective_cache_size').val(), 10);

        // save the data to the server
        WGRD.putData(obj).success(function (response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                // update all saved org_ variables to the latest values
                org_db_remote = isChecked('#radio_db_external').toString();
                org_db_user_name = $('#db_user_name').val();
                org_db_host = IPHELPER.trimIP4($('#db_host').val());
                org_db_port = $('#db_port').val();
                org_db_ssl_mode = $('#db_ssl_mode').val();
                org_db_name = $('#db_name').val();

                org_db_max_connections = $('#max_connections').val();
                org_db_shared_buffers = $('#shared_buffers').val();
                org_db_working_memory = $('#work_mem').val();
                org_db_checkpoint_segments = $('#checkpoint_segments').val();
                org_db_max_locks_per_transaction = $('#max_locks_per_transaction').val();
                org_db_effective_cache_size = $('#effective_cache_size').val();

                //
                // restart the server, if needed
                //
                if (S_DB_C.needs_restart) {
                    S_DB_C.restartLogServer();
                    // page lock is updated after the servers restart via _update_pagelock()
                } else {
                    // update page lock
                    S_DB_C._update_pagelock();
                }
            }
        });
    }
};
$(document).ready(S_DB_C.init);
