/*global using_local_db, procTableColNames, procTableColModel */
var S_DB_D = {

    // setup the page
    init : function () {
        S_DB_D.initUI();
        S_DB_D.initEvents();
    },

    // initialize UI elements
    initUI : function () {
        S_DB_D.toggleBuiltinInfo(using_local_db);

        S_DB_D.createProcessGrid();
        S_DB_D.refreshLogList();
        S_DB_D.refreshStatusReport();
    },

    // add event handlers
    initEvents : function () {
        $('#refresh_process_table').button().click(function () {
            var attr = $('#refresh_process_table').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                $('#process_table').jqGrid('setGridParam', {loadui: 'block', datatype: S_DB_D.refreshProcessGrid()});
            }
        });

        $('#refresh_log_list').button().click(function () {
            var attr = $('#refresh_log_list').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                S_DB_D.refreshLogList();
            }
        });

        $('#log_select').change(function () {
            $('#refresh_log').click();
        });

        $('#refresh_log').button().click(function () {
            var attr = $('#refresh_log').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                S_DB_D.refreshLog();
            }
        });

        $('#btn_refresh_status_report').button().click(S_DB_D.refreshStatusReport);

        $(window).bind('resizeEnd', function () {
            S_DB_D.doResize();
        });
    },

    toggleBuiltinInfo: function (local_db) {
        if (local_db === 0) {
            $('#processes_div').hide();
            $('#log_panel_div').hide();
        } else {
            $('#processes_div').show();
            $('#log_panel_div').show();
        }
    },

    createProcessGrid: function () {
        $('#process_table').jqGrid({
            loadonce: true,
            loadui: 'block',
            datatype: S_DB_D.refreshProcessGrid,
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            colNames: procTableColNames,
            colModel: procTableColModel,
            sortname: 'name',
            viewrecords: true,
            sortorder: 'asc'
        });
    },

    refreshProcessGrid: function () {
        WGRD.enableUIElements(false, ['#refresh_process_table']);
        $('#progress_refresh_process_table').show();
        $('#process_table').jqGrid('clearGridData');

        $.ajax({
            url: 'process_info',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function (data) {
                // update the table with the new data
                $('#process_table').jqGrid('setGridParam', {
                    rowNum: data.length,  // show all rows
                    datatype: 'local',
                    data: data
                });
                $('#process_table').trigger('reloadGrid');
            },
            error: function (response) {
                $('#process_table').jqGrid('setGridParam', {datatype: 'local'});
            },
            complete: function () {
                $('#progress_refresh_process_table').hide();
                WGRD.enableUIElements(true, ['#refresh_process_table']);
                S_DB_D.doResize();
            }
        });
    },

    refreshLogList: function () {
        WGRD.enableUIElements(false, ['#log_select', '#refresh_log_list']);
        $('#progress_refresh_log_list').show();

        var sel_log = $('#log_select').val();

        $.ajax({
            url: 'get_log_list',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function (response) {
                // update the choice box with the new data
                $('#log_select option').remove();
                var found_log = false;
                $.each(response.data, function (index, item) {
                    $('#log_select').append('<option value="' + item + '">' + item + '</option>');
                    if (item === sel_log) {
                        found_log = true;
                    }
                });

                // refresh log contents if selected log changed
                if (found_log) {
                    $('#log_select').val(sel_log);
                } else if ($('#log_select').val()) {
                    S_DB_D.refreshLog();
                } else {
                    WGRD.enableUIElements(false, ['#refresh_log']);
                    $('#progress_refresh_log').hide();
                }
            },
            error: function (response) {
                $('#log_contents').val('');
            },
            complete: function () {
                $('#progress_refresh_log_list').hide();
                WGRD.enableUIElements(true, ['#log_select', '#refresh_log_list']);
            }
        });
    },

    refreshLog: function () {
        WGRD.enableUIElements(false, ['#refresh_log', '#log_select', '#refresh_log_list']);
        $('#progress_refresh_log').show();
        $('#log_contents').val('');

        var lines = 100;  // default
        var error = WGRD.isValidNumeric($('#log_lines'), '');
        if (!error || error.length === 0) {
            lines = parseInt($('#log_lines').val(), 10);
        } else {
            $('#log_lines').val(lines);
        }

        if ($('#log_select').val() !== null) {
            $.ajax({
                url: 'get_log',
                type: 'POST',
                dataType: 'json',
                data: {'log_name': $('#log_select').val(), 'num_lines': lines},
                success: function (response) {
                    // update the text area with the new data
                    $('#log_contents').val(response.data);
                },
                error: function (response) {
                    $('#log_contents').val('');
                },
                complete: function () {
                    $('#progress_refresh_log').hide();
                    WGRD.enableUIElements(true, ['#refresh_log', '#log_select', '#refresh_log_list']);
                }
            });
        }
    },

    refreshStatusReport : function () {
        WGRD.enableUIElements(false, ['#btn_refresh_status_report']);
        $('#progress_refresh_status_report').show();
        $('#status_report_results').val('');

        $.ajax({
            url: 'get_status_report',
            type: 'POST',
            dataType: 'json',
            success: function (response) {
                // update the text area with the new data
                $('#status_report_results').val(response.data);
            },
            error: function (response) {
                $('#status_report_results').val('');
            },
            complete: function () {
                $('#progress_refresh_status_report').hide();
                WGRD.enableUIElements(true, ['#btn_refresh_status_report']);
            }
        });
    },

    doResize: function () {
        var padleft = parseInt($("#processes_div").css('margin-left'), 10);
        var grid_width = $("#processes_div").width() - padleft * 2;
        $('#process_table').setGridWidth(grid_width);
    }
};
$(document).ready(S_DB_D.init);