/*global POLLER, WGRD, setBarWidths, checkLoginPageRedirect, S_ERROR_REMOTE_BACKUP, S_CREATE_SNAPSHOT_TITLE, S_ERROR_CREATE_IN_PROGRESS, S_ERROR_RESTORE_IN_PROGRESS, S_CREATE_SNAPSHOT_MSG, S_RESTORE_SNAPSHOT_TITLE, S_SERVER_RESTART_MSG, S_ERROR_RESTORE_SNAPSHOT_EMPTY, S_RESTORE_SNAPSHOT_LOCAL_EMPTY, S_RESTORE_SNAPSHOT_LOCAL_DISABLED, S_DB_UPGRADE_TITLE, S_DB_UPGRADE_CONFIRMATION_MSG,S_DB_UPGRADE_MSG ,S_ERR_ACTION_DB_UPGRADE */
var S_DB_S = {

    remote_backup_enabled: false,
    create_snapshot_inprogress: false,
    restore_snapshot_inprogress: false,  // server-reported status for global restore action
    restore_snapshot_initiated: false,   // restore action initiated here
    poller: null,

    // setup the page
    init: function () {
        S_DB_S.initUI();
        S_DB_S.initEvents();
    },

    // initialize UI elements
    initUI: function () {
        WGRD.enableUIElements(false, ['#btn_db_start', '#btn_db_stop', '#btn_db_restart']);
        WGRD.enableUIElements(false, ['#btn_create_snapshot', '#btn_restore_snapshot']);

        S_DB_S.updateDbInfo();
        S_DB_S.createLogFreqChart();
        S_DB_S.getLogFreqChartData();
    },

    // add event handlers
    initEvents: function () {
        $('#btn_db_start').button().click(S_DB_S.startDb);
        $('#btn_db_stop').button().click(S_DB_S.stopDb);
        $('#btn_db_restart').button().click(S_DB_S.restartDb);
        $('#btn_db_upgrade').button().click(S_DB_S.upgradeDb);

        $('#btn_create_snapshot').click(S_DB_S.createSnapshot);
        $('#btn_restore_snapshot').click(S_DB_S.restoreSnapshot);
        $('#restore_snapshot_local').click(S_DB_S.toggleSnapshotRestoreType);
        $('#restore_snapshot_upload').click(S_DB_S.toggleSnapshotRestoreType);

        $('#btn_refresh_freq').click(function (e) {
            e.preventDefault();
            S_DB_S.getLogFreqChartData();
        });

        $('#refresh_process_table').button().click(function () {
            var attr = $('#refresh_process_table').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                $('#process_table').jqGrid('setGridParam', {loadui: 'block', datatype: S_DB_S.refreshProcessGrid()});
            }
        });

        $('#refresh_log_list').button().click(function () {
            var attr = $('#refresh_log_list').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                S_DB_S.refreshLogList();
            }
        });

        $('#log_select').change(function () {
            $('#refresh_log').click();
        });

        $('#refresh_log').button().click(function () {
            var attr = $('#refresh_log').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                S_DB_S.refreshLog();
            }
        });

        $('#btn_refresh_status_report').button().click(S_DB_S.refreshStatusReport);

        $(window).bind('resizeEnd', function () {
            S_DB_S.doResize();
        });

        // start a poller to refresh the db info every minute
        S_DB_S.poller = new POLLER('db_info', {'interval': '5'}, 60000, S_DB_S.dbInfoRefreshSuccessHandler, S_DB_S.dbInfoRefreshErrorHandler);
    },

    dbInfoRefreshSuccessHandler: function (response) {
        S_DB_S.updateDbInfoUI(response);
        return true;
    },

    dbInfoRefreshErrorHandler: function (response, num_failed) {
        $('#progress_db_action').hide();
        return true;
    },

    startDb: function () {
        S_DB_S.dbAction('start');
    },

    stopDb: function () {
        S_DB_S.dbAction('stop');
    },

    restartDb: function () {
        S_DB_S.dbAction('restart');
    },

    dbAction: function (param) {
        $('#progress_db_action').show();
        WGRD.enableUIElements(false, ['#btn_db_start', '#btn_db_stop', '#btn_db_restart']);
        if (S_DB_S.poller !== null) {
            S_DB_S.poller.pause();
        }

        $.ajax({
            url: 'db_action?action=' + param + '&db_loc=' + $('#db_location').text(),
            type: 'POST',
            dataType: 'json',
            data: '',
            success: S_DB_S.updateDbInfo,
            error: S_DB_S.updateDbInfo
        });
    },

    upgradeDb: function () {
        $('#confirmBoxDiv h3').text(S_DB_UPGRADE_TITLE);
        WGRD.confirmModal(S_DB_UPGRADE_CONFIRMATION_MSG, true, S_DB_S._upgradeDb, true);
    },

    _upgradeDb: function () {
        var start_enabled = true;
        if ($('#btn_db_start').attr('disabled')) {
            start_enabled = false;
        }

        // update the ui
        $('#progress_db_action').show();
        WGRD.enableUIElements(false, ['#btn_db_start', '#btn_db_stop', '#btn_db_restart', '#btn_db_upgrade']);
        if (S_DB_S.poller !== null) {
            S_DB_S.poller.pause();
        }

        // send the upgrade request
        $.ajax({
            url: 'db_upgrade',
            type: 'POST',
            dataType: 'json',
            success: function (response) {
                if (response.status) {
                    // success, wait for wsserver to restart
                    var dlg = WGRD.okMessageModal(S_DB_UPGRADE_MSG, S_DB_UPGRADE_TITLE);
                    WGRD.redirectAfterRestart(dlg, '/servers/database/status', 2 * 60 * 1000);
                } else {
                    //     reset the ui and show an error message
                    $('#progress_db_action').hide();
                    WGRD.enableUIElements(start_enabled, ['#btn_db_start']);
                    WGRD.enableUIElements(!start_enabled, ['#btn_db_stop', '#btn_db_restart']);
                    WGRD.enableUIElements(true, ['#btn_db_upgrade']);
                    if (S_DB_S.poller !== null) {
                        S_DB_S.poller.resume(false);
                    }
                    WGRD.okMessageModal(S_ERR_ACTION_DB_UPGRADE, S_DB_UPGRADE_TITLE);
                }
            },
            error: function (response) {
                // reset the ui and show an error message
                $('#progress_db_action').hide();
                WGRD.enableUIElements(start_enabled, ['#btn_db_start']);
                WGRD.enableUIElements(!start_enabled, ['#btn_db_stop', '#btn_db_restart']);
                WGRD.enableUIElements(true, ['#btn_db_upgrade']);
                if (S_DB_S.poller !== null) {
                    S_DB_S.poller.resume(false);
                }
                WGRD.okMessageModal(S_ERR_ACTION_DB_UPGRADE, S_DB_UPGRADE_TITLE);
            }
        });
    },

    // ajax call to get some updated db info and refresh the UI
    updateDbInfo: function () {
        $.ajax({
            url: 'db_info',
            type: 'POST',
            dataType: 'json',
            data: {'interval': 0.2},
            success: function (data) {
                S_DB_S.updateDbInfoUI(data);
            }
        });
    },

    updateDbInfoUI: function (data) {
        if (data.db_location === undefined) {
            $('#db_location').html('');
        } else {
            $('#db_location').html(data.db_location);
        }
        if (data.uptime === undefined) {
            $('#db_uptime').html('');
        } else {
            $('#db_uptime').html(data.uptime);
        }
        if (data.memory === undefined) {
            $('#db_memory').html('');
        } else {
            $('#db_memory').html(data.memory);
        }
        if (data.disk_usage === undefined) {
            $('#db_du').html('');
        } else {
            $('#db_du').html(data.disk_usage);
        }

        var avail_str = '';
        if (data.db_avail !== undefined) {
            avail_str += data.db_avail;
        }
        if (data.db_status !== undefined) {
            if (avail_str.length === 0) {
                avail_str = data.db_avail;
            } else if (data.db_status.length > 0) {
                avail_str += ' <em>(' + data.db_status + ')</em>';
            }
        }
        $('#db_avail').html(avail_str);

        if (data.avail === undefined || data.avail === -1 || data.using_local_db === 0) {
            // server is not available or is remote
            WGRD.enableUIElements(false, ['#btn_db_start', '#btn_db_stop', '#btn_db_restart']);
        } else if (data.avail !== 1) {
            // db is not available
            WGRD.enableUIElements(true, ['#btn_db_start']);
            WGRD.enableUIElements(false, ['#btn_db_stop', '#btn_db_restart']);
        } else {
            // db is available
            WGRD.enableUIElements(true, ['#btn_db_stop', '#btn_db_restart']);
            WGRD.enableUIElements(false, ['#btn_db_start']);
        }

        if (data.upgrade === undefined || data.upgrade === 0) {
            $('#btn_db_upgrade').hide();
        } else {
            $('#btn_db_upgrade').show();
        }

        S_DB_S.remote_backup_enabled = data.remote_backup_enabled;
        S_DB_S.create_snapshot_inprogress = data.create_snapshot_inprogress;
        S_DB_S.restore_snapshot_inprogress = data.restore_snapshot_inprogress;
        $('#is_creating_alert').toggle(S_DB_S.create_snapshot_inprogress);
        $('#is_restoring_alert').toggle(S_DB_S.restore_snapshot_inprogress);
        WGRD.enableUIElements(!S_DB_S.restore_snapshot_inprogress && !S_DB_S.create_snapshot_inprogress, ['#btn_create_snapshot', '#btn_restore_snapshot']);

        $('#progress_db_action').hide();
        if (S_DB_S.poller !== null) {
            S_DB_S.poller.resume(false);
        }
    },

    createSnapshot: function () {
        // check if remote backup is enabled
        if (!S_DB_S.remote_backup_enabled) {
            WGRD.okMessageModal(S_ERROR_REMOTE_BACKUP, S_CREATE_SNAPSHOT_TITLE);
            return;
        }

        // check if an action is already in progress
        if (S_DB_S.create_snapshot_inprogress) {
            WGRD.okMessageModal(S_ERROR_CREATE_IN_PROGRESS, S_CREATE_SNAPSHOT_TITLE);
            return;
        }
        if (S_DB_S.restore_snapshot_inprogress) {
            WGRD.okMessageModal(S_ERROR_RESTORE_IN_PROGRESS, S_CREATE_SNAPSHOT_TITLE);
            return;
        }

        // confirmation dialog
        WGRD.setConfirmModalTitle(S_CREATE_SNAPSHOT_TITLE);
        WGRD.confirmModal(S_CREATE_SNAPSHOT_MSG, true, S_DB_S._createSnapshot, true);
    },

    _createSnapshot: function () {
        // initiate the snapshot creation
        $.ajax({
            url: 'create_snapshot',
            dataType: 'json',
            method: 'POST',
            success: function (data) {
                if (data.status) {
                    $('#is_creating_alert').show();
                    WGRD.closeModal();
                } else {
                    WGRD.okMessageModal(data.message, S_CREATE_SNAPSHOT_TITLE);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                WGRD.okMessageModal(textStatus, S_CREATE_SNAPSHOT_TITLE);
            }
        });
    },

    restoreSnapshot: function () {
        // check if an action is already in progress
        if (S_DB_S.create_snapshot_inprogress) {
            WGRD.okMessageModal(S_ERROR_CREATE_IN_PROGRESS, S_RESTORE_SNAPSHOT_TITLE);
            return;
        }
        if (S_DB_S.restore_snapshot_inprogress) {
            WGRD.okMessageModal(S_ERROR_RESTORE_IN_PROGRESS, S_RESTORE_SNAPSHOT_TITLE);
            return;
        }

        WGRD.doModal('#restore_snapshot_dlg',
                    S_DB_S.initializeRestoreSnapshot,
                    S_DB_S.saveRestoreSnapshot,
                    null,  // params
                    null,  // cancelHandler
                    true); // stayOpenOnSave
    },

    initializeRestoreSnapshot: function (params) {
        // clear any existing related divs from the iframe
        $('#restoreSnapshotFrame').empty();
        $('#restore_snapshot_form')[0].reset();  // needed to clear the file input in IE

        // Initialize UI
        WGRD.enableUIElements(false, ['#restore_snapshot_local', '#restore_snapshot_local_fname', '#restore_snapshot_upload', '#restore_snapshot_upload_file', '#restore_snapshot_ok']);
        $("#restore_snapshot_local").prop("checked", false);
        $("#restore_snapshot_upload").prop("checked", false);
        $('#restore_snapshot_local_fname').empty();
        $('#restore_snapshot_local_info').hide();
        $('#restore_snapshot_processing').hide();
        $('#restore_snapshot_loading').show();

        // get the snapshot list from the server
        $.ajax({
            url: 'snapshot_list',
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                if (data.snapshot_list !== null) {
                    // build the list of available snapshots
                    var options = $('#restore_snapshot_local_fname');
                    $.each(data.snapshot_list, function () {
                        options.append($("<option />").val(this.path).text(this.name));
                    });

                    // update the UI controls
                    WGRD.enableUIElements(true, ['#restore_snapshot_local']);
                    if (data.snapshot_list.length === 0) {
                        // remote backups enabled, but no snapshots available
                        $('#restore_snapshot_local_info').html('<em>' + S_RESTORE_SNAPSHOT_LOCAL_EMPTY + '</em>');
                        $('#restore_snapshot_local_info').show();
                    }
                } else {
                    // remote backups disabled
                    $('#restore_snapshot_local_info').html('<em>' + S_RESTORE_SNAPSHOT_LOCAL_DISABLED + '</em>');
                    $('#restore_snapshot_local_info').show();
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                WGRD.okMessageModal(textStatus, S_RESTORE_SNAPSHOT_TITLE);
            },
            complete: function () {
                // always allow uploading a snapshot file
                WGRD.enableUIElements(true, ['#restore_snapshot_upload', '#restore_snapshot_ok']);
                S_DB_S.toggleSnapshotRestoreType();
                $('#restore_snapshot_loading').hide();
            }
        });

        return true;
    },

    saveRestoreSnapshot: function (params) {
        // make sure a file is selected
        if ($('#restore_snapshot_local').is(':checked') && !$('#restore_snapshot_local_fname').val()) {
            return S_ERROR_RESTORE_SNAPSHOT_EMPTY;
        }
        if ($('#restore_snapshot_upload').is(':checked') && !$('#restore_snapshot_upload_file').val()) {
            return S_ERROR_RESTORE_SNAPSHOT_EMPTY;
        }
        if (!$('#restore_snapshot_local').is(':checked') && !$('#restore_snapshot_upload').is(':checked')) {
            return S_ERROR_RESTORE_SNAPSHOT_EMPTY;
        }

        // set both tracking variables to indicate that a restore is in progress and that we initiated it
        S_DB_S.restore_snapshot_inprogress = true;
        S_DB_S.restore_snapshot_initiated = true;
        WGRD.enableUIElements(false, ['#restore_snapshot_close', '#restore_snapshot_ok']);

        // we submit the certs to the server and rely on the iframe reload to close the dialog
        $('#restore_snapshot_form').submit();
        return;
    },

    restoreSnapshotStarted: function () {
        if (!S_DB_S.restore_snapshot_initiated) {  // check if we initiated the action
            return;
        }

        // check for any errors
        var results = $('#restoreSnapshotFrame').contents().find('#restore_snapshot_results_err').text();
        if (results) {
            $('#restore_snapshot_error').html(results);
            $('#restore_snapshot_error').show();
            $('#restore_snapshot_processing').hide();
            WGRD.enableUIElements(true, ['#restore_snapshot_close', '#restore_snapshot_ok']);
            S_DB_S.restore_snapshot_inprogress = false;
            S_DB_S.restore_snapshot_initiated = false;
        } else {
            // no errors so hide the dialog
            $('#restore_snapshot_dlg').modal('hide');

            // show the "restore in progress" banner
            $('#is_restoring_alert').show();

            // get the restore task filename
            var task = $('#restoreSnapshotFrame').contents().find('#restore_snapshot_results_task').text();
            if (!task) {
                task = null;
            }

            // redirect to login page (2 minute timeout)
            var dlg = WGRD.okMessageModal(S_SERVER_RESTART_MSG, S_RESTORE_SNAPSHOT_TITLE);
            setTimeout(function () {
                // delay the server polling so the okMessageModal animation doesn't get starved
                WGRD.redirectAfterRestartOrTask(dlg, '/servers/database/status', task, 2 * 60 * 1000);
                $('#restore_snapshot_processing').show();
            }, 300);
        }
    },

    toggleSnapshotRestoreType: function () {
        WGRD.enableUIElements($('#restore_snapshot_local').is(':checked'), ['#restore_snapshot_local_fname']);
        WGRD.enableUIElements($('#restore_snapshot_upload').is(':checked'), ['#restore_snapshot_upload_file']);
    },

    //
    // Log Frequency Chart
    //
    plot_trend : null,
    chartType : 'bar',
    seriesLength: 0,

    createLogFreqChart: function () {
        /* chart control buttons */
        $('#log_frequency_bar').click(function () {
            S_DB_S.chartType = 'bar';
            S_DB_S.getLogFreqChartData();
        });
        $('#log_frequency_line').click(function () {
            S_DB_S.chartType = 'line';
            S_DB_S.getLogFreqChartData();
        });
    },

    getLogFreqChartData: function (start, end) {
        S_DB_S.showChartLoading();
        var myurl = 'log_data_frequency';
        if (start !== null && end !== null) {
            myurl = 'log_data_frequency?start=' + start + '&end=' + end;
            if (start > end) {
                myurl = 'log_data_frequency?start=' + end + '&end=' + start;
            }
            $('#log_frequency_reset').show();
        } else {
            $('#log_frequency_reset').hide();
        }
        $.ajax({
            url: myurl,
            method: 'GET',
            dataType: 'json',
            error: S_DB_S.checkLoginPageRedirect,
            success: S_DB_S.onDataReceived
        });
    },

    onDataReceived: function (series) {
        var i;
        $('#div_log_frequency').show();
        $('#log_frequency_graph').show();
        $('#log_frequency_loading').hide();
        $.jqplot.config.enablePlugins = true; // on the page before plot creation.

        if (S_DB_S.plot_trend) {
            $("#log_frequency_graph *").unbind();
            S_DB_S.plot_trend.destroy();
        }

        var options = S_DB_S.line_options;
        if (S_DB_S.chartType === 'bar') {
            options = S_DB_S.bar_options;
        }

        if (series === null || series.length === 0) {
            // use default scale and null series when there is no data
            options.axes.xaxis.min = 0;
            options.axes.xaxis.max = 100;
            S_DB_S.seriesLength = 0;
            S_DB_S.plot_trend = $.jqplot('log_frequency_graph', [[null]], options);
        } else {
            for (i = 0; i < series.length; i++) {
                series[i][1] = parseInt(series[i][1], 10);
            }
            options.axes.xaxis.min = series[0][0];
            options.axes.xaxis.max = series[0][-1];
            S_DB_S.seriesLength = series.length;
            S_DB_S.plot_trend = $.jqplot('log_frequency_graph', [series], options);
        }
        setBarWidths(S_DB_S.plot_trend, S_DB_S.seriesLength, '#log_frequency_graph');
        S_DB_S.plot_trend.replot();
    },

    checkLoginPageRedirect: function (xhr, status, error) {
        checkLoginPageRedirect(xhr, status, error);
    },

    showChartLoading: function () {
        $('#log_frequency_loading').show();
        $('#log_frequency_graph').hide();
    },

    line_options: {
        title: { show: false },
        legend: { yoffset: 0, show: false },
        gridPadding: { left: 0, top: 0, right: 0, bottom: 0 },
        seriesDefaults: {
            pointLabels: { show: false }
        },
        axes: {
            xaxis: {
                pad: 0,
                renderer: $.jqplot.DateAxisRenderer,
                autoscale: false,
                numberTicks: 5,
                tickOptions: {
                    showLabel: false,
                    angle: 0,
                    formatString: '%Y-%m-%d %H:%M',
                    fontSize: 9
                }
            },
            yaxis: {
                tickOptions: {
                    fontSize: 9,
                    formatString: '%.0f',
                    show: false,
                    showLabel: false
                }
            }
        },
        cursor: {
            zoom: false,
            tooltipLocation: 'sw',
            showVerticalLine: true,
            showCursorLegend: true,
            showTooltip: false,
            cursorLegendFormatString: '%s%s %s',
            constrainZoomTo: 'x'
        },
        grid: { background: '#ffffff' },
        series: [{
            label: ' ',
            fill: true,
            fillAlpha: 0.8,
            fillAndStroke: true,
            color: "rgb(32,92,128)",
            fillColor: "rgb(225,235,245)",
            lineWidth: 1.0,
            neighborThreshold: 10,
            showMarker: true,
            markerOptions: {
                show: true,
                style: 'filledCircle',
                size: 1.0
            }
        }]
    },

    bar_options: {
        title: { show: false },
        legend: { yoffset: 0, show: false },
        gridPadding: { left: 0, top: 0, right: 0, bottom: 0 },
        series: [{
            renderer: $.jqplot.BarRenderer,
            pointLabels: { show: false },
            label: ' ',
            neighborThreshold: 10,
            color: '#2BBED8',
            markerOptions: {
                show: false
            }
        }],
        seriesDefaults: {
            showMarker: false,
            shadow: false,
            renderer: $.jqplot.BarRenderer,
            rendererOptions: {
                barWidth: 10,
                barDirection: 'vertical'
            }
        },
        grid: { background: '#ffffff', shadow: false},
        axesDefaults: { useSeriesColor: false },
        axes: {
            xaxis: {
                pad: 0,
                renderer: $.jqplot.DateAxisRenderer,
                autoscale: false,
                numberTicks: 5,
                tickOptions: {
                    showLabel: false,
                    angle: 0,
                    formatString: '%Y-%m-%d %H:%M',
                    fontSize: 9
                }
            },
            yaxis: {
                tickOptions: {
                    fontSize: 9,
                    formatString: '%.0f',
                    show: false,
                    showLabel: false
                },
                pad: 0,
                padMax: 1.2,
                min: 0,
                autoscale: false
            }
        },
        highlighter: { show: false },
        cursor: {
            zoom: false,
            tooltipLocation: 'sw',
            showVerticalLine: true,
            showCursorLegend: true,
            showTooltip: false,
            cursorLegendFormatString: '%s%s %s',
            constrainZoomTo: 'x'
        }
    },

    doResizeChart: function () {
        var padleft = parseInt($("#log_frequency_parent").css('margin-left'), 10);
        var div_width = $("#log_frequency_parent").width() - padleft * 2;
        var i;
        $("#div_log_frequency").width(div_width);
        if (S_DB_S.plot_trend !== null) {
            var length = S_DB_S.seriesLength;
            if (S_DB_S.plot_trend.plugins.cursor._zoom.isZoomed) {
                length = 1;
                for (i in S_DB_S.plot_trend.series[0].data) {
                    if (S_DB_S.plot_trend.series[0].data.hasOwnProperty(i)) {
                        if (S_DB_S.plot_trend.series[0].data[i]['0'] > S_DB_S.plot_trend.axes.xaxis.min &&
                                (S_DB_S.plot_trend.series[0].data[i]['0'] < S_DB_S.plot_trend.axes.xaxis.max)) {
                            length += 1;
                        }
                    }
                }
            }
            setBarWidths(S_DB_S.plot_trend, length, "#div_log_frequency");
            S_DB_S.plot_trend.replot();
        }
    },

    doResize : function () {
        S_DB_S.doResizeChart();
    },

    showProcessing: function () {
        $('#restore_snapshot_error').hide();
        $('#restore_snapshot_processing').show();
        return true;
    }

};
$(document).ready(S_DB_S.init);
