/*global S_USER_MODE, lock_page, is_page_locked, IPHELPER, S_IP_MAP:true, alert,
S_CREATE_GLOBAL_DLG_TITLE, S_CREATE_DEVICE_DLG_TITLE, S_UPDATE_GLOBAL_DLG_TITLE, S_UPDATE_DEVICE_DLG_TITLE, S_REPEATED_IP, S_DELETE_GLOBAL_TITLE, S_DELETE_DEVICE_TITLE, S_IMPORT_GLOBAL_FILE_TITLE, S_IMPORT_DEVICE_FILE_TITLE,
S_IMPORT_GLOBAL_FILE_MSG, S_IMPORT_DEVICE_FILE_MSG, S_ABOUT_TO_DELETE_MAP_GLOBAL, S_RESET_GLOBAL_MAP_TITLE, S_RESET_DEVICE_MAP_TITLE, S_NO_MAP_FOUND, S_ABOUT_TO_DELETE_MAP_DEVICE, S_SELECT_VALID_DEVICE, S_MAPPING_NAME_REQUIRED */
var S_IP_MAP = {
    path: "/servers/logserver/ip_map/",
    dynamic_resolution_enabled: false,
    gNameIdMap: {},
    gSelectedMapType: 0,
    gSelectedDeviceID: 0,
    gSelectedDeviceName: '',
    gGridData: [],
    nullData : {'records': 0, 'total': 0, 'rows': [], 'page': 0},

    init: function () {
        S_IP_MAP.initUI();
        S_IP_MAP.initEvents();
    },

    initUI: function () {
        if ($('#dynamic_resolution_enabled').is(':checked')) {
            S_IP_MAP.dynamic_resolution_enabled = true;
            $('#dynamic_resolution_state').html($('#str_enabled').html());
        } else {
            S_IP_MAP.dynamic_resolution_enabled = false;
            $('#dynamic_resolution_state').html($('#str_disabled').html());
        }

        S_IP_MAP.createIpMapGrid();

        // Check if the lock_page is in sessionStorage, this will be true
        // if user acquired a lock and clicked on refresh on the same page
        // and is in the same browser tab.
        S_IP_MAP.pg_tracker = window.sessionStorage.getItem(lock_page);

        var viewMode = WGRD.userInViewMode(is_page_locked, S_IP_MAP.pg_tracker);

        S_USER_MODE.initEvents();
        // if user mode is readonly, disable the dynamic resolution "configure" button
        if (viewMode) {
            WGRD.enableUIElements(false, ["#btn_dynamic_resolution", "#create_ip_map", "#update_ip_map", "#remove_ip_map", "#import_ip_map", "#reset_ip_map"]);
        }

        S_USER_MODE.initUI([], viewMode);
    },

    initEvents: function () {
        WGRD.pgUnloadCallBack(S_IP_MAP.pg_tracker, lock_page);
        $('#btn_dynamic_resolution').button().click(S_IP_MAP.dynResAction);
        $('#select_map_types').change(S_IP_MAP.setDeviceNameVisibility);
        S_IP_MAP._setSelectedDeviceEvent();
        $('#device_name').hide().bind('keypress', function (e) {
            if (e.keyCode === 13) {
                if (!S_IP_MAP._validateDeviceNameSN(true)) {
                    S_IP_MAP._loadSpecificData(S_IP_MAP.nullData);
                    return false;
                }
                S_IP_MAP.filter();
            }
        });

        $('#filter').click(S_IP_MAP.validateAndFilter);

        $('#create_ip_map').click(S_IP_MAP.create);
        $('#update_ip_map').click(S_IP_MAP.update);
        $('#remove_ip_map').click(S_IP_MAP.remove);

        $('#import_ip_map').click(S_IP_MAP.importCsv);
        $('#export_ip_map').click(S_IP_MAP.exportCsv);
        $('#reset_ip_map').click(S_IP_MAP.reset);

        $('#search_input').bind('keypress', function (e) {
            if (e.keyCode === 13) {
                if (!S_IP_MAP._validateDeviceNameSN(true)) {
                    S_IP_MAP._loadSpecificData(S_IP_MAP.nullData);
                    return false;
                }
                S_IP_MAP.search();
            }
        });

        $('#btn_refresh').click(S_IP_MAP.validateAndRefresh);
        $('#search').click(S_IP_MAP.validateAndSearch);
        $(window).bind('resizeEnd', function () {
            S_IP_MAP._doResizeGrid();
        });
    },

    // ------------ Dynamic Resolution  ------------------------------------------------

    dynResAction: function () {
        WGRD.doModal('#dynamic_resolution_dlg',
                     S_IP_MAP.initDynResModal,
                     S_IP_MAP.saveDynResModal);
    },

    initDynResModal: function () {
        // set the checkbox state
        $('#dynamic_resolution_enabled').prop('checked', S_IP_MAP.dynamic_resolution_enabled);

        return true;
    },

    saveDynResModal: function () {
        // save the dynamic hostname resolution setting
        var enabled = $('#dynamic_resolution_enabled').is(':checked');

        var err = null;
        $.ajax({
            url: 'ip_map/set_dyn_res_state?enabled=' + enabled,
            type: 'POST',
            async: false,
            error: function (data) {
                err = data.statusText;
            }
        });

        if (err === null) {
            if (enabled) {
                S_IP_MAP.dynamic_resolution_enabled = true;
                $('#dynamic_resolution_state').html($('#str_enabled').html());
            } else {
                S_IP_MAP.dynamic_resolution_enabled = false;
                $('#dynamic_resolution_state').html($('#str_disabled').html());
            }
        }

        return err;
    },

    // ------------ Dynamic Resolution (end) -------------------------------------------

    createIpMapGrid: function () {
        $("#ip_map_table").jqGrid({
            loadonce: true,
            datatype: S_IP_MAP.refreshGrid,
            // The colNames are placed in the template so we can localize them.
            colNames: [$("#ip_map_col_model #ip").html(), $("#ip_map_col_model #name").html()],
            colModel: [
                { name: "ip", sortable: true, sorttype: IPHELPER.sortIpAddressCell},
                { name: "name", sortable: true, sorttype: 'text'}
            ],
            viewrecords: true,
            gridview: true,
            autoencode: true,
            shrinktofit: true,
            autowidth: true,
            shrinkToFit: true,
            multiselect: true,
            height: "auto",
            sortname: 'ip',
            sortorder: 'asc',
            prmNames: {
                page: null,
                rows: null,
                sort: null,
                order: null,
                search: null,
                nd: null,
                id: null,
                oper: null,
                editoper: null,
                addoper: null,
                deloper: null,
                subgridid: null,
                npage: null,
                totalrows: null
            },
            onSortCol: function () {
                // Concession to limits of jqgrid. Before we refresh we set datatype back to json.
                $("#ip_map_table").setGridParam({datatype: 'local'});
            },
            loadComplete: function () {
                S_IP_MAP._toggleRowChangeBtns();
                S_IP_MAP._doResizeGrid();
                S_IP_MAP.sortGrid();
            },
            onSelectRow: function (rowid, status, e) { S_IP_MAP._toggleRowChangeBtns(); },
            onSelectAll: function(selRows) { S_IP_MAP._toggleRowChangeBtns(); }
        });
    },

    create: function () {
        if (!S_IP_MAP._validateDeviceNameSN(true)) {
            return;
        }
        var params = {};
        WGRD.doModal('#update_and_create_dlg',
            S_IP_MAP._initializeCreateControl,
            S_IP_MAP._createRecord,
            params,
            undefined,
            false);
    },

    _initializeCreateControl: function () {
        S_IP_MAP._resetUpdateAndCreateModal();
        var title = S_CREATE_GLOBAL_DLG_TITLE;
        if ($('#select_map_types')[0].selectedIndex === 1) {
            title = S_CREATE_DEVICE_DLG_TITLE;
        }
        $("#update_and_create_title").html(title);
        S_IP_MAP._setEditedDeviceNameVisibility();
        $("#ip").attr('disabled', false);
        return true;
    },

    _resetUpdateAndCreateModal: function () {
        // Contains shared logic to initialize state for the update/create modal divs.
        $("#update_and_create_error").hide();
        $("#update_and_create_error").html('');
        $("#update_and_create_dlg #ip").val('');
        $("#update_and_create_dlg #name").val('');
        $("#update_and_create_dlg #edited_device").val('');
    },

    _validateIPExistence: function (ip) {
        var flag = false, i, cell_ip;
        for (i = 0; i < S_IP_MAP.gGridData.length; i++) {
            cell_ip = S_IP_MAP.gGridData[i].cell[0];
            if (ip === cell_ip) {
                flag = true;
                break;
            }
        }
        return flag;
    },

    _createRecord: function (params) {
        var ip = $("#update_and_create_dlg #ip").val();
        var name = $("#update_and_create_dlg #name").val();
        var appliance_id = S_IP_MAP.gSelectedDeviceID;
        var appliance_name = S_IP_MAP.gSelectedDeviceName;

        var error_msg = S_IP_MAP._validateForm(ip, name, true);
        if (error_msg === undefined) {
            var blocking_response;
            $.ajax({
                url: S_IP_MAP.path + 'create',
                type: 'POST',
                data: {appliance_id: appliance_id, appliance_name: appliance_name, ip: ip, name: name},
                dataType: "json",
                async: false,
                success: function (response) {
                    blocking_response = response;
                }
            });
            if (blocking_response.status) {
                S_IP_MAP.refreshGrid();
            } else {
                error_msg = blocking_response.message;
            }
        }

        return error_msg;
    },

    update: function () {
        if (!S_IP_MAP._validateDeviceNameSN(true)) {
            return;
        }
        var sel_row_ids = $('#ip_map_table').jqGrid('getGridParam', 'selarrrow');

        WGRD.doModal('#update_and_create_dlg',
            S_IP_MAP._initializeUpdateControl,
            S_IP_MAP._updateRecord,
            {},
            undefined,
            false);
    },

    _initializeUpdateControl: function () {
        S_IP_MAP._resetUpdateAndCreateModal();
        var title = S_UPDATE_GLOBAL_DLG_TITLE;
        if ($('#select_map_types')[0].selectedIndex === 1) {
            title = S_UPDATE_DEVICE_DLG_TITLE;
        }
        $("#update_and_create_title").html(title);
        S_IP_MAP._setEditedDeviceNameVisibility();

        var ip_table = $('#ip_map_table');
        var sel_row_id = $('#ip_map_table').jqGrid('getGridParam', 'selrow');
        var ip = ip_table.jqGrid('getCell', sel_row_id, 'ip');
        $("#update_and_create_dlg #ip").val(ip);
        var name = ip_table.jqGrid('getCell', sel_row_id, 'name');
        $("#update_and_create_dlg #name").val(name);

        $("#ip").attr('disabled', true);
        return true;
    },

    _updateRecord: function (params) {
        var error_msg;
        var ip = $("#update_and_create_dlg #ip").val();
        var name = $("#update_and_create_dlg #name").val();
        var appliance_id = S_IP_MAP.gSelectedDeviceID;
        var appliance_name = S_IP_MAP.gSelectedDeviceName;

        error_msg = S_IP_MAP._validateForm(ip, name);
        if (error_msg === undefined) {
            var blocking_response;
            $.ajax({
                url: S_IP_MAP.path + 'update',
                type: 'POST',
                dataType: 'json',
                data: {appliance_id: appliance_id, appliance_name: appliance_name, ip: ip, name: name},
                async: false,
                success: function (response) { blocking_response = response; }
            });
            if (blocking_response.status) {
                S_IP_MAP.refreshGrid();
            } else {
                error_msg = blocking_response.message;
            }
        }
        return error_msg;
    },

    _validateForm: function (ip, name, is_create) {
        var error_msg;
        if (!IPHELPER.validIP4(ip) && !IPHELPER.validIP6(ip)) {
            error_msg = $("#invalid_ip_error").html();
        } else if (name.trim().length === 0) {
            error_msg = S_MAPPING_NAME_REQUIRED.format(ip);
        } else if (is_create && S_IP_MAP._validateIPExistence(ip)) {
            error_msg = S_REPEATED_IP.format(ip);
        }
        return error_msg;
    },

    remove: function () {
        if (!S_IP_MAP._validateDeviceNameSN(true)) {
            return;
        }
        var ip_table = $('#ip_map_table');
        var sel_row_ids = ip_table.jqGrid('getGridParam', 'selarrrow');
        if (sel_row_ids === null) {
            return;
        }

        var ips = [];
        var i;
        for (i = 0; i < sel_row_ids.length; i++) {
            ips.push(ip_table.jqGrid('getCell', sel_row_ids[i], 'ip'));
        }
        var params = {ips: ips};
        var msg = $("#delete_global_confirm_msg").html();
        var title = S_DELETE_GLOBAL_TITLE;
        if ($('#select_map_types')[0].selectedIndex === 1) {
            msg = $("#delete_device_confirm_msg").html();
            title = S_DELETE_DEVICE_TITLE;
        }
        $('#confirmBoxDiv h3').text(title);
        WGRD.confirmModal(msg, false, S_IP_MAP._deleteRecord, false, true, params);
    },

    _deleteRecord: function (params) {
        var appliance_id = S_IP_MAP.gSelectedDeviceID;
        var appliance_name = S_IP_MAP.gSelectedDeviceName;
        var ips = JSON.stringify(params.ips);
        $.ajax({
            url: S_IP_MAP.path + 'delete',
            type: 'POST',
            dataType: 'json',
            data: {appliance_id: appliance_id, appliance_name: appliance_name, ips: ips},
            success: function (response) {
                if (response.status) {
                    S_IP_MAP.refreshGrid();
                } else {
                    WGRD.okMessageModal(response.message, $("#delete_error_title").html());
                }
            }
        });
    },

    importCsv: function () {
        if (!S_IP_MAP._validateDeviceNameSN(true)) {
            return;
        }
        WGRD.doModal('#csv_load_dlg',
            S_IP_MAP._initializeImportCsv,
            S_IP_MAP._saveImportCsv,
            undefined,
            S_IP_MAP._cancelImportCsv,
            true);
    },

    _initializeImportCsv: function () {
        var title = S_IMPORT_GLOBAL_FILE_TITLE;
        var msg = S_IMPORT_GLOBAL_FILE_MSG;
        if ($('#select_map_types')[0].selectedIndex === 1) {
            title = S_IMPORT_DEVICE_FILE_TITLE;
            msg = S_IMPORT_DEVICE_FILE_MSG;
        }
        $("#import_file_title").html(title);
        $("#import_file_msg").html(msg);
        return true;
    },

    _saveImportCsv: function () {
        S_IP_MAP.uploading_csv = true;
        if ($("#csv_import_file").val() === '') {
            return $("#no_file_error").html();
        }
        $('#appliance_id').val(S_IP_MAP.gSelectedDeviceID);
        $('#appliance_name').val(S_IP_MAP.gSelectedDeviceName);
        $('#csv_load_form').submit();
    },

    _cancelImportCsv: function () {
        S_IP_MAP._hideWaitCursor();
    },

    _csvFileUploaded: function () {
        // called when the iframe that handles the csv file upload is loaded
        // we use this to check for errors
        if (!S_IP_MAP.uploading_csv) {
            return;
        }

        // check for any errors
        var result = $.parseJSON($("#csvImportIFrame").contents().find("body").text());
        if (!result.status) {
            $('#csv_load_dlg div.wgrd-modal-error').html(result.message);
            $('#csv_load_dlg div.wgrd-modal-error').show();
        } else {
            // no errors so hide the dialog
            $('#csv_load_dlg').modal('hide');
            S_IP_MAP.refreshGrid();
        }

        S_IP_MAP._hideWaitCursor();
        S_IP_MAP.uploading_csv = false;
    },

    exportCsv: function () {
        if (!S_IP_MAP._validateDeviceNameSN(true)) {
            return;
        }
        var url = S_IP_MAP.path + "export_csv";
        url += "?appliance_id=" + S_IP_MAP.gSelectedDeviceID;
        window.location = url;
    },

    reset: function () {
        if (!S_IP_MAP._validateDeviceNameSN(true)) {
            return;
        }
        var msg = S_ABOUT_TO_DELETE_MAP_GLOBAL;
        var title = S_RESET_GLOBAL_MAP_TITLE;
        if ($('#select_map_types')[0].selectedIndex === 1) {
            title = S_RESET_DEVICE_MAP_TITLE;
            msg = S_ABOUT_TO_DELETE_MAP_DEVICE.format(S_IP_MAP.gSelectedDeviceName);
        }
        $('#confirmBoxDiv h3').text(title);
        WGRD.confirmModal(msg, false, S_IP_MAP._resetAllRecords, false, true, undefined);
    },

    _resetAllRecords: function () {
        var appliance_id = S_IP_MAP.gSelectedDeviceID;
        var appliance_name = S_IP_MAP.gSelectedDeviceName;
        $.ajax({
            url: S_IP_MAP.path + 'reset',
            type: 'POST',
            dataType: 'json',
            data: {appliance_id: appliance_id, appliance_name: appliance_name},
            success: function (response) {
                if (response.status) {
                    S_IP_MAP.refreshGrid();
                } else {
                    WGRD.okMessageModal(response.message, $("#reset_error_title").html());
                }
            }
        });
    },

    validateAndSearch: function () {
        if (!S_IP_MAP._validateDeviceNameSN(true)) {
            S_IP_MAP._loadSpecificData(S_IP_MAP.nullData);
            return false;
        }
        S_IP_MAP.search();
    },

    validateAndFilter: function () {
        if (!S_IP_MAP._validateDeviceNameSN(true)) {
            S_IP_MAP._loadSpecificData(S_IP_MAP.nullData);
            return false;
        }
        S_IP_MAP.filter();
    },

    validateAndRefresh: function () {
        if (!S_IP_MAP._validateDeviceNameSN(true)) {
            S_IP_MAP._loadSpecificData(S_IP_MAP.nullData);
            return false;
        }
        S_IP_MAP.refreshGrid();
    },

    search: function () {
        $("#ip_map_table").setGridParam({datatype: 'json'});
        var value = $("#search_input").val();
        S_IP_MAP._showWaitCursor();
        $.ajax({
            url: S_IP_MAP.path + 'search',
            type: 'GET',
            dataType: 'json',
            data: {appliance_id: S_IP_MAP.gSelectedDeviceID, s: value},
            success: function (response) {
                if (response.status) {
                    S_IP_MAP._loadSpecificData(response.data);
                    if (response.data.records === 0) {
                        $('#invalid_device_name_error')
                                                      .show()
                                                      .html(S_NO_MAP_FOUND)
                                                      .delay(2000)
                                                      .fadeOut();
                    }
                } else {
                    alert(response.message);
                }
            },
            complete: S_IP_MAP._hideWaitCursor
        });
        return true;
    },

    filter: function () {
        $("#search_input").val('');
        $("#ip_map_table").setGridParam({datatype: 'json'});
        S_IP_MAP._showFilterWaitCursor();
        $.ajax({
            url: S_IP_MAP.path + 'search',
            type: 'GET',
            dataType: 'json',
            data: {appliance_id: S_IP_MAP.gSelectedDeviceID, s: ''},
            success: function (response) {
                if (response.status) {
                    S_IP_MAP._loadSpecificData(response.data);
                    if (response.data.records === 0) {
                        $('#invalid_device_name_error')
                                                      .show()
                                                      .html(S_NO_MAP_FOUND)
                                                      .delay(2000)
                                                      .fadeOut();
                    }
                } else {
                    alert(response.message);
                }
            },
            complete: S_IP_MAP._hideFilterWaitCursor
        });
        return true;
    },

    _loadSpecificData: function (data) {
        $("#ip_map_table").jqGrid('clearGridData');
        $('#ip_map_table').jqGrid('setGridParam', {
            rowNum: data.records,
            datatype: 'json'
        });
        $("#ip_map_table")[0].addJSONData(data);
        S_IP_MAP.gGridData = data.rows;
        S_IP_MAP.sortGrid();
    },

    refreshGrid: function () {
        $("#search_input").val('');
        $('#ip_map_table').jqGrid('clearGridData');
        S_IP_MAP._showWaitCursor();
        $.ajax({
            url: S_IP_MAP.path + "retrieve",
            type: 'GET',
            dataType: 'json',
            data: {appliance_id: S_IP_MAP.gSelectedDeviceID},
            success: function (data) {
                // update the table with the new data
                S_IP_MAP._loadSpecificData(data);
            },
            error: function (response) {
                $('#ip_map_table').jqGrid('setGridParam', {datatype: 'local'});
            },
            complete: function () {
                S_IP_MAP._doResizeGrid();
                S_IP_MAP._hideWaitCursor();
            }
        });
    },

    sortGrid: function () {
        $("#ip_map_table").jqGrid('setGridParam', 'datatype', 'local');
        $("#ip_map_table").jqGrid('sortGrid').trigger('reloadGrid');
        // sortGrid has no direction and toggles. We have to sort twice to preserve existing direction.
        $("#ip_map_table").jqGrid('sortGrid').trigger('reloadGrid');
        $("#ip_map_table").jqGrid('setGridParam', 'datatype', 'json');
    },

    _toggleRowChangeBtns: function () {
        // enable/disable "Remove"/"Edit" button depending on if any rows are selected or not
        if (!WGRD.userInViewMode(is_page_locked, S_IP_MAP.pg_tracker)) {
            // only toggle the buttons in read/write mode
            var selRows = $('#ip_map_table').jqGrid('getGridParam', 'selarrrow');
            if (selRows.length == 0) {
                WGRD.enableUIElements(false, ["#update_ip_map", "#remove_ip_map"]);
            } else if (selRows.length == 1) {
                WGRD.enableUIElements(true, ["#update_ip_map", "#remove_ip_map"]);
            } else {
                WGRD.enableUIElements(true, ["#remove_ip_map"]);
                WGRD.enableUIElements(false, ["#update_ip_map"]);
            }
        }
    },

    _showWaitCursor: function () {
        WGRD.enableUIElements(false, ['#search', '#btn_refresh']);
        $('#error').hide();
        $('#table_loading').show();
    },

    _hideWaitCursor: function () {
        WGRD.enableUIElements(true, ['#search', '#btn_refresh']);
        $('#table_loading').hide();
    },

    _showFilterWaitCursor: function () {
        WGRD.enableUIElements(false, ['#filter', '#btn_refresh']);
        $('#filter_loading').show();
    },

    _hideFilterWaitCursor: function () {
        WGRD.enableUIElements(true, ['#filter', '#btn_refresh']);
        $('#filter_loading').hide();
    },

    _doResizeGrid: function () {
        var pad = parseInt($("#ip_map_table_div").css('margin-left'), 10);
        pad *= 2;
        if (pad === 0) {
            pad += 1;  // add at least 1 pixel padding to keep the grid smaller than the parent
        }
        var grid_width = $("#ip_map_table_div").width() - pad;
        $('#ip_map_table').setGridWidth(grid_width);
    },

    // The drop down "device_name" and button "filter" in index page will only be visible for "Device Map"
    setDeviceNameVisibility: function () {
        $("#invalid_device_name_error").hide();
        if ($('#select_map_types')[0].selectedIndex === 0) {
            $('#device_name').hide();
            $('#for').hide();
            $('#filter').hide();
            S_IP_MAP.gSelectedDeviceID = 0;
            S_IP_MAP.refreshGrid();
        } else {
            $('#device_name').show();
            $('#for').show();
            $('#filter').show();
            if (!S_IP_MAP._validateDeviceNameSN(false)) {
                S_IP_MAP.gSelectedDeviceID = -1;
                S_IP_MAP._loadSpecificData(S_IP_MAP.nullData);
            } else {
                S_IP_MAP.refreshGrid();
            }
        }
    },

    // The field "device_name" in dialog will only be visible for "Device Map"
    _setEditedDeviceNameVisibility: function () {
        if ($('#select_map_types')[0].selectedIndex === 0) {
            $("#device_name_div").hide();
        } else {
            $("#device_name_div").show();
            $("#edited_device").val(S_IP_MAP.gSelectedDeviceName);
        }
        $("#edited_device").attr('disabled', true);
    },

    // Initialize the list in the drop down "device_name" in index page and set the event by user's selection.
    _setSelectedDeviceEvent: function () {
        $.ajax({
            url: S_IP_MAP.path + 'get_appliance_list',
            type: 'POST',
            data: {},
            dataType: "json",
            async: false,
            success: function (response) {
                $('#device_name').typeahead({
                    source: function (query, process) {
                        var return_list = [], i, id, name;
                        for (i = 0; i < response.length; i++) {
                            name = response[i].name;
                            return_list.push(name);
                            id = response[i].id;
                            S_IP_MAP.gNameIdMap[name] = id;
                        }
                        return return_list;
                    },
                    updater: function (response) {
                        var selected_id =  S_IP_MAP.gNameIdMap[response];
                        S_IP_MAP.gSelectedDeviceID = selected_id;
                        S_IP_MAP.gSelectedDeviceName = response;
                        S_IP_MAP.filter();
                        return response;
                    }
                });
            }
        });
    },

    // If the appliance name and SN not valid, when user click Add/Edit/Remove/Import/Export button in next step,
    // this function will prevent doing further operations and print warning message.
    _validateDeviceNameSN: function (warning_flag) {
        var appliance_name;
        $("#invalid_device_name_error").hide();
        if ($('#select_map_types')[0].selectedIndex === 0) {
            return true;
        }

        var flag = false;
        var device_name =  $("#device_name").val();
        if (device_name !== '') {
            for (appliance_name in S_IP_MAP.gNameIdMap) {
                if (S_IP_MAP.gNameIdMap.hasOwnProperty(appliance_name)) {
                    if (appliance_name === device_name) {
                        flag = true;
                        S_IP_MAP.gSelectedDeviceID = S_IP_MAP.gNameIdMap[appliance_name];
                        $('#device_name').val(appliance_name);
                        break;
                    }
                }
            }
        }
        if (!flag) {
            S_IP_MAP.gSelectedDeviceID = -1;
            if (warning_flag) {
                $('#invalid_device_name_error')
                                              .show()
                                              .html(S_SELECT_VALID_DEVICE)
                                              .delay(2000)
                                              .fadeOut();
            }
            return false;
        }
        return true;
    }
};
$(document).ready(S_IP_MAP.init);
