/*global auditReportColModel, auditReportColNames, S_EXPORT_CSV_ERROR, S_EXPORT_CSV_TITLE, S_PROCESSING */
var SYS_A = {

    logCatId: 'cat_all', // default to showing all logs

    init: function () {
        SYS_A.initUI();
        SYS_A.initEvents();
    },

    // initialize UI elements
    initUI: function () {
        // create date pickers
        var today = new Date();
        var start_date = new Date(today.setHours(0, 0, 0, 0));  // set start date to start of today
        $('#datepicker_start').datetimepicker();
        $('#datepicker_start').data('datetimepicker').setLocalDate(start_date);
        $('#datepicker_end').datetimepicker();
        $('#datepicker_end').val('');  // leave end time blank to mean "end of today"

        // set the current time range label
        SYS_A._update_timerange_str();

        // create the log table
        SYS_A.createAuditReportGrid();
    },

    initEvents: function () {
        // add datetime picker event handlers
        $('#datepicker_start').on('hide', function (e) {
            SYS_A._reloadGrid();
        });
        $('#datepicker_end').on('hide', function (e) {
            SYS_A._reloadGrid();
        });
        $('#datepicker_end').on('show', function (e) {
            if (!$('#datepicker_end').find('input').val()) {
                // default to 24 hours after start_date, when empty
                var start_date = SYS_A._getStartDate();
                start_date = start_date.setDate(start_date.getDate() + 1);
                $('#datepicker_end').data('datetimepicker').setLocalDate(new Date(start_date));
            }
        });

        // log category filters
        $('#selected_cat').change(function () {
            SYS_A.logCatId = $('#selected_cat option:selected').val();
            SYS_A._reloadGrid();
        });

        // refresh button
        $('#btn_refresh').button().click(function () {
            SYS_A._reloadGrid();
        });

        // actions menu
        $(".li_action").bind('click', function (event) {
            event.preventDefault();
            switch (this.id) {
            case "csv":
                SYS_A.download_csv();
                break;
            }
        });

        // resize the grid
        $(window).bind('resizeEnd', function () {
            SYS_A._doResizeGrid();
        });
    },

    createAuditReportGrid: function () {
        var audit_report_grid = $('#audit_report_grid_table').jqGrid({
            autowidth: true,
            altRows: true,
            altclass: 'gridAltRow',
            autoencode: true,
            caption: '',
            colNames: auditReportColNames,
            colModel: auditReportColModel,
            url: 'audit_report',
            mtype: 'GET',
            datatype: 'json',
            height: 'auto',
            loadui: 'block',
            pager: '#audit_report_grid_pager',
            pagerpos: 'right',
            recordpos: 'left',
            rowNum: 25,
            rowList: [25, 100, 250, 500],
            shrinkToFit: true,
            sortname: 'date',
            sortorder: 'desc',
            toppager: true,
            viewrecords: true,
            postData: {
                b_time: function () { return SYS_A._getDateStr(SYS_A._getStartDate()); },
                e_time: function () { return SYS_A._getDateStr(SYS_A._getEndDate());   },
                client_tz: function () { return WGRD.client_tz; },
                log_type: function () { return SYS_A._getCatStr(); }
            },
            jsonReader: {
                root: 'data',
                page: 'currpage',
                total: 'totalpages',
                records: 'totalrecords'
            }
        });

        audit_report_grid.jqGrid('navGrid', '#audit_report_grid_pager', {refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});
        audit_report_grid.setColProp('date', { formatter: SYS_A._utcDateFormatter });
    },

    _reloadGrid: function () {
        $('#audit_report_grid_table').setGridParam().trigger("reloadGrid");
        SYS_A._update_timerange_str();
    },

    _utcDateFormatter: function (cellvalue, options, rowObject) {
        return $.getDateDisplay(cellvalue, true);
    },

    _doResizeGrid: function () {
        var pad = parseInt($("#audit_report_grid_div").css('margin-left'), 10);
        pad *= 2;
        if (pad === 0) {
            pad += 1;  // add at least 1 pixel padding to keep the grid smaller than the parent
        }
        var grid_width = $("#audit_report_grid_div").width() - pad;
        $('#audit_report_grid_table').setGridWidth(grid_width);
    },

    _update_timerange_str: function () {
        var start_date = SYS_A._getStartDate();
        var end_date = SYS_A._getEndDate();
        start_date = SYS_A._getLocalDateStr(start_date);
        end_date = SYS_A._getLocalDateStr(end_date);
        $('#date_range_str').html(start_date + ' - ' + end_date);
    },

    _getLocalDateStr: function (date) {
        // convert to date string in local time (account for timzone offset)
        var tmp_time = date.getTime() - date.getTimezoneOffset() * 60 * 1000;
        date = new Date();
        date.setTime(tmp_time);
        date = date.toISOString();
        date = date.replace('T', ' ');
        date = date.substring(0, date.length - 5); // remove the microseconds
        return date;
    },

    _getDateStr: function (date) {
        // we send the date in UTC
        var date_str = date.toISOString();
        date_str = date_str.replace('T', ' ').replace('Z', '');
        return date_str;
    },

    _getStartDate: function () {
        var start_date;
        var start_div = $('#datepicker_start');
        if (!start_div.find('input').val()) {
            // empty start date means beginning of today
            start_date = new Date(new Date().setHours(0, 0, 0, 0));
        } else {
            start_date = start_div.data('datetimepicker').getLocalDate();
        }
        return start_date;
    },

    _getEndDate: function () {
        var start_date, end_date;
        var end_div = $('#datepicker_end');
        if (!end_div.find('input').val()) {
            // empty date means "24 hours after start date"
            start_date = SYS_A._getStartDate();
            start_date.setDate(start_date.getDate() + 1);
            end_date = start_date;
        } else {
            end_date = end_div.data('datetimepicker').getLocalDate();
        }
        return end_date;
    },

    _getCatStr: function () {
        var btn_id = SYS_A.logCatId;
        return btn_id.substring(4);
    },

    download_csv: function () {
        WGRD.enableUIElements(false, ['#btn_actions']);
        WGRD.progressModal(S_EXPORT_CSV_TITLE, S_PROCESSING);
        $.ajax({
            url: 'export_audit',
            data: {
                'export_type': 'CSV',
                'b_time': SYS_A._getDateStr(SYS_A._getStartDate()),
                'e_time': SYS_A._getDateStr(SYS_A._getEndDate()),
                'client_tz': function () { return WGRD.client_tz; },
                'log_type': SYS_A._getCatStr()
            },
            dataType: 'json',
            success: function (response, textStatus, jqXHR) {
                if (response.status === 0) {
                    var file_args = '?tmp_file_name=' + response.tmp_file_name + '&file_name=' + response.file_name;
                    window.location = 'get_tmp_file' + file_args;
                } else {
                    WGRD.okMessageModal(response.error_msg, S_EXPORT_CSV_TITLE);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                WGRD.okMessageModal(S_EXPORT_CSV_ERROR + errorThrown, S_EXPORT_CSV_TITLE);
            },
            complete: function (jqXHR, textStatus) {
                WGRD.enableUIElements(true, ['#btn_actions']);
                WGRD.progressModalClose();
            }
        });

        return;
    }

};
$(document).ready(SYS_A.init);