/*global WGRD, S_USER_MODE, S_VIEW_TEXT, S_EDIT_TEXT, IPHELPER, writeErrorContainer, validateDomainNameStr, validateDomainName, alert, SystemConfigObj, has_inf_settings, has_domain_settings, org_iface_list, org_ntp_enabled, org_curr_time:true, org_tz, org_route_list, lock_page, is_page_locked, org_email_encryption_level, ifaceColModel, ifaceColNames, routesColModel, routesColNames,
S_EDIT_INTF_TITLE, S_VIEW_INTF_TITLE, S_SHOW_ROUTE_SETTINGS, S_HIDE_ROUTE_SETTINGS, S_ROUTE_ADD_TITLE, S_ROUTE_EDIT_TITLE, S_ROUTE_VIEW_TITLE, S_ROUTE_METRIC, IFACE_STATUS, IFACE_IP_TYPE, S_ERR_DNS_IP, S_ERR_DNS_DUP, S_ERR_NTP_IP, S_ERR_IP, S_ERR_DOMAIN, S_ERR_DNS_REQ, S_ERR_NTP_EMPTY, S_ERR_NTP_DUP, S_ERR_TIME_EMPTY, S_ERR_IFACE_IP, S_ERR_IFACE_MASK, S_ERR_IFACE_GW, S_ERR_IFACE_REQ, S_ERR_ROUTE_DST, S_ERR_ROUTE_GW, S_ERR_ROUTE_GW_DST, S_ERR_ROUTE_DUPLICATE, S_ERR_HNAME_EMPTY, S_ERR_HNAME_LEN, S_ERR_HNAME_DASH_STARTS, S_ERR_HNAME_DASH_ENDS, S_ERR_HNAME_CHARS, S_SEND_FEEDBACK_TITLE, S_SEND_FEEDBACK_MESSAGE, S_ERR_EMAIL_HNAME_EMPTY, S_ERR_EMAIL_HNAME_LEN, S_EMAIL_PORT_NUM, S_ERR_EMAIL_UNAME_EMPTY, S_ERR_EMAIL_UNAME_LEN, S_ERR_EMAIL_PASSWD_LEN, S_ERR_BACKUP_HNAME_EMPTY, S_ERR_BACKUP_HNAME_LEN, S_ERR_BACKUP_UNAME_EMPTY, S_ERR_BACKUP_UNAME_LEN, S_BACKUP_PORT_NAME, S_ERR_BACKUP_DIR_EMPTY, S_ERR_BACKUP_DIR_LEN, S_ERR_BACKUP_DIR_BACKSLASH, S_SUCCESS, S_ERR_HNAME_ONLY_DIGITS */
var SYS_C = {

    email_auth_password_changed: false,
    email_auth_password_value: '', // Used to restore the email password when a user clicks away from that field.

    // setup the page
    init: function () {
        SYS_C.initUI();
        SYS_C.initEvents();
    },

    // initialize UI elements
    initUI: function () {
        $('#progress_save').hide();
        $('#error_container').hide();

        // disable grid buttons by default since nothing is selected by default
        WGRD.enableUIElements(false, ['#inf_edit_btn', '#route_edit_btn', '#route_delete_btn']);

        $('#sys_time').datetimepicker({
            pickDate: true,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });

        // init the interface and routes tables
        SYS_C.initInfGrid(org_iface_list);
        SYS_C.initRoutesGrid(org_route_list);

        // init ntp radio button and hide/show span
        if (org_ntp_enabled) {
            $("#ntp_enabled_radio").prop("checked", true);
            $("#ntp_disabled_radio").prop("checked", false);
        } else {
            $("#ntp_enabled_radio").prop("checked", false);
            $("#ntp_disabled_radio").prop("checked", true);
        }
        SYS_C.toggleNtpEnable();

        // init the email settings controls
        SYS_C.email_auth_password_value = $('#email_auth_password').val();
        SYS_C.toggleEmailState();
        $("#email_encryption").val(org_email_encryption_level);

        $("#static_route_settings").hide();

        // init system time
        $('#sys_time').data('datetimepicker').setDate(new Date(org_curr_time));

        // init the backup settings controls
        SYS_C.toggleBackupState();

        // detect if any fields are changed
        var flds = $("input", window.document);
        $(flds).on('change keyup', flds, function (eo) {
            $('#error_container').hide();
        });

        $('#send_feedback_tooltip').tooltip();

        S_USER_MODE.show_warning_msg = true;

        // Check if the lock_page is in sessionStorage, this will be true
        // if user acquired a lock and clicked on refresh on the same page
        // and is in the same browser tab.
        SYS_C.pg_tracker = window.sessionStorage.getItem(lock_page);

        var viewMode = WGRD.userInViewMode(is_page_locked, SYS_C.pg_tracker);

        if (viewMode) {
            $('#inf_edit_btn').text(S_VIEW_TEXT);
            $('#route_edit_btn').text(S_VIEW_TEXT);
            $('#edit_iface_dlg h3').text(S_VIEW_INTF_TITLE);
            WGRD.enableUI(false, "#system_config");
            WGRD.enableUI(true, "#inf_div");
            WGRD.enableUI(true, "#static_route_settings");
        } else {
            $('#inf_edit_btn').text(S_EDIT_TEXT);
            $('#route_edit_btn').text(S_EDIT_TEXT);
            $('#edit_iface_dlg h3').text(S_EDIT_INTF_TITLE);
        }
        var ids = ['#route_add_btn', '#route_delete_btn', '#iface_save', '#route_save', '#submit_button'];
        S_USER_MODE.initUI(ids, viewMode);
    },

    // add event handlers
    initEvents : function () {
        WGRD.pgUnloadCallBack(SYS_C.pg_tracker, lock_page);
        // interface edit dialog listeners
        $('#iface_state').click(SYS_C.toggleIfaceState);
        $('#iface_type').change(SYS_C.toggleIfaceType);

        // table buttons
        $('#inf_edit_btn').button().click(SYS_C.editIfaceAction);
        $('#route_add_btn').button().click(SYS_C.routeAddAction);
        $('#route_edit_btn').button().click(SYS_C.routeEditAction);
        $('#route_delete_btn').button().click(SYS_C.routeDeleteAction);

        // dns
        $('#add_dns_server').button().click(SYS_C.addDnsServer);
        $('#remove_dns_server').button().click(SYS_C.removeDnsServer);

        // ntp
        $('#ntp_enabled_radio').click(SYS_C.toggleNtpEnable);
        $('#ntp_disabled_radio').click(SYS_C.toggleNtpEnable);
        $('#add_ntp_server').button().click(SYS_C.addNtpServer);
        $('#remove_ntp_server').button().click(SYS_C.removeNtpServer);

        // static routes
        $('#static_route_settings_btn').click(SYS_C.showHideRouteSettings);

        // call home send feedback
        $('#send_feedback_enabled').click(SYS_C.toggleSendFeedbackState);

        // email
        $('#email_enabled').click(SYS_C.toggleEmailState);
        $('#email_auth_enabled').click(SYS_C.toggleEmailState);

        // email password changes
        $('#email_auth_password').change(function () {
            SYS_C.email_auth_password_changed = true;
            SYS_C.email_auth_password_value = $('#email_auth_password').val();
        });

        // When the user selects the password field, empty it.
        $('#email_auth_password').focus(function () {
            $('#email_auth_password').val('');
        });

        // Set the email password back to what it was from its blank form
        // when the user moves on.
        $('#email_auth_password').blur(function () {
            $('#email_auth_password').val(SYS_C.email_auth_password_value);
        });

        // remote backup
        $('#remote_backup_enable').click(SYS_C.toggleBackupState);
        $('#remote_backup_test_btn').click(SYS_C.testRemoteBackup);

        // cancel / submit
        $('#submit_button').button().click(SYS_C.savePage);

        $(window).bind('resizeEnd', function () {
            SYS_C.doResizeGrids();
        });

        //User mode changes
        S_USER_MODE.initEvents();
    },

    // create the interface table grid
    initInfGrid: function (data) {
        // convert the interface constants to strings for presentation
        var i;
        for (i = 0; i < data.length; i++) {
            data[i].status = IFACE_STATUS[data[i].status];
            data[i].ip_type = IFACE_IP_TYPE[data[i].ip_type];
            if (!data[i].ip_addr) {  // default to empty if it is not defined
                data[i].ip_addr = '';
            }
            if (!data[i].gw) {  // default to empty if it is not defined
                data[i].gw = '';
            }
        }

        // set the grid
        $('#inf_grid_table').jqGrid({
            colModel: ifaceColModel,
            colNames: ifaceColNames,
            loadonce: true,
            loadui: 'block',
            datatype: 'local',
            data: data,
            rowNum: data.length,
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            sortname: 'name',
            viewrecords: true,
            sortorder: 'asc',
            gridComplete: function () {
                // select a row and enable the edit button after grid load
                var ids = $('#inf_grid_table').jqGrid("getDataIDs");
                if (ids && ids.length > 0) {
                    $('#inf_grid_table').jqGrid("setSelection", ids[0]);
                    WGRD.enableUIElements(true, ['#inf_edit_btn']);
                } else {
                    WGRD.enableUIElements(false, ['#inf_edit_btn']);
                }
            }
        });
    },

    // create the static routes table grid
    initRoutesGrid: function (data) {
        var i;
        var col_data = new Array(data.length);
        for (i = 0; i < data.length; i++) {
            col_data[i] = {};
            col_data[i].destination = data[i][0];
            col_data[i].gateway = data[i][1];
            col_data[i].metric = data[i][2];
        }

        var static_routes_grid = $('#static_routes_grid_table').jqGrid({
            colModel: routesColModel,
            colNames: routesColNames,
            loadonce: true,
            loadui: 'block',
            datatype: 'local',
            data: col_data,
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            sortname: 'destination',
            viewrecords: true,
            sortorder: 'asc',
            rowNum: 5,
            rowList: [5, 10, 20, 100],
            pager: '#static_routes_pager',
            gridComplete: function () {
                // select a row and enable the edit button after grid load
                var ids = $('#static_routes_grid_table').jqGrid("getDataIDs");
                if (ids && ids.length > 0) {
                    $('#static_routes_grid_table').jqGrid("setSelection", ids[0]);
                    WGRD.enableUIElements(true, ['#route_edit_btn', '#route_delete_btn']);
                } else {
                    WGRD.enableUIElements(false, ['#route_edit_btn', '#route_delete_btn']);
                }
            }
        });

        static_routes_grid.jqGrid('navGrid', '#static_routes_pager', {edit: false, add: false, del: false, search: false, refresh: false},
            {},  // edit button
            {},  // add button
            {}); // del button
    },

    addDnsServer: function (event) {
        event.preventDefault();
        var dns_server = IPHELPER.trimIP4($('#dns_server').val());

        // verify server is valid ip
        if (dns_server.length === 0 || IPHELPER.usableHostIP4(dns_server) !== 0) {
            $('#dns_server').focus();
            $('#dns_server').select();
            writeErrorContainer(S_ERR_DNS_IP, false);
            return;
        }

        // don't allow duplicates
        if ($('#dns_server_list option[value="' + dns_server + '"]').length > 0) {
            $('#dns_server').focus();
            $('#dns_server').select();
            writeErrorContainer(S_ERR_DNS_DUP, false);
            return;
        }

        $('#dns_server_list').append('<option value="' + dns_server + '">' + dns_server + '</option>');
        $('#dns_server').val("");
        $('#error_container').hide();
    },

    removeDnsServer: function (event) {
        event.preventDefault();
        var selected_server = $('#dns_server_list').val();

        if (selected_server && selected_server.length !== 0) {
            $('#dns_server_list option[value="' + selected_server + '"]').remove();
        }
        return;
    },

    addNtpServer: function (event) {
        event.preventDefault();
        var ntp_server = $('#ntp_server').val();

        var ntp_valid_ip = IPHELPER.validIP4(ntp_server);

        // verify server is valid ip
        if (ntp_server.length === 0 || (!ntp_valid_ip && !validateDomainNameStr(ntp_server))) {
            $('#ntp_server').focus();
            $('#ntp_server').select();
            writeErrorContainer(S_ERR_NTP_IP, false);
            return;
        }

        if (ntp_valid_ip) {
            ntp_server = IPHELPER.trimIP4(ntp_server);
        }

        // don't allow duplicates
        if ($('#ntp_server_list option[value="' + ntp_server + '"]').length > 0) {
            $('#ntp_server').focus();
            $('#ntp_server').select();
            writeErrorContainer(S_ERR_NTP_DUP, false);
            return;
        }

        $('#ntp_server_list').append('<option value="' + ntp_server + '">' + ntp_server + '</option>');
        $('#ntp_server').val("");
        $('#error_container').hide();
    },

    removeNtpServer: function (event) {
        event.preventDefault();
        var selected_server = $('#ntp_server_list').val();

        if (selected_server && selected_server.length !== 0) {
            $('#ntp_server_list option[value="' + selected_server + '"]').remove();
        }
        return;
    },

    toggleNtpEnable: function () {
        var enable = $('#ntp_enabled_radio').is(':checked');
        if (enable) {
            $('#ntp_enabled').show();
            $('#ntp_disabled').hide();
        } else {
            $('#ntp_enabled').hide();
            $('#ntp_disabled').show();
        }
    },

    showHideRouteSettings: function (event) {
        event.preventDefault();
        if ($('#static_route_settings').is(':visible')) {
            $('#static_route_settings_btn').text(S_SHOW_ROUTE_SETTINGS);
        } else {
            $('#static_route_settings_btn').text(S_HIDE_ROUTE_SETTINGS);
        }
        $('#static_route_settings').slideToggle();
    },

    //
    // -------------------- start Interface Modal ---------------------------------//
    //

    editIfaceAction: function () {
        // make sure a row was selected
        if (!$('#inf_grid_table').jqGrid('getGridParam', 'selrow')) {
            return;
        }

        WGRD.doModal('#edit_iface_dlg',
                     SYS_C.initIfaceModal,
                     SYS_C.saveIfaceModal);
    },

    initIfaceModal: function (params) {
        // place dialog control initialization here
        var grid = $('#inf_grid_table');
        var selRowId = grid.jqGrid('getGridParam', 'selrow');
        var status = grid.jqGrid('getCell', selRowId, 'status');
        var name = grid.jqGrid('getCell', selRowId, 'name');
        var ip_type = grid.jqGrid('getCell', selRowId, 'ip_type');
        var ip = grid.jqGrid('getCell', selRowId, 'ip_addr');
        var ip_split = ip.split('/');
        var mask = '';
        if (ip_split.length === 2) {
            ip = ip_split[0];
            mask = ip_split[1];
        }

        var gw = grid.jqGrid('getCell', selRowId, 'gw');

        var enabled = true;
        if (status === IFACE_STATUS[0]) {
            // disabled
            enabled = false;
        }
        if (ip_type === IFACE_IP_TYPE[0]) {
            $('#iface_type :nth-child(1)').attr('selected', 'selected');
        } else {
            $('#iface_type :nth-child(2)').attr('selected', 'selected');
        }

        $('#iface_name').html(name);
        $('#iface_state').prop('checked', enabled);
        $('#iface_ip').val(ip);
        $('#iface_mask').val(mask);
        $('#iface_gw').val(gw);

        SYS_C.toggleIfaceState();
        SYS_C.toggleIfaceType();

        return true;
    },

    saveIfaceModal: function () {
        //validate dialog controls here
        var data = {};
        data.name = $('#iface_name').html();

        var enabled = $('#iface_state').is(':checked');
        if (enabled) {
            data.status = IFACE_STATUS[1];
            if ($('#iface_type')[0].selectedIndex === 0) {
                data.ip_type = IFACE_IP_TYPE[0];
                var ip_address = IPHELPER.trimIP4($('#iface_ip').val());
                var mask = $('#iface_mask').val();
                data.gw = IPHELPER.trimIP4($('#iface_gw').val());

                // validate IP and GW
                if (IPHELPER.usableHostIP4(ip_address) !== 0) {
                    $('#iface_ip').focus();
                    $('#iface_ip').select();
                    return S_ERR_IFACE_IP;
                }
                if (mask.length === 0 || !$.isNumeric(mask) || parseInt(mask, 10) < 0 || parseInt(mask, 10) > 32) {
                    $('#iface_mask').focus();
                    $('#iface_mask').select();
                    return S_ERR_IFACE_MASK;
                }
                data.ip_addr = ip_address + '/' + mask;
                if (IPHELPER.usableHostIP4(data.gw) !== 0) {
                    $('#iface_gw').focus();
                    $('#iface_gw').select();
                    return S_ERR_IFACE_GW;
                }
            } else {
                data.ip_type = IFACE_IP_TYPE[1];
                data.ip_addr = '';
                data.gw = '';
            }
        } else {
            data.status = IFACE_STATUS[0];
            data.ip_type = IFACE_IP_TYPE[1];
            data.ip_addr = '';
            data.gw = '';
        }

        // update the table
        var grid = $('#inf_grid_table');
        var selRowId = grid.jqGrid('getGridParam', 'selrow');
        var table_data = grid.jqGrid('getGridParam', 'data');
        var row_data = grid.jqGrid('getRowData', selRowId);
        var i = SYS_C._ifaceFindRow(grid, table_data, row_data);
        if (i !== -1) {
            table_data.splice(i, 1);
            table_data.splice(i, 0, data);
        }
        grid.trigger('reloadGrid');

        return;
    },

    _ifaceFindRow: function (grid, table_data, row_data) {
        var i;
        for (i = 0; i < table_data.length; i++) {
            if (table_data[i].name === row_data.name) {  // name is constant
                return i;
            }
        }
        return -1;
    },

    toggleIfaceState: function () {
        var enabled = $('#iface_state').is(':checked');
        $('#iface_state_text').text(IFACE_STATUS[enabled ? 1 : 0]);
        WGRD.enableUIElements(enabled, ['#iface_type', '#iface_ip', '#iface_mask', '#iface_gw']);
    },

    toggleIfaceType: function () {
        if ($('#iface_type')[0].selectedIndex === 0) {
            // static
            $('#iface_ip_cg').show();
            $('#iface_gw_cg').show();
        } else {
            // dhcp
            $('#iface_ip_cg').hide();
            $('#iface_gw_cg').hide();
        }
    },

    //
    // -------------------- end Interface Modal -----------------------------------//
    //


    //
    // -------------------- start Routes Modal ------------------------------------//
    //

    routeAddAction: function () {
        $('#add_edit_route_dlg h3').html(S_ROUTE_ADD_TITLE);

        WGRD.doModal('#add_edit_route_dlg',
                     SYS_C.initRouteModal,
                     SYS_C.saveRouteModal);
    },

    routeEditAction: function () {
        // verify something is selected
        var grid = $('#static_routes_grid_table');
        var selRowId = grid.jqGrid('getGridParam', 'selrow');
        if (!selRowId) {
            return;
        }
        if (WGRD.userInViewMode(is_page_locked, SYS_C.pg_tracker)) {
            $('#add_edit_route_dlg h3').html(S_ROUTE_VIEW_TITLE);
        } else {
            $('#add_edit_route_dlg h3').html(S_ROUTE_EDIT_TITLE);
        }

        var params = {};
        params.selRowId = selRowId;
        params.destination = grid.jqGrid('getCell', selRowId, 'destination');
        params.gateway = grid.jqGrid('getCell', selRowId, 'gateway');
        params.metric = grid.jqGrid('getCell', selRowId, 'metric');

        WGRD.doModal('#add_edit_route_dlg',
                     SYS_C.initRouteModal,
                     SYS_C.saveRouteModal,
                     params);
    },

    initRouteModal: function (params) {
        //place dialog control initialization here
        if (params) {
            $('#route_dst').val(params.destination);
            $('#route_gw').val(params.gateway);
            $('#route_metric').val(params.metric);
        } else {
            $('#route_dst').val('');
            $('#route_gw').val('');
            $('#route_metric').val('1');
        }

        return true;
    },

    saveRouteModal: function (params) {
        // validate dialog controls here
        var data = {};

        // check valid destination ip
        data.destination = IPHELPER.trimIP4($('#route_dst').val());
        if (IPHELPER.usableHostIP4(data.destination) !== 0 && IPHELPER.usableNetworkIP4(data.destination) !== 0) {
            $('#route_dst').focus();
            $('#route_dst').select();
            return S_ERR_ROUTE_DST;
        }

        // check valid gateway ip
        data.gateway = IPHELPER.trimIP4($('#route_gw').val());
        if (IPHELPER.usableHostIP4(data.gateway) !== 0) {
            $('#route_gw').focus();
            $('#route_gw').select();
            return S_ERR_ROUTE_GW;
        }

        // check metric range
        data.metric = $('#route_metric').val();
        var metric_error = WGRD.isValidNumeric($('#route_metric'), S_ROUTE_METRIC);
        if (metric_error && metric_error.length > 0) {
            $('#route_metric').focus();
            $('#route_metric').select();
            return metric_error;
        }
        data.metric = parseInt(data.metric, 10);

        // don't allow destination and gateway to be the same
        var slash_index = data.destination.indexOf('/');
        var ip = data.destination;
        if (slash_index !== -1) {
            ip = data.destination.substring(0, slash_index);
        }
        if (ip === data.gateway) {
            $('#route_gw').focus();
            $('#route_gw').select();
            return S_ERR_ROUTE_GW_DST;
        }

        // block duplicate routes
        var grid = $('#static_routes_grid_table');
        var table_data = grid.jqGrid('getGridParam', 'data');
        if (SYS_C._routeFindRow(grid, table_data, data) !== -1) {
            return S_ERR_ROUTE_DUPLICATE;
        }

        // update the table
        if (params) {
            SYS_C._deleteRouteRow(grid, table_data, params.selRowId);
            SYS_C._addRouteRow(grid, table_data, data);
        } else {
            SYS_C._addRouteRow(grid, table_data, data);
        }

        return;
    },

    routeDeleteAction: function () {
        // verify something is selected
        var grid = $('#static_routes_grid_table');
        var selRowId = grid.jqGrid('getGridParam', 'selrow');
        if (!selRowId) {
            return;
        }

        var table_data = grid.jqGrid('getGridParam', 'data');
        SYS_C._deleteRouteRow(grid, table_data, selRowId);
    },

    _addRouteRow: function (grid, table_data, row_data) {
        table_data.push(row_data);
        grid.trigger('reloadGrid');
    },

    _deleteRouteRow: function (grid, table_data, selRowId) {
        var row_data = grid.jqGrid('getRowData', selRowId);
        var i = SYS_C._routeFindRow(grid, table_data, row_data);
        if (i !== -1) {
            table_data.splice(i, 1);
        }
        grid.trigger('reloadGrid');
    },

    _routeFindRow: function (grid, table_data, row_data) {
        var i;
        for (i = 0; i < table_data.length; i++) {
            if (table_data[i].destination === row_data.destination &&
                    table_data[i].gateway === row_data.gateway &&
                    table_data[i].metric === parseInt(row_data.metric, 10)) {

                return i;
            }
        }
        return -1;
    },

    //
    // -------------------- end Routes Modal --------------------------------------//
    //


    toggleSendFeedbackState: function () {
        if (!$('#send_feedback_enabled').is(':checked')) {
            WGRD.okMessageModal(S_SEND_FEEDBACK_MESSAGE, S_SEND_FEEDBACK_TITLE);
        }
    },

    //
    // -------------------- start email settings ----------------------------------//
    //

    toggleEmailState: function () {
        var enabled = $('#email_enabled').is(':checked');
        var auth_enabled = $('#email_auth_enabled').is(':checked');
        WGRD.enableUIElements(enabled, ['#email_auth_user', '#email_auth_password',
                '#email_host', '#email_port', '#email_encryption', '#email_auth_enabled']);
        if (enabled) {
            WGRD.enableUIElements(auth_enabled, ['#email_auth_user', '#email_auth_password']);
        }
    },

    validateEmailSettings: function () {
        if (!$('#email_enabled').is(':checked')) {
            return true;
        }
        // host
        var eserv = $('#email_host').val();
        if (eserv.length === 0) {
            $('#email_host').focus();
            $('#email_host').select();
            writeErrorContainer(S_ERR_EMAIL_HNAME_EMPTY, false);
            return false;
        }
        if (eserv.length > 128) {
            $('#email_host').focus();
            $('#email_host').select();
            writeErrorContainer(S_ERR_EMAIL_HNAME_LEN, false);
            return false;
        }

        // port - 1-65535
        var port_error = WGRD.isValidNumeric($('#email_port'), S_EMAIL_PORT_NUM);
        if (port_error && port_error.length > 0) {
            $('#email_port').focus();
            $('#email_port').select();
            writeErrorContainer(port_error, false);
            return false;
        }

        if ($('#email_auth_enabled').is(':checked')) {
            // auth username
            var uname = $('#email_auth_user').val();
            if (uname.length === 0) {
                $('#email_auth_user').focus();
                $('#email_auth_user').select();
                writeErrorContainer(S_ERR_EMAIL_UNAME_EMPTY, false);
                return false;
            }
            if (uname.length > 128) {
                $('#email_auth_user').focus();
                $('#email_auth_user').select();
                writeErrorContainer(S_ERR_EMAIL_UNAME_LEN, false);
                return false;
            }
            // password (could be empty)
            if (SYS_C.email_auth_password_changed && SYS_C.email_auth_password_value.length > 128) {
                $('#email_auth_password').focus();
                writeErrorContainer(S_ERR_EMAIL_PASSWD_LEN, false);
                return false;
            }
        }
        return true;
    },
    //
    //
    // -------------------- end email settings ----------------------------------//
    //

    toggleBackupState: function () {
        var enabled = $('#remote_backup_enable').is(':checked');
        WGRD.enableUIElements(enabled, ['#remote_backup_host', '#remote_backup_port', '#remote_backup_user', '#remote_backup_dir', '#remote_backup_test_btn']);
    },

    testRemoteBackup: function () {
        if (!$('#remote_backup_enable').is(':checked')) {
            return;
        }

        if (!SYS_C.validateBackupSettings()) {
            return;
        }

        var data = {
            'enabled': $('#remote_backup_enable').is(':checked'),
            'method': 'sftp',
            'host': $('#remote_backup_host').val(),
            'port': $('#remote_backup_port').val(),
            'user': $('#remote_backup_user').val(),
            'directory': $('#remote_backup_dir').val()
        };

        $('#remote_backup_test_btn').button({'disabled': true});
        $('#test_backup_conn_results').hide();
        $('#progress_test_backup_conn').show();

        $.ajax({
            url: 'test_backup_conn',
            dataType: 'json',
            data: data,
            success: function (response) {
                if (response.success) {
                    $('#test_backup_conn_results').attr('class', 'success');
                    $('#test_backup_conn_results').text(S_SUCCESS);
                } else {
                    $('#test_backup_conn_results').attr('class', 'fail');
                    $('#test_backup_conn_results').text(response.message);
                }
                $('#test_backup_conn_results').show();
            },
            error: function (response) {
                alert(response);
            },
            complete: function () {
                $('#progress_test_backup_conn').hide();
                $('#remote_backup_test_btn').button({'disabled': false});
            }
        });
    },

    cancelPage: function () {
        window.location.pathname = 'system/settings';
    },

    validateBackupSettings: function () {
        if (!$('#remote_backup_enable').is(':checked')) {
            return true;
        }

        // host
        var hname = $('#remote_backup_host').val();
        if (hname.length === 0) {
            $('#remote_backup_host').focus();
            $('#remote_backup_host').select();
            writeErrorContainer(S_ERR_BACKUP_HNAME_EMPTY, false);
            return false;
        }
        if (hname.length > 128) {
            $('#remote_backup_host').focus();
            $('#remote_backup_host').select();
            writeErrorContainer(S_ERR_BACKUP_HNAME_LEN, false);
            return false;
        }

        // port - 1-65535
        var port_error = WGRD.isValidNumeric($('#remote_backup_port'), S_BACKUP_PORT_NAME);
        if (port_error && port_error.length > 0) {
            $('#remote_backup_port').focus();
            $('#remote_backup_port').select();
            writeErrorContainer(port_error, false);
            return false;
        }

        // username
        var uname = $('#remote_backup_user').val();
        if (uname.length === 0) {
            $('#remote_backup_user').focus();
            $('#remote_backup_user').select();
            writeErrorContainer(S_ERR_BACKUP_UNAME_EMPTY, false);
            return false;
        }
        if (uname.length > 128) {
            $('#remote_backup_user').focus();
            $('#remote_backup_user').select();
            writeErrorContainer(S_ERR_BACKUP_UNAME_LEN, false);
            return false;
        }

        // directory
        var dir = $('#remote_backup_dir').val();
        if (dir.length === 0) {
            $('#remote_backup_dir').focus();
            $('#remote_backup_dir').select();
            writeErrorContainer(S_ERR_BACKUP_DIR_EMPTY, false);
            return false;
        }
        if (dir.length > 512) {
            $('#remote_backup_dir').focus();
            $('#remote_backup_dir').select();
            writeErrorContainer(S_ERR_BACKUP_DIR_LEN, false);
            return false;
        }
        if (dir.indexOf('\\') !== -1) {
            $('#remote_backup_dir').focus();
            $('#remote_backup_dir').select();
            writeErrorContainer(S_ERR_BACKUP_DIR_BACKSLASH, false);
            return false;
        }

        return true;
    },

    _validateInfSettings: function () {
        // hostname (alphanumeric plus dash and max 64 chars)
        var hname = $('#hostname').val();
        if (hname.length === 0) {
            $('#hostname').focus();
            $('#hostname').select();
            writeErrorContainer(S_ERR_HNAME_EMPTY, false);
            return false;
        }
        if (/^[0-9,.]*$/.test(hname) === true) {
            $('#hostname').focus();
            $('#hostname').select();
            writeErrorContainer(S_ERR_HNAME_ONLY_DIGITS, false);
            return false;
        }
        if (hname.length > 64) {
            $('#hostname').focus();
            $('#hostname').select();
            writeErrorContainer(S_ERR_HNAME_LEN, false);
            return false;
        }
        if (hname.indexOf('-') === 0) {  // can't start with dash
            $('#hostname').focus();
            $('#hostname').select();
            writeErrorContainer(S_ERR_HNAME_DASH_STARTS, false);
            return false;
        }
        if (/\-$/.test(hname) === true) {  // can't end with dash
            $('#hostname').focus();
            $('#hostname').select();
            writeErrorContainer(S_ERR_HNAME_DASH_ENDS, false);
            return false;
        }
        if (/^[a-z0-9\-]+$/i.test(hname) === false) {  // letters, numbers and dash
            $('#hostname').focus();
            $('#hostname').select();
            writeErrorContainer(S_ERR_HNAME_CHARS, false);
            return false;
        }

        // require at least one enabled interface
        var inf_data = $('#inf_grid_table').jqGrid('getGridParam', 'data');
        var inf_enabled = false;
        var i;
        for (i = 0; i < inf_data.length; i++) {
            if (IFACE_STATUS.indexOf(inf_data[i].status) === 1) {
                inf_enabled = true;
                break;
            }
        }
        if (!inf_enabled) {
            writeErrorContainer(S_ERR_IFACE_REQ, false);
            return false;
        }

        return true;
    },

    _validateDomainSettings: function () {
        // domain name - optional
        if ($.trim($('#dns_name').val()).length > 0) {
            if (!validateDomainName('#dns_name')) {
                $('#dns_name').focus();
                $('#dns_name').select();
                writeErrorContainer(S_ERR_DOMAIN, false);
                return false;
            }
        }

        // require at least one dns server if there are no dhcp addresses
        if ($('select#dns_server_list option').length === 0) {
            var inf_data = $('#inf_grid_table').jqGrid('getGridParam', 'data');
            var has_dhcp = false;
            var i;
            for (i = 0; i < inf_data.length; i++) {
                if (IFACE_IP_TYPE.indexOf(inf_data[i].ip_type) === 1 && IFACE_STATUS.indexOf(inf_data[i].status) === 1) {
                    has_dhcp = true;
                    break;
                }
            }
            if (!has_dhcp) {
                $('#dns_server').focus();
                $('#dns_server').select();
                writeErrorContainer(S_ERR_DNS_REQ, false);
                return false;
            }
        }

        return true;
    },

    _validateTimeSettings: function () {
        // require at least one ntp server if it is enabled
        if ($('#ntp_enabled_radio').is(':checked')) {
            if ($('#ntp_server_list option').length === 0) {
                $('#ntp_server').focus();
                $('#ntp_server').select();
                writeErrorContainer(S_ERR_NTP_EMPTY, false);
                return false;
            }
        } else {
            // make sure the time is valid
            if ($('#sys_time').data('datetimepicker').getDate() === null) {
                $('#time_val').focus();
                $('#time_val').select();
                writeErrorContainer(S_ERR_TIME_EMPTY, false);
                return false;
            }
        }

        return true;
    },

    validateUI: function () {
        // interface settings
        if (has_inf_settings && !SYS_C._validateInfSettings()) {
            return false;
        }

        // domain settings
        if (has_domain_settings && !SYS_C._validateDomainSettings()) {
            return false;
        }

        // time settings
        if (!SYS_C._validateTimeSettings()) {
            return false;
        }

        // remote backup server settings
        if (!SYS_C.validateBackupSettings()) {
            return false;
        }

        // email server settings
        if (!SYS_C.validateEmailSettings()) {
            return false;
        }

        return true;
    },

    savePage: function () {
        $('#error_container').hide();
        $('#submit_button').attr('disabled', true);
        $('#progress_save').show();

        // validate the input
        if (!SYS_C.validateUI()) {
            // validation failed
            $('#submit_button').removeAttr('disabled');
            $('#progress_save').hide();
            return;
        }

        // save the data
        var cfg_data = new SystemConfigObj();

        // track whether we are controlling interface and/or domain settings
        cfg_data.has_inf_settings = has_inf_settings;
        cfg_data.has_domain_settings = has_domain_settings;

        // hostname
        cfg_data.hostname = $('#hostname').val();

        // interface info
        var inf_data = $('#inf_grid_table').jqGrid('getGridParam', 'data');
        cfg_data.inf_list = new Array(inf_data.length);
        var i;
        for (i = 0; i < inf_data.length; i++) {
            cfg_data.inf_list[i] = JSON.parse(JSON.stringify(inf_data[i]));  // use JSON to clone the data object since we change the status and ip_type values
            cfg_data.inf_list[i].status = IFACE_STATUS.indexOf(cfg_data.inf_list[i].status);
            cfg_data.inf_list[i].ip_type = IFACE_IP_TYPE.indexOf(cfg_data.inf_list[i].ip_type);
            if (cfg_data.inf_list[i].ip_type !== 0) {
                // remove the ip_addr and gw fields when not "static"
                delete cfg_data.inf_list[i].ip_addr;
                delete cfg_data.inf_list[i].gw;
            }
        }

        // domain name
        cfg_data.dns_name = $.trim($('#dns_name').val());

        // dns server list
        $("#dns_server_list option").each(function (i) {
            cfg_data.dns_servers[i] = $(this).val();
        });

        // ntp and time
        cfg_data.curr_time = 0;
        if ($('#ntp_enabled_radio').is(':checked')) {
            cfg_data.ntp_enabled = true;
            $("#ntp_server_list option").each(function (i) {
                cfg_data.ntp_servers[i] = $(this).val();
            });
        } else {
            cfg_data.ntp_enabled = false;
            cfg_data.curr_time = $('#sys_time').data('datetimepicker').getDate().getTime();
            cfg_data.set_time = (cfg_data.curr_time !== org_curr_time);  // only set the time if it changed
        }

        // save/preserve the timezone (TZ is not exposed in UI, but we preserve the setting)
        cfg_data.tz = org_tz;

        // static routes
        var route_data = $('#static_routes_grid_table').jqGrid('getGridParam', 'data');
        cfg_data.static_route_list = new Array(route_data.length);
        for (i = 0; i < route_data.length; i++) {
            cfg_data.static_route_list[i] = route_data[i];
            cfg_data.static_route_list[i].metric = parseInt(cfg_data.static_route_list[i].metric, 10);
        }

        // callhome data
        if ($('#send_feedback_enabled').is(':checked')) {
            cfg_data.send_feedback_enabled = true;
        } else {
            cfg_data.send_feedback_enabled = false;
        }

        // email server settings
        if ($('#email_enabled').is(':checked')) {
            cfg_data.email_enabled = true;
            cfg_data.email_host = $('#email_host').val();
            cfg_data.email_port = parseInt($('#email_port').val(), 10);
            if ($('#email_auth_enabled').is(':checked')) {
                cfg_data.email_auth_enabled = true;
                cfg_data.email_auth_user = $('#email_auth_user').val();
                cfg_data.email_auth_password = SYS_C.email_auth_password_changed ?
                        $('#email_auth_password').val() : null;
            } else {
                cfg_data.email_auth_enabled = false;
            }
            cfg_data.email_encryption_level = $('#email_encryption').val();
        } else {
            cfg_data.email_enabled = false;
        }

        // remote backup settings
        if ($('#remote_backup_enable').is(':checked')) {
            cfg_data.remote_backup_enable = true;
            cfg_data.remote_backup_host = $('#remote_backup_host').val();
            cfg_data.remote_backup_port = parseInt($('#remote_backup_port').val(), 10);
            cfg_data.remote_backup_user = $('#remote_backup_user').val();
            cfg_data.remote_backup_dir = $('#remote_backup_dir').val();
        } else {
            cfg_data.remote_backup_enable = false;
        }

        // submit the change
        WGRD.putData(cfg_data).success(function (response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                // update org_curr_time if we set the time
                if (cfg_data.set_time) {
                    org_curr_time = cfg_data.curr_time;
                }
                WGRD.updateModeUI(1);  //Update the user mode div
                WGRD.resetUserMode();  //Reset the lock after save
            }
        });
    },

    doResizeGrids: function () {
        var pad = parseInt($("#inf_grid_div").css('margin-left'), 10);
        pad *= 2;
        if (pad === 0) {
            pad += 1;  // add at least 1 pixel padding to keep the grid smaller than the parent
        }
        var grid_width = $("#inf_grid_div").width() - pad;
        $('#inf_grid_table').setGridWidth(grid_width);
        $('#static_routes_grid_table').setGridWidth(grid_width);
    }
};
$(document).ready(SYS_C.init);
