/*global WGRD, POLLER, IPHELPER, validateDomainNameWildcardStr, alert, activeUsersColModel, activeUsersColNames, S_ERROR_TITLE, S_WAITING, SEND_FEEDBACK_STATUS, S_CONNECTED, S_LOADING, S_ACTIVE_USERS_TITLE, S_SEARCH_USER, S_REFRESH_USER_LIST, S_GEN_CSR_TITLE, S_CSR_OVERWRITE_TITLE, S_CSR_OVERWRITE, S_CSR_DOWNLOAD_ERROR, S_IMPORT_CERT_DESCR_WEB, S_WEBSERVER_CERT_ERROR, S_WEBSERVER_CERT_PFX_ERROR, S_EXPORT_CERT_ERROR, S_EXPORT_CERT_TITLE, S_REGENERATE, S_RESTORE, S_CONFIRM_REGENERATE_CERT_TITLE, S_CONFIRM_REGENERATE_CERT, S_CONFIRM_RESTORE_CERT_TITLE, S_CONFIRM_RESTORE_CERT, S_ERR_ACTION_RESTORE_CERT, S_CA_CERT_ERROR, S_SERVER_RESTART_TITLE, S_SERVER_RESTART_MSG, S_MISSING_CA_CERT, S_SERVER_REBOOT_TITLE, S_SERVER_REBOOT_MSG, S_SERVER_SHUTDOWN_TITLE, S_SERVER_UPGRADE_TITLE, S_SERVER_UPGRADE_MSG, S_SERVER_RESTORE_TITLE, S_SERVER_RESTORE_MSG, S_UPGRADE_CONFIRMATION_MSG, S_UPGRADE_ERROR_MSG, S_SYSTEM_RESTART_TITLE, S_SYSTEM_RESTART_MSG, S_REBOOT_CONFIRMATION_MSG, S_SHUTDOWN_CONFIRMATION_MSG, S_RESTORE_CONFIRMATION_MSG, S_NAME_EMPTY_MSG, S_COMP_EMPTY_MSG, S_COUNTRY_ERR_MSG, S_NAME_LEN_MSG, S_DEPT_LEN_MSG, S_COMP_LEN_MSG, S_CITY_LEN_MSG, S_STATE_LEN_MSG, S_ERR_ALT_NAME_INVALID, S_ERR_ALT_NAME_DUP, S_SHOW_ADV_SETTINGS, S_HIDE_ADV_SETTINGS, S_ERR_ACTION_REBOOT, S_ERR_ACTION_SHUTDOWN, S_ERR_ACTION_RESTORE, S_ERR_ACTION_UPGRADE, S_LOGOUT_CURRENT_USER, S_LOGOUT_OTHER_USER, S_LOGOUT_OTHER_USER_MSG, S_CA_CERT_EXPIRE_ONE_MONTH, S_CA_CERT_EXPIRED */
var SYS_S = {

    usingBuiltinCert: true,
    pollSystemStatus: null,
    pollActiveUsers: null,

    init: function () {
        SYS_S.initUI();
        SYS_S.initEvents();
    },

    // initialize UI elements
    initUI: function () {
        $("#adv").hide();
        $('#progress_server_action').hide();
        $('#progress_refresh_sys_info').hide();

        $('#missing_ca_cert_tooltip').tooltip({
            html: true,
            placement: 'left',
            title: S_MISSING_CA_CERT
        });

        WGRD.enableUIElements(true, ['#btn_reboot']);
        SYS_S.createActiveUsersGrid();
        SYS_S.updateSystemInfo();

        // detect if any fields are changed
        var flds = $("input, textarea", window.document);
        $(flds).on('change keyup', flds, function (eo) {
            $('#web_cert_load_error').hide();
            $('#upgrade_load_error').hide();
        });
        WGRD.enableUIElements(false, ['#logout_user']);
    },

    initEvents: function () {
        $(window).bind('resizeEnd', function () {
            SYS_S.doResizeGrid();
        });

        // Show the modal dialog
        $('#web_csr_btn').button().click(SYS_S.webCSRAction);
        $('#web_csr_download_btn').button().click(SYS_S.webCSRDownloadAction);
        $('#restore_btn').button().click(SYS_S.restoreAction);
        $('#reboot_btn').button().click(SYS_S.rebootAction);
        $('#upgrade_btn').button().click(SYS_S.upgradeAction);
        $('#shutdown_btn').button().click(SYS_S.shutdownAction);
        $('#import_web_cert_btn').button().click(SYS_S.importWebCertAction);
        $('#export_web_cert_btn').button().click(SYS_S.exportWebCertChainAction);
        $('#restore_web_cert_btn').button().click(SYS_S.restoreWebCertAction);
        $('#web_cert_type').change(SYS_S.setWebCertType);

        $('#add_alt_name').button().click(SYS_S.addAltName);
        $('#remove_alt_name').button().click(SYS_S.removeAltName);

        $('#web_cert_server_enabled_paste').click(function (event) {
            return SYS_S.toggleImportCertType(event);
        });
        $('#web_cert_server_enabled_file').click(function (event) {
            return SYS_S.toggleImportCertType(event);
        });

        $('#logout_user').button().click(SYS_S.initLogOutDialog);  //Launch the dialog
        $('#logout_user_btn').button().click(SYS_S.delUserSession); //Trigger other user's session deletion
        $('#logout_confirm_save_btn').click(SYS_S.userLogOut);

        // start a poller to refresh the system and active users info every 30 and 60 seconds, respectively
        SYS_S.pollSystemStatus = new POLLER('system_info', null, 30000, SYS_S.updateSystemInfoHandler, SYS_S.activeUsersRefreshErrorHandler);
        SYS_S.pollActiveUsers = new POLLER('get_active_users', null, 60000, SYS_S.activeUsersRefreshSuccessHandler, SYS_S.activeUsersRefreshErrorHandler);
    },

    toggleImportCertType: function (event) {
        var target = event.currentTarget.id;
        var index = target.indexOf('_enabled_');
        var prefix = target.substring(0, index + 1);
        var enable = $('#' + prefix + 'enabled_paste').is(':checked');
        if (enable) {
            $('#' + prefix + 'import_paste').show();
            $('#' + prefix + 'import_file').hide();
        } else {
            $('#' + prefix + 'import_paste').hide();
            $('#' + prefix + 'import_file').show();
        }
    },

    updateSystemInfoHandler: function (response) {
        SYS_S.updateSystemInfoUI(response);
        return true;
    },

    initLogOutDialog: function () {
        $('#logout_error').hide();
        $('#logout_user_btn').hide();
        $('#logout_confirm_save_btn').show();
        $('#logout_confirm_msg').show();

        $("#logout_confirm_dlg").modal();
    },

    _show_success_error_msg: function (id, msg, success) {
        $(id)
             .text(msg)
             .show();
        if (success) {
            $(id)
                 .addClass("alert-success wgrd-modal-success")
                 .removeClass("alert-error wgrd-modal-error");
        } else {
            $(id)
                .removeClass("alert-success wgrd-modal-success")
                .addClass("alert-error wgrd-modal-error");
        }
    },

    userLogOut: function () {
        var sel_row = jQuery('#active_users_grid_table').jqGrid('getGridParam', 'selrow');
        var user_data = {'sess_key': $("#active_users_grid_table").jqGrid('getCell', sel_row, 4)};

        $.ajax({
            url: 'check_user',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: user_data,
            success: function (data) {
                if (data.status) { // Success
                    //Check if the user being logged out is the current user or not
                    if (data.current_user) {
                        $('#logout_confirm_cancel_btn').prop("disabled", true);
                        $('#logout_confirm_save_btn').prop("disabled", true);
                        $('#logout_confirm_msg').hide();
                        SYS_S._show_success_error_msg($('#logout_error'), S_LOGOUT_CURRENT_USER, true);
                        $('#loading').show();
                        setTimeout(function () {
                            WGRD.logout();
                        }, 1000);
                    } else { // Logging out other user, check if page_locked
                        if (data.page_locked) {
                            $('#logout_confirm_msg').hide();
                            SYS_S._show_success_error_msg($('#logout_error'), S_LOGOUT_OTHER_USER_MSG, false);
                            $('#logout_confirm_cancel_btn').prop("disabled", false);
                            $('#logout_confirm_save_btn').hide();
                            $('#logout_user_btn').prop("disabled", false)
                                                 .show();
                        } else {
                            SYS_S.delUserSession();
                        }
                    }
                } else { //Error in logging out user
                    $('#logout_error').show();
                }
            },
            error: function (data) {
                $('#logout_error').show();
            }
        });
    },

    delUserSession: function () {

        WGRD.enableUIElements(false, ['#logout_user']);
        $('#logout_confirm_msg').hide();
        var sel_row = jQuery('#active_users_grid_table').jqGrid('getGridParam', 'selrow');
        var username = $("#active_users_grid_table").jqGrid('getCell', sel_row, 0);
        var sess_key = $("#active_users_grid_table").jqGrid('getCell', sel_row, 4);
        var user_data = {'username': username, 'sess_key': sess_key};
        $('#logout_confirm_cancel_btn').prop("disabled", true);
        $('#logout_confirm_save_btn').prop("disabled", true);
        $('#logout_user_btn').prop("disabled", true);
        $.ajax({
            url: 'del_user_sess',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: user_data,
            success: function (data) {
                if (data.status) {
                    SYS_S._show_success_error_msg($('#logout_error'), S_LOGOUT_OTHER_USER, true);
                    setTimeout(function () {
                        $('#logout_confirm_dlg').modal('hide');
                        $('#logout_confirm_cancel_btn').prop("disabled", false);
                        $('#logout_confirm_save_btn').prop("disabled", false);
                        SYS_S.refreshActiveUsersGrid();
                    }, 1000);
                }
            },
            error: function (data) {
                $('#logout_error').show();
            }
        });
    },

    activeUsersRefreshSuccessHandler: function (response) {
        $('#active_users_grid_table').jqGrid('clearGridData');
        $('#active_users_grid_table').jqGrid('setGridParam', {
            datatype: 'local',
            data: response
        });

        $('#active_users_grid_table').trigger('reloadGrid');
        $('#active_users_grid_table').setCaption(S_ACTIVE_USERS_TITLE);

        SYS_S.doResizeGrid();
        return true;
    },

    activeUsersRefreshErrorHandler: function (response, num_failed) {
        return true;
    },

    // ------------ Generate CSR -------------------------------------------------------

    webCSRAction: function () {
        $('#progress_dlg').modal();

        // check if a pending csr already exists or not; if so, prompt to overwrite it
        $.ajax({
            url: 'webserver_csr_exists',
            dataType: 'json',
            success: function (response) {
                $('#progress_dlg').modal('hide');
                if (response.status === 0) {  // success
                    if (response.exists) {
                        $('#confirmBoxDiv h3').text(S_CSR_OVERWRITE_TITLE);
                        WGRD.confirmModal(S_CSR_OVERWRITE, true, function () {
                            WGRD.doModal('#web_gen_csr_dlg',
                                    SYS_S.initGenCsrModal,
                                    SYS_S.saveGenCsrModal);
                        });
                    } else {
                        WGRD.doModal('#web_gen_csr_dlg',
                                SYS_S.initGenCsrModal,
                                SYS_S.saveGenCsrModal);
                    }
                } else {  // error
                    alert(response.message);
                }
            },

            error: function (response) {
                $('#progress_dlg').modal('hide');
            }
        });
    },

    initGenCsrModal: function () {
        //place dialog control initialization here
        return true;
    },

    saveGenCsrModal: function () {
        //validate dialog controls here
        var err = SYS_S.validateCsr('#web_gen_csr_dlg');
        if (err) {
            return err;
        }

        err = SYS_S.genCsr('#web_gen_csr_dlg', '#web_csr_btn');
        return err;
    },

    validateCsr: function (parent_div) {
        // handle required fields
        if ($('#cn').val().length === 0) {
            return S_NAME_EMPTY_MSG;
        }
        if ($('#cname').val().length === 0) {
            return S_COMP_EMPTY_MSG;
        }

        // enforce max field length
        if ($('#cn').val().length > 64) {
            return S_NAME_LEN_MSG;
        }
        if ($('#ou').val().length > 64) {
            return S_DEPT_LEN_MSG;
        }
        if ($('#cname').val().length > 64) {
            return S_COMP_LEN_MSG;
        }
        if ($('#city').val().length > 128) {
            return S_CITY_LEN_MSG;
        }
        if ($('#state').val().length > 128) {
            return S_STATE_LEN_MSG;
        }

        // restrict to 2-digit country code
        if ($('#country').val().length !== 2) {
            return S_COUNTRY_ERR_MSG;
        }

        return;
    },

    genCsr: function (parent_div, button_div) {
        var cn = $('#cn').val();       //Name (CN)
        var ou = $('#ou').val();       //Department Name (OU)
        var o = $('#cname').val();     //Company Name (O)
        var city = $('#city').val();   //City (L)
        var state = $('#state').val(); //State (ST)
        var c = $('#country').val();   //Country (C)

        var san_list = '';           //Alt Name list (SAN)
        $("#alt_name_list option").each(function (i) {
            san_list += $(this).val() + ',';
        });

        if (button_div) {
            $(button_div).button('loading');
        }

        var err = null;
        var data = {
            'name': cn,
            'alt_names': san_list,
            'dept': ou,
            'comp_name': o,
            'city': city,
            'state': state,
            'country': c
        };
        $.ajax({
            url: 'gen_webserver_csr',
            async: false,
            dataType: 'json',
            method: 'POST',
            data: JSON.stringify(data),
            contentType: 'application/json',
            success: function (response) {
                if (response.status === 0) {
                    window.location = 'get_file';
                    $('#web_csr_download_btn').show();
                } else {
                    err = response.message;
                }

                if (button_div) {
                    $(button_div).button('reset');
                }
            },
            error: function (response) {
                err = response.message;
            }
        });

        return err;
    },

    addAltName: function (event) {
        event.preventDefault();
        $('#web_gen_csr_error').hide();
        var alt_name = $('#alt_name').val();

        // verify server is valid ip
        if (alt_name.length === 0 || (!IPHELPER.validIP4(alt_name) && !validateDomainNameWildcardStr(alt_name))) {
            $('#alt_name').focus();
            $('#alt_name').select();
            $('#web_gen_csr_error').show();
            $('#web_gen_csr_error').html(S_ERR_ALT_NAME_INVALID);
            return;
        }

        // don't allow duplicates
        if ($('#alt_name_list option[value="' + alt_name + '"]').length > 0) {
            $('#alt_name').focus();
            $('#alt_name').select();
            $('#web_gen_csr_error').show();
            $('#web_gen_csr_error').html(S_ERR_ALT_NAME_DUP);
            return;
        }

        $('#alt_name_list').append('<option value="' + alt_name + '">' + alt_name + '</option>');
        $('#alt_name').val("");
        $('#error_container').hide();
    },

    removeAltName: function (event) {
        event.preventDefault();
        $('#web_gen_csr_error').hide();
        var alt_name = $('#alt_name_list').val();

        if (alt_name && alt_name.length !== 0) {
            $('#alt_name_list option[value="' + alt_name + '"]').remove();
        }
        return;
    },

    webCSRDownloadAction: function () {
        var err = null;
        $('#web_csr_download_btn').button('loading');
        $.ajax({
            url: 'get_webserver_csr',
            async: false,
            success: function (response, textStatus, jqXHR) {
                if (response.status === 0) {
                    window.location = 'get_file';
                } else {
                    err = response.message;
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                err = errorThrown;
            },
            complete: function (jqXHR, textStatus) {
                $('#web_csr_download_btn').button('reset');
            }
        });

        if (err) {
            WGRD.okMessageModal(S_CSR_DOWNLOAD_ERROR + err, S_ERROR_TITLE);
        }
    },

    // ------------ Generate CSR (end) -------------------------------------------------


    // ------------ Import WebServer Cert (start) --------------------------------------

    importWebCertAction: function () {
        WGRD.doModal('#web_cert_load_dlg',
                    SYS_S.initializeWebCertImport,
                    SYS_S.saveWebCertImport,
                    null,  // params
                    null,  // cancelHandler
                    true); // stayOpenOnSave
    },

    initializeWebCertImport: function (params) {
        // clear any existing related divs from the iframe
        $('#webserverCertImportFrame').empty();
        $('#web_cert_load_form')[0].reset();  // needed to clear the file input in IE

        // Initialize UI
        $('#web_cert_server_enabled_file').click();
        $('#web_cert_server_import_paste').hide();
        $('#web_cert_server_import_paste').val('');
        $('#web_cert_server_import_file').val('');
        $('#web_cert_pfx').hide();
        $('#web_cert_password_pfx').val('');
        $('#web_cert_pem').show();

        WGRD.enableUIElements(true, ['#web_cert_import_close', '#web_cert_import_ok']);
        $('#web_cert_load_loading').hide();

        return true;
    },

    saveWebCertImport: function (params) {
        // validate the data
        if ($('#web_cert_type').val() === "PEM") {
            // require a signed server cert
            var enable = $('#web_cert_server_enabled_file').is(':checked');
            if (enable && !$('#web_cert_server_import_file').val()) {
                return S_WEBSERVER_CERT_ERROR;
            }
            if (!enable && !$('#web_cert_server_import_paste').val()) {
                return S_WEBSERVER_CERT_ERROR;
            }
        } else if ($('#web_cert_type').val() === "PFX") {
            if (!$('#web_cert_server_import_file_pfx').val()) {
                return S_WEBSERVER_CERT_PFX_ERROR;
            }
        }

        // we submit the certs to the server and rely on the iframe reload to close the dialog
        SYS_S.uploading_webserver_cert = true;
        WGRD.enableUIElements(false, ['#web_cert_import_close', '#web_cert_import_ok']);

        $('#web_cert_load_form').submit();
        return;
    },

    // called when the iframe that handles the webserver cert upload is loaded
    // we use this to check for uploaded cert errors
    webserverCertUploaded: function () {
        if (!SYS_S.uploading_webserver_cert) {
            return;
        }

        // check for any errors
        var errors = $('#webserverCertImportFrame').contents().find('#webserver_cert_results_err').text();
        var warning = $('#webserverCertImportFrame').contents().find('#webserver_cert_results_warn').text();
        if (errors) {
            $('#web_cert_load_dlg div.wgrd-modal-error').html(errors);
            $('#web_cert_load_dlg div.wgrd-modal-error').show();
        } else {
            var message = S_SERVER_RESTART_MSG;
            if (warning) {
                // warn the user that they should import the cert chain for the webserver cert
                message += '<br><br><em>' + S_MISSING_CA_CERT + '</em>';
                $('#missing_ca_cert_warning').show();
            } else {
                // clear the warning icon/tooltip
                $('#missing_ca_cert_warning').hide();
            }

            // no errors so hide the dialog
            $('#web_cert_load_dlg').modal('hide');

            // redirect to login page (2 minute timeout)
            var dlg = WGRD.okMessageModal(message, S_SERVER_RESTART_TITLE);
            WGRD.redirectAfterRestart(dlg, null, 2 * 60 * 1000);
        }

        WGRD.enableUIElements(true, ['#web_cert_import_close', '#web_cert_import_ok']);
        $('#web_cert_load_loading').hide();
        SYS_S.uploading_webserver_cert = false;
    },

    // ------------ Import WebServer Cert (end) ----------------------------------------


    // ------------ Export WebServer Cert (start) --------------------------------------

    exportWebCertChainAction: function () {
        WGRD.enableUIElements(false, ['#export_web_cert_btn']);
        $('#progress_dlg').modal();

        $.ajax({
            url: 'export_webserver_cert_chain',
            dataType: 'json',
            success: function (response, textStatus, jqXHR) {
                $('#progress_dlg').modal('hide');
                if (response.status === 0) {
                    var file_args = '?tmp_file_name=' + response.tmp_file_name + '&file_name=' + response.file_name;
                    window.location = 'get_tmp_file' + file_args;
                } else {
                    WGRD.okMessageModal(S_EXPORT_CERT_ERROR + response.error_msg, S_EXPORT_CERT_TITLE);
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('#progress_dlg').modal('hide');
                WGRD.okMessageModal(S_EXPORT_CERT_ERROR + errorThrown, S_EXPORT_CERT_TITLE);
            },
            complete: function (jqXHR, textStatus) {
                WGRD.enableUIElements(true, ['#export_web_cert_btn']);
            }
        });
    },

    // ------------ Export WebServer Cert (start) --------------------------------------


    // ------------ Restore WebServer Cert (start) -------------------------------------

    restoreWebCertAction: function () {
        var title = SYS_S.usingBuiltinCert ? S_CONFIRM_REGENERATE_CERT_TITLE : S_CONFIRM_RESTORE_CERT_TITLE;
        var msg = SYS_S.usingBuiltinCert ? S_CONFIRM_REGENERATE_CERT : S_CONFIRM_RESTORE_CERT;

        $('#confirmBoxDiv h3').text(title);
        WGRD.confirmModal(msg, true, function () {
            $.ajax({
                url: 'restore_webserver_cert',
                dataType: 'json',
                method: 'POST',
                success: function (response) {
                    if (response.status === 0) {
                        // warn the user about the server restart
                        WGRD.okMessageModal(S_SERVER_RESTART_MSG, S_SERVER_RESTART_TITLE);
                        var okBtn = WGRD.okMessageModalBtn();
                        okBtn.html(S_WAITING);
                        WGRD.enableUIElements(false, [okBtn.selector]);

                        // we cannot detect when the server is back up because the browser will not make the untrusted ssl connection
                        // instead, we wait and then re-direct
                        var from_page = window.location.pathname + window.location.search;
                        setTimeout(function () {
                            window.location.href = '/auth/login?from_page=' + encodeURIComponent(from_page);  // login page by default
                        }, 30000);
                    } else {
                        alert(S_ERR_ACTION_RESTORE_CERT);
                    }
                },
                error: function (response) {
                    alert(S_ERR_ACTION_RESTORE_CERT);
                }
            });
        }, true);
    },

   // ------------ Restore WebServer Cert (end) ----------------------------------------

    setWebCertType: function () {
        if ($('#web_cert_type').val() === "PEM") {
            // PEM file
            $('#web_cert_pfx').hide();
            $('#web_cert_pem').show();
        } else {
            // PFX file
            $('#web_cert_pem').hide();
            $('#web_cert_pfx').show();
        }
    },

   // ------------ Upgrade System (start) ----------------------------------------------

    upgradeAction: function () {
        if (is_upgrade_allowed) {
            WGRD.doModal('#upgrade_ws_dlg',
                    SYS_S.initializeUpgrade,
                    SYS_S.doUpgrade,
                    null,  // params
                    null,  // cancelHadler
                    true); // stayOpenOnSave
        }
        else {
            WGRD.okMessageModal(S_SERVER_CAN_NOT_UPGRADE_MSG, S_SERVER_CAN_NOT_UPGRADE_TITLE);
        }
    },

    initializeUpgrade: function (params) {
        // clear any existing related divs from the iframe
        $('#upgradeFrame').empty();
        $('#upgrade_system_form')[0].reset();  // needed to clear the file input in IE

        // Initialize UI
        $('#upgrade_file').val('');
        WGRD.enableUIElements(true, ['#upgrade_ws_close', '#upgrade_ws_ok']);
        $('#upgrade_load_loading').hide();

        return true;
    },

    doUpgrade: function (params) {
        // validate the data

        // verify a file was selected
        if (!$('#upgrade_file').val()) {
            return S_UPGRADE_ERROR_MSG;
        }

        // we submit the certs to the server and rely on the iframe reload to close the dialog
        SYS_S.uploading_upgrade_package = true;
        WGRD.enableUIElements(false, ['#upgrade_ws_close', '#upgrade_ws_ok']);

        $('#upgrade_system_form').submit();
        return;
    },

    // called when the iframe that handles upgrade upload is loaded
    // we use this to check for upload errors
    upgradePackageUploaded: function () {
        if (!SYS_S.uploading_upgrade_package) {
            return;
        }

        // check for any errors
        var results = $('#upgradeFrame').contents().find('#upgrade_results_err').text();
        if (results) {
            $('#upgrade_ws_dlg div.wgrd-modal-error').html(results);
            $('#upgrade_ws_dlg div.wgrd-modal-error').show();
        } else {
            // no errors so hide the dialog
            $('#upgrade_ws_dlg').modal('hide');

            // get the upgrade system task filename
            var task = $('#upgradeFrame').contents().find('#upgrade_results_task').text();
            if (!task) {
                task = null;
            }

            // wait for the upgrade to finish - handles restart and non-restart case
            $('#is_upgrading_alert').show();
            var dlg = WGRD.okMessageModal(S_SERVER_UPGRADE_MSG, S_SERVER_UPGRADE_TITLE);
            WGRD.redirectAfterRestartOrTask(dlg, '/system/settings', task, null);
        }

        WGRD.enableUIElements(true, ['#upgrade_ws_close', '#upgrade_ws_ok']);
        $('#upgrade_load_loading').hide();
        SYS_S.uploading_upgrade_package = false;
    },

    // ------------ Other actions  -----------------------------------------------------

    rebootAction: function () {
        $('#error_msg').hide();
        $('#confirmBoxDiv h3').text(S_SERVER_REBOOT_TITLE);
        WGRD.confirmModal(S_REBOOT_CONFIRMATION_MSG, true, SYS_S._rebootAction, true);
    },

    _rebootAction: function () {
        $.ajax({
            url: 'reboot_system',
            method: 'POST',
            dataType: 'json',
            success: function (response) {
                if (response.status === 0) {
                    // redirect to login page (10 minute timeout)
                    var dlg = WGRD.okMessageModal(S_SERVER_REBOOT_MSG, S_SERVER_REBOOT_TITLE);
                    WGRD.redirectAfterRestart(dlg);
                } else {
                    alert(S_ERR_ACTION_REBOOT);
                }
            },
            error: function (response) {
                alert(S_ERR_ACTION_REBOOT);
            }
        });

        return true;
    },

    restoreAction: function () {
        $('#error_msg').hide();
        $('#confirmBoxDiv h3').text(S_SERVER_RESTORE_TITLE);
        WGRD.confirmModal(S_RESTORE_CONFIRMATION_MSG, true, SYS_S._restoreAction, true, true);
    },

    _restoreAction: function () {
        $.ajax({
            url: 'restore_system',
            method: 'POST',
            dataType: 'json',
            success: function (response) {
                if (response.status === 0) {
                    // redirect to wizard page after 20 seconds
                    WGRD.okMessageModal(S_SERVER_RESTORE_MSG, S_SERVER_RESTORE_TITLE);
                    var okBtn = WGRD.okMessageModalBtn();
                    okBtn.html(S_WAITING);
                    WGRD.enableUIElements(false, [okBtn.selector]);
                    setTimeout(function () {
                        window.location.href = '/servers/wizard';
                    }, 20000);
                } else {
                    alert(S_ERR_ACTION_RESTORE);
                }
            },
            error: function (response) {
                alert(S_ERR_ACTION_RESTORE);
            }
        });

        return true;
    },

    shutdownAction: function () {
        $('#error_msg').hide();
        $('#confirmBoxDiv h3').text(S_SERVER_SHUTDOWN_TITLE);
        WGRD.confirmModal(S_SHUTDOWN_CONFIRMATION_MSG, true, SYS_S._shutdownAction, true);
    },

    _shutdownAction: function () {
        $.ajax({
            url: 'shutdown_system',
            method: 'POST',
            dataType: 'json',
            success: function (response) {
                if (response.status === 0) {
                    var poll_server = function () {
                        if (WGRD.isServerOnline()) {
                            setTimeout(poll_server, 500);
                        } else {
                            $('#confirmBoxDiv').modal('hide');
                            $('.content_header').hide();
                            $('#statusForm').hide();
                            $('#active_users').hide();
                            $('#shutdown_div').show();
                        }
                    };
                    setTimeout(poll_server, 500);
                } else {
                    alert(S_ERR_ACTION_SHUTDOWN);
                }
            },
            error: function (response) {
                alert(S_ERR_ACTION_SHUTDOWN);
            }
        });

        return true;
    },

    // ------------ Other actions (end) ------------------------------------------------

    // ajax call to get some updated system info and refresh the UI
    updateSystemInfo: function () {
        WGRD.enableUIElements(false, [$('#sys_config_btn')]);
        $('#progress_refresh_sys_info').show();
        $.ajax({
            url: 'system_info',
            type: 'POST',
            dataType: 'json',
            success: function (data) {
                SYS_S.updateSystemInfoUI(data);
            },
            complete: function () {
                WGRD.enableUIElements(true, ['#refresh_sys_info']);
                $('#progress_refresh_sys_info').hide();
                WGRD.enableUIElements(true, [$('#sys_config_btn')]);
            }
        });
    },

    updateSystemInfoUI: function (data) {
        var i, len, iplist, endpoint_list;
        var version = '';
        var release_tag = '';
        var build = '';
        var dt, now, cert_expiration;

        $('#sys_hostname').html('');
        if (data.sys_hostname !== undefined) {
            $('#sys_hostname').html(data.sys_hostname);
        }
        $('#sys_os_info').html('');
        if (data.sys_os_info !== undefined) {
            $('#sys_os_info').html(data.sys_os_info);
        }
        $('#sys_server_uuid').html('');
        if (data.sys_server_uuid !== undefined) {
            $('#sys_server_uuid').html(data.sys_server_uuid);
        }
        $('#sys_time').html('');
        if (data.sys_time !== undefined) {
            dt = new Date(data.sys_time);
            now = dt.toString();
            $('#sys_time').html(now);
        }
        $('#sys_feedback').html('');
        if (data.sys_feedback !== undefined) {
            $('#sys_feedback').text(SEND_FEEDBACK_STATUS[data.sys_feedback]);
        }
        $('#sys_memory').html('');
        if (data.sys_memory !== undefined) {
            $('#sys_memory').html(data.sys_memory);
        }
        if (data.version !== undefined) {
            version = data.version;
        }
        if (data.release_tag !== undefined) {
            release_tag = data.release_tag;
        }
        if (data.build_num !== undefined) {
            build = data.build_num;
        }
        $('#web_csr_enddate').html('');
        if (data.webserver_cert_enddate !== undefined) {
            dt = new Date(data.webserver_cert_enddate);
            cert_expiration = dt.toString();
            $('#web_csr_enddate').html(cert_expiration);
        }
        if (data.webserver_cert_flag === "warning") {
            $('#expire_ca_cert_tooltip').tooltip({
                html: true,
                placement: 'left',
                title: S_CA_CERT_EXPIRE_ONE_MONTH
            });
            $('#expire_ca_cert_warning').show();
        }
        else if (data.webserver_cert_flag === "expired") {
            $('#expire_ca_cert_tooltip').tooltip({
                html: true,
                placement: 'left',
                title: S_CA_CERT_EXPIRED
            });
            $('#expire_ca_cert_warning').show();
        }
        else {
            $('#expire_ca_cert_warning').hide();
        }

        $('#sys_avail_zone').html('');
        if (data.sys_avail_zone !== undefined) {
            $('#sys_avail_zone').html(data.sys_avail_zone);
        }

        // Append release tag to version string, if there is one.
        if (release_tag) {
            version += ' ' + release_tag;
        }

        if (version && build) {
            $('#ws_version').html(version + ' (' + build + ')');
        } else {
            $('#ws_version').html(version);
        }

        if (data.sys_cpu !== undefined) {
            if (data.sys_cpu_per_core !== undefined) {
                // show the per-core CPU % in a tooltip
                var titleStr = '<html>';
                for (i = 0, len = data.sys_cpu_per_core.length; i < len; i++) {
                    titleStr += data.sys_cpu_per_core[i];
                    if (i < len - 1) {
                        titleStr += '<br>';
                    }
                }
                titleStr += '</html>';

                $('#sys_cpu').html(data.sys_cpu + '&nbsp;<a id="sys_cpu_tooltip" data-toggle="tooltip"><i class="icon-question-sign"></i></a>');
                $('#sys_cpu_tooltip').tooltip({
                    html: true,
                    placement: 'right',
                    title: titleStr
                });
            } else {
                $('#sys_cpu').html(data.sys_cpu);
            }
        } else {
            $('#sys_cpu').html('');
        }

        if (data.sys_ips) {
            iplist = '';
            for (i = 0, len = data.sys_ips.length; i < len; i++) {
                if (data.sys_ips[i].status === 0) {
                    iplist += '<i class="icon-remove-circle"></i> ' + data.sys_ips[i].ip_addr + ' <i>(' + data.sys_ips[i].name + ')</i><br>';  // down
                } else if (data.sys_ips[i].status === 1) {
                    iplist += '<i class="icon-ok-sign"></i> ' + data.sys_ips[i].ip_addr + ' <i>(' + data.sys_ips[i].name + ')</i><br>';  // up
                }
                // else skip secondary IPs (-1)
            }
            $('#sys_ip_list').html(iplist);
        }

        if (data.sys_public_hostnames) {
            var hnlist = '';
            for (i = 0, len = data.sys_public_hostnames.length; i < len; i++) {
                hnlist += data.sys_public_hostnames[i].name;
                if (len > 1) {
                    // only show the device name if there is more than one device
                    hnlist += ' <i>(' + data.sys_public_hostnames[i].device + ')</i>';
                }
                hnlist += '<br>';
            }
            $('#sys_public_hostnames').html(hnlist);
        }
        if (data.sys_public_ips) {
            iplist = '';
            for (i = 0, len = data.sys_public_ips.length; i < len; i++) {
                iplist += data.sys_public_ips[i].ip;
                if (len > 1) {
                    // only show the device name if there is more than one device
                    iplist += ' <i>(' + data.sys_public_ips[i].device + ')</i>';
                }
                iplist += '<br>';
            }
            $('#sys_public_ips').html(iplist);
        }
        if (data.sys_azure_endpoints) {
            endpoint_list = '';
            for (i = 0, len = data.sys_azure_endpoints.length; i < len; i++) {
                endpoint_list += data.sys_azure_endpoints[i];
                endpoint_list += '<br>';
            }
            if (data.sys_azure_endpoint_warning) {
                endpoint_list += '<span class="text-error">' + data.sys_azure_endpoint_warning + '</span>';
                endpoint_list += '<br>';
            }
            $('#sys_azure_endpoints').html(endpoint_list);
            if (endpoint_list.length === 0) {
                $('#sys_azure_endpoints_div').hide();
            } else {
                $('#sys_azure_endpoints_div').show();
            }
        } else {
            $('#sys_azure_endpoints_div').hide();
        }

        // change the button text depending on what cert is currently in use
        if (data.webserver_cert_builtin === undefined || data.webserver_cert_builtin) {
            SYS_S.usingBuiltinCert = true;
            $('#restore_web_cert_btn').text(S_REGENERATE);
        } else {
            SYS_S.usingBuiltinCert = false;
            $('#restore_web_cert_btn').text(S_RESTORE);
        }

        // show/hide button to download pending CSR
        if (data.webserver_pending_csr) {
            $('#web_csr_download_btn').show();
        } else {
            $('#web_csr_download_btn').hide();
        }

        // hide/show the webserver certificate validation warning
        if (data.missing_ca_cert && !SYS_S.usingBuiltinCert) {
            $('#missing_ca_cert_warning').show();
        } else {
            $('#missing_ca_cert_warning').hide();
        }

        // hide/show the reboot warning if upgrading
        if (data.is_upgrading) {
            $('#is_upgrading_alert').show();
        } else {
            $('#is_upgrading_alert').hide();
        }

        WGRD.enableUIElements(true, [$('#sys_config_btn')]);
    },

    localtimeFormatter: function (cellvalue, options, rowObject) {
        var dt, localtime;

        dt = new Date(cellvalue);
        localtime = dt.toString();
        return localtime;
    },

    //Create active users table, showing user name
    //ip and expiration information.
    //Load data from the server and have sorting/paging locally
    createActiveUsersGrid: function () {
        var active_users_grid = $('#active_users_grid_table').jqGrid({
            loadonce: true,
            loadui: 'block',
            datatype: SYS_S.refreshActiveUsersGrid,
            height: 'auto',
            autoencode: true,
            autowidth: true,
            shrinkToFit: true,
            colNames: activeUsersColNames,
            colModel: activeUsersColModel,
            pager: '#active_users_pager',
            sortname: 'user',
            viewrecords: true,
            sortorder: 'asc',
            rowNum: 5,
            rowList: [5, 10, 20, 100],
            caption: S_ACTIVE_USERS_TITLE,
            onSelectRow: function (rowid, status, e) {
                SYS_S.toggleLogOutBtn();
            }
        });

        $("#active_users_grid_table").setColProp('expiration', { formatter: SYS_S.localtimeFormatter });

        active_users_grid.jqGrid('navGrid', '#active_users_pager', { edit: false, add: false, del: false, search: false, refresh: true },
            {},  // edit button
            {},  // add button
            {}); //del button

        $('#active_users_grid_div .ui-icon-refresh').click(function () {
            // get the new grid data from the server and reload it
            $('#active_users_grid_table').jqGrid('setGridParam', {loadui: 'block', datatype: SYS_S.refreshActiveUsersGrid()});
        });
        // change the tooltips on the buttons
        $('#refresh_active_users_grid_table').attr('title', S_REFRESH_USER_LIST);
    },

    toggleLogOutBtn: function () {
        // enable/disable "Logout" button depending on if any rows are selected or not
        var selRowId = $('#active_users_grid_table').jqGrid('getGridParam', 'selrow');
        WGRD.enableUIElements(selRowId, ['#logout_user']);
    },

    refreshActiveUsersGrid: function () {
        $('#active_users_grid_table').jqGrid('clearGridData');
        $('#active_users_grid_table').setCaption(S_ACTIVE_USERS_TITLE + " (" + S_LOADING + ")");
        $.ajax({
            url: 'get_active_users',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function (data) {
                // update the table with the new data
                $('#active_users_grid_table').jqGrid('setGridParam', {
                    datatype: 'local',
                    data: data
                });
                $('#active_users_grid_table').trigger('reloadGrid');
                $('#active_users_grid_table').setCaption(S_ACTIVE_USERS_TITLE);

                SYS_S.doResizeGrid();
            },
            error: function (response) {
                $('#active_users_grid_table').setCaption(S_ACTIVE_USERS_TITLE);
                $('#active_users_grid_table').jqGrid('setGridParam', {datatype: 'local'});
                SYS_S.doResizeGrid();
            }
        });
    },

    doResizeGrid: function () {
        var pad = parseInt($("#active_users_grid_div").css('margin-left'), 10);
        pad *= 2;
        if (pad === 0) {
            pad += 1;  // add at least 1 pixel padding to keep the grid smaller than the parent
        }
        var grid_width = $("#active_users_grid_div").width() - pad;
        $('#active_users_grid_table').setGridWidth(grid_width);
    },

    showwaitcursor: function (prefix) {
        $('#' + prefix + 'error').hide();
        $('#' + prefix + 'loading').show();
        return true;
    }
};
$(document).ready(SYS_S.init);
