/*global S_USER_MODE, S_VIEW_TEXT, S_EDIT_TEXT, R_MT_DETAIL, S_MG_REMOVE_TASK_MSG,  S_MG_CANCEL_TASK_MSG,
lock_page, is_page_locked, tasksRunningMsg, TaskObj, tasksActionsMsg, tasksColNames, tasksColModel, tasksTypeNames,
tasksIntervals, escapeHtml*/
var S_MG_TASKS = {
    action: '',
    path: "/tasks/",

    init : function () {
        S_MG_TASKS.initUI();
        S_MG_TASKS.initEvents();
    },

    initUI : function () {
        $('#error_container').hide();
        S_MG_TASKS.createTasksGrid();

        var ids = ["#manage_tasks", "#remove_task", "#cancel_task"];

        WGRD.updatePgInBrowserSession(is_page_locked, lock_page);

        S_MG_TASKS.pg_tracker = window.sessionStorage.getItem(lock_page);
        var viewMode = WGRD.userInViewMode(is_page_locked, S_MG_TASKS.pg_tracker);
        if (viewMode) {
            $('#edit_task').val(S_VIEW_TEXT);
        } else {
            $('#edit_task').val(S_EDIT_TEXT);
        }
        S_USER_MODE.initUI(ids, viewMode);
    },

    initEvents : function () {
        WGRD.pgUnloadCallBack(S_MG_TASKS.pg_tracker, lock_page);
        $(".manage_tasks_select").click(S_MG_TASKS.manageTasks);

        $('#edit_task').click(S_MG_TASKS.editTask);
        $('#remove_task').click(S_MG_TASKS.removeTask);
        $('#cancel_task').click(S_MG_TASKS.cancelTask);

        $('#btn_refresh').click(S_MG_TASKS.refreshGrid);
        $(window).bind('resizeEnd', function () {
            S_MG_TASKS._doResizeGrid();
        });

        $('#confirm_save_btn').click(function (event) {
            $('#confirm_dlg').modal("hide");
            S_MG_TASKS.handleTaskAction();
        });

        // show task details
        $(document).on('click', '.detaildialog', R_MT_DETAIL.showDetailsDialog);

        //User mode changes
        S_USER_MODE.initEvents();
    },

    _loadSpecificModal : function (params) {
        // disable the menu
        WGRD.enableUIElements(false, ["#manage_tasks"]);

        $('#loading_show_msg').text(tasksRunningMsg.load);
        $('#loading').show();

        $('#modal_container').html('');

        $.ajax({
            url: S_MG_TASKS.path + params.url,
            type: 'GET',
            dataType: 'html',
            success: function (data) {
                // Load the modal page data to html
                $('#modal_container').html(data);
                // Show the specific modal
                var moduleObj = window[params.modal];
                moduleObj.showTaskModal(params);
            },
            error: function (response) {
                $('#error_container').text(response.message);
                $('#error_container')
                    .delay(2000)
                    .fadeOut();
            },
            complete: function () {
                $('#loading').hide();
                // enable the menu
                WGRD.enableUIElements(true, ["#manage_tasks"]);
            }
        });
    },

    manageTasks : function () {
        var params = {'mode': 'add',
                      'complete_cb': S_MG_TASKS.refreshGrid};
        switch (this.id) {
        case 'report_select':
            params.url = 'schedule_reports';
            params.modal = 'R_MT_REP';
            break;
        case 'backup_select':
            params.url = 'backup_logs';
            params.modal = 'S_MT_B';
            break;
        case 'restore_select':
            params.url = 'restore_logs';
            params.modal = 'S_MT_R';
            break;
        }
        S_MG_TASKS._loadSpecificModal(params);
    },

    editTask : function () {
        // Get the current task
        var selrow = $('#tasks_table').jqGrid('getGridParam', 'selrow');
        if (selrow === null) {
            return;
        }
        // Get the local row data, raw data without format
        var rowdata = $('#tasks_table').getLocalRow(selrow);
        var params = {'mode': 'edit',
                      'task': rowdata,
                      'complete_cb': S_MG_TASKS.refreshGrid};

        switch (rowdata.task_type) {
        case 'report':
            params.url = 'schedule_reports';
            params.modal = 'R_MT_REP';
            break;
        case 'backup':
            params.url = 'backup_logs';
            params.modal = 'S_MT_B';
            break;
        case 'restore':
            params.url = 'restore_logs';
            params.modal = 'S_MT_R';
            break;
        default:
            return;
        }
        S_MG_TASKS._loadSpecificModal(params);
    },

    removeTask : function () {
        var selRowIds = $('#tasks_table').jqGrid('getGridParam', 'selarrrow');
        if (selRowIds === null || selRowIds.length === 0) {
            return;
        }

        S_MG_TASKS.action = 'remove';
        $("#confirm_show_msg").text(S_MG_REMOVE_TASK_MSG);
        $("#confirm_dlg").modal();
    },

    cancelTask : function () {
        var selRowIds = $('#tasks_table').jqGrid('getGridParam', 'selarrrow');
        if (selRowIds === null || selRowIds.length === 0) {
            return;
        }

        S_MG_TASKS.action = 'cancel';
        $("#confirm_show_msg").text(S_MG_CANCEL_TASK_MSG);
        $("#confirm_dlg").modal();
    },

    handleTaskAction : function () {
        // remove all tasks, cancel running tasks
        var task_status = 'all';
        if (S_MG_TASKS.action === 'cancel') {
            task_status = 'running';
        }

        var task_list = S_MG_TASKS._getSelectedTasks(task_status);
        if (task_list.length === 0) {
            return;
        }

        $('#loading_show_msg').text(tasksRunningMsg[S_MG_TASKS.action]);
        $('#loading').show();
        // disable cancel or remove button
        WGRD.enableUIElements(false, ["#" + S_MG_TASKS.action + "_task"]);

        var task_obj = new TaskObj();
        task_obj.task_action = (S_MG_TASKS.action === 'cancel') ? 1 : 0;

        var i;
        for (i = 0; i < task_list.length; i++) {
            task_obj.task_id_list.push(task_list[i].id);
            task_obj.task_name_list.push(task_list[i].name);
        }

        WGRD.putData(task_obj).success(function (response) {
            // just for remove/cancel operations, refresh the data in the grid table
            S_MG_TASKS.refreshGrid();

            // we need to do some things after the save operations is successful
            if (response.status) {
                $('#error_container').text(tasksActionsMsg[S_MG_TASKS.action]);
            }

            $('#loading').hide();
            $('#error_container')
                                .delay(2000)
                                .fadeOut();
        });
    },

    createTasksGrid : function () {
        var tasks_grid = $("#tasks_table").jqGrid({
            loadonce: true,
            datatype: S_MG_TASKS.refreshGrid,
            // The colNames are placed in the template so we can localize them.
            colNames: tasksColNames,
            colModel: tasksColModel,
            pager: '#tasks_pager',
            viewrecords: true,
            gridview: true,
            autoencode: true,
            shrinktofit: true,
            autowidth: true,
            shrinkToFit: true,
            height: "auto",
            // Sort column name for status
            sortname: 'status_content',
            sortorder: 'asc',
            rowNum: 10,
            rowList: [10, 20, 50, 100],
            multiselect: true,
            loadComplete: function () {
                S_MG_TASKS._toggleRowChangeBtns();
                S_MG_TASKS._doResizeGrid();
                S_MG_TASKS.sortGrid();
            },
            onSelectRow: function (rowid, status, e) {
                S_MG_TASKS._toggleRowChangeBtns();
            },
            onSelectAll: function (rowid, status) {
                S_MG_TASKS._toggleRowChangeBtns();
            }
        });

        // add the pager with custom actions for the "delete" button
        tasks_grid.jqGrid('navGrid', '#tasks_pager', { edit: false, add: false, del: false, search: false, refresh: false});
    },

    _taskColFormatter : function (elem, cellval, opts) {
        var value = elem;
        if (cellval.colModel.name === 'status_content') {

            var status_value = '';
            var status_data = '';
            // check status_value to color the content
            if (typeof (opts.status_value) === "string") {
                status_data = opts.status_data;
                status_value = opts.status_value.substring(0, 3);
            } else {
                status_data = opts[4];
                status_value = opts[5].substring(0, 3);
            }

            var color = '';
            switch (status_value) {
            case '100':
                color = '#008000';
                break;
            case '101':
                color = '#FF0000';
                break;
            case '102':
                color = '#A9A9A9';
                break;
            case '103':
                color = '#4682B4';
                break;
            default:
                color = '#3CB371';
                break;
            }

            var status_content = elem.format($.getDateDisplay(status_data, true));
            value = "<font color='" + color + "'>" + status_content + "</font>";
        } else if (cellval.colModel.name === 'name') {
            var task_id = '';
            if (typeof (opts.id) === "string") {
                task_id = opts.id;
            } else {
                task_id = opts[0];
            }
            value = "<a href='' id='" + task_id + "' class='detaildialog'>" + escapeHtml(elem) + "</a>";
        } else if (cellval.colModel.name === 'task_type') {
            value = tasksTypeNames[elem];
        } else if (cellval.colModel.name === 'run_mode') {
            value = tasksIntervals[elem];
        } else if (cellval.colModel.name === 'start_time') {
            value = $.getDateDisplay(elem, true);
        }
        return value;
    },

    _loadSpecificData : function (data) {
        $("#tasks_table").jqGrid('clearGridData');
        $('#tasks_table').jqGrid('setGridParam', {
            datatype: 'json'
        });
        $("#tasks_table")[0].addJSONData(data);
        S_MG_TASKS.sortGrid();
    },

    refreshGrid : function () {
        $('#tasks_table').jqGrid('clearGridData');

        // Set formatter and sorttype for special column
        $("#tasks_table").setColProp('status_content', {
            formatter: S_MG_TASKS._taskColFormatter,
            sorttype: function (cellValue, rowObject) {return rowObject.status_value; }
        });

        var sortname = $("#tasks_table").getGridParam('sortname');
        var sortorder = $("#tasks_table").getGridParam('sortorder');
        $("#tasks_table").setGridParam({ sortname: sortname, sortorder: sortorder });

        $("#tasks_table").setColProp('name', { formatter: S_MG_TASKS._taskColFormatter });
        $("#tasks_table").setColProp('task_type', { formatter: S_MG_TASKS._taskColFormatter });
        $("#tasks_table").setColProp('run_mode', { formatter: S_MG_TASKS._taskColFormatter });
        $("#tasks_table").setColProp('start_time', { formatter: S_MG_TASKS._taskColFormatter });

        S_MG_TASKS._showWaitCursor();
        $.ajax({
            url: S_MG_TASKS.path + "tasks?sidx=" + sortname + "&sord=" + sortorder,
            type: 'GET',
            dataType: 'json',
            data: '',
            success: function (data) {
                // update the table with the new data
                S_MG_TASKS._loadSpecificData(data);
            },
            error: function (response) {
                $('#tasks_table').jqGrid('setGridParam', {datatype: 'local'});
                $('#error_container').text(response.message);
                $('#error_container')
                    .delay(2000)
                    .fadeOut();
            },
            complete: function () {
                S_MG_TASKS._doResizeGrid();
                S_MG_TASKS._hideWaitCursor();

                // scroll to bottom in case many tasks in the grid.
                $(document).scrollTop($(document).height() - $(window).height());
                // disable remove/cancel buttons, edit button enable in read-only mode.
                WGRD.enableUIElements(false, ["#remove_task", "#cancel_task"]);
                WGRD.enableUIElements((is_page_locked === 0), ["#edit_task"]);
                WGRD.enableUIElements(WGRD.userInViewMode(is_page_locked, S_MG_TASKS.pg_tracker), ["#edit_task"]);
            }
        });
    },

    sortGrid : function () {
        $("#tasks_table").jqGrid('setGridParam', {datatype: 'local'});
    },

    _getSelectedTasks : function (status) {
        var selected_tasks = [];
        var tasks_table = $('#tasks_table');

        var selRowIds = tasks_table.jqGrid('getGridParam', 'selarrrow');
        if (selRowIds === null || selRowIds.length === 0) {
            return selected_tasks;
        }

        // return selected tasks with filter status data
        var i, status_value, task_status;
        for (i = 0; i < selRowIds.length; i++) {
            // check status range
            status_value = tasks_table.jqGrid('getCell', selRowIds[i], 'status_value');
            switch (status_value.substring(0, 3)) {
            case '100':
                task_status = 'completed';
                break;
            case '101':
                task_status = 'failed';
                break;
            case '102':
                task_status = 'cancelled';
                break;
            case '103':
                task_status = 'waiting';
                break;
            default:
                task_status = 'running';
                break;
            }
            if (status === task_status || status === 'all') {
                selected_tasks.push(tasks_table.getLocalRow(selRowIds[i]));
            }
        }

        return selected_tasks;
    },

    _toggleRowChangeBtns : function () {
        // enable/disable "Remove"/"Edit" button depending on if any rows are selected or not
        if (!WGRD.userInViewMode(is_page_locked, S_MG_TASKS.pg_tracker)) {
            // only toggle the buttons in read/write mode
            var tasks_table = $('#tasks_table');
            var selRowIds = tasks_table.jqGrid('getGridParam', 'selarrrow');
            if (selRowIds === null || selRowIds.length === 0) {
                WGRD.enableUIElements(false, ["#edit_task", "#remove_task", "#cancel_task"]);
                return;
            }
            WGRD.enableUIElements(true, ["#remove_task"]);

            // not support edit more than one task or a completed one-time task
            WGRD.enableUIElements((selRowIds.length === 1), ["#edit_task"]);
            if (selRowIds.length === 1) {
                var completed_task = S_MG_TASKS._getSelectedTasks('completed');
                if (completed_task.length === 1 && completed_task[0].run_mode === '0d') {
                    WGRD.enableUIElements(false, ["#edit_task"]);
                }
            }

            // only running task could be cancelled
            WGRD.enableUIElements(false, ["#cancel_task"]);
            var running_tasks = S_MG_TASKS._getSelectedTasks('running');
            if (running_tasks.length > 0 && running_tasks.length === selRowIds.length) {
                WGRD.enableUIElements(true, ["#cancel_task"]);
            }
        }
    },

    _showWaitCursor : function () {
        WGRD.enableUIElements(false, ['#btn_refresh']);
        $('#table_loading').show();
    },

    _hideWaitCursor : function () {
        WGRD.enableUIElements(true, ['#btn_refresh']);
        $('#table_loading').hide();
    },

    _doResizeGrid : function () {
        var pad = parseInt($("#tasks_table_div").css('margin-left'), 10);
        pad *= 2;
        if (pad === 0) {
            pad += 1;  // add at least 1 pixel padding to keep the grid smaller than the parent
        }
        var grid_width = $("#tasks_table_div").width() - pad;
        $('#tasks_table').setGridWidth(grid_width);
    }

};
$(document).ready(S_MG_TASKS.init);
