/*global active_restore_list, backup_files_list, converToTimeStr24,
  createDateFromStr, escapeHtml, is_page_locked, RestoreLogObj, unescapeHtml,
  S_RESTORE_ADD_MSG, S_RESTORE_EDIT_MSG, S_RESTORE_EMPTY_TIME,
  S_RESTORE_ERROR_TIME, S_RESTORE_NAME_MSG, S_RESTORE_NAME_DUPLICATE_MSG,
  S_RESTORE_NO_BACKUPS, S_RESTORE_RUN_AGAIN, S_RESTORE_TITLE,
  is_email_enabled
*/
var S_MT_R = {
    mode : '',
    complete_cb : null,
    modify_enabled : false,
    start_over : false,

    // setup the page
    init : function () {
        S_MT_R.initData();
        S_MT_R.initUI();
        S_MT_R.initEvents();
    },

    initData : function () {
        // data values are shown in html elements, so they need to be escaped before being displayed
        // we escape the data here and store them escaped at the client
        // data sent to the server must not be escaped
        // the javascript logic must consider whether a value is escaped or unescaped when working with it
        var i, len;
        for (i = 0, len = active_restore_list.length; i < len; i++) {
            active_restore_list[i].task_name = escapeHtml(active_restore_list[i].task_name);
            active_restore_list[i].description = escapeHtml(active_restore_list[i].description);
        }
    },

    // initialize UI elements
    initUI : function () {
        $('#add_error_restore').hide();

        if (backup_files_list.length === 0) {
            $('#add_error_restore').show().text(S_RESTORE_NO_BACKUPS);
            WGRD.enableUIElements(false, ['#backup_dir', '#backup_list', '#backup_end_list', '#restore_now']);
        } else {
            WGRD.enableUIElements(true, ['#backup_dir', '#backup_list', '#backup_end_list', '#restore_now']);
        }

        $('#restore_close').hide();

        // configure the start/end time pickers
        $('#start_time').datetimepicker({
            pickDate: false,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });
        $('#end_time').datetimepicker({
            pickDate: false,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });

        $('#email_notify_tooltip').tooltip();

        // detect if any fields are changed
        var flds = $("input, select", window.document);
        $(flds).on('change keyup', flds, function (eo) {
            $('#add_error_restore').hide();
        });
    },

    // add event handlers
    initEvents : function () {
        // detect if the settings changes when user edits the page
        $("#create_restore_dlg input").change(S_MT_R.toggleModifyEnable);
        $("#create_restore_dlg select").change(S_MT_R.toggleModifyEnable);

        $('#restore_close').button().click(S_MT_R.closeTaskModal);
        $('#restore_now').button().click(S_MT_R.restoreDb);
    },

    showTaskModal: function (params) {
        if (backup_files_list.length > 0) {
            if (S_MT_R.complete_cb === null) {
                S_MT_R.complete_cb = params.complete_cb;
            }
            WGRD.doModal('#create_restore_dlg',
                         S_MT_R.initializeRestore,
                         null,
                         params);
        } else {
            // show a notification dialog telling the admin that system backup configuration is required
            WGRD.okMessageModal(S_RESTORE_NO_BACKUPS, S_RESTORE_TITLE);
        }
    },

    closeTaskModal : function () {
        $('#create_restore_dlg').modal('hide');
    },

    initializeRestore : function (params) {
        S_MT_R.mode = params.mode;

        // disable task name, enable description
        if (params.mode === 'edit') {
            S_MT_R.editRestore(params);
        }
        if (is_email_enabled === 1) {
            $('#email_notify_chkbox').prop("disabled", false);
        } else {
            $('#email_notify_chkbox').prop("disabled", true);
        }
        return true;
    },

    editRestore : function (params) {
        var task_obj;
        var task_name;
        var restore_obj;
        var start_date, end_date;
        var start_time, end_time;
        var notify;
        var i, len;

        // check the params
        task_obj = params.task;
        if (task_obj === undefined || task_obj === null) {
            return;
        }

        // handle the task status action
        S_MT_R.toggleStatusAction(task_obj);

        // handle the element ids
        S_MT_R.toggleChangeViewMode();

        task_name = task_obj.name;
        $('.wizard-subtitle').text(task_name);
        $('#restore_name').val(task_name);

        // fill decriptions, the start time and end time, notification checked or not
        for (i = 0, len = active_restore_list.length; i < len; i++) {
            restore_obj = active_restore_list[i];
            if (restore_obj.task_name === escapeHtml(task_name)) {
                // decriptions
                $('#restore_desc').val(unescapeHtml(restore_obj.description));

                // start_time and end_time
                start_time = restore_obj.data_begin_time;
                end_time = restore_obj.data_end_time;

                start_date = start_time.split(' ')[0];
                end_date = end_time.split(' ')[0];

                $('#backup_list').val(start_date);
                $('#backup_end_list').val(end_date);

                $('#start_time').data('datetimepicker').setDate(createDateFromStr(restore_obj.data_begin_time));
                $('#end_time').data('datetimepicker').setDate(createDateFromStr(restore_obj.data_end_time));

                // notify checkbox
                notify = restore_obj.notify_admin;
                $('#email_notify_chkbox').prop('checked', notify);
                break;
            }
        }
    },

    toggleChangeViewMode : function () {
        var enabled;
        var elem_ids;

        WGRD.enableUIElements(false, ['#restore_name']);

        enabled = true;
        // Disable or enable the other element ids in RO or RW mode.
        if (is_page_locked === 0) {
            enabled = false;
        }

        elem_ids = ['#restore_desc', '#backup_list', '#backup_end_list', '#email_notify_chkbox'];
        WGRD.enableUIElements(enabled, elem_ids);
        if (enabled) {
            $('#restore_close').hide();
            $("#restore_now").show();
            $('#start_time').data('datetimepicker').enable();
            $('#end_time').data('datetimepicker').enable();
        } else {
            $('#restore_close').show();
            $("#restore_now").hide();
            $('#start_time').data('datetimepicker').disable();
            $('#end_time').data('datetimepicker').disable();
        }
    },

    toggleModifyEnable : function () {
        if (S_MT_R.modify_enabled && S_MT_R.mode === 'edit') {
            WGRD.enableUIElements(true, ['#restore_now']);
        }
    },

    toggleStatusAction : function (task_object) {
        //get task_status and run mode
        var task_status = task_object.status_value.substring(0, 3);
        var task_mode = task_object.run_mode;

        S_MT_R.start_over = true;
        // check the task status, to enable/disable run again button
        if (task_status === '101' || task_status === '102') {
            $('#restore_now').text(S_RESTORE_RUN_AGAIN);
        } else if (task_status === '100') {
            // '1m': '1 month', '1w': '1 week', '1d': '1 day', '0d': 'one time'
            // The finished 'run one time' task could run again if any change to it. 
            if (task_mode === '0d') {
                S_MT_R.modify_enabled = true;
                $('#restore_now').attr('disabled', true);
            }
        } else if (task_status !== '103') {
            $('#restore_now').attr('disabled', true);
        }
    },

    // Add/edit a restore logs task
    restoreDb : function () {
        var restore_name, restore_desc;
        var restore_obj, active_obj;
        var i, len;

        var start_time, end_time;
        var begin_date, end_date;
        var start_d, end_d;

        var notify_checked;

        // Verify the Restore task name
        restore_name = $('#restore_name').val();
        restore_desc = $('#restore_desc').val();
        if (restore_name.trim().length === 0) {
            $('#restore_name').focus();
            $('#restore_name').select();

            $('#add_error_restore').show().text(S_RESTORE_NAME_MSG);
            return;
        }

        //load all of restore tasks
        restore_obj = null;
        for (i = 0, len = active_restore_list.length; i < len; i++) {
            active_obj = active_restore_list[i];
            if (active_obj.task_name.toLowerCase() === escapeHtml(restore_name.toLowerCase())) {
                // Check if restore task name exists already.
                if (S_MT_R.mode === 'add') {
                    $('#add_error_restore').show().text(S_RESTORE_NAME_DUPLICATE_MSG);
                    return;
                }

                restore_obj = active_obj;
                break;
            }
        }

        // make sure the start time is before the end time
        start_time = $('#start_time_val').val();
        end_time = $('#end_time_val').val();
        // the date string returned by toLocaleDateString()
        // may contain characters from non-English language
        start_d = new Date($('#backup_list').val() + " " + start_time);
        end_d = new Date($('#backup_end_list').val() + " " + end_time);
        if (start_time === "" || end_time === "") {
            $('#add_error_restore').show().text(S_RESTORE_EMPTY_TIME);
            return;
        }
        if (start_d.getTime() >= end_d.getTime()) {
            $('#add_error_restore').show().text(S_RESTORE_ERROR_TIME);
            return;
        }
        begin_date = $('#backup_list').val() + " " + converToTimeStr24(start_time);
        end_date = $('#backup_end_list').val() + " " + converToTimeStr24(end_time);

        // get email notify checkbox
        notify_checked = $('#email_notify_chkbox').prop('checked');

        $('#restore_now').attr('disabled', true);

        // create new object when the mode is 'add'.
        if (S_MT_R.mode === 'add') {
            restore_obj = new RestoreLogObj();
        }

        // update the current restore object, it will be saved to server.
        restore_obj.task_name = restore_name;
        restore_obj.description = restore_desc;
        restore_obj.run_interval = '0d';
        restore_obj.data_begin_time = begin_date;
        restore_obj.data_end_time = end_date;
        restore_obj.notify_admin = notify_checked;

        restore_obj.start_over = S_MT_R.start_over;

        // save the data to the server
        WGRD.putData(restore_obj).success(function (response) {
            S_MT_R.toggleCallBackAction();

            // we need to do some things after the save operations is successful
            if (response.status) {
                // unescaped data was sent to server, so we need to escape the local data.
                restore_obj.task_name = escapeHtml(restore_obj.task_name);
                restore_obj.description = escapeHtml(restore_obj.description);
                if (S_MT_R.mode === 'add') {
                    // append to the active retore task list
                    active_restore_list.push(restore_obj);
                    $('#error_container').text(S_RESTORE_ADD_MSG);
                } else {
                    $('#error_container').text(S_RESTORE_EDIT_MSG);
                }
            }
            $('#error_container')
                                .delay(2000)
                                .fadeOut();
        });

        S_MT_R.toggleBackupAction();
    },

    toggleBackupAction : function () {
        $('#create_restore_dlg').modal('hide');
    },

    toggleCallBackAction : function () {
        // Call the callback function if it is set.
        if (S_MT_R.complete_cb !== null) {
            S_MT_R.complete_cb();
        }
    }
};
// Add the sourceURL for debug
//@ sourceURL=restore.js
$(document).ready(S_MT_R.init);

