/*global active_schedule_list, ftp_servers_list, cw_id_list, avail_device_list, cw_reports_list, summary_rep_list, all_reports_list, customization_list, is_page_locked,
server_rep_list, server_summary_rep_list, avail_server_list, escapeHtml, unescapeHtml, createDateAtMidnight, isChecked, is_email_enabled, sch_intervals_msg,
ReportScheduleObj, S_ALL_DEVICES_TEXT, S_SPECIFY_DEV_TEXT, S_ALL_SERVERS_TEXT, S_SPECIFY_SERVERS_TEXT, S_SEL_DEVICES_TITLE,
S_DEVICE_INFO_TEXT, FTP_HELP, REMOTE_HELP, S_SEL_SERVERS_TITLE, S_SERVER_INFO_TEXT, S_CW_REP, S_SEL_REPORTS_TITLE,
S_EXECUTIVE_SUMM_REP, S_SERVER_SUMMARY_REP, S_SERVER_REP, S_SPECIFIC_REP, S_SHOW_ADV_SETTINGS, S_HIDE_ADV_SETTINGS,
S_NOTIFY_ADMIN_MSG, S_NOTIFY_ADMIN_FILE_MSG, S_FINISH_BUTTON, S_NEXT_BUTTON, S_SCHEDULE_NAME_MSG, S_SCHEDULE_NAME_DUPLICATE_MSG,
S_ERR_DEVICE_MSG, S_ERR_TARGET_MSG, S_SCHEDULE_EMAIL_MSG, S_ERROR_FTP_SERVER, S_ERR_FILE_LOC_MSG, S_ERR_FILE_LOC_MSG,S_ERR_REP_MSG,
S_ERROR_EMPTY_TIME_MSG, S_ERROR_TIME_MSG, S_ERROR_TIME_LIMIT_MSG, S_ERROR_EMPTY_BEGIN_TIME, S_TARGET_CHANGE_MSG, S_TARGET_CHANGE_MSG,
S_SCH_EDIT_MSG, S_SCH_ADD_MSG, S_REPORT_CUST_DEFAULT, S_NONE, S_ERROR_EMAIL_TO_INVALID, S_ERROR_EMAIL_TO_DUPLICATE, S_EACH_MORNING,
S_EACH_MORNING, S_EACH_AFTERNOON, S_DEVICE_LABEL_MAIN, S_SCHEDULE_DEFAULT_SUBJ, S_SCHEDULE_DEFAULT_BODY, S_ADD_SCHEDULE_TITLE,
S_VIEW_SCHEDULE_TITLE, S_EDIT_SCHEDULE_TITLE, S_DEVICE_LABEL_1, S_SERVER_LABEL_1, S_SCH_RUN_AGAIN, dim_anonymization_enabled, S_REP_AGGR_SINGLE, S_REP_AGGR_COMBINED, S_REP_AGGR_BOTH, language*/
var R_MT_REP = {

    panes : ['gen', 'device', 'target', 'report'],
    active_pane : '',

    backButton : '',
    nextButton : '',
    closeButton : '',
    saveButton : '',

    mode : '',
    complete_cb : null,
    modify_enabled : false,
    start_over : false,
    is_rbEnabled : false,

    // setup the page
    init : function () {
        R_MT_REP.initData();
        R_MT_REP.initUI();
        R_MT_REP.initEvents();
    },

    initData : function () {
        // data values are shown in html elements, so they need to be escaped before being displayed
        // we escape the data here and store them escaped at the client
        // data sent to the server must not be escaped
        // the javascript logic must consider whether a value is escaped or unescaped when working with it
        var i;
        for (i = 0; i < active_schedule_list.length; i++) {
            active_schedule_list[i].schedule_name = escapeHtml(active_schedule_list[i].schedule_name);
            active_schedule_list[i].schedule_desc = escapeHtml(active_schedule_list[i].schedule_desc);
            active_schedule_list[i].connectwise_active_id = escapeHtml(active_schedule_list[i].connectwise_active_id);
            active_schedule_list[i].file_location = escapeHtml(active_schedule_list[i].file_location);
        }

        for (i = 0; i < ftp_servers_list.length; i++) {
            ftp_servers_list[i].server_name = escapeHtml(ftp_servers_list[i].server_name);
            ftp_servers_list[i].upload_location = escapeHtml(ftp_servers_list[i].upload_location);
        }
    },

    // initialize UI elements
    initUI : function () {
        $('#error_container').hide();

        //Report Schedules
        R_MT_REP.populateCustomizationList();
        R_MT_REP.populateFtpServerList();

        //Initialize Schedule wizard
        R_MT_REP.initScheduleUI();

        $('#file_help').tooltip();
        $('#connectwise_tooltip').tooltip();
        $('#email_notify_tooltip').tooltip();
        $('#email_tooltip').tooltip();
    },

    initScheduleUI : function () {
        if (dim_anonymization_enabled === 1) {
            WGRD.enableUIElements(false, [('#radio_servers')]);
            $('#anonymization_msg').show();
        } else {
            WGRD.enableUIElements(true, [('#radio_servers')]);
            $('#anonymization_msg').hide();
        }
        var footer = $('#manage_schedule_dlg').find('.wizard-modal-footer');
        R_MT_REP.backButton = $(footer).find('.wizard-back');
        R_MT_REP.nextButton = $(footer).find('.wizard-next');
        R_MT_REP.closeButton = $(footer).find('.wizard-close');
        R_MT_REP.saveButton = $(footer).find('.wizard-save');

        $("#start_date span, #end_date span").bind('click', function (e) {
            if ($('#start_date_val').hasClass('disabled')) {
                e.stopImmediatePropagation();
            }
        });

        $('#start_date').datetimepicker({
            pickDate: true,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });

        // set the default start date from yesterday's midnight.
        $('#start_date').data('datetimepicker').setLocalDate(createDateAtMidnight(0));

        $('#end_date').datetimepicker({
            pickDate: true,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });

        // set the default end date to today's midnight.
        $('#end_date').data('datetimepicker').setLocalDate(createDateAtMidnight(1));

        $('#start_end_date').hide();
    },

    // add event handlers
    initEvents : function () {
        R_MT_REP.initScheduleWizardEvent();
    },

    //------------------------------------------------------- REPORT SCHEDULE RELATED UI BEGINS HERE ------------------------------------- //
    initScheduleWizardEvent : function () {
        // detect if the settings changes when user edits the page
        $("#manage_schedule_dlg input").change(R_MT_REP.toggleModifyEnable);
        $("#manage_schedule_dlg select").change(R_MT_REP.toggleModifyEnable);

        //Events for buttons on the wizard, next/back are visible when adding a schedule
        $(R_MT_REP.nextButton).on('click', R_MT_REP.nextButtonAction);
        $(R_MT_REP.backButton).on('click', R_MT_REP.backButtonAction);

        //Close and save are visible when editing a schedule
        $(R_MT_REP.closeButton).on('click', R_MT_REP.closeScheduleDialog);
        $(R_MT_REP.saveButton).on('click', R_MT_REP.updateSchedule);

        //Device div, init radio events
        $('#radio_devices').change(R_MT_REP.showDevicesOrServers);
        $('#radio_servers').change(R_MT_REP.showDevicesOrServers);

        //Device div, init select events
        $('#select_device_types').on('change', R_MT_REP.toggleDeviceType);

        //Device div, init add/remove resources event
        $('#add_resource').on('click', R_MT_REP.showSpecificDevicesModal);
        $('#rem_resource').on('click', R_MT_REP.removeSpecificDevices);

        $('#copy_device').on('click', R_MT_REP.copyDevices);
        $('#del_device').on('click', R_MT_REP.delDevices);

        //specify_device_div, init event to save the add device/server dialog
        $('#specify_device_save').on('click', R_MT_REP.saveSpecificDevices);
        $('#specify_device_close').on('click', R_MT_REP.closeSpecificDevices);

        $('#device_server_name').on('keyup', R_MT_REP.deviceSearchEvent);

        //Init Target div events
        $('#email').on('click', R_MT_REP.showRepTypBasedOnTargets);
        $('#file').on('click', R_MT_REP.toggleFileChkbox);
        $('#connectwise').on('click', R_MT_REP.toggleCWChkbox);
        $('#email_adv').on('click', R_MT_REP.showHideAdvSettings);
        $('#ftp_servers_list').on('change', R_MT_REP.ftpServerAction);
        $('#file_select').on('change', R_MT_REP.showFTPOrRemoteLocation);

        $('#add_schedule_email').on('click', R_MT_REP.addEmail);
        $('#remove_schedule_email').on('click', R_MT_REP.removeEmail);

        //Init report div events
        $('#add_report').on('click', R_MT_REP.addReports);
        $('#rem_report').on('click', R_MT_REP.removeReports);
        $('#specific_rep_type').on('change', R_MT_REP.handleRepTypeChangeEvent);
        $('#rep_type').on('change', R_MT_REP.toggleReportType);
        $('#copy_rep_right').on('click', R_MT_REP.copyReports);
        $('#del_rep').on('click', R_MT_REP.delReports);

        $('#rep_tz').on('change', R_MT_REP.runReportAction);
        $('#run_schedule').on('change', R_MT_REP.runReportAction);
        $('#run_time_of_day_val').on('change', R_MT_REP.runReportAction);
        $('#main_sch_div').on('mousemove', R_MT_REP.runReportAction);

        //specify_reports_div, init event to close the add reports dialog
        $('#specify_rep_close').on('click', R_MT_REP.closeSpecificReports);

        //specify_device_div, init event to save the add reports dialog
        $('#specify_rep_save').on('click', R_MT_REP.saveSpecificReports);

        $("#manage_schedule_dlg").find('.wizard-steps').on('click', 'li.already-visited a.wizard-nav-link', $('#manage_schedule_dlg'),
            function (event) {
                var currentActiveNav = '#' + R_MT_REP.active_pane + '_li';
                var currentActiveDiv = '#' + R_MT_REP.active_pane + '_div';

                //Validate before going to the next pane
                if (!R_MT_REP.validateCurrentPane()) {
                    return;
                }

                var index = $(event.target).data('navindex');
                var newActiveNav = '#' + index + '_li';
                var newActiveDiv = '#' + index + '_div';

                R_MT_REP.active_pane = index;
                $(currentActiveNav).removeClass('active');
                $(currentActiveDiv).hide();
                $(newActiveNav).addClass('active');
                $(newActiveDiv).show();
                R_MT_REP.prevNextButtonTextState();
            });
        $('specify_rep_select').on('change', R_MT_REP.handleSelectedRepChangeEvent);
    },

    toggleModifyEnable : function () {
        if (R_MT_REP.modify_enabled && R_MT_REP.mode === 'edit') {
            WGRD.enableUIElements(true, [R_MT_REP.saveButton]);
        }
    },

    showDevicesOrServers : function () {
        var device_checked = $('#radio_devices').prop('checked');
        if (device_checked) {
            $('#select_device_types option[value=0]').text(S_ALL_DEVICES_TEXT);
            $('#select_device_types option[value=1]').text(S_SPECIFY_DEV_TEXT);
            R_MT_REP.hideShowConnectWise(true);
            if (cw_id_list.length !== 0) {
                $('#connectwise').prop("disabled", false);
            } else {
                $('#connectwise').prop("disabled", true);
            }
            $('#rep_aggr').prop('disabled', false);
        } else {
            $('#select_device_types option[value=0]').text(S_ALL_SERVERS_TEXT);
            $('#select_device_types option[value=1]').text(S_SPECIFY_SERVERS_TEXT);
            R_MT_REP.hideShowConnectWise(false);
            $('#rep_aggr').prop('disabled', true)
                          .prop("selectedIndex", 0);
        }

        R_MT_REP.toggleCWChkbox();
        $('#active_resources').empty();
        $('#select_device_types').prop('selectedIndex', 0);
        R_MT_REP.toggleDeviceType();
    },

    showFTPOrRemoteLocation : function () {
        var selected_val = $('#file_select option:selected').val();
        if (selected_val === 'ftp') {
            $('#file_location_div').show();
            $('#rb_location_div').hide();
            $('#file_help').removeData('tooltip').tooltip({'title': FTP_HELP});
        } else {
            $('#file_location_div').hide();
            $('#rb_location_div').show();
            $('#file_help').removeData('tooltip').tooltip({'title': REMOTE_HELP});
        }
    },

    removeSpecificDevices : function (event) {
        event.preventDefault();
        $('#active_resources option:selected').remove();
        R_MT_REP.toggleReportAggregation();
    },

    closeSpecificDevices : function () {
        $('#specify_device_div').hide();
        $('#main_sch_div').show();
    },

    saveSpecificDevices : function () {

        var active_device_length = $('#active_devices_servers option').length;
        if (active_device_length !== 0) {
            $('#active_resources').empty();
            $('#active_resources')
                .append($('#active_devices_servers option')
                    .clone()
                    .children()
                    .end());
        }
        R_MT_REP.toggleReportAggregation();
        R_MT_REP.closeSpecificDevices();
    },

    toggleReportAggregation : function () {

        var device_checked = $('#radio_devices').prop('checked');
        if (!device_checked) {
            return;
        }
        // if only one device(included cluster) selected, aggregation will be only 'single', otherwise all of the options.
        $('#rep_aggr').prop('disabled', false);
        if ($('#active_resources option').length !== 1) {
            return;
        }
        var resource_id = $('#active_resources option')[0].value;
        $.each(avail_device_list, function (index, value) {
            // the group does not have the 'sn' field.
            if (parseInt(resource_id, 10) === value.id && typeof (value.sn) === "string") {
                $('#rep_aggr').prop('disabled', true)
                              .prop("selectedIndex", 0);
                return;
            }
        });
    },

    closeSpecificReports : function () {
        $('#specify_reports_div').hide();
        $('#main_sch_div').show();
    },

    saveSpecificReports : function () {

        var active_rep_length = $('#active_rep_type option').length;
        if (active_rep_length !== 0) {
            $('#specify_rep_select').empty();
            $('#specify_rep_select')
                .append($('#active_rep_type optgroup')
                    .clone()
                    .children('option')
                    .end());
        }
        R_MT_REP.closeSpecificReports();
        R_MT_REP.enableRepOptions();
    },

    copyDevices : function (event) {
        event.preventDefault();
        var selected_items = $('#filtered_devices_servers option:selected');
        $.each(selected_items, function (index, value) {
            var device_id = value.value;
            var title = value.text;
            if ($('#active_devices_servers option[value =' + device_id + ']').length === 0) {
                $('#active_devices_servers').append('<option value=' + device_id + ' title="' + title + '">' + title + '</option>');
            }
        });
    },

    delDevices : function (event) {
        event.preventDefault();
        $('#active_devices_servers option:selected').remove();
    },

    copyReports : function (event) {
        event.preventDefault();

        //first find the category the current available reports belong to
        var current_category_id = $('#specific_rep_type option:selected').val();
        var current_category_text = $('#specific_rep_type option:selected').text();

        var selected_items = $('#filtered_rep_type').val();
        if ($('#active_rep_type optgroup[id =' + current_category_id + ']').length === 0) {
            $('#active_rep_type').append('<optgroup id="' + current_category_id + '" label="' + current_category_text + '"></optgroup>');
        }

        $.each(selected_items, function (index, value) {
            var title = $('#filtered_rep_type option[value="' + value + '"]').text();
            if ($('#active_rep_type option[value ="' + value + '"]').length === 0) {
                $('#active_rep_type optgroup[id=' + current_category_id + ']').append('<option value="' + value + '" title="' + title + '">' + title + '</option>');
            }
        });
    },

    delReports : function (event) {
        event.preventDefault();
        $('#active_rep_type option:selected').remove();
        $('#active_rep_type optgroup:empty').remove();
    },

    toggleReportType : function () {
        var index = $('#rep_type')[0].selectedIndex;
        if (index === 1) {
            $('#specify_rep_div').show();
        } else {
            $('#specify_rep_div').hide();
        }
        R_MT_REP.enableRepOptions();
    },

    handleSelectedRepChangeEvent: function () {
        R_MT_REP.healthRepPresent();
    },

    healthRepPresent: function () {
        var health_rep_present = false;
        var index = $('#rep_type')[0].selectedIndex;
        if (index === 1) {
            $('#specify_rep_select option').each(function () {
                // Check if the value matches any of the health report ids
                if ($.inArray(this.value, ['102', '113', '114']) !== -1) {
                    health_rep_present = true;
                    return false;
                }
            });
        }
        return health_rep_present;
    },

    enableRepOptions: function () {
        // disable the report options and select 'Single' by default
        // for servers or if user has select health reports
        var device_checked = $('#radio_devices').prop('checked');
        var single_rep_option = false;
        if (!device_checked || R_MT_REP.healthRepPresent()) {
            single_rep_option = true;
        }

        if (single_rep_option) {
            $('#rep_aggr').prop('disabled', true)
                          .prop("selectedIndex", 0);
        } else {
            $('#rep_aggr').prop('disabled', false);
        }
    },

    handleRepTypeChangeEvent : function () {

        $('#filtered_rep_type').empty();
        var index = $('#specific_rep_type option:selected')[0];
        if (index.value === 'cw') {
            var sub_rep_list = cw_reports_list[0].sub_reports;
            $.each(sub_rep_list, function (index, value) {
                var id = value.id;
                var title = value.title;
                $('#filtered_rep_type').append('<option value=' + id + ' title="' + title + '">' + title + '</option>');
            });
        } else {
            var sub_rep = $(index).data('sub_rep');
            $.each(sub_rep, function (index, rep) {
                var id = rep.id;
                var title = rep.title;
                $('#filtered_rep_type').append('<option value=' + id + ' title="' + title + '">' + title + '</option>');
            });
        }
    },

    showSpecificDevicesModal : function (event) {
        event.preventDefault();
        $('#device_server_name').val("");

        $('#active_devices_servers').empty();

        $('#active_devices_servers')
            .append($('#active_resources option')
                .clone()
                .children()
                .end());

        var title = S_SEL_DEVICES_TITLE;
        var device_info_text = S_DEVICE_INFO_TEXT;
        var device_checked = $('#radio_devices').prop('checked');

        if (!device_checked) {
            title = S_SEL_SERVERS_TITLE;
            device_info_text = S_SERVER_INFO_TEXT;
        }
        $('#active_resources').empty();

        R_MT_REP.populate_device_server_select();
        $('#specify_device_div')
                               .show()
                               .find('h3').text(title);
        $('#dev_serv_info').html(device_info_text);
        $('#main_sch_div').hide();
    },

    _add_reports : function (report_list) {
        $.each(report_list, function (index, report) {
            var id = report.id;
            var title = report.title;
            var sub_rep = report.sub_reports;
            $('#specific_rep_type').append('<option id=' + id + ' value=' + id + '>' + title + '</option>');
            $('#' + id).data('sub_rep', sub_rep);
        });
    },

    addReports : function (event) {
        event.preventDefault();
        $('#specific_rep_type').empty();
        $('#active_rep_type').empty();

        $('#active_rep_type')
            .append($('#specify_rep_select optgroup')
                .clone()
                .children('option')
                .end());

        var rep_category = $('#rep_type')[0][0].value;
        if (rep_category === 'cw') {
            $('#specific_rep_type').append('<option value=' + rep_category + '>' + S_CW_REP + '</option>');
        } else if (rep_category === 'all_summary') {
            R_MT_REP._add_reports(summary_rep_list);
        } else if (rep_category === 'all') {
            R_MT_REP._add_reports(all_reports_list);
        } else if (rep_category === 'all_servers') {
            R_MT_REP._add_reports(server_rep_list);
        } else if (rep_category === 'all_server_summary') {
            R_MT_REP._add_reports(server_summary_rep_list);
        }
        $('#specify_reports_div')
                               .show()
                               .find('h3').text(S_SEL_REPORTS_TITLE);
        R_MT_REP.handleRepTypeChangeEvent();
        $('#main_sch_div').hide();
    },

    removeReports : function (event) {
        event.preventDefault();
        $('#specify_rep_select option:selected').remove();
        $('#specify_rep_select optgroup:empty').remove();
        R_MT_REP.enableRepOptions();
    },

    showReportOption : function (cw_checked) {
        $('#rep_aggr').empty();

        if (cw_checked) {
            $('#rep_aggr').append('<option value=single>' + S_REP_AGGR_SINGLE + '</option>');
            $('#rep_aggr').append('<option value=both>' + S_REP_AGGR_BOTH + '</option>');
        } else {
            $('#rep_aggr').append('<option value=single>' + S_REP_AGGR_SINGLE + '</option>');
            $('#rep_aggr').append('<option value=combined>' + S_REP_AGGR_COMBINED + '</option>');
            $('#rep_aggr').append('<option value=both>' + S_REP_AGGR_BOTH + '</option>');
        }
    },

    showRepTypBasedOnTargets : function () {

        var email_checked = $('#email').is(':checked');
        var file_checked = $('#file').is(':checked');
        var cw_checked = $('#connectwise').is(':checked');
        var target = 0;
        $('#rep_type').empty();

        if (cw_checked) {
            $('#rep_type').append('<option value=cw>' + S_CW_REP + '</option>');
            $('#run_schedule').prop('disabled', true)
                              .prop("selectedIndex", 0);
            R_MT_REP.runReportAction();
            target = 2;
        } else if (email_checked) {
            $('#rep_type').append('<option value=all_summary>' + S_EXECUTIVE_SUMM_REP + '</option>');
            $('#run_schedule').prop('disabled', false);
            target = 0;
        } else {  // file or remote backup
            $('#rep_type').append('<option value=all>' + S_EXECUTIVE_SUMM_REP + '</option>');
            $('#run_schedule').prop('disabled', false);
            target = 1;
        }
        var isDevicesChecked = isChecked('#radio_devices');
        if (!isDevicesChecked) {
            $('#rep_type').empty();
            if (email_checked && !file_checked) { //Email
                $('#rep_type').append('<option value=all_server_summary>' + S_SERVER_SUMMARY_REP + '</option>');
            } else {
                $('#rep_type').append('<option value=all_servers>' + S_SERVER_REP + '</option>');
            }
        }

        if (email_checked) {
            $('#target_email_div').show();
        } else {
            $('#target_email_div').hide();
        }
        $('#rep_type').append('<option value=specify>' + S_SPECIFIC_REP + '</option>');

        R_MT_REP._update_selected_reps(target);
    },

    _update_selected_reps : function (target) {

        var selected_rep_len = $('#specify_rep_select option').length;
        if (selected_rep_len === 0) {
            $('#rep_type').prop('selectedIndex', 0);
            $('#specify_rep_select').empty();
            return;
        }
        var report_id_list = [];
        $('#specify_rep_select option').each(function () {
            if (this.value.indexOf(',') !== -1) {
                var id_list = this.value.split(',');
                for(var i = 0; i < id_list.length; i++) {
                    report_id_list.push(id_list[i]);
                }
                return;
            }
            report_id_list.push(this.value);
        });

        var report_filter_list = '';
        $('#rep_type').prop('selectedIndex', 1);
        var isDevicesChecked = isChecked('#radio_devices');
        if (!isDevicesChecked) {
            report_filter_list = server_rep_list;
            if (target === 0) { //Email
                //only summary reports should be present
                report_filter_list = server_summary_rep_list;
            }
        } else {
            if (target === 1) { //File or remote backup
                return; //No need to do anything, this target indicates all report types
            }
            if (target === 0) { //Email
                //only summary reports should be present
                report_filter_list = summary_rep_list;
            } else { //ConnectWise
                //only cw reports must be present
                report_filter_list = cw_reports_list;
            }
        }

        $('#specify_rep_select').empty();
        $.each(report_filter_list, function (index, main_rep) {
            var main_rep_id = main_rep.id;
            var main_rep_title = main_rep.title;
            var main_rep_added = false;
            var sub_report_list = main_rep.sub_reports;

            $.each(sub_report_list, function (index, sub_rep) {
                var sub_rep_id = sub_rep.id;
                var sub_rep_title = sub_rep.title;
                var sub_rep_id2 = sub_rep_id;
                if (Object.prototype.toString.call(sub_rep_id) === '[object Array]') {
                    sub_rep_id2 = sub_rep_id[0];
                }
                if (report_id_list.indexOf(sub_rep_id2.toString()) !== -1) {
                    if (!main_rep_added) {
                        $('#specify_rep_select').append('<optgroup id="' + main_rep_id + '" label="' + main_rep_title + '"></optgroup>');
                        main_rep_added = true;
                    }
                    $('#specify_rep_select optgroup[id=' + main_rep_id + ']').append('<option value="' + sub_rep_id + '" title="' + sub_rep_title + '">' + sub_rep_title + '</option>');
                }
            });
        });
    },

    showHideNotifyChkbox : function (show) {
        if (show) {
            $('#notify_admin_div').show();
            if (is_email_enabled === 1) {
                $('#email_notify_chkbox').prop("disabled", false);
            } else {
                $('#email_notify_chkbox').prop("disabled", true);
            }
        } else {
            $('#notify_admin_div').hide();
        }
    },

    toggleFileChkbox : function () {
        var checked = $('#file').is(':checked');
        var cw_checked = $('#connectwise').is(':checked');

        if (checked) {
            $('#file_location_container').show();
            R_MT_REP.showFTPOrRemoteLocation();
        } else {
            $('#file_location_container').hide();
            $('#file_location_div').hide();
            $('#rb_location_div').hide();
        }

        R_MT_REP.showHideNotifyChkbox(checked || cw_checked);
        R_MT_REP.showRepTypBasedOnTargets();
    },

    toggleCWChkbox : function () {
        var checked = $('#connectwise').is(':checked');
        var file_checked = $('#file').is(':checked');

        if (checked) {
            $('#cw_rep_div').show();
        } else {
            $('#cw_rep_div').hide();
        }
        R_MT_REP.showHideNotifyChkbox(checked || file_checked);
        R_MT_REP.showRepTypBasedOnTargets();
        R_MT_REP.showReportOption(checked);
    },

    showHideAdvSettings : function (event) {
        event.preventDefault();
        if ($('#show_hide_subj_body').is(':visible')) {
            $('#email_adv').text(S_SHOW_ADV_SETTINGS);
        } else {
            $('#email_adv').text(S_HIDE_ADV_SETTINGS);
        }
        $('#show_hide_subj_body').slideToggle();
    },

    deviceSearchEvent : function () {
        var device_checked = $('#radio_devices').prop('checked');
        var resource_list = [];
        if (device_checked) {
            resource_list = avail_device_list;
        } else {
            resource_list = avail_server_list;
        }
        var val = $('#device_server_name').val();
        $('#filtered_devices_servers').empty();
        var matching_list = $.map(resource_list, function (value) {
                var search = new RegExp(val, "gi");
                var name_sn = value.name;
                if (name_sn.match(search)) {
                    return value;
                }
                return null;
            });

        $.each(matching_list, function (index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            $('#filtered_devices_servers').append('<option value=' + resource_id + ' title="' + name_sn + '">' + name_sn + '</option>');
        });
    },

    populate_device_server_select : function () {

        var device_checked = $('#radio_devices').prop('checked');
        var resource_list = [];
        if (device_checked) {
            resource_list = avail_device_list;
        } else {
            resource_list = avail_server_list;
        }
        $('#filtered_devices_servers').empty();
        $.each(resource_list, function (index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            $('#filtered_devices_servers').append('<option value=' + resource_id + ' title="' + name_sn + '">' + name_sn + '</option>');
        });
    },

    toggleDeviceType : function () {
        var index = $('#select_device_types')[0].selectedIndex;
        if (index === 0) { //Hide if all devices are selected
            $('#selected_resources').hide();
        } else {
            $('#selected_resources').show();
        }
    },

    //Based on the arg doing the following:
    //Hide/show connectwise option in target div
    //Hide/show connectwise in report selection div
    hideShowConnectWise : function (show) {
        if (show) {
            $('#connectwise_div').show();
            $('#email_notify_span').text(S_NOTIFY_ADMIN_MSG);
            $('#rep_type option[value=cw]').show();
        } else {
            $('#connectwise_div').hide();
            $('#email_notify_span').text(S_NOTIFY_ADMIN_FILE_MSG);
            $('#connectwise').prop('checked', false);
            $('#rep_type option[value=cw]').hide();
        }
    },

    backButtonAction : function () {
        $('.add_error_sch').hide();
        $('#' + R_MT_REP.active_pane + '_li').removeClass("active");
        $('#' + R_MT_REP.active_pane + '_div').hide();
        var index = R_MT_REP.panes.indexOf(R_MT_REP.active_pane);
        R_MT_REP.active_pane = R_MT_REP.panes[index - 1];
        R_MT_REP.prevNextButtonState();
    },

    prevNextButtonTextState : function () {
        if (R_MT_REP.active_pane === 'gen') {
            WGRD.enableUIElements(false, [R_MT_REP.backButton]);
        } else {
            WGRD.enableUIElements(true, [R_MT_REP.backButton]);
        }

        if (R_MT_REP.active_pane === 'report') {
            $(R_MT_REP.nextButton).text(S_FINISH_BUTTON);
        } else {
            $(R_MT_REP.nextButton).text(S_NEXT_BUTTON);
        }
    },

    prevNextButtonState : function () {
        $('#' + R_MT_REP.active_pane + '_li').addClass('already-visited');
        $('#' + R_MT_REP.active_pane + '_li').addClass('active');
        $('#' + R_MT_REP.active_pane + '_div').show();
        R_MT_REP.prevNextButtonTextState();
    },

    _validateGenDiv : function () {
        var name = $('#schedule_name').val();
        if (name.trim().length === 0) {
            $('#schedule_name').focus();
            $('#schedule_name').select();

            $('.add_error_sch').show().text(S_SCHEDULE_NAME_MSG);
            return false;
        }

        if (R_MT_REP.mode === 'add') {
            //Check if schedule name exists already
            var schedule_obj = null;
            var i;
            for (i = 0; i < active_schedule_list.length; i++) {
                schedule_obj = active_schedule_list[i];
                if (schedule_obj.schedule_name.toLowerCase() === escapeHtml(name.trim().toLowerCase())) {
                    $('.add_error_sch').show().text(S_SCHEDULE_NAME_DUPLICATE_MSG);
                    return false;
                }
            }
        }
        $('.wizard-subtitle').text(name)
                             .attr('title', name);
        return true;
    },

    _validateDeviceDiv : function () {

        var index = $('#select_device_types')[0].selectedIndex;
        if (index !== 0 && $('#active_resources option').length === 0) {
            $('.add_error_sch').show().text(S_ERR_DEVICE_MSG);
            return false;
        }
        return true;
    },

    _validateTargetDiv : function () {
        var targets = ['#email', '#file', '#connectwise'];
        var target_chkd = false;
        $.each(targets, function (i, target) {
            if ($(target).prop('checked')) {
                target_chkd = true;
                return false;
            }
        });
        //At least one target must be checked
        if (!target_chkd) {
            $('.add_error_sch').show().text(S_ERR_TARGET_MSG);
            return false;
        }

        //If email checkbox is checked or notify checkbox is checked, then at least one recipient email address must be present
        var email_checked = $('#email').prop('checked');

        if (email_checked && $('#schedule_emails option').length === 0) {
            $('.add_error_sch').show().text(S_SCHEDULE_EMAIL_MSG);
            $('#schedule_email_to').focus();
            $('#schedule_email_to').select();
            return false;
        }

        //If file location checkbox is checked, then url must not be empty
        var file_checked = $('#file').prop('checked');
        var ftp_server_index = $('#ftp_servers_list')[0].selectedIndex;
        var selected_val = $('#file_select option:selected').val();
        if (file_checked) {
            if (selected_val === 'ftp') {
                var ftp_location = $('#ftp_location').val();
                if (ftp_server_index === 0) {
                    $('.add_error_sch').show().text(S_ERROR_FTP_SERVER);
                    $('#ftp_servers_list').focus();
                    $('#ftp_servers_list').select();
                    return false;
                }
                if (ftp_location.trim().length === 0) {
                    $('.add_error_sch').show().text(S_ERR_FILE_LOC_MSG);
                    $('#ftp_location').focus();
                    $('#ftp_location').select();
                    return false;
                }
            } else {
                var rb_location = $('#rb_location').val();
                if (rb_location.trim().length === 0) {
                    $('.add_error_sch').show().text(S_ERR_FILE_LOC_MSG);
                    $('#rb_location').focus();
                    $('#rb_location').select();
                    return false;
                }
            }
        }
        return true;
    },

    _validateReportDiv : function () {
        var index = $('#rep_type')[0].selectedIndex;
        if (index !== 0 && $('#specify_rep_select option').length === 0) {
            $('.add_error_sch').show().text(S_ERR_REP_MSG);
            return false;
        }

        // validate the time range, restricted to 3 months.
        var rep_sch = $('#run_schedule option:selected').val();
        if (rep_sch === '0d') {
            var start_date = $('#start_date').data('datetimepicker').getLocalDate();
            var end_date = $('#end_date').data('datetimepicker').getLocalDate();
            if (start_date === null || end_date === null) {
                $('#report_div').scrollTop(0);
                $('.add_error_sch').show().text(S_ERROR_EMPTY_TIME_MSG);
                return false;
            }
            if (start_date && end_date && end_date <= start_date) {
                $('#report_div').scrollTop(0);
                $('.add_error_sch').show().text(S_ERROR_TIME_MSG);
                return false;
            }
            if (end_date.getMonth() - start_date.getMonth() >= 3) {
                $('#report_div').scrollTop(0);
                $('.add_error_sch').show().text(S_ERROR_TIME_LIMIT_MSG);
                return false;
            }
        } else {
            var run_time_of_day = $('#run_time_of_day').data('datetimepicker').getLocalDate();
            if (run_time_of_day === null) {
                $('#report_div').scrollTop(0);
                $('.add_error_sch').show().text(S_ERROR_EMPTY_BEGIN_TIME);
                return false;
            }
        }

        return true;
    },

    validateCurrentPane : function () {

        $('.add_error_sch').hide();

        var active_pane = R_MT_REP.active_pane;

        switch (active_pane) {
        case "gen":
            return R_MT_REP._validateGenDiv();
        case "device":
            return R_MT_REP._validateDeviceDiv();
        case "target":
            return R_MT_REP._validateTargetDiv();
        case "report":
            return R_MT_REP._validateReportDiv();
        }
    },

    nextButtonAction : function () {
        $('#' + R_MT_REP.active_pane + '_li').addClass('already-visited');

        if (!R_MT_REP.validateCurrentPane()) {
            return;
        }

        if (R_MT_REP.active_pane === 'report') {
            if (!R_MT_REP.saveSchedule()) {
                return;
            }
            R_MT_REP.backButton.hide();
            R_MT_REP.nextButton.hide();
        }

        $('#' + R_MT_REP.active_pane + '_li').removeClass('active');

        $('#' + R_MT_REP.active_pane + '_div').hide();
        var index = R_MT_REP.panes.indexOf(R_MT_REP.active_pane);
        R_MT_REP.active_pane = R_MT_REP.panes[index + 1];
        R_MT_REP.prevNextButtonState();
    },

    closeScheduleDialog : function () {
        $('#manage_schedule_dlg').modal('hide');
    },

    updateSchedule : function () {
        var name = $('#schedule_name').val();
        if (name.trim().length === 0) {
            //return error message string here
            return S_SCHEDULE_NAME_MSG;
        }

        //Check if schedule name exists already
        var schedule_obj = null;
        var i;
        for (i = 0; i < active_schedule_list.length; i++) {
            schedule_obj = active_schedule_list[i];
            if (schedule_obj.schedule_name === escapeHtml(name)) {
                break;
            }
        }

        schedule_obj.schedule_name = unescapeHtml(schedule_obj.schedule_name);  // unescape the name since we will be sending this data to the server; could also use 'name' variable here
        schedule_obj.schedule_desc = $('#schedule_desc').val();  // value is already unescaped

        //Update device div
        if (!R_MT_REP._validateDeviceDiv()) {
            return;
        }
        R_MT_REP._save_devices_info(schedule_obj);

        //Update target div
        if (!R_MT_REP._validateTargetDiv()) {
            return;
        }
        var current_targets = schedule_obj.targets;
        R_MT_REP._save_targets_info(schedule_obj);

        var new_targets = schedule_obj.targets;

        var currentTargetStr = current_targets.toString();
        var newTargetStr = new_targets.toString();

        var emailInCurrentTarget = currentTargetStr.indexOf('#email');
        var emailInNewTarget = newTargetStr.indexOf('#email');

        var cwInCurrentTarget = currentTargetStr.indexOf('#connectwise');
        var cwInNewTarget = newTargetStr.indexOf('#connectwise');

        if (cwInCurrentTarget === cwInNewTarget && cwInCurrentTarget === -1) { //ConnectWise was never checked
            if (emailInCurrentTarget !== emailInNewTarget && emailInCurrentTarget === 0) {
                $('.add_error_sch').show().html(S_TARGET_CHANGE_MSG);
                return;
            }
        } else if ((cwInCurrentTarget === -1 || cwInNewTarget === -1) &&
                   (cwInCurrentTarget !== cwInNewTarget)) { //ConnectWise was toggled
            $('.add_error_sch').show().html(S_TARGET_CHANGE_MSG);
            return;
        }

        //get data from report div and save to schedule_obj
        if (!R_MT_REP._validateReportDiv()) {
            return;
        }
        R_MT_REP._save_reports_info(schedule_obj);

        schedule_obj.start_over = R_MT_REP.start_over;

        // save the data to the server
        WGRD.putData(schedule_obj).success(function (response) {
            R_MT_REP.toggleCallBackAction();

            // we need to do some things after the save operations is successful
            if (response.status) {
                // unescaped data was sent to server, so we need to escape the local data
                schedule_obj.schedule_name = escapeHtml(schedule_obj.schedule_name);
                schedule_obj.schedule_desc = escapeHtml(schedule_obj.schedule_desc);
                schedule_obj.connectwise_active_id = escapeHtml(schedule_obj.connectwise_active_id);
                schedule_obj.file_location = escapeHtml(schedule_obj.file_location);

                $('#error_container').text(S_SCH_EDIT_MSG);
            }
            $('#error_container')
                .delay(2000)
                .fadeOut();
        });

        R_MT_REP.toggleSaveAction();
    },

    _save_devices_info : function (schedule_obj) {

        var isDevicesChecked = isChecked('#radio_devices');

        schedule_obj.device_or_server = -1;
        if (!isDevicesChecked) {
            schedule_obj.device_or_server = -2;
        }

        var index = $('#select_device_types')[0].selectedIndex;
        var active_device_list = [];
        if (index === 1) {
            $('#active_resources option').each(function () {
                active_device_list.push(parseInt(this.value, 10));
            });
        }
        schedule_obj.active_device_list = active_device_list;
    },

    _save_targets_info : function (schedule_obj) {
        //get data from target div and save to schedule_obj
        var targets_chks = ['email', 'file', 'connectwise'];
        var targets = [];
        $.each(targets_chks, function (i, target) {
            if ($('#' + target).prop('checked')) {
                targets.push(target);
            }
        });

        schedule_obj.targets = targets;
        schedule_obj.file_location = '';
        schedule_obj.ftp_server_id = '';
        if ($('#file').prop('checked')) {
            var selected_val = $('#file_select option:selected').val();
            if (selected_val === 'ftp') {
                var ftp_server = $('#ftp_servers_list option:selected').val();
                if (ftp_server !== '') {
                    var ftp_server_obj = null;
                    var i, name;
                    for (i = 0; i < ftp_servers_list.length; i++) {
                        name = unescapeHtml(ftp_servers_list[i].server_name);
                        if (name === ftp_server) {
                            ftp_server_obj = ftp_servers_list[i];
                            break;
                        }
                    }
                    if (ftp_server_obj !== null) {
                        var sub_folder = $('#ftp_location').val();
                        var server_id = ftp_server_obj.server_id;
                        if (sub_folder[0] !== '/') {
                            sub_folder = '/' + sub_folder;
                        }
                        schedule_obj.file_location = unescapeHtml(sub_folder);
                        schedule_obj.ftp_server_id = server_id;
                    }
                }
            } else {
                var rb_location = $('#rb_location').val();
                schedule_obj.file_location = unescapeHtml(rb_location);
            }
        }
        var connectwise_active_id = $('#cw_managed_id option:selected').val();

        schedule_obj.connectwise_active_id = connectwise_active_id || '';

        var email_list = [];
        $('#schedule_emails option').each(function () {
            email_list.push($(this).val());
        });

        schedule_obj.email_list = email_list;
        var subj = $('#schedule_email_subject').val();
        schedule_obj.email_subj = subj;
        var body = $('#schedule_email_body').val();
        schedule_obj.email_body = body;
        var notify_checked = $('#email_notify_chkbox').prop('checked');
        schedule_obj.notify_admin = notify_checked;
    },

    _save_reports_info : function (schedule_obj) {
        var index = $('#rep_type')[0].selectedIndex;
        var report_id_list = [];
        if (index === 1) {
            $('#specify_rep_select option').each(function () {
                if (this.value.indexOf(',') !== -1) {
                    var id_list = this.value.split(',');
                    for(var i = 0; i < id_list.length; i++) {
                        report_id_list.push(parseInt(id_list[i], 10));
                    }
                    return;
                }
                report_id_list.push(parseInt(this.value, 10));
            });
        }
        schedule_obj.report_id_list = report_id_list;

        schedule_obj.language = $('#rep_lang').val();

        var tz_name = $('#rep_tz').val();
        schedule_obj.tz_name = tz_name;

        var report_customization = $('#rep_custom').val();
        schedule_obj.customization_name = report_customization;

        schedule_obj.aggregate = $('#rep_aggr option:selected').val();

        var rep_sch = $('#run_schedule option:selected').val();
        schedule_obj.report_schedule = rep_sch;

        // save data_begin_time and data_end_time
        schedule_obj.data_begin_time = '';
        schedule_obj.data_end_time = '';
        if (rep_sch === '0d') {
            var start_date = $('#start_date').data('datetimepicker').getLocalDate();
            var end_date = $('#end_date').data('datetimepicker').getLocalDate();
            // The datetimepicker here is used to acquire the datetime selected by users. However in addition to the datetime,
            // the value returned by getLocalDate() also contains a timezone that is the timezone of the browser, which is usually
            // the timezone of the underlying operating system, so call _get_local_date_without_time_zone() to get rid of the timezone.
            // The UI has a control get a timezone from users. This timezone will be used as the timezone of the start and end dates.
            schedule_obj.data_begin_time = R_MT_REP._get_local_date_without_time_zone(start_date);
            schedule_obj.data_end_time = R_MT_REP._get_local_date_without_time_zone(end_date);
        } else {
            // Similar to above
            var run_time_of_day =  R_MT_REP._get_local_time_without_time_zone($('#run_time_of_day').data('datetimepicker').getLocalDate());
            schedule_obj.run_time_of_day = run_time_of_day;
        }
    },

    _get_local_date_without_time_zone : function (local_date) {
        return local_date.format("yyyy-mm-dd HH:MM:ss");
    },

    _get_local_time_without_time_zone : function (local_date) {
        return local_date.format("HH:MM:ss");
    },

    // local_date is a local time whose timezone is the timezone shown in the 'Time Zone' box,
    // which may not be the timezone of the datetimepicker. To show local_date as it is 
    // in the datetimepicker, this function makes a local time of the timezone of the datetimepicker
    // that looks like local_date.
    _make_local_date_from_string : function (local_date) {
        var date = new Date();
        var temp = local_date.split(' ');
        var yyyymmdd = temp[0].split('-');
        var hhmmss = temp[1].split(':');
        date.setFullYear(parseInt(yyyymmdd[0], 10));
        date.setMonth(parseInt(yyyymmdd[1], 10) - 1);
        date.setDate(parseInt(yyyymmdd[2], 10));
        date.setHours(parseInt(hhmmss[0], 10));
        date.setMinutes(parseInt(hhmmss[1], 10));
        date.setSeconds(parseInt(hhmmss[2], 10));
        return date;
    },

    // Similar to above
    _make_local_time_from_string : function (local_time) {
        var date = new Date();
        var hhmmss = local_time.split(":");
        date.setHours(parseInt(hhmmss[0], 10));
        date.setMinutes(parseInt(hhmmss[1], 10));
        date.setSeconds(parseInt(hhmmss[2], 10));
        return date;
    },

    saveSchedule : function () {

        var schedule_obj = {};

        //get data from gen div
        schedule_obj.schedule_name = $('#schedule_name').val();
        schedule_obj.schedule_desc = $('#schedule_desc').val();

        //get data from device div
        R_MT_REP._save_devices_info(schedule_obj);

        //get data from target div
        R_MT_REP._save_targets_info(schedule_obj);

        //get data from report div and save to schedule_obj
        R_MT_REP._save_reports_info(schedule_obj);

        var obj = new ReportScheduleObj();

        obj.schedule_name = schedule_obj.schedule_name;
        obj.schedule_desc = schedule_obj.schedule_desc;
        obj.report_schedule = schedule_obj.report_schedule;
        obj.data_begin_time = schedule_obj.data_begin_time;
        obj.data_end_time = schedule_obj.data_end_time;

        var rep_sch = $('#run_schedule option:selected').val();
        if (rep_sch !== '0d') {
            obj.run_time_of_day = schedule_obj.run_time_of_day;
        }

        obj.notify_admin = schedule_obj.notify_admin;
        obj.report_id_list = schedule_obj.report_id_list;
        obj.device_or_server = schedule_obj.device_or_server;
        obj.active_device_list = schedule_obj.active_device_list;
        obj.targets = schedule_obj.targets;
        obj.aggregate = schedule_obj.aggregate;
        obj.tz_name = schedule_obj.tz_name;
        obj.language = schedule_obj.language;
        obj.customization_name = schedule_obj.customization_name;
        obj.ftp_server_id = schedule_obj.ftp_server_id;
        obj.file_location = schedule_obj.file_location;
        obj.email_list = schedule_obj.email_list;
        obj.email_subj = schedule_obj.email_subj;
        obj.email_body = schedule_obj.email_body;
        obj.connectwise_active_id = schedule_obj.connectwise_active_id;

        // save the data to the server
        WGRD.putData(obj).success(function (response) {
            R_MT_REP.toggleCallBackAction();

            // we need to do some things after the save operations is successful
            if (response.status) {
                // unescaped data was sent to server, so we need to escape the local data
                active_schedule_list.push({'schedule_name': escapeHtml(obj.schedule_name),
                           'schedule_desc': escapeHtml(obj.schedule_desc),
                           'report_schedule': obj.report_schedule,
                           'data_begin_time': obj.data_begin_time,
                           'data_end_time': obj.data_end_time,
                           'run_time_of_day': obj.run_time_of_day,
                           'notify_admin': obj.notify_admin,
                           'report_id_list': obj.report_id_list,
                           'device_or_server': obj.device_or_server,
                           'active_device_list': obj.active_device_list,
                           'targets': obj.targets,
                           'aggregate': obj.aggregate,
                           'language': obj.language,
                           'tz_name': obj.tz_name,
                           'customization_name': obj.customization_name,
                           'ftp_server_id': obj.ftp_server_id,
                           'file_location': escapeHtml(obj.file_location),
                           'email_list': obj.email_list,
                           'email_subj': obj.email_subj,
                           'email_body': obj.email_body,
                           'connectwise_active_id': escapeHtml(obj.connectwise_active_id),
                           '__module__': 'modules.scripts.tasks.rep_sch_grp_scripts',
                           '__class__': 'ReportScheduleObj'
                    });

                $('#error_container').text(S_SCH_ADD_MSG);
            }
            $('#error_container')
                                .delay(2000)
                                .fadeOut();
        });

        R_MT_REP.toggleSaveAction();
    },

    populateCustomizationList : function () {
        $('#rep_custom').append('<option value="' + S_REPORT_CUST_DEFAULT + '">' + S_REPORT_CUST_DEFAULT + '</option>');
        var i;
        for (i = 0; i < customization_list.length; i++) {
            if (customization_list[i].default === 0) {
                $('#rep_custom').append('<option value="' + customization_list[i].name + '">' + customization_list[i].name + '</option>');
            } else {
                // Add the default template name to the first place
                $('#rep_custom').prepend('<option value="' + customization_list[i].name + '">' + customization_list[i].name + '</option>');
            }
        }
    },

    populateFtpServerList : function () {
        var i, name;
        for (i = 0; i < ftp_servers_list.length; i++) {
            name = ftp_servers_list[i].server_name;
            $('#ftp_servers_list').append('<option value="' + name + '">' + name + '</option>');
        }
    },

    enable_rb_UI : function (enable) {
        if (!enable) {
            $('#rb_location').val('')
                             .prop('disabled', true);
            $('#rb_config_status').show();
        } else {
            $('#rb_config_status').hide();
            $('#rb_location').prop('disabled', false);
        }
    },

    showFileDiv : function () {
        var ftp_servers_length = ftp_servers_list.length;
        var file_checked = $('#file').prop('checked');
        var is_remote_bkup_enabled = R_MT_REP.is_rbEnabled;
        if (ftp_servers_length === 0 && !is_remote_bkup_enabled) {
            $('#file').prop('checked', false);
            R_MT_REP.enable_rb_UI(is_remote_bkup_enabled);
            $('#file_location_container').hide();
            return;
        }
        if (file_checked) {
            $('#file_location_container').show();
            R_MT_REP.showFTPOrRemoteLocation();
            R_MT_REP.enable_rb_UI(is_remote_bkup_enabled);
        } else {
            $('#file_location_container').hide();
        }
    },

    //Called when user changes the ftp server and when user clicks on the edit option
    ftpServerAction : function () {
        var selected_val = $('#ftp_servers_list option:selected').val();
        var root_location = S_NONE;
        var i, server_name, server_index, upload_location;
        for (i = 0; i < ftp_servers_list.length; i++) {
            server_name = unescapeHtml(ftp_servers_list[i].server_name);
            server_index = selected_val.indexOf(server_name);
            if (server_index === 0) {
                upload_location = ftp_servers_list[i].upload_location;
                if (upload_location.length !== 0) {
                    root_location = "<b>" + upload_location + "</b>";
                } else {
                    root_location = '';
                }
                break;
            }
        }
        $('#cur_ftp_server').html(root_location);
    },

    addEmail : function (event) {
        event.preventDefault();
        $('.add_error_sch').hide();
        var selected_email = $('#schedule_email_to').val();
        var patt = /[^\s]+@[^\s]+([.]\w{2,})+/;

        // email to address
        if (selected_email.length === 0 || (!patt.test(selected_email))) {
            $('#schedule_email_to').focus();
            $('#schedule_email_to').select();
            $('.add_error_sch').show().text(S_ERROR_EMAIL_TO_INVALID);
            return;
        }

        if ($('#schedule_emails option[value="' + selected_email + '"]').length > 0) {
            $('#schedule_email_to').focus();
            $('#schedule_email_to').select();
            $('.add_error_sch').show().text(S_ERROR_EMAIL_TO_DUPLICATE);
            return;
        }

        $('#schedule_emails').append('<option value="' + selected_email + '">' + selected_email + '</option>');
        $('#schedule_email_to').val("");
    },

    removeEmail : function (event) {
        event.preventDefault();
        var selected_email = $('#schedule_emails').val();

        if (selected_email.length !== 0) {
            $('#schedule_emails option[value="' + selected_email + '"]').remove();
        }
        return;
    },

    runReportAction : function () {
        var report_interval = $('#run_schedule').val();
        if (report_interval === '0d') {
            $('#start_end_date').show();
            $('#run_time_of_day_div').hide();
            $('#report_time').text(sch_intervals_msg[report_interval][0]);
            $('#report_range').text(sch_intervals_msg[report_interval][1]);
        } else {
            var run_time_of_day = '12:00 AM';
            var temp_run_time_val =  $('#run_time_of_day_val').val();
            var morning_or_afternoon = S_EACH_MORNING;

            if (temp_run_time_val !== '') {
                // Only when the input 'next run time' contains 'AM' or 'PM', the text description in 'report_time'
                // could be modified to 'Each morning' or 'Each afternoon' automatically.
                if (temp_run_time_val.indexOf('AM') !== -1) {
                    morning_or_afternoon = S_EACH_MORNING;
                    run_time_of_day = temp_run_time_val;
                } else if (temp_run_time_val.indexOf('PM') !== -1) {
                    morning_or_afternoon = S_EACH_AFTERNOON;
                    run_time_of_day = temp_run_time_val;
                }
            }
            if (report_interval === '1d') {
                $('#report_time').text(sch_intervals_msg[report_interval][0].format(morning_or_afternoon, run_time_of_day) + ', ' + $('#rep_tz option:selected').text());
            } else {
                $('#report_time').text(sch_intervals_msg[report_interval][0].format(run_time_of_day) + ', ' + $('#rep_tz option:selected').text());
            }
            $('#start_end_date').hide();
            $('#run_time_of_day_div').show();
            $('#report_range').text(sch_intervals_msg[report_interval][1]);
        }
    },

    /*
       Called when add or Edit buttons are clicked for groups
       If edit, then pass in row data
       */
    showTaskModal : function (params) {
        if (R_MT_REP.complete_cb === null) {
            R_MT_REP.complete_cb = params.complete_cb;
        }

        WGRD.doModal('#manage_schedule_dlg',
                     R_MT_REP.initializeSchedules,
                     null,
                     params);
        //Every time user clicks add/edit/view check if user has
        //permission for remote backup operation, accordingly enable or disable remote radio option
        R_MT_REP.chk_for_rmt_bkup();
    },

    chk_for_rmt_bkup : function () {
        $.ajax({
            url: 'test_backup_conn',
            success: function (response) {
                R_MT_REP.is_rbEnabled = response[0];
            },
            error: function (response) {
                R_MT_REP.is_rbEnabled = false;
            },
            complete: function () {
                R_MT_REP.showFileDiv();
            }
        });
    },

    initializeSchedules : function (params) {
        R_MT_REP.mode = params.mode;
        if (params.mode === 'add') {
            R_MT_REP._init_sch('add');
            R_MT_REP._add_schedule();
        } else { //Update UI
            R_MT_REP._init_sch('edit');
            R_MT_REP._edit_schedule(params);
        }
        return true;
    },

    _init_sch : function (arg) {
        R_MT_REP.active_pane = 'gen';

        //Reset gen_div contents
        $('#schedule_name').val("")
                           .attr('disabled', false);
        $('.wizard-subtitle').text("")
                             .attr('title', "");
        $('#schedule_desc').val("");

        $('#radio_devices').prop("checked", true);
        $('#device_server_container').show();
        $('#device_server_lbl').text(S_DEVICE_LABEL_MAIN);
        R_MT_REP.showDevicesOrServers();
        $('#main_sch_div').show();

        //Reset specify_device_div contents
        $('#specify_device_div').hide();
        $('#device_server_name').val("");
        $('#active_devices_servers').empty();
        $('#active_resources').empty();

        //Reset target div contents
        var target_div_chkboxes = ['#email', '#file', '#connectwise'];
        $.each(target_div_chkboxes, function (i, chkbox) {
            $(chkbox).prop('checked', false);
        });

        if (is_email_enabled === 1) {
            $('#email').prop("disabled", false);
        } else {
            $('#email').prop("disabled", true);
        }

        $('#email_notify_chkbox').prop('checked', false);
        R_MT_REP.showFTPOrRemoteLocation();
        R_MT_REP.toggleFileChkbox();
        R_MT_REP.toggleCWChkbox();

        $('select#ftp_servers_list').prop('selectedIndex', 0);
        $('select#file_select').prop('selectedIndex', 0);
        $('#cur_ftp_server').html(S_NONE);
        $('#ftp_location').val('');
        $('#rb_location').val('');

        $('#show_hide_subj_body').hide();
        $('#email_adv').text(S_SHOW_ADV_SETTINGS);

        //Reset schedule email text
        $('#schedule_email_to').val("");
        $('#schedule_emails').empty();

        //Reset schedule email subject and body
        $('#schedule_email_subject').val(S_SCHEDULE_DEFAULT_SUBJ);
        $('#schedule_email_body').val(S_SCHEDULE_DEFAULT_BODY);

        //Reset report types
        $('#rep_type').prop("selectedIndex", 0);
        $('#specify_rep_select').empty();
        R_MT_REP.toggleReportType();

        //Reset report customization to 'Default'
        $('#rep_custom').prop("selectedIndex", 0);

        //Uncheck report aggregations
        $('#rep_aggr').prop('selectedIndex', 0);
        $('#rep_tz').val(WGRD.client_tz);
        $('#rep_lang').val(language);

        //Reset run reports to 'Daily'
        $('#run_schedule').prop('selectedIndex', 0);
        R_MT_REP.runReportAction();

        //Reset specify_device_div contents
        $('#specify_reports_div').hide();
        $('#filtered_rep_type').empty();
        $('#active_rep_type').empty();

        // Configure time picker for the next run time
        $('#run_time_of_day').datetimepicker({
            pickDate: false,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });

        $.each(R_MT_REP.panes, function (i, pane) {
            if (arg === 'add') {
                $('#' + pane + '_li').removeClass("already-visited");
            } else {
                $('#' + pane + '_li').addClass('already-visited');
            }

            $('#' + pane + '_li').removeClass("active");
            $('#' + pane + '_div').hide();
        });

        $('#' + R_MT_REP.active_pane + '_li').addClass("active");
        $('#' + R_MT_REP.active_pane + '_div').show();

        if (arg === 'add') {
            $(R_MT_REP.backButton).show();
            $(R_MT_REP.nextButton).show();

            $(R_MT_REP.closeButton).hide();
            $(R_MT_REP.saveButton).hide();
        } else {
            $(R_MT_REP.backButton).hide();
            $(R_MT_REP.nextButton).hide();

            $(R_MT_REP.closeButton).show();
            $(R_MT_REP.saveButton).show();
        }
    },

    _add_schedule : function () {
        WGRD.enableUIElements(false, [R_MT_REP.backButton]);
        $(R_MT_REP.nextButton).text(S_NEXT_BUTTON);
        $('#manage_schedule_dlg h3').text(S_ADD_SCHEDULE_TITLE);
    },

    _edit_schedule : function (params) {
        var task_obj = params.task;
        if (task_obj === undefined || task_obj === null) {
            return;
        }

        R_MT_REP.toggleStatusAction(task_obj);

        if (is_page_locked === 0) {
            $('#manage_schedule_dlg h3').text(S_VIEW_SCHEDULE_TITLE);
            $("#saveSch").hide();
        } else {
            $('#manage_schedule_dlg h3').text(S_EDIT_SCHEDULE_TITLE);
            $("#saveSch").show();
        }

        var schedule_obj = null;
        var task_name = task_obj.name;
        var i;
        for (i = 0; i < active_schedule_list.length; i++) {
            schedule_obj = active_schedule_list[i];
            if (schedule_obj.schedule_name === escapeHtml(task_name)) {
                break;
            }
        }

        //populate gen div
        $('#schedule_name').val(unescapeHtml(schedule_obj.schedule_name)).attr('disabled', true);
        $('.wizard-subtitle').text(unescapeHtml(schedule_obj.schedule_name))
                             .attr('title', unescapeHtml(schedule_obj.schedule_name));
        $('#schedule_desc').val(unescapeHtml(schedule_obj.schedule_desc));

        //populate device div

        //In edit mode, disable switching from device to server and vice-versa
        var device_or_server = schedule_obj.device_or_server;
        var resource_list = [];
        $('#device_server_container').hide();
        // In edit/view mode, no text will be present
        $('#device_server_lbl').text("");
        if (device_or_server === -1) {
            resource_list = avail_device_list;
            $('#radio_devices').prop("checked", true);
        } else {
            resource_list = avail_server_list;
            $('#radio_servers').prop("checked", true);
            if (dim_anonymization_enabled === 1) {
                WGRD.enableUIElements(false, [$('#saveSch')]);
            } else {
                WGRD.enableUIElements(true, [$('#saveSch')]);
            }
        }
        var index = 0;
        var device_list = schedule_obj.active_device_list;

        R_MT_REP.showDevicesOrServers();
        if (device_list.length !== 0) {
            index = 1;
            var count = 0;
            $.each(resource_list, function (i, resource) {
                var resource_id = resource.id;

                if (device_list.indexOf(resource_id) !== -1) {
                    var name_sn = resource.name;
                    $('#active_resources').append('<option value=' + resource_id + ' title="' + name_sn + '">' + name_sn + '</option>');
                    count = count + 1;
                }
                //We only want to iterate the resource list till we have looked into all of the devices in device_list.
                if (count === device_list.length) {
                    return false;
                }
            });
        }
        R_MT_REP.toggleReportAggregation();

        $('#select_device_types').prop('selectedIndex', index);
        R_MT_REP.toggleDeviceType();

        //populate target div
        var targets = schedule_obj.targets;
        var target_div_chkboxes = ['email', 'file', 'connectwise'];
        $.each(target_div_chkboxes, function (i, chkbox) {
            if (targets.indexOf(chkbox) !== -1) {
                $('#' + chkbox).prop('checked', true);
            }
        });


        if ($('#file').is(':checked')) {
            var file_loc = schedule_obj.file_location;
            var ftp_server_id = schedule_obj.ftp_server_id;
            if (ftp_server_id !== '') {
                var server_id, server_name, upload_location;
                for (i = 0; i < ftp_servers_list.length; i++) {
                    server_id = ftp_servers_list[i].server_id;
                    if (server_id === ftp_server_id) {
                        server_name = ftp_servers_list[i].server_name;
                        upload_location = ftp_servers_list[i].upload_location;
                        if (upload_location.length !== 0 && upload_location.charAt(0) !== "/") {
                            upload_location = '/' + upload_location;
                        }
                        $('#ftp_servers_list').val(unescapeHtml(server_name));
                        $('#ftp_location').val(unescapeHtml(file_loc));
                        if (upload_location.length !== 0) {
                            $('#cur_ftp_server').html("<b>" + upload_location + "</b>");
                        } else {
                            $('#cur_ftp_server').text('');
                        }
                        break;
                    }
                }
                R_MT_REP.ftpServerAction();
            } else if (file_loc !== '') {
                $('select#file_select').prop('selectedIndex', 1);
                $('#rb_location').val(unescapeHtml(file_loc));
                R_MT_REP.showFTPOrRemoteLocation();
            }
        }

        R_MT_REP.toggleFileChkbox();
        R_MT_REP.toggleCWChkbox();

        $('#cw_managed_id').val(unescapeHtml(schedule_obj.connectwise_active_id));

        var email_list = schedule_obj.email_list;
        $.each(email_list, function (index, value) {
            $('#schedule_emails').append('<option value="' + value + '">' + value + '</option>');
        });

        $('#schedule_email_subject').val(schedule_obj.email_subj);
        $('#schedule_email_body').val(schedule_obj.email_body);

        var notify = schedule_obj.notify_admin;
        $('#email_notify_chkbox').prop('checked', notify);

        //populate report div
        var report_id_list = schedule_obj.report_id_list;
        if (report_id_list.length !== 0) {
            $('#rep_type').prop("selectedIndex", 1);

            var email_checked = $('#email').is(':checked');
            var file_checked = $('#file').is(':checked');
            var cw_checked = $('#connectwise').prop('checked');

            var isDevicesChecked = isChecked('#radio_devices');

            var report_filter_list = '';
            if (!isDevicesChecked) {
                report_filter_list = server_rep_list;
                if (email_checked) { //Email
                    //only summary reports should be present
                    report_filter_list = server_summary_rep_list;
                }
            } else {
                if (cw_checked) {
                    report_filter_list = cw_reports_list;
                } else if (email_checked) {
                    report_filter_list = summary_rep_list;
                } else if (file_checked) {
                    report_filter_list = all_reports_list;
                }
            }

            $.each(report_filter_list, function (index, main_rep) {
                var main_rep_id = main_rep.id;
                var main_rep_title = main_rep.title;
                var main_rep_added = false;
                var sub_report_list = main_rep.sub_reports;

                $.each(sub_report_list, function (index, sub_rep) {
                    var sub_rep_id = sub_rep.id;
                    var sub_rep_title = sub_rep.title;
                    var sub_rep_id2 = sub_rep_id;
                    if (Object.prototype.toString.call(sub_rep_id) === '[object Array]') {
                        sub_rep_id2 = sub_rep_id[0];
                    }
                    if (report_id_list.indexOf(sub_rep_id2) !== -1) {
                        if (!main_rep_added) {
                            $('#specify_rep_select').append('<optgroup id="' + main_rep_id + '" label="' + main_rep_title + '"></optgroup>');
                            main_rep_added = true;
                        }
                        $('#specify_rep_select optgroup[id=' + main_rep_id + ']').append('<option value="' + sub_rep_id + '" title="' + sub_rep_title + '">' + sub_rep_title + '</option>');
                    }
                });
            });
            R_MT_REP.toggleReportType();
        }

        $('#rep_lang').val(schedule_obj.language);
        $('#rep_tz').val(schedule_obj.tz_name);
        $('#rep_custom').val(schedule_obj.customization_name);

        $('#rep_aggr').val(schedule_obj.aggregate);
        var rep_sch = schedule_obj.report_schedule;
        $('#run_schedule').val(rep_sch);

        // filled the start_date and end_date when the run mode is 'one time'
        // '1m': '1 month', '1w': '1 week', '1d': '1 day', '0d': 'one time'
        if (rep_sch === '0d') {
            // data_begin_end and data_end_time are local times
            $('#start_date').data('datetimepicker').setLocalDate(R_MT_REP._make_local_date_from_string(schedule_obj.data_begin_time));
            $('#end_date').data('datetimepicker').setLocalDate(R_MT_REP._make_local_date_from_string(schedule_obj.data_end_time));
        } else {
            $('#run_time_of_day').data('datetimepicker').setLocalDate(R_MT_REP._make_local_time_from_string(schedule_obj.run_time_of_day));
        }

        R_MT_REP.runReportAction();
    },

    toggleStatusAction : function (task_object) {
        //get task_status and run mode
        var task_status = task_object.status_value.substring(0, 3);
        var task_mode = task_object.run_mode;

        R_MT_REP.start_over = true;
        // check the task status, to enable/disable run again button
        if (task_status === '101' || task_status === '102') {
            $(R_MT_REP.saveButton).text(S_SCH_RUN_AGAIN);
        } else if (task_status === '100') {
            // The finished 'run one time' task could run again if any change to it. 
            if (task_mode === '0d') {
                R_MT_REP.modify_enabled = true;
                $(R_MT_REP.saveButton).attr('disabled', true);
            }
        } else if (task_status !== '103') {
            $(R_MT_REP.saveButton).attr('disabled', true);
        }
    },

    toggleSaveAction : function () {
        $('#manage_schedule_dlg').modal('hide');
    },

    toggleCallBackAction : function () {
        // Call the callback funtion if it is set.
        if (R_MT_REP.complete_cb !== null) {
            R_MT_REP.complete_cb();
        }
    }
};
// Add the sourceURL for debug
//@ sourceURL=schedule_reports.js
$(document).ready(R_MT_REP.init);
