/*global S_TASK_STATUS, S_TASK_TYPE, S_TASK_DESCRIPTION, S_TASK_CREATED_ON,
S_TASK_FAILED, task_interval_map, task_type_map, escapeHtml */
var R_MT_DETAIL = {
    init : function () {
        R_MT_DETAIL.initEvents();
    },

    initEvents : function () {
        $('#task_ok').click(function () {
            $('#task_detail_dlg').modal("hide");
        });
    },

    showDetailsDialog : function (event) {
        event.preventDefault();

        var task_name = event.currentTarget.text;
        var task_id = event.currentTarget.id;
        var task_data = {'task_id': task_id};

        $('#task_contents').empty();
        $('#details').empty();
        $('#task_detail_header').text(S_TASK_STATUS);
        $('#details_div').hide();
        $('#task_summary_table').hide();
        $('#error_msg').hide();

        $.ajax({
            url: 'get_task_details',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: task_data,
            success : function (data) {
                if (data.status) {
                    var task_type = data.task_details.task_type;
                    var task_status = data.task_details.task_status;
                    var run_interval = data.task_details.run_interval;
                    var task_desc = data.task_details.description;
                    var create_time = data.task_details.task_create_time;
                    var task_activity = data.task_details.task_activity;

                    $('#task_summary_table').show();
                    if (task_type.length > 0) {
                        var subtitle = task_name + ' - ' + task_status + ' - ' + task_interval_map[run_interval];
                        $('#task-subtitle').text(subtitle)
                                           .attr('title', subtitle);

                        var type_name = task_type_map[task_type];
                        R_MT_DETAIL.prepare_detail_data(S_TASK_TYPE, type_name);
                    }
                    if (task_desc.length > 0) {
                        R_MT_DETAIL.prepare_detail_data(S_TASK_DESCRIPTION, escapeHtml(task_desc));
                    }
                    if (create_time.length > 0) {
                        R_MT_DETAIL.prepare_detail_data(S_TASK_CREATED_ON, $.getDateDisplay(create_time, true));
                    }
                    if (task_activity.length > 0) {
                        $('#details_div').show();

                        $.each(task_activity, function (index, value) {
                            if (value.data.length > 0) {
                                var activity_data = '';
                                // If 'GMT' in the data, format into local time
                                if (value.data.indexOf('GMT') < 0) {
                                    activity_data = value.data;
                                } else {
                                    activity_data = $.getDateDisplay(value.data, true);
                                }

                                $('#details').append('<tr><td>' + value.content.format(activity_data) + '</td></tr>');
                            } else {
                                $('#details').append('<tr><td>' + value.content + '</td></tr>');
                            }
                        });
                    }
                    //If more than one dialog is up, then first hide the current active modal dialog
                    //then show the new dialog, when the new one is closed, show the previous one
                    //This is done to prevent an Uncaught RangeError: Maximum call stack size exceeded exception that 
                    //is shown in the console if two dialogs are up at the same time.
                    var $currentModals = $('.modal.in');
                    if ($currentModals.length > 0) {
                        $currentModals.one('hidden', function () {
                            // when they've finished hiding
                            $('#task_detail_dlg').modal('show');
                            $('#task_detail_dlg').one('hidden', function () {
                                // when we close the dialog
                                $currentModals.modal('show');
                            });
                        }).modal('hide');
                    } else {
                        $("#task_detail_dlg").show();
                    }
                } else {
                    $('#error_msg').show().find('p').text(data.message);
                }

                $("#task_detail_dlg").modal();
            },
            error : function () {
                $('.modal-body').append('<p class="text-error">' + S_TASK_FAILED + '</p>');
            }
        });
    },

    prepare_detail_data : function (col_name, col_data) {
        var col1 = '<td width="40%"><b>' + col_name + '</b></td>';
        var col2 = '<td style="word-break:break-all;">' + col_data + '</td>';
        var row = '<tr>' + col1 + col2 + '</tr>';

        $('#task_contents').append(row);
    }
};
$(document).ready(R_MT_DETAIL.init);