/*global escapeHtml, unescapeHtml, is_page_locked, lock_page, selected_tab, ad_domain_list:true, S_ATLEAST_ONE_AD, S_USER_NAME_EMPTY, writeErrorContainer, S_AD_DUPLICATE, S_AD_TEST_FAILED, S_AD_TEST_PASSED, UserManagementObj, S_USER_MODE, S_VIEW_TEXT, S_EDIT_TEXT, S_PASSWORD_EMPTY, S_ERROR_AD_INVALID, radius_domains, RadiusObj, S_RADIUS_IP_REPEAT, S_RADIUS_IP_EMPTY, S_RADIUS_INVALID, S_RADIUS_PORT_EMPTY, S_RADIUS_SECRET_EMPTY, S_RADIUS_SECRET_MISMATCH, S_RADIUS_PORT_DIGITS, S_RADIUS_MAX, S_TIMEOUT_RANGE, S_RETRIES_RANGE, S_GROUP_ATTR_RANGE, S_ATLEAST_ONE_RADIUS, S_RADIUS_PORT_RANGE, S_CLOSE, S_CANCEL, S_TXT_LOCKOUT_DURATION, S_TXT_LOCKOUT_STEPSIZE, S_TXT_LOCKOUT_NSTEPS, IPHELPER, validateDomainNameStr, validateSRVRecordStr, S_ERROR_IPCIDR_INVALID, S_ERROR_IPCIDR_EXISTS*/
var USER_CONFIGURE = {
    mode : '',

    init : function () {
        USER_CONFIGURE.initData();
        USER_CONFIGURE.initUI();
        USER_CONFIGURE.initEvents();
        USER_CONFIGURE.initTabs();
    },

    initData: function () {
        // data values are shown in html elements, so they need to be escaped before being displayed
        // we escape the data here and store them escaped at the client
        // data sent to the server must not be escaped
        // the javascript logic must consider whether a value is escaped or unescaped when working with it
        var i, len;
        for (i = 0, len = radius_domains.length; i < len; i++) {
            radius_domains[i].host_name = escapeHtml(radius_domains[i].host_name);
            radius_domains[i].secret = escapeHtml(radius_domains[i].secret);
        }
    },

    initUI : function () {
        $('#progress_save').hide();
        $('#error_container').hide();
        $('#radius_success_error').hide();

        USER_CONFIGURE.populateRadiusList();
        USER_CONFIGURE.updateRadiusUI();

        //Users and Roles
        USER_CONFIGURE.initUserModeUI();
    },

    initUserModeUI : function () {
        var ids = ['#add_radius', '#remove_radius'];
        USER_CONFIGURE.pg_tracker = window.sessionStorage.getItem(lock_page);

        var viewMode = WGRD.userInViewMode(is_page_locked, USER_CONFIGURE.pg_tracker);
        var ad_enabled = $('#active_directory_chkbox').is(':checked');
        var radius_enabled = $('#radius_chkbox').is(':checked');
        var lockout_enabled = $('#lockout_enabled').is(':checked');

        var ad_elem_ids = ['#add_ad_domain', '#remove_ad_domain',
                           '#active_directory_chkbox', '#dc_ssl_chkbox',
                           '#ad_priority_up', '#ad_priority_down'];
        var radius_elem_ids = ['#radius_chkbox', '#radius_priority_up',
                               '#radius_priority_down', '#add_radius',
                               '#radius_timeout', '#radius_retries',
                               '#radius_group_attribute'];
        var other_elem_ids = ['#lockout_enabled',
                                '#lockout_duration', '#lockout_stepsize',
                                '#lockout_nsteps', '#user_add_host_network'];

        if (viewMode) {
            $('#edit_radius').val(S_VIEW_TEXT);
            $('#user_host_network_field').hide();
            $('#remove_user_host_network').hide();

            WGRD.enableUIElements(false, ad_elem_ids);
            WGRD.enableUIElements(false, radius_elem_ids);
            WGRD.enableUIElements(false, other_elem_ids);
            USER_CONFIGURE.showHideSubmitButton(false);
        } else {
            $('#edit_radius').val(S_EDIT_TEXT);
            if (!ad_enabled) {
                WGRD.enableUIElements(false, ad_elem_ids);
            }
            if (!radius_enabled) {
                WGRD.enableUIElements(false, radius_elem_ids);
            }
            if (!lockout_enabled) {
                WGRD.enableUIElements(false, ['#lockout_duration', '#lockout_stepsize', '#lockout_nsteps']);
            }
            WGRD.enableUIElements(true, ['#active_directory_chkbox', '#radius_chkbox']);
        }
        S_USER_MODE.initUI(ids, viewMode);
        $('.nav-tabs a[href=' + selected_tab + ']').tab('show');
        S_USER_MODE.selected_tab = selected_tab;
    },

    initEvents : function () {
        WGRD.pgUnloadCallBack(USER_CONFIGURE.pg_tracker, lock_page);

        $('#add_ad_domain').button().click(USER_CONFIGURE.addADDomain);
        $('#remove_ad_domain').button().click(USER_CONFIGURE.removeADDomain);
        $('#test_ad_domain').button().click(USER_CONFIGURE.testADDomain);
        $('#add_radius').button().click(USER_CONFIGURE.addRadius);
        $('#edit_radius').button().click(USER_CONFIGURE.addRadius);
        $('#remove_radius').button().click(USER_CONFIGURE.removeRadius);
        $('#radius_dlg_save').button().click(USER_CONFIGURE.toRadiusBox);
        $('#ad_priority_up').button().click(USER_CONFIGURE.ADindexUp);
        $('#ad_priority_down').button().click(USER_CONFIGURE.ADindexDown);
        $('#radius_priority_up').button().click(USER_CONFIGURE.radiusIndexUp);
        $('#radius_priority_down').button().click(USER_CONFIGURE.radiusIndexDown);
        $('#user_add_host_network').on('click', USER_CONFIGURE.addHostNetwork);
        $('#remove_user_host_network').on('click', USER_CONFIGURE.removeHostNetwork);
        $("#active_directory_chkbox").change(USER_CONFIGURE.ADstateChange);
        $("#radius_chkbox").change(USER_CONFIGURE.radiusStateChange);
        $("#lockout_enabled").change(USER_CONFIGURE.lockoutStateChange);

        $('#radius_domains').change(USER_CONFIGURE.updateRadiusUI);

        $('#submit_button').button()
                           .click(USER_CONFIGURE.savePage);

        //User mode changes
        S_USER_MODE.initEvents();
    },

    initTabs : function () {
        $('.nav-tabs a[href="#remote_auth"]').click(function (e) {
            S_USER_MODE.selected_tab = "#remote_auth";
        });
        $('.nav-tabs a[href="#user_lockout"]').click(function (e) {
            S_USER_MODE.selected_tab = "#user_lockout";
        });
        $('.nav-tabs a[href="#user_access_control"]').click(function (e) {
            S_USER_MODE.selected_tab = "#user_access_control";
        });
    },

    addHostNetwork: function (event) {
        event.preventDefault();

        var user_host_network = IPHELPER.trimIP4($('#user_host_network').val());

        // verify server is valid ip
        if (IPHELPER.usableHostIP4(user_host_network) !== 0 && IPHELPER.usableNetworkIP4(user_host_network) !== 0) {
            $('#user_host_network').focus();
            $('#user_host_network').select();
            writeErrorContainer(S_ERROR_IPCIDR_INVALID, false);
            return;
        }

        // don't allow duplicates
        if ($('#default_network_acl_list option[value="' + user_host_network + '"]').length > 0) {
            $('#user_host_network').focus();
            $('#user_host_network').select();
            writeErrorContainer(S_ERROR_IPCIDR_EXISTS, false);
            return;
        }

        $('#default_network_acl_list').append('<option value="' + user_host_network + '">' + user_host_network + '</option>');
        $('#user_host_network').val("");
    },

    removeHostNetwork : function (event) {
        event.preventDefault();
        $('#default_network_acl_list option:selected').remove();
    },

    testADDomain : function () {
        WGRD.doModal('#test_ad_dlg',
                     USER_CONFIGURE._initializeADTest,
                     USER_CONFIGURE._testAD,
                     null);
    },

    _initializeADTest : function () {
        $('#user_name').val("");
        $('#password').val("");
        return true;
    },

    addRadius : function () {
        var button_id = $(this).attr('id');
        var params = {'new_mode': true};
        if (button_id === 'edit_radius') {
            if ($('#radius_domains :selected').length === 0) {
                return;
            }
            params.new_mode = false;
        }
        if (button_id === 'add_radius') {
            if ($('#radius_domains option').size() >= 8) {
                writeErrorContainer(S_RADIUS_MAX, false);
                $('#error_container').delay(2000).fadeOut();
                return;
            }
        }
        WGRD.doModal('#add_radius_dlg',
                     USER_CONFIGURE._initializeRadius,
                     USER_CONFIGURE.toRadiusBox,
                     params,
                     null,
                     true);
    },

    ADindexDown : function (event) {
        event.preventDefault();
        if (!WGRD.isEnabled('#ad_priority_up')) {
            return;
        }
        var options = $('#active_directory_domains option');
        var current_index = $('#active_directory_domains option:selected').index();
        $(options[current_index]).insertAfter($(options[current_index + 1]));
        return;
    },

    ADindexUp : function (event) {
        event.preventDefault();
        if (!WGRD.isEnabled('#ad_priority_up')) {
            return;
        }
        var options = $('#active_directory_domains option');
        var current_index = $('#active_directory_domains option:selected').index();
        $(options[current_index]).insertBefore($(options[current_index - 1]));
        return;
    },

    ADstateChange : function (event) {
        var ad_enabled = $('#active_directory_chkbox').is(':checked');
        var ad_elem_ids = ['#add_ad_domain', '#remove_ad_domain',
                           '#dc_ssl_chkbox', '#ad_priority_up',
                           '#ad_priority_down'];
        WGRD.enableUIElements(ad_enabled, ad_elem_ids);
    },

    _initializeRadius : function (params) {
        var i;
        if (params.new_mode) {
            // add new radius
            $('#radius_ip').val("");
            $('#port').val("1812");
            $('#secret').val("");
            $('#secret_confirm').val("");
            WGRD.enableUIElements(true, ['#radius_ip']);
        } else {
            // edit existing radius
            var radius_host = $('#radius_domains').val();
            var secret = '';
            $('#radius_ip').val(radius_host);
            for (i = 0; i < radius_domains.length; i++) {
                if (unescapeHtml(radius_domains[i].host_name) === radius_host) {
                    $('#port').val(radius_domains[i].port);
                    secret = unescapeHtml(radius_domains[i].secret);
                    WGRD.enableUIElements(false, ['#radius_ip']);
                    break;
                }
            }
            if (WGRD.userInViewMode(is_page_locked, USER_CONFIGURE.pg_tracker)) {
                WGRD.enableUIElements(false, ['#port', '#secret', '#secret_confirm']);
                $("#radius_dlg_save").hide();
                $("#radius_dlg_close").text(S_CLOSE);
            } else {
                $('#secret').val(secret);
                $('#secret_confirm').val(secret);
                $("#radius_dlg_close").text(S_CANCEL);
            }
        }
        return true;
    },

    _show_success_error_msg : function (id, msg, success) {
        $(id)
             .text(msg)
             .show();
        if (success) {
            $(id)
                 .addClass("alert-success wgrd-modal-success")
                 .removeClass("alert-error wgrd-modal-error");
        } else {
            $(id)
                 .removeClass("alert-success wgrd-modal-success")
                 .addClass("alert-error wgrd-modal-error");
        }
    },

    _testAD : function () {
        var $id = $('#add_success_error');
        $id.hide();
        var user_name = $('#user_name').val();
        var password = $('#password').val();

        if (user_name.trim().length === 0) {
            $('#user_name').focus();
            $('#user_name').select();
            USER_CONFIGURE._show_success_error_msg($id, S_USER_NAME_EMPTY, false);
            return S_USER_NAME_EMPTY;
        }

        if (password.trim().length === 0) {
            $('#password').focus();
            $('#password').select();
            USER_CONFIGURE._show_success_error_msg($id, S_PASSWORD_EMPTY, false);
            return S_PASSWORD_EMPTY;
        }

        var val = '';
        var test_data = {'user_name': user_name, 'password': password};
        $.ajax({
            url: 'test_ad',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: test_data,
            success : function (data) {
                if (data.status) {
                    USER_CONFIGURE._show_success_error_msg($id, S_AD_TEST_PASSED, true);
                    val = S_AD_TEST_PASSED;
                } else {
                    USER_CONFIGURE._show_success_error_msg($id, S_AD_TEST_FAILED, false);
                    val = S_AD_TEST_FAILED;
                }
            },
            error : function (data) {
                USER_CONFIGURE._show_success_error_msg($id, S_AD_TEST_FAILED, false);
                val = S_AD_TEST_FAILED;
            }
        });
        return val;
    },

    addADDomain : function (event) {
        event.preventDefault();
        if (!WGRD.isEnabled('#add_ad_domain')) {
            return;
        }
        var val = USER_CONFIGURE._validateAD();

        if (val) {
            var ad_domain = $('#active_directory_domain').val().trim();

            if ($('#active_directory_domains option[value="' + ad_domain + '"]').length > 0) {
                $('#active_directory_domain').focus();
                $('#active_directory_domain').select();
                writeErrorContainer(S_AD_DUPLICATE, false);
                return;
            }
            $('#active_directory_domains').append('<option value="' + ad_domain + '">' + ad_domain + '</option>');
            $('#active_directory_domain').val("");
            $('#error_container').hide();
        }
    },

    get_radius_list: function () {
        var i;
        // unescape the html before saving
        for (i = 0; i < radius_domains.length; i++) {
            radius_domains[i].host_name = unescapeHtml(radius_domains[i].host_name);
            radius_domains[i].secret = unescapeHtml(radius_domains[i].secret);
        }
        return radius_domains;
    },

    _validateAD : function () {
        var ad_domain = $('#active_directory_domain').val().trim();

        if (ad_domain.length === 0 || (!IPHELPER.validIP4(ad_domain) && !validateDomainNameStr(ad_domain) && !validateSRVRecordStr(ad_domain))) {
            $('#active_directory_domain').focus();
            $('#active_directory_domain').select();
            writeErrorContainer(S_ERROR_AD_INVALID, false);
            return false;
        }
        return true;
    },

    lockoutStateChange : function () {
        var lockout_enabled = $('#lockout_enabled').is(':checked');
        var other_elem_ids = ['#lockout_duration', '#lockout_stepsize',
                              '#lockout_nsteps'];
        WGRD.enableUIElements(lockout_enabled, other_elem_ids);
    },

    _validateRadius : function (new_mode) {
        var radius_ip = $('#radius_ip').val().trim();
        var i;
        if (new_mode) {
            for (i = 0; i < radius_domains.length; i++) {
                if (unescapeHtml(radius_domains[i].host_name) === radius_ip) {
                    return S_RADIUS_IP_REPEAT;
                }
            }
            if (radius_ip.length === 0) {
                $('#radius_ip').focus();
                $('#radius_ip').select();
                return S_RADIUS_IP_EMPTY;
            }
            // validate the host is an ip or hostname
            if (!IPHELPER.validIP4(radius_ip) && !validateDomainNameStr(radius_ip) && !validateSRVRecordStr(radius_ip)) {
                return S_RADIUS_INVALID;
            }
        }
        var radius_port = $('#port').val();
        if (radius_port.length === 0) {
            $('#port').focus();
            $('#port').select();
            return S_RADIUS_PORT_EMPTY;
        }
        var patt = /\D/;
        if (patt.test(radius_port)) {
            $('#port').focus();
            $('#port').select();
            return S_RADIUS_PORT_DIGITS;
        }
        if (radius_port < 1 || radius_port > 65535) {
            $('#port').focus();
            $('#port').select();
            return S_RADIUS_PORT_RANGE;
        }
        var radius_secret = $('#secret').val();
        if (radius_secret.length === 0) {
            $('#secret').focus();
            $('#secret').select();
            return S_RADIUS_SECRET_EMPTY;
        }
        var secret_confirm = $('#secret_confirm').val();
        if (radius_secret !== secret_confirm) {
            $('#secret').focus();
            $('#secret').select();
            return S_RADIUS_SECRET_MISMATCH;
        }
    },

    radiusIndexDown : function (event) {
        event.preventDefault();
        if (!WGRD.isEnabled('#radius_priority_down')) {
            return;
        }
        var options = $('#radius_domains option');
        var current_index = $('#radius_domains option:selected').index();

        if (current_index === radius_domains.length - 1) {
            return;
        }
        $(options[current_index]).insertAfter($(options[current_index + 1]));

        var tmp = radius_domains[current_index];
        radius_domains[current_index] = radius_domains[current_index + 1];
        radius_domains[current_index + 1] = tmp;
        return;
    },

    radiusIndexUp : function (event) {
        event.preventDefault();
        if (!WGRD.isEnabled('#radius_priority_up')) {
            return;
        }
        var options = $('#radius_domains option');
        var current_index = $('#radius_domains option:selected').index();
        if (current_index === 0) {
            return;
        }
        $(options[current_index]).insertBefore($(options[current_index - 1]));

        var tmp = radius_domains[current_index];
        radius_domains[current_index] = radius_domains[current_index - 1];
        radius_domains[current_index - 1] = tmp;
        return;
    },

    radiusStateChange : function (event) {
        var radius_enabled = $('#radius_chkbox').is(':checked');
        var radius_elem_ids = ['#radius_priority_up',
                               '#radius_priority_down', '#add_radius',
                               '#radius_timeout', '#radius_retries',
                               '#radius_group_attribute'];
        WGRD.enableUIElements(radius_enabled, radius_elem_ids);
    },

    removeADDomain : function (event) {
        event.preventDefault();
        if (!WGRD.isEnabled('#remove_ad_domain')) {
            return;
        }
        var sel_ad_domain = $('#active_directory_domains').val();

        if (sel_ad_domain === null || sel_ad_domain.length === 0) {
            return;
        }

        $('#active_directory_domains option[value="' + sel_ad_domain + '"]').remove();

        return;
    },

    removeRadius : function (event) {
        event.preventDefault();
        if (!WGRD.isEnabled('#remove_radius')) {
            return;
        }
        var selected_remove = $('#radius_domains').val();

        if (selected_remove === null || selected_remove.length === 0) {
            return;
        }
        var i, name;
        for (i = 0; i < radius_domains.length; i++) {
            name = radius_domains[i].host_name;
            if (name === selected_remove) {
                radius_domains.splice(i, 1);
                break;
            }
        }
        $('#radius_domains option[value="' + selected_remove + '"]').remove();

        return;
    },

    _normalize_ad_group : function (user_name) {
        //Extract dc
        var dc_index = user_name.indexOf('dc=');
        var cn_str = '';
        var ou_str = '/';
        var dc_str = user_name.substring(dc_index, user_name.length).trim();

        //check if we have 'ou='
        var ou_index = user_name.indexOf('ou=');
        if (ou_index === -1) {//
            cn_str = user_name.substring(0, dc_index - 1);
        } else {
            ou_str = user_name.substring(ou_index, dc_index - 1);
            ou_str = ou_str.replace(/ou=/g, '');
            var ou_comma_index = ou_str.indexOf(',');
            if (ou_comma_index !== -1) {
                var tmp_ou = '';
                var ou;
                ou_str = ou_str.split(',');
                for (ou = ou_str.length - 1; ou >= 0; ou--) {
                    tmp_ou = tmp_ou + ou_str[ou] + '/';
                }
                ou_str = '/' + tmp_ou;
            } else {
                ou_str = '/' + ou_str + '/';
            }
            cn_str = user_name.substring(0, ou_index - 1);
        }
        cn_str = cn_str.replace(/cn=/g, '');
        var cn_comma_index = cn_str.indexOf(',');
        if (cn_comma_index !== -1) {
            var tmp_cn = '';
            cn_str = cn_str.split(',');
            var cn;
            for (cn = cn_str.length - 1; cn >= 0; cn--) {
                tmp_cn = tmp_cn + cn_str[cn] + '/';
            }
            cn_str = tmp_cn.substring(0, tmp_cn.length - 1);
        }
        dc_str = dc_str.replace(/dc=/g, '');
        dc_str = dc_str.replace(/,/g, '.');
        return dc_str + ou_str + cn_str;
    },

    populateRadiusList: function () {
        var i, name;
        $('#radius_domains').empty();
        for (i = 0; i < radius_domains.length; i++) {
            name = radius_domains[i].host_name;
            $('#radius_domains').append('<option value="' + name + '">' + name + '</option>');
        }
    },

    showHideSubmitButton : function (enable) {
        if (enable && !WGRD.userInViewMode(is_page_locked, USER_CONFIGURE.pg_tracker)) {
            $('#submit_button').show();
        } else {
            $('#submit_button').hide();
        }
    },

    // validate all UI input
    validateUI : function () {

        if ($('#active_directory_chkbox').is(':checked')) {
            var ad_domains_count = $('#active_directory_domains option').length;
            if (ad_domains_count === 0) {
                $('.nav-tabs a[href="#remote_auth"]').tab('show');
                $('#active_directory_domains').focus();
                $('#active_directory_domains').select();
                writeErrorContainer(S_ATLEAST_ONE_AD, false);
                return false;
            }
        }
        if ($('#radius_chkbox').is(':checked')) {
            var radius_domains_count = $('#radius_domains option').length;
            if (radius_domains_count === 0) {
                $('.nav-tabs a[href="#remote_auth"]').tab('show');
                $('#radius_domains').focus();
                $('#radius_domains').select();
                writeErrorContainer(S_ATLEAST_ONE_RADIUS, false);
                return false;
            }
        }
        var lockout_duration_error = WGRD.isValidNumeric($('#lockout_duration'), S_TXT_LOCKOUT_DURATION);
        if (lockout_duration_error && lockout_duration_error.length > 0) {
            $('.nav-tabs a[href="#user_lockout"]').tab('show');
            $('#lockout_duration').focus();
            $('#lockout_duration').select();
            writeErrorContainer(lockout_duration_error, false);
            return false;
        }
        var lockout_stepsize_error = WGRD.isValidNumeric($('#lockout_stepsize'), S_TXT_LOCKOUT_STEPSIZE);
        if (lockout_stepsize_error && lockout_stepsize_error.length > 0) {
            $('.nav-tabs a[href="#user_lockout"]').tab('show');
            $('#lockout_stepsize').focus();
            $('#lockout_stepsize').select();
            writeErrorContainer(lockout_stepsize_error, false);
            return false;
        }
        var lockout_nsteps_error = WGRD.isValidNumeric($('#lockout_nsteps'), S_TXT_LOCKOUT_NSTEPS);
        if (lockout_nsteps_error && lockout_nsteps_error.length > 0) {
            $('.nav-tabs a[href="#user_lockout"]').tab('show');
            $('#lockout_nsteps').focus();
            $('#lockout_nsteps').select();
            writeErrorContainer(lockout_nsteps_error, false);
            return false;
        }
        $('#default_network_acl_list option').each(function () {
            var host_network = IPHELPER.trimIP4(this.text);
            if (IPHELPER.usableHostIP4(host_network) !== 0 && IPHELPER.usableNetworkIP4(host_network) !== 0) {
                writeErrorContainer(S_ERROR_IPCIDR_INVALID, false);
                return false;
            }
        });
        return true;
    },

    savePage : function () {
        $('#error_container').hide();
        $('#submit_button').attr('disabled', true);
        $('#progress_save').show();

        // validate the input
        if (!USER_CONFIGURE.validateUI()) {
            // validation failed
            $('#submit_button').removeAttr('disabled');
            $('#progress_save').hide();
            return;
        }

        var obj = new UserManagementObj();

        var enable = $('#active_directory_chkbox').is(':checked');
        obj.is_ad_enabled = enable;
        //Save AD related settings
        obj.is_ext_mgmt_enabled = false;

        enable = $('#dc_ssl_chkbox').is(':checked');
        obj.dc_ssl_enabled = enable;

        enable = $('#radius_chkbox').is(':checked');
        obj.is_radius_enabled = enable;

        obj.lockout_enabled = $('#lockout_enabled').is(':checked');
        obj.lockout_duration = parseInt($('#lockout_duration').val(), 10);
        obj.lockout_stepsize = parseInt($('#lockout_stepsize').val(), 10);
        obj.lockout_nsteps = parseInt($('#lockout_nsteps').val(), 10);

        var ad_list = [];
        $('#active_directory_domains option').each(function () {
            ad_list.push($(this).val());
        });
        obj.ad_new_list = ad_list;
        obj.ad_domain_list = ad_domain_list;

        //Save RADIUS related settings
        obj.radius_domains = USER_CONFIGURE.get_radius_list();
        obj.timeout = $('#radius_timeout').val();
        if (obj.timeout < 1 || obj.timeout > 120) {
            $('#radius_timeout').focus();
            $('#radius_timeout').select();
            writeErrorContainer(S_TIMEOUT_RANGE, false);
            $('#submit_button').attr('disabled', false);
            $('#progress_save').hide();
            return;
        }
        obj.retries = $('#radius_retries').val();
        if (obj.retries < 1 || obj.retries > 5) {
            $('#radius_retries').focus();
            $('#radius_retries').select();
            writeErrorContainer(S_RETRIES_RANGE, false);
            $('#submit_button').attr('disabled', false);
            $('#progress_save').hide();
            return;
        }
        obj.group_attribute = $('#radius_group_attribute').val();
        if (obj.group_attribute < 0 || obj.group_attribute > 255) {
            $('#radius_group_attribute').focus();
            $('#radius_group_attribute').select();
            writeErrorContainer(S_GROUP_ATTR_RANGE, false);
            $('#submit_button').attr('disabled', false);
            $('#progress_save').hide();
            return;
        }

        obj.default_network_acl_list = [];
        $('#default_network_acl_list option').each(function () {
            obj.default_network_acl_list.push(this.text);
        });

        // save the data to the server
        WGRD.putData(obj).success(function (response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                ad_domain_list = obj.ad_new_list;
                $('#error_container')
                                    .delay(2000)
                                    .fadeOut();

                WGRD.updateModeUI(1);  //Update the user mode div
                WGRD.resetUserMode();  //Reset the lock after save
            }
        });
    },

    toRadiusBox : function (params) {
        $('#radius_success_error').hide();
        var i, name;
        name = $('#radius_ip').val().trim();
        var val = USER_CONFIGURE._validateRadius(params.new_mode);
        if (val) {
            $('#radius_success_error').show()
                            .text(val);
        } else {
            if (params.new_mode) {
                var radius_entry = new RadiusObj();
                radius_entry.host_name = name;
                radius_entry.port = $('#port').val();
                radius_entry.secret = $('#secret').val();
                radius_domains.push(radius_entry);
                $('#radius_domains').append('<option value="' + name + '">' + name + '</option>');
            } else {
                for (i = 0; i < radius_domains.length; i++) {
                    if (unescapeHtml(radius_domains[i].host_name) === name) {
                        radius_domains[i].port = $('#port').val();
                        radius_domains[i].secret = $('#secret').val();
                        break;
                    }
                }
            }
            $('#add_radius_dlg').modal("hide");
        }
    },

    updateRadiusUI: function () {
        // enable/disable buttons
        var viewMode = WGRD.userInViewMode(is_page_locked, USER_CONFIGURE.pg_tracker);
        if ($('#radius_domains :selected').length === 0) {
            WGRD.enableUIElements(false, ['#edit_radius', '#remove_radius']);
        } else if (viewMode) {
            WGRD.enableUIElements(false, ['#remove_radius']);
            WGRD.enableUIElements(true, ['#edit_radius']);
        } else {
            WGRD.enableUIElements(true, ['#edit_radius', '#remove_radius']);
        }
    }
};
$(document).ready(USER_CONFIGURE.init);
