/*global S_USER_NAME_EMPTY, S_AD_TEST_FAILED, S_AD_TEST_PASSED, IPHELPER, validateDomainNameStr, validateSRVRecordStr, S_PASSWORD_EMPTY, S_ERR_DOMAINNAME, S_RUN, S_STOP*/
var USER_DIAGNOSTICS = {
    mode : '',
    usrdiagTid : '-1',

    init : function () {
        USER_DIAGNOSTICS.initEvents();
    },

    initEvents : function () {
        $('#run_ad_controller').button().click(USER_DIAGNOSTICS.diagnosticTests);
        $('#run_ad_auth').button().click(USER_DIAGNOSTICS.diagnosticTests);
        $('#run_radius_test').button().click(USER_DIAGNOSTICS.diagnosticTests);
        $('#diagnostics_criteria').change(USER_DIAGNOSTICS.testTypeChange);
    },

    testTypeChange : function () {
        if ($('#diagnostics_criteria option:selected').attr('value') === '0') {
            $('#ad_controller_choice').show();
            $('#ad_auth_domain_group').hide();
            $('#ad_auth_user_group').hide();
            $('#ad_auth_pass_group').hide();
            $('#radius_server_group').hide();
            $('#radius_port_group').hide();
            $('#radius_username_group').hide();
            $('#radius_passphrase_group').hide();
            $('#radius_secret_group').hide();
        } else if ($('#diagnostics_criteria option:selected').attr('value') === '1') {
            $('#ad_controller_choice').hide();
            $('#ad_auth_domain_group').show();
            $('#ad_auth_user_group').show();
            $('#ad_auth_pass_group').show();
            $('#radius_server_group').hide();
            $('#radius_port_group').hide();
            $('#radius_username_group').hide();
            $('#radius_passphrase_group').hide();
            $('#radius_secret_group').hide();
        } else if ($('#diagnostics_criteria option:selected').attr('value') === '2') {
            $('#ad_controller_choice').hide();
            $('#ad_auth_domain_group').hide();
            $('#ad_auth_user_group').hide();
            $('#ad_auth_pass_group').hide();
            $('#radius_server_group').show();
            $('#radius_port_group').show();
            $('#radius_username_group').show();
            $('#radius_passphrase_group').show();
            $('#radius_secret_group').show();
        }
    },

    _show_success_error_msg : function (id, msg, success) {
        $(id)
             .text(msg)
             .show();
        if (success) {
            $(id)
                 .addClass("alert-success wgrd-modal-success")
                 .removeClass("alert-error wgrd-modal-error");
        } else {
            $(id)
                 .removeClass("alert-success wgrd-modal-success")
                 .addClass("alert-error wgrd-modal-error");
        }
    },

    diagnosticTests: function () {
        if ($('#run_ad_controller').val() === S_RUN) {
            USER_DIAGNOSTICS.usrdiagTid = '-1';
            var button_id = $(this).attr('id');

            $('#diag_report_results').val('');

            var username = '';
            var port = '';
            var domain = '';
            var password = '';
            var secret = '';
            // get the fields from the page
            if (button_id === 'run_ad_controller') {
                domain = $('#ad_controller').val();
            } else if (button_id === 'run_ad_auth') {
                domain = $('#ad_auth_domain').val();
                username = $('#ad_auth_user').val();
                password = $('#ad_auth_pass').val();
            } else { //radius 
                domain = $('#radius_server').val();
                port = $('#radius_port').val();
                username = $('#radius_username').val();
                password = $('#radius_passphrase').val();
                secret = $('#radius_secret').val();
            }
            // validate the domain
            if (domain.length === 0 || (!IPHELPER.validIP4(domain) && !validateDomainNameStr(domain) && !validateSRVRecordStr(domain))) {
                $('#diag_report_results').val(S_ERR_DOMAINNAME + domain);
                return;
            }
            USER_DIAGNOSTICS._test_running(true);
            // jquery's ajax request doesn't support readystatechange events, so we do it manually to support the streaming response
            var manual_request = new XMLHttpRequest();

            if (button_id === 'run_ad_controller') {
                manual_request.open('POST', 'diagnostics_tests?domain=' + encodeURIComponent(domain) + '&test=domain');
            } else if (button_id === 'run_ad_auth') {
                manual_request.open('POST', 'diagnostics_tests?domain=' + encodeURIComponent(domain) + '&test=auth' + '&username=' + encodeURIComponent(username) + '&password=' + encodeURIComponent(password));
            } else {
                manual_request.open('POST', 'diagnostics_tests?domain=' + encodeURIComponent(domain) + '&test=radius' + '&port=' + encodeURIComponent(port) + '&username=' + encodeURIComponent(username) + '&password=' + encodeURIComponent(password) + '&secret=' + encodeURIComponent(secret));
            }
            var csrf_token = $("#csrf_token").val();
            manual_request.setRequestHeader('X-CSRFToken', csrf_token);
            manual_request.onreadystatechange = function () {
                // check status is 200
                var results_str;
                if (this.status === 200) {
                    if (this.readyState === 3) {  // in progress
                        results_str = USER_DIAGNOSTICS.save_and_strip_tid(this.responseText);
                        $('#diag_report_results').val(results_str);
                    } else if (this.readyState === 4) {  // done
                        results_str = USER_DIAGNOSTICS.save_and_strip_tid(this.responseText);
                        $('#diag_report_results').val(results_str);
                        USER_DIAGNOSTICS._test_running(false);
                    }
                } else if (this.readyState > 1) {  // readystate<1 means haven't sent data yet; IE will have status=0 with readystate=1
                    // error
                    $('#diag_report_results').val(this.responseText);
                    USER_DIAGNOSTICS._test_running(false);
                }
            };
            manual_request.send();
        } else { // assume it is stop
            $.ajax({
                url: 'stop_diagnostics',
                type: 'POST',
                data: {'tid': USER_DIAGNOSTICS.usrdiagTid},
                // success: // don't need to do anything - handled by complete()
                error: function (response) {
                    var curr_data = $('#diag_report_results').val();
                    $('#diag_report_results').val(curr_data + response.responseText);
                },
                complete: function () {
                    USER_DIAGNOSTICS._test_running(false);
                }
            });
        }
    },

    save_and_strip_tid: function (responseText) {
        // we use a special line of text to indicate the task id
        // this detects, stores and deletes that line
        var tid_text = '$USRDIAG_TID$=';
        var index;

        if (responseText.lastIndexOf(tid_text, 0) === 0) {
            index = responseText.indexOf('\n');
            if (index >= 0) {
                USER_DIAGNOSTICS.usrdiagTid = responseText.substring(tid_text.length, index);
                return responseText.substring(index + 1, responseText.length);
            }
        }
        return responseText;
    },

    _test_running : function (state) {
        if (state) {
            $('#run_ad_controller_progress').show();
            $('#run_ad_auth_progress').show();
            $('#run_radius_test_progress').show();

            $('#run_ad_controller').val(S_STOP);
            $('#run_ad_auth').val(S_STOP);
            $('#run_radius_test').val(S_STOP);
        } else {
            $('#run_ad_controller_progress').hide();
            $('#run_ad_auth_progress').hide();
            $('#run_radius_test_progress').hide();

            $('#run_ad_controller').val(S_RUN);
            $('#run_ad_auth').val(S_RUN);
            $('#run_radius_test').val(S_RUN);
        }
    }
};
$(document).ready(USER_DIAGNOSTICS.init);
