var isValidIpStr = function (ip_str) {
    return (/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test($.trim(ip_str)));
};
var isValidIp = function (element) {
    return isValidIpStr($(element).val());
};
var hasDashCommaPeriod = function (element) {
    return (/^[a-z0-9\_\-\.]+$/i.test($(element).val()));
};
var hasPeriodSlashDash = function (element) {
    return (/^[a-z0-9\.\\\-]+$/i.test($(element).val()));
};
var hasAlphaNumSpecial = function (element) {
    var val = $(element).val();
    if (val === '') {
        return true;
    }
    return (/^[a-z0-9\-\ \,\_\+\.\*\:\@\/]+$/i.test($(element).val()));
};
var valHasAlphaNumSpecialAll = function (val) {
    return (/^[a-z0-9\-\ \_\+\.\*\:\@\/\~\!\#\%\(\)\{\}\?\`\=\[\]\\\;\,\|\$\^\&]+$/i.test(val));
};
var hasAlphaNumSpecialAll = function (element) {
    return valHasAlphaNumSpecialAll($(element).val());
};
var containsAllAscii = function (str) {
    return (/^[\000-\177]*$/.test(str));
};

//Password is valid if it is not empty and less than/equal to 32 chars OR less than/equal to max_length if passed.
//Element 1 is required, Element 2 is optional, if present check if they have identical values
//
// return value, 0 means - password is valid OR respective error number
var checkPassword = function (element1, element2, max_length) {
    max_length = max_length || 32;
    var password = $(element1).val();

    if (password === '') {
        return 1;
    }
    if (password.length > max_length) {
        return (max_length === 32) ? 2 : 3;
    }
    if ($(element2).length) {
        var confirm_password = $(element2).val();
        return (confirm_password === password) ? 0 : 4;
    }
    return 0;
};

/*
   Validate the passed in username:
     Return 0 if validation passes
     Return 1 if username is empty
     Return 2 if username is builtin 'admin'
     Return 3 if username has special characters
*/
var validateUsername = function (elem) {
    var patt = /[\-!\@$%\^&*()_+|~=`{}\[\]:";'<>?,\/]/;

    var username = $.trim($(elem).val());
    if (username.length === 0) {
        return 1;
    }
    if (username === 'admin') {
        return 2;
    }
    if (patt.test(username)) {
        return 3;
    }
    return 0;
};

// Validate a password.  val is the password string
// limitAsciiChars: Boolean, limit the string to ascii only
// Set a max limit of 1000 chars for user password
// At least 8 chars must be present, allow spaces in password
var validatePassword = function (val, maxChars, limitAsciiChars) {
    var limitChars = maxChars || 1000;
    var limitAscii = limitAsciiChars || false;

    if ($.trim(val) === '') {
        return 1;
    }
    if (val.length < 8) {
        return 2;
    }

    if (val.length > limitChars) {
        return 3;
    }
    if (limitAscii && valHasAlphaNumSpecialAll(val)) {
        return 4;
    }
    return 0;
};

// Validate a password and a password confirmation.
// password/confirm are the password strings
// limitAsciiChars: Boolean, limit the string to ascii only
var validatePasswordAndConfirm = function (password, confirm, limitAsciiChars) {
    var limitAscii = limitAsciiChars || false;

    var passValid = validatePassword(password, limitAscii);
    if (passValid) {
        return passValid;
    }
    var confValid = validatePassword(confirm, limitAscii);
    if (confValid) {
        return confValid;
    }

    if (password !== confirm) {
        return 5;
    }
    return 0;
};

var validateDomainNameStr = function (str) {
    var domainName = $.trim(str);
    if (domainName.length < 1 || domainName.length > 255) {
        return false;
    }

    if (isValidIpStr(domainName)) {
        return false;
    }

    return (/^([a-zA-Z0-9]([\-a-zA-Z0-9]*[a-zA-Z0-9])?\.)+([a-zA-Z])+$/i.test(domainName));
};

var validateDomainNameWildcardStr = function (str) {
    var domainName = $.trim(str);
    if (domainName.length < 1 || domainName.length > 255) {
        return false;
    }

    if (isValidIpStr(domainName)) {
        return false;
    }

    // check if string starts with *.
    if (domainName.substring(0, 2) === "*.") {
        domainName = domainName.substring(2, domainName.length);
    }

    return (/^([a-zA-Z0-9]([\-a-zA-Z0-9]*[a-zA-Z0-9])?\.)+([a-zA-Z])+$/i.test(domainName));
};

var validateDomainName = function (element) {
    var domainName = $.trim($(element).val());
    return (validateDomainNameStr(domainName));
};

var validateSRVRecordStr = function (str) {
    var SRVRecord = $.trim(str);
    if (SRVRecord.length < 1 || SRVRecord.length > 255) {
        return false;
    }

    if (isValidIpStr(SRVRecord)) {
        return false;
    }

    //SRV format _service._proto.name  i.e. _sip._udp.sip.voice.google.com
    return (/^(_[a-zA-Z]+\.){2}([a-zA-Z0-9]([\-a-zA-Z0-9]*[a-zA-Z0-9])?\.)+([a-zA-Z])+$/i.test(SRVRecord));
};

/*
  If msg is not empty, then show the error message
  and add the error class to control-group which is the
  ancestor of the passed in element
*/
var showHideErrorMsg = function (element, msg) {
    if (msg !== undefined) {
        $(element).parents('.control-group').addClass('error');
        $(element + '~ span').text(msg);
    } else {
        $(element).parents('.control-group').removeClass('error');
        $(element + '~ span').text("");
    }
};

