var UserManagementObj = function () {
    this.__module__ = 'modules.scripts.users.user_scripts';
    this.__class__ = 'UserManagementObj';

    //AD Settings
    this.is_ad_enabled = false;
    this.dc_ssl_enabled = false;

    this.ad_domain_list = [];
    this.ad_new_list = [];

    this.is_ext_mgmt_enabled = false;

    this.mgmt_ip = '';
    this.passphrase = '';

    this.user_obj_list = [];
    this.user_obj = '';

    this.device_list = [];
    this.group_list = [];

    //RADIUS Settings
    this.is_radius_enabled = false;

    this.radius_domains = []; //Array of RadiusObjs

    this.default_network_acl_list = [];

    this.timeout = 5;
    this.retries = 3;
    this.group_attribute = 11;

    this.lockout_enabled = false;
    this.lockout_duration = 5;
    this.lockout_stepsize = 5;
    this.lockout_nsteps = 30;
};

var UserObj = function () {
    this.__module__ = 'modules.scripts.users.user_scripts';
    this.__class__ = 'UserObj';

    this.user_name = '';
    this.user_type = 'Local User'; //Default: Local other types: Local Group,  AD User, AD Group, RADIUS User, RADIUS Group

    this.password = ''; //Applicable only for local users and RADIUS Users
    this.locked_out = false;

    this.password_control = false;

    this.user_roles = [];
    this.current_user_roles = [];

    this.combined_roles = [];

    this.active_devices = [];
    this.active_usergroups = [];

    this.user_network_acl_list = [];
    this.group_network_acl_list = [];

    this.user_action = 0;  //Not saved to the server: 0 means add, 1 means edit, 2 means remove
};

var RadiusObj = function () {
    this.__module__ = 'modules.scripts.users.user_scripts';
    this.__class__ = 'RadiusObj';

    this.host_name = '';
    this.port = 0;
    this.secret = '';
};
