/*global world_countries,world_states_provinces,D_NETMAPPER*/
var WGMAP_MERCATOR = {
    width: 1280,
    height: 720,
    parent_divid: null,
    projection: null,
    path: null,
    svg: null,
    bgColor: 'white',
    countryColor: { 'stroke': 'rgba(120,120,120,0.8)', 'fill': 'rgb(241,236,183)', 'strokewidth': '0.25px' },
    waterColor: { 'stroke': 'rgb(20,72,126)', 'fill': 'rgb(20,72,126)', 'strokewidth': '0px' },
    lastZoom: { 's': 1, 't': [0, 0] },
    init: function () {
        return;
    },
    /* initMap()
        divid - parent id
        data - {'nodes': [{'status', 'latitude', 'longitude'}], 'links': [{'status', 'sourceidx', 'targetidx'}] }
        width - optional
        height - optional
        autoZoom - optional
     */
    initMap: function (divid, data, width, height, autoZoom) {
        if (width) {
            WGMAP_MERCATOR.width = width;
        }
        if (height) {
            WGMAP_MERCATOR.height = height;
        }
        WGMAP_MERCATOR.parent_divid = divid;
        $("#" + divid).width(WGMAP_MERCATOR.width);
        $("#" + divid).height(WGMAP_MERCATOR.height);
        $("#" + divid).css('overflow', 'hidden');
        $("#" + divid).css('background-color', WGMAP_MERCATOR.bgColor);

        WGMAP_MERCATOR.projection = d3.geo
            .mercator()
            .translate([WGMAP_MERCATOR.width / 2, WGMAP_MERCATOR.height / 2])
            .scale((WGMAP_MERCATOR.width - 1) / 2 / Math.PI);

        var centerLngLat = D_NETMAPPER.getCenter(data.nodes);
        centerLngLat = [0, 30];
        var center = WGMAP_MERCATOR.projection(centerLngLat);
        var scaleExtent = [1.0, 18];

        WGMAP_MERCATOR.path = d3.geo.path()
            .projection(WGMAP_MERCATOR.projection);

        WGMAP_MERCATOR.zoomBehavior = d3.behavior.zoom()
            .scaleExtent(scaleExtent)
            .translate([WGMAP_MERCATOR.width / 2 - center[0], WGMAP_MERCATOR.height / 2 - center[1]])
            .on("zoom", WGMAP_MERCATOR.zoomed);

        if (WGMAP_MERCATOR.svg !== null) {
            WGMAP_MERCATOR.svg.remove();
            $("#threatmap div").remove();
        }

        WGMAP_MERCATOR.svg = d3.select("#" + divid).append("svg")
            .attr("width", WGMAP_MERCATOR.width)
            .attr("height", WGMAP_MERCATOR.height);

        WGMAP_MERCATOR.mapObject = WGMAP_MERCATOR.svg
                                    .append("g");

        WGMAP_MERCATOR.svg.call(WGMAP_MERCATOR.zoomBehavior);

        $("#hoveritem").text(data.nodes.length + " nodes mapped");
        $("#hoveritem").css("color", "Black");

        var world_objects = [
            { 'obj': world_countries, 'class': 'countries', 'color': WGMAP_MERCATOR.countryColor },
            { 'obj': world_states_provinces, 'class': 'states_provinces', 'color': WGMAP_MERCATOR.countryColor }
        ];
        var idx, world_object;
        for (idx = 0; idx < world_objects.length; idx++) {
            world_object = world_objects[idx];
            WGMAP_MERCATOR.mapObject.selectAll("path." + world_object.class).remove();
            WGMAP_MERCATOR.mapObject.selectAll(world_object.class)
                .data(world_object.obj.features)
                .enter().append("path")
                    .attr("class", world_object.class)
                    .attr("fill", world_object.color.fill)
                    .attr("shape-rendering", "optimizeQuality")
                    .attr("stroke", world_object.color.stroke)
                    .attr("stroke-width", world_object.color.strokewidth)
                    .attr("d", WGMAP_MERCATOR.path);
        }


        D_NETMAPPER.nodeSize = 4;
        var s = 1;
        var t;
        D_NETMAPPER.update(data, WGMAP_MERCATOR.mapObject, WGMAP_MERCATOR.projection, WGMAP_MERCATOR.parent_divid, WGMAP_MERCATOR.pixelpos, s);
        if (autoZoom) {
            if (data.nodes.length === 1) {
                t = WGMAP_MERCATOR.projection(data.nodes[0].longlat);
                WGMAP_MERCATOR.zoomBehavior
                    .translate([t[0], t[1]])
                    .scale(2.0);
            } else if (data.nodes.length > 1) {
                var zoomtranslate = D_NETMAPPER.getZoom(WGMAP_MERCATOR.width, WGMAP_MERCATOR.height, 5);
                var scale = Math.min(zoomtranslate[0], scaleExtent[1]);
                WGMAP_MERCATOR.zoomBehavior
                    .translate(zoomtranslate[1])
                    .scale(scale);
            } else {
                t = WGMAP_MERCATOR.projection([0, 30]);
                WGMAP_MERCATOR.zoomBehavior
                    .translate([t[0], t[1]])
                    .scale(1.0);
            }
        }
        WGMAP_MERCATOR.zoomed();
    },
    draw: function (data, newscale) {
        if (data) {
            D_NETMAPPER.update(data, WGMAP_MERCATOR.mapObject, WGMAP_MERCATOR.projection, WGMAP_MERCATOR.parent_divid, WGMAP_MERCATOR.pixelpos, newscale);
        } else if (newscale) {
            D_NETMAPPER.update(null, null, null, null, null, newscale);
        }
        D_NETMAPPER.draw(WGMAP_MERCATOR.path);
        WGMAP_MERCATOR.mapObject.selectAll("path.countries")
            .attr("stroke-width", function (d) { return 0.5 / D_NETMAPPER.scale; })
            .attr("d", WGMAP_MERCATOR.path);
        WGMAP_MERCATOR.mapObject.selectAll("path.states_provinces")
            .attr("stroke-width", function (d) { return 0.5 / D_NETMAPPER.scale; })
            .attr("d", WGMAP_MERCATOR.path);
        WGMAP_MERCATOR.mapObject.selectAll("path.lakes")
            .attr("d", WGMAP_MERCATOR.path);
    },
    zoomed: function () {
        var s = WGMAP_MERCATOR.zoomBehavior.scale();
        var t = WGMAP_MERCATOR.zoomBehavior.translate();
        if (s === WGMAP_MERCATOR.lastZoom.s && t[0] === WGMAP_MERCATOR.lastZoom.t[0] && t[1] === WGMAP_MERCATOR.lastZoom.t[1]) {
            // Hint when scrolled past min or max but not when panning past the limits
            if (!$("#limithit").is(":visible")) {
                var p = $("#" + WGMAP_MERCATOR.parent_divid);
                var w = p.width();
                var h = p.height();
                var o = p.offset();
                p.append('<div id="limithit" style="background-color:rgba(51,51,51,0.05);width:' + w + 'px; height:' + h + 'px;position:absolute;top:' + o.top + 'px;left:' + o.left + 'px;" />');
                setTimeout(function () { $("#limithit").remove(); }, 350);
                return;
            }
        }
        t[0] = Math.min(-20, t[0]);
        t[1] = Math.min(240, t[1]);
        WGMAP_MERCATOR.zoomBehavior.translate(t);
        if (s === WGMAP_MERCATOR.lastZoom.s && t[0] === WGMAP_MERCATOR.lastZoom.t[0] && t[1] === WGMAP_MERCATOR.lastZoom.t[1]) {
            return;
        }

        WGMAP_MERCATOR.mapObject
            .attr("transform", "translate(" + t + ")scale(" + s + ")");

        var nodeRadius = 10;
        if (s < 3) {
            if (D_NETMAPPER.mapNodes.length > 500) {
                nodeRadius = 4;
            } else if (D_NETMAPPER.mapNodes.length > 50) {
                nodeRadius = 8;
            }
        }
        D_NETMAPPER.nodeSize = nodeRadius / s;
        WGMAP_MERCATOR.draw(null, s);

        WGMAP_MERCATOR.lastZoom = {'s': s, 't': t};
    },
    pixelpos: function (coordinates) {
        var t = WGMAP_MERCATOR.zoomBehavior.translate();
        var s = WGMAP_MERCATOR.zoomBehavior.scale();
        var pixelpos = WGMAP_MERCATOR.projection(coordinates);
        pixelpos[0] *= s;
        pixelpos[1] *= s;
        pixelpos[0] += t[0];
        pixelpos[1] += t[1];

        return pixelpos;
    }
};

$(document).ready(WGMAP_MERCATOR.init);

