import os, sys, cherrypy
apppath = os.path.dirname(os.path.abspath(__file__))
if apppath not in sys.path:
    sys.path.append(apppath)

import wsm

def application(environ, start_response):
    cherrypy.config.update({'apache_port': int(environ.get('apache_port', 4130))})
    return cherrypy.tree(environ, start_response)

cherrypy.config.update(wsm.global_conf)
app = cherrypy.Application(wsm.WSM(), config=wsm.config)
cherrypy.tree.apps[''] = app
